/* Autogenerated: ECCKiila https://gitlab.com/nisec/ecckiila */
/*-
 * MIT License
 * 
 * Copyright (c) 2020 Luis Rivera-Zamarripa, Jesús-Javier Chi-Domínguez, Billy Bob Brumley
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#if defined(__SIZEOF_INT128__) && !defined(PEDANTIC)

#include <stdint.h>
#include <string.h>
#define LIMB_BITS 64
#define LIMB_CNT 4
/* Field elements */
typedef uint64_t fe_t[LIMB_CNT];
typedef uint64_t limb_t;

#ifdef OPENSSL_NO_ASM
#define FIAT_ID_GOSTR3410_2001_TESTPARAMSET_NO_ASM
#endif

#define fe_copy(d, s) memcpy(d, s, sizeof(fe_t))
#define fe_set_zero(d) memset(d, 0, sizeof(fe_t))

/* Projective points */
typedef struct {
    fe_t X;
    fe_t Y;
    fe_t Z;
} pt_prj_t;

/* Affine points */
typedef struct {
    fe_t X;
    fe_t Y;
} pt_aff_t;

/* BEGIN verbatim fiat code https://github.com/mit-plv/fiat-crypto */
/*-
 * MIT License
 *
 * Copyright (c) 2020 the fiat-crypto authors (see the AUTHORS file)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* Autogenerated: word_by_word_montgomery --static --use-value-barrier id_GostR3410_2001_TestParamSet 64 '2^255 + 1073' */
/* curve description: id_GostR3410_2001_TestParamSet */
/* machine_wordsize = 64 (from "64") */
/* requested operations: (all) */
/* m = 0x8000000000000000000000000000000000000000000000000000000000000431 (from "2^255 + 1073") */
/*                                                                    */
/* NOTE: In addition to the bounds specified above each function, all */
/*   functions synthesized for this Montgomery arithmetic require the */
/*   input to be strictly less than the prime modulus (m), and also   */
/*   require the input to be in the unique saturated representation.  */
/*   All functions also ensure that these two properties are true of  */
/*   return values.                                                   */
/*  */
/* Computed values: */
/* eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) */
/* bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) */

#include <stdint.h>
typedef unsigned char fiat_id_GostR3410_2001_TestParamSet_uint1;
typedef signed char fiat_id_GostR3410_2001_TestParamSet_int1;
typedef signed __int128 fiat_id_GostR3410_2001_TestParamSet_int128;
typedef unsigned __int128 fiat_id_GostR3410_2001_TestParamSet_uint128;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif

#if !defined(FIAT_ID_GOSTR3410_2001_TESTPARAMSET_NO_ASM) && \
    (defined(__GNUC__) || defined(__clang__))
static __inline__ uint64_t
fiat_id_GostR3410_2001_TestParamSet_value_barrier_u64(uint64_t a) {
    __asm__("" : "+r"(a) : /* no inputs */);
    return a;
}
#else
#define fiat_id_GostR3410_2001_TestParamSet_value_barrier_u64(x) (x)
#endif

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^64
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(
    uint64_t *out1, fiat_id_GostR3410_2001_TestParamSet_uint1 *out2,
    fiat_id_GostR3410_2001_TestParamSet_uint1 arg1, uint64_t arg2,
    uint64_t arg3) {
    fiat_id_GostR3410_2001_TestParamSet_uint128 x1;
    uint64_t x2;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x3;
    x1 = ((arg1 + (fiat_id_GostR3410_2001_TestParamSet_uint128)arg2) + arg3);
    x2 = (uint64_t)(x1 & UINT64_C(0xffffffffffffffff));
    x3 = (fiat_id_GostR3410_2001_TestParamSet_uint1)(x1 >> 64);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^64
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(
    uint64_t *out1, fiat_id_GostR3410_2001_TestParamSet_uint1 *out2,
    fiat_id_GostR3410_2001_TestParamSet_uint1 arg1, uint64_t arg2,
    uint64_t arg3) {
    fiat_id_GostR3410_2001_TestParamSet_int128 x1;
    fiat_id_GostR3410_2001_TestParamSet_int1 x2;
    uint64_t x3;
    x1 = ((arg2 - (fiat_id_GostR3410_2001_TestParamSet_int128)arg1) - arg3);
    x2 = (fiat_id_GostR3410_2001_TestParamSet_int1)(x1 >> 64);
    x3 = (uint64_t)(x1 & UINT64_C(0xffffffffffffffff));
    *out1 = x3;
    *out2 = (fiat_id_GostR3410_2001_TestParamSet_uint1)(0x0 - x2);
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_mulx_u64 is a multiplication, returning the full double-width result.
 * Postconditions:
 *   out1 = (arg1 * arg2) mod 2^64
 *   out2 = ⌊arg1 * arg2 / 2^64⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffffffffffff]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_id_GostR3410_2001_TestParamSet_mulx_u64(uint64_t *out1,
                                                         uint64_t *out2,
                                                         uint64_t arg1,
                                                         uint64_t arg2) {
    fiat_id_GostR3410_2001_TestParamSet_uint128 x1;
    uint64_t x2;
    uint64_t x3;
    x1 = ((fiat_id_GostR3410_2001_TestParamSet_uint128)arg1 * arg2);
    x2 = (uint64_t)(x1 & UINT64_C(0xffffffffffffffff));
    x3 = (uint64_t)(x1 >> 64);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(
    uint64_t *out1, fiat_id_GostR3410_2001_TestParamSet_uint1 arg1,
    uint64_t arg2, uint64_t arg3) {
    fiat_id_GostR3410_2001_TestParamSet_uint1 x1;
    uint64_t x2;
    uint64_t x3;
    x1 = (!(!arg1));
    x2 = ((fiat_id_GostR3410_2001_TestParamSet_int1)(0x0 - x1) &
          UINT64_C(0xffffffffffffffff));
    x3 =
        ((fiat_id_GostR3410_2001_TestParamSet_value_barrier_u64(x2) & arg3) |
         (fiat_id_GostR3410_2001_TestParamSet_value_barrier_u64((~x2)) & arg2));
    *out1 = x3;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_mul multiplies two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_mul(uint64_t out1[4],
                                                    const uint64_t arg1[4],
                                                    const uint64_t arg2[4]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x14;
    uint64_t x15;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x16;
    uint64_t x17;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    uint64_t x23;
    uint64_t x24;
    uint64_t x25;
    uint64_t x26;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x27;
    uint64_t x28;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x29;
    uint64_t x30;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x31;
    uint64_t x32;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x33;
    uint64_t x34;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x35;
    uint64_t x36;
    uint64_t x37;
    uint64_t x38;
    uint64_t x39;
    uint64_t x40;
    uint64_t x41;
    uint64_t x42;
    uint64_t x43;
    uint64_t x44;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x45;
    uint64_t x46;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x47;
    uint64_t x48;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x49;
    uint64_t x50;
    uint64_t x51;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x52;
    uint64_t x53;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x54;
    uint64_t x55;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x56;
    uint64_t x57;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x58;
    uint64_t x59;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x60;
    uint64_t x61;
    uint64_t x62;
    uint64_t x63;
    uint64_t x64;
    uint64_t x65;
    uint64_t x66;
    uint64_t x67;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x68;
    uint64_t x69;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x70;
    uint64_t x71;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x72;
    uint64_t x73;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x74;
    uint64_t x75;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x76;
    uint64_t x77;
    uint64_t x78;
    uint64_t x79;
    uint64_t x80;
    uint64_t x81;
    uint64_t x82;
    uint64_t x83;
    uint64_t x84;
    uint64_t x85;
    uint64_t x86;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x87;
    uint64_t x88;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x89;
    uint64_t x90;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x91;
    uint64_t x92;
    uint64_t x93;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x94;
    uint64_t x95;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x96;
    uint64_t x97;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x98;
    uint64_t x99;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x100;
    uint64_t x101;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x102;
    uint64_t x103;
    uint64_t x104;
    uint64_t x105;
    uint64_t x106;
    uint64_t x107;
    uint64_t x108;
    uint64_t x109;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x110;
    uint64_t x111;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x112;
    uint64_t x113;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x114;
    uint64_t x115;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x116;
    uint64_t x117;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x118;
    uint64_t x119;
    uint64_t x120;
    uint64_t x121;
    uint64_t x122;
    uint64_t x123;
    uint64_t x124;
    uint64_t x125;
    uint64_t x126;
    uint64_t x127;
    uint64_t x128;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x129;
    uint64_t x130;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x131;
    uint64_t x132;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x133;
    uint64_t x134;
    uint64_t x135;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x136;
    uint64_t x137;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x138;
    uint64_t x139;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x140;
    uint64_t x141;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x142;
    uint64_t x143;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x144;
    uint64_t x145;
    uint64_t x146;
    uint64_t x147;
    uint64_t x148;
    uint64_t x149;
    uint64_t x150;
    uint64_t x151;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x152;
    uint64_t x153;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x154;
    uint64_t x155;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x156;
    uint64_t x157;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x158;
    uint64_t x159;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x160;
    uint64_t x161;
    uint64_t x162;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x163;
    uint64_t x164;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x165;
    uint64_t x166;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x167;
    uint64_t x168;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x169;
    uint64_t x170;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x171;
    uint64_t x172;
    uint64_t x173;
    uint64_t x174;
    uint64_t x175;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[0]);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x5, &x6, x4, (arg2[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x7, &x8, x4, (arg2[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x9, &x10, x4, (arg2[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x11, &x12, x4, (arg2[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x13, &x14, 0x0, x12, x9);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x15, &x16, x14, x10, x7);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x17, &x18, x16, x8, x5);
    x19 = (x18 + x6);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x20, &x21, x11,
                                                 UINT64_C(0xdbf951d5883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x22, &x23, x20,
                                                 UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x24, &x25, x20,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x26, &x27, 0x0, x11,
                                                      x24);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x28, &x29, x27, x13,
                                                      x25);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x30, &x31, x29, x15,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x32, &x33, x31, x17,
                                                      x22);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x34, &x35, x33, x19,
                                                      x23);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x36, &x37, x1, (arg2[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x38, &x39, x1, (arg2[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x40, &x41, x1, (arg2[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x42, &x43, x1, (arg2[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x44, &x45, 0x0, x43,
                                                      x40);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x46, &x47, x45, x41,
                                                      x38);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x48, &x49, x47, x39,
                                                      x36);
    x50 = (x49 + x37);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x51, &x52, 0x0, x28,
                                                      x42);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x53, &x54, x52, x30,
                                                      x44);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x55, &x56, x54, x32,
                                                      x46);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x57, &x58, x56, x34,
                                                      x48);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x59, &x60, x58, x35,
                                                      x50);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x61, &x62, x51,
                                                 UINT64_C(0xdbf951d5883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x63, &x64, x61,
                                                 UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x65, &x66, x61,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x67, &x68, 0x0, x51,
                                                      x65);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x69, &x70, x68, x53,
                                                      x66);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x71, &x72, x70, x55,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x73, &x74, x72, x57,
                                                      x63);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x75, &x76, x74, x59,
                                                      x64);
    x77 = ((uint64_t)x76 + x60);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x78, &x79, x2, (arg2[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x80, &x81, x2, (arg2[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x82, &x83, x2, (arg2[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x84, &x85, x2, (arg2[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x86, &x87, 0x0, x85,
                                                      x82);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x88, &x89, x87, x83,
                                                      x80);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x90, &x91, x89, x81,
                                                      x78);
    x92 = (x91 + x79);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x93, &x94, 0x0, x69,
                                                      x84);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x95, &x96, x94, x71,
                                                      x86);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x97, &x98, x96, x73,
                                                      x88);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x99, &x100, x98, x75,
                                                      x90);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x101, &x102, x100, x77,
                                                      x92);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x103, &x104, x93,
                                                 UINT64_C(0xdbf951d5883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x105, &x106, x103,
                                                 UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x107, &x108, x103,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x109, &x110, 0x0, x93,
                                                      x107);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x111, &x112, x110, x95,
                                                      x108);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x113, &x114, x112, x97,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x115, &x116, x114, x99,
                                                      x105);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x117, &x118, x116, x101,
                                                      x106);
    x119 = ((uint64_t)x118 + x102);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x120, &x121, x3, (arg2[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x122, &x123, x3, (arg2[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x124, &x125, x3, (arg2[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x126, &x127, x3, (arg2[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x128, &x129, 0x0, x127,
                                                      x124);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x130, &x131, x129, x125,
                                                      x122);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x132, &x133, x131, x123,
                                                      x120);
    x134 = (x133 + x121);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x135, &x136, 0x0, x111,
                                                      x126);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x137, &x138, x136, x113,
                                                      x128);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x139, &x140, x138, x115,
                                                      x130);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x141, &x142, x140, x117,
                                                      x132);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x143, &x144, x142, x119,
                                                      x134);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x145, &x146, x135,
                                                 UINT64_C(0xdbf951d5883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x147, &x148, x145,
                                                 UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x149, &x150, x145,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x151, &x152, 0x0, x135,
                                                      x149);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x153, &x154, x152, x137,
                                                      x150);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x155, &x156, x154, x139,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x157, &x158, x156, x141,
                                                      x147);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x159, &x160, x158, x143,
                                                      x148);
    x161 = ((uint64_t)x160 + x144);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x162, &x163, 0x0, x153,
                                                       UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x164, &x165, x163, x155,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x166, &x167, x165, x157,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(
        &x168, &x169, x167, x159, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x170, &x171, x169, x161,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x172, x171, x162, x153);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x173, x171, x164, x155);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x174, x171, x166, x157);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x175, x171, x168, x159);
    out1[0] = x172;
    out1[1] = x173;
    out1[2] = x174;
    out1[3] = x175;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_square squares a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_square(uint64_t out1[4],
                                                       const uint64_t arg1[4]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x14;
    uint64_t x15;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x16;
    uint64_t x17;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    uint64_t x23;
    uint64_t x24;
    uint64_t x25;
    uint64_t x26;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x27;
    uint64_t x28;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x29;
    uint64_t x30;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x31;
    uint64_t x32;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x33;
    uint64_t x34;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x35;
    uint64_t x36;
    uint64_t x37;
    uint64_t x38;
    uint64_t x39;
    uint64_t x40;
    uint64_t x41;
    uint64_t x42;
    uint64_t x43;
    uint64_t x44;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x45;
    uint64_t x46;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x47;
    uint64_t x48;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x49;
    uint64_t x50;
    uint64_t x51;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x52;
    uint64_t x53;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x54;
    uint64_t x55;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x56;
    uint64_t x57;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x58;
    uint64_t x59;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x60;
    uint64_t x61;
    uint64_t x62;
    uint64_t x63;
    uint64_t x64;
    uint64_t x65;
    uint64_t x66;
    uint64_t x67;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x68;
    uint64_t x69;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x70;
    uint64_t x71;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x72;
    uint64_t x73;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x74;
    uint64_t x75;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x76;
    uint64_t x77;
    uint64_t x78;
    uint64_t x79;
    uint64_t x80;
    uint64_t x81;
    uint64_t x82;
    uint64_t x83;
    uint64_t x84;
    uint64_t x85;
    uint64_t x86;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x87;
    uint64_t x88;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x89;
    uint64_t x90;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x91;
    uint64_t x92;
    uint64_t x93;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x94;
    uint64_t x95;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x96;
    uint64_t x97;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x98;
    uint64_t x99;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x100;
    uint64_t x101;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x102;
    uint64_t x103;
    uint64_t x104;
    uint64_t x105;
    uint64_t x106;
    uint64_t x107;
    uint64_t x108;
    uint64_t x109;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x110;
    uint64_t x111;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x112;
    uint64_t x113;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x114;
    uint64_t x115;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x116;
    uint64_t x117;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x118;
    uint64_t x119;
    uint64_t x120;
    uint64_t x121;
    uint64_t x122;
    uint64_t x123;
    uint64_t x124;
    uint64_t x125;
    uint64_t x126;
    uint64_t x127;
    uint64_t x128;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x129;
    uint64_t x130;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x131;
    uint64_t x132;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x133;
    uint64_t x134;
    uint64_t x135;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x136;
    uint64_t x137;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x138;
    uint64_t x139;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x140;
    uint64_t x141;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x142;
    uint64_t x143;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x144;
    uint64_t x145;
    uint64_t x146;
    uint64_t x147;
    uint64_t x148;
    uint64_t x149;
    uint64_t x150;
    uint64_t x151;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x152;
    uint64_t x153;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x154;
    uint64_t x155;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x156;
    uint64_t x157;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x158;
    uint64_t x159;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x160;
    uint64_t x161;
    uint64_t x162;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x163;
    uint64_t x164;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x165;
    uint64_t x166;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x167;
    uint64_t x168;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x169;
    uint64_t x170;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x171;
    uint64_t x172;
    uint64_t x173;
    uint64_t x174;
    uint64_t x175;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[0]);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x5, &x6, x4, (arg1[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x7, &x8, x4, (arg1[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x9, &x10, x4, (arg1[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x11, &x12, x4, (arg1[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x13, &x14, 0x0, x12, x9);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x15, &x16, x14, x10, x7);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x17, &x18, x16, x8, x5);
    x19 = (x18 + x6);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x20, &x21, x11,
                                                 UINT64_C(0xdbf951d5883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x22, &x23, x20,
                                                 UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x24, &x25, x20,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x26, &x27, 0x0, x11,
                                                      x24);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x28, &x29, x27, x13,
                                                      x25);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x30, &x31, x29, x15,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x32, &x33, x31, x17,
                                                      x22);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x34, &x35, x33, x19,
                                                      x23);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x36, &x37, x1, (arg1[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x38, &x39, x1, (arg1[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x40, &x41, x1, (arg1[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x42, &x43, x1, (arg1[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x44, &x45, 0x0, x43,
                                                      x40);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x46, &x47, x45, x41,
                                                      x38);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x48, &x49, x47, x39,
                                                      x36);
    x50 = (x49 + x37);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x51, &x52, 0x0, x28,
                                                      x42);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x53, &x54, x52, x30,
                                                      x44);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x55, &x56, x54, x32,
                                                      x46);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x57, &x58, x56, x34,
                                                      x48);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x59, &x60, x58, x35,
                                                      x50);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x61, &x62, x51,
                                                 UINT64_C(0xdbf951d5883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x63, &x64, x61,
                                                 UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x65, &x66, x61,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x67, &x68, 0x0, x51,
                                                      x65);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x69, &x70, x68, x53,
                                                      x66);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x71, &x72, x70, x55,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x73, &x74, x72, x57,
                                                      x63);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x75, &x76, x74, x59,
                                                      x64);
    x77 = ((uint64_t)x76 + x60);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x78, &x79, x2, (arg1[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x80, &x81, x2, (arg1[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x82, &x83, x2, (arg1[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x84, &x85, x2, (arg1[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x86, &x87, 0x0, x85,
                                                      x82);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x88, &x89, x87, x83,
                                                      x80);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x90, &x91, x89, x81,
                                                      x78);
    x92 = (x91 + x79);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x93, &x94, 0x0, x69,
                                                      x84);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x95, &x96, x94, x71,
                                                      x86);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x97, &x98, x96, x73,
                                                      x88);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x99, &x100, x98, x75,
                                                      x90);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x101, &x102, x100, x77,
                                                      x92);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x103, &x104, x93,
                                                 UINT64_C(0xdbf951d5883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x105, &x106, x103,
                                                 UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x107, &x108, x103,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x109, &x110, 0x0, x93,
                                                      x107);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x111, &x112, x110, x95,
                                                      x108);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x113, &x114, x112, x97,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x115, &x116, x114, x99,
                                                      x105);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x117, &x118, x116, x101,
                                                      x106);
    x119 = ((uint64_t)x118 + x102);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x120, &x121, x3, (arg1[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x122, &x123, x3, (arg1[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x124, &x125, x3, (arg1[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x126, &x127, x3, (arg1[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x128, &x129, 0x0, x127,
                                                      x124);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x130, &x131, x129, x125,
                                                      x122);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x132, &x133, x131, x123,
                                                      x120);
    x134 = (x133 + x121);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x135, &x136, 0x0, x111,
                                                      x126);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x137, &x138, x136, x113,
                                                      x128);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x139, &x140, x138, x115,
                                                      x130);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x141, &x142, x140, x117,
                                                      x132);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x143, &x144, x142, x119,
                                                      x134);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x145, &x146, x135,
                                                 UINT64_C(0xdbf951d5883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x147, &x148, x145,
                                                 UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x149, &x150, x145,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x151, &x152, 0x0, x135,
                                                      x149);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x153, &x154, x152, x137,
                                                      x150);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x155, &x156, x154, x139,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x157, &x158, x156, x141,
                                                      x147);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x159, &x160, x158, x143,
                                                      x148);
    x161 = ((uint64_t)x160 + x144);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x162, &x163, 0x0, x153,
                                                       UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x164, &x165, x163, x155,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x166, &x167, x165, x157,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(
        &x168, &x169, x167, x159, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x170, &x171, x169, x161,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x172, x171, x162, x153);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x173, x171, x164, x155);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x174, x171, x166, x157);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x175, x171, x168, x159);
    out1[0] = x172;
    out1[1] = x173;
    out1[2] = x174;
    out1[3] = x175;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_add adds two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_add(uint64_t out1[4],
                                                    const uint64_t arg1[4],
                                                    const uint64_t arg2[4]) {
    uint64_t x1;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x2;
    uint64_t x3;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x4;
    uint64_t x5;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x6;
    uint64_t x7;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x8;
    uint64_t x9;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x10;
    uint64_t x11;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x12;
    uint64_t x13;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x14;
    uint64_t x15;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x16;
    uint64_t x17;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x1, &x2, 0x0, (arg1[0]),
                                                      (arg2[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x3, &x4, x2, (arg1[1]),
                                                      (arg2[1]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x5, &x6, x4, (arg1[2]),
                                                      (arg2[2]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x7, &x8, x6, (arg1[3]),
                                                      (arg2[3]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x9, &x10, 0x0, x1,
                                                       UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x11, &x12, x10, x3,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x13, &x14, x12, x5,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(
        &x15, &x16, x14, x7, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x17, &x18, x16, x8,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x19, x18, x9, x1);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x20, x18, x11, x3);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x21, x18, x13, x5);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x22, x18, x15, x7);
    out1[0] = x19;
    out1[1] = x20;
    out1[2] = x21;
    out1[3] = x22;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_sub subtracts two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_sub(uint64_t out1[4],
                                                    const uint64_t arg1[4],
                                                    const uint64_t arg2[4]) {
    uint64_t x1;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x2;
    uint64_t x3;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x4;
    uint64_t x5;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x6;
    uint64_t x7;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x8;
    uint64_t x9;
    uint64_t x10;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x11;
    uint64_t x12;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x13;
    uint64_t x14;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x15;
    uint64_t x16;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x17;
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x1, &x2, 0x0, (arg1[0]),
                                                       (arg2[0]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x3, &x4, x2, (arg1[1]),
                                                       (arg2[1]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x5, &x6, x4, (arg1[2]),
                                                       (arg2[2]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x7, &x8, x6, (arg1[3]),
                                                       (arg2[3]));
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(
        &x9, x8, 0x0, UINT64_C(0xffffffffffffffff));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x10, &x11, 0x0, x1,
                                                      (x9 & UINT16_C(0x431)));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x12, &x13, x11, x3, 0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x14, &x15, x13, x5, 0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(
        &x16, &x17, x15, x7, (x9 & UINT64_C(0x8000000000000000)));
    out1[0] = x10;
    out1[1] = x12;
    out1[2] = x14;
    out1[3] = x16;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_opp negates a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_opp(uint64_t out1[4],
                                                    const uint64_t arg1[4]) {
    uint64_t x1;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x2;
    uint64_t x3;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x4;
    uint64_t x5;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x6;
    uint64_t x7;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x8;
    uint64_t x9;
    uint64_t x10;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x11;
    uint64_t x12;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x13;
    uint64_t x14;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x15;
    uint64_t x16;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x17;
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x1, &x2, 0x0, 0x0,
                                                       (arg1[0]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x3, &x4, x2, 0x0,
                                                       (arg1[1]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x5, &x6, x4, 0x0,
                                                       (arg1[2]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x7, &x8, x6, 0x0,
                                                       (arg1[3]));
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(
        &x9, x8, 0x0, UINT64_C(0xffffffffffffffff));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x10, &x11, 0x0, x1,
                                                      (x9 & UINT16_C(0x431)));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x12, &x13, x11, x3, 0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x14, &x15, x13, x5, 0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(
        &x16, &x17, x15, x7, (x9 & UINT64_C(0x8000000000000000)));
    out1[0] = x10;
    out1[1] = x12;
    out1[2] = x14;
    out1[3] = x16;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_from_montgomery translates a field element out of the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^4) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_from_montgomery(
    uint64_t out1[4], const uint64_t arg1[4]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x9;
    uint64_t x10;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint64_t x16;
    uint64_t x17;
    uint64_t x18;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x19;
    uint64_t x20;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x21;
    uint64_t x22;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x23;
    uint64_t x24;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x25;
    uint64_t x26;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x27;
    uint64_t x28;
    uint64_t x29;
    uint64_t x30;
    uint64_t x31;
    uint64_t x32;
    uint64_t x33;
    uint64_t x34;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x35;
    uint64_t x36;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x37;
    uint64_t x38;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x39;
    uint64_t x40;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x41;
    uint64_t x42;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x43;
    uint64_t x44;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x45;
    uint64_t x46;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x47;
    uint64_t x48;
    uint64_t x49;
    uint64_t x50;
    uint64_t x51;
    uint64_t x52;
    uint64_t x53;
    uint64_t x54;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x55;
    uint64_t x56;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x57;
    uint64_t x58;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x59;
    uint64_t x60;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x61;
    uint64_t x62;
    uint64_t x63;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x64;
    uint64_t x65;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x66;
    uint64_t x67;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x68;
    uint64_t x69;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x70;
    uint64_t x71;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x72;
    uint64_t x73;
    uint64_t x74;
    uint64_t x75;
    uint64_t x76;
    x1 = (arg1[0]);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x2, &x3, x1,
                                                 UINT64_C(0xdbf951d5883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x4, &x5, x2,
                                                 UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x6, &x7, x2, UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x8, &x9, 0x0, x1, x6);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x10, &x11, 0x0,
                                                      (x9 + x7), (arg1[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x12, &x13, x10,
                                                 UINT64_C(0xdbf951d5883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x14, &x15, x12,
                                                 UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x16, &x17, x12,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x18, &x19, 0x0, x5, x14);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x20, &x21, 0x0, x10,
                                                      x16);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(
        &x22, &x23, 0x0, (((uint64_t)x21 + x11) + x17), (arg1[2]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x24, &x25, x23, x4, 0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x26, &x27, x25, x18,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x28, &x29, x22,
                                                 UINT64_C(0xdbf951d5883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x30, &x31, x28,
                                                 UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x32, &x33, x28,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x34, &x35, 0x0, x22,
                                                      x32);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x36, &x37, x35, x24,
                                                      x33);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x38, &x39, x37, x26,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x40, &x41, x39,
                                                      (x27 + (x19 + x15)), x30);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x42, &x43, 0x0, x36,
                                                      (arg1[3]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x44, &x45, x43, x38,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x46, &x47, x45, x40,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x48, &x49, x42,
                                                 UINT64_C(0xdbf951d5883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x50, &x51, x48,
                                                 UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x52, &x53, x48,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x54, &x55, 0x0, x42,
                                                      x52);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x56, &x57, x55, x44,
                                                      x53);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x58, &x59, x57, x46,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x60, &x61, x59,
                                                      (x47 + (x41 + x31)), x50);
    x62 = (x61 + x51);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x63, &x64, 0x0, x56,
                                                       UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x65, &x66, x64, x58,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x67, &x68, x66, x60,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(
        &x69, &x70, x68, x62, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x71, &x72, x70, 0x0,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x73, x72, x63, x56);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x74, x72, x65, x58);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x75, x72, x67, x60);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x76, x72, x69, x62);
    out1[0] = x73;
    out1[1] = x74;
    out1[2] = x75;
    out1[3] = x76;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_to_montgomery translates a field element into the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_to_montgomery(
    uint64_t out1[4], const uint64_t arg1[4]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x12;
    uint64_t x13;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x14;
    uint64_t x15;
    uint64_t x16;
    uint64_t x17;
    uint64_t x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x22;
    uint64_t x23;
    uint64_t x24;
    uint64_t x25;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x26;
    uint64_t x27;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x28;
    uint64_t x29;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x30;
    uint64_t x31;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x32;
    uint64_t x33;
    uint64_t x34;
    uint64_t x35;
    uint64_t x36;
    uint64_t x37;
    uint64_t x38;
    uint64_t x39;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x40;
    uint64_t x41;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x42;
    uint64_t x43;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x44;
    uint64_t x45;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x46;
    uint64_t x47;
    uint64_t x48;
    uint64_t x49;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x50;
    uint64_t x51;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x52;
    uint64_t x53;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x54;
    uint64_t x55;
    uint64_t x56;
    uint64_t x57;
    uint64_t x58;
    uint64_t x59;
    uint64_t x60;
    uint64_t x61;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x62;
    uint64_t x63;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x64;
    uint64_t x65;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x66;
    uint64_t x67;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x68;
    uint64_t x69;
    uint64_t x70;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x71;
    uint64_t x72;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x73;
    uint64_t x74;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x75;
    uint64_t x76;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x77;
    uint64_t x78;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x79;
    uint64_t x80;
    uint64_t x81;
    uint64_t x82;
    uint64_t x83;
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x1, &x2, (arg1[0]),
                                                 UINT32_C(0x464584));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x3, &x4, x1,
                                                 UINT64_C(0xdbf951d5883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x5, &x6, x3,
                                                 UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x7, &x8, x3, UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x9, &x10, (arg1[1]),
                                                 UINT32_C(0x464584));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x11, &x12, 0x0, x1, x7);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x13, &x14, 0x0,
                                                      ((x12 + x2) + x8), x9);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x15, &x16, x13,
                                                 UINT64_C(0xdbf951d5883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x17, &x18, x15,
                                                 UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x19, &x20, x15,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x21, &x22, 0x0, x6, x17);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x23, &x24, (arg1[2]),
                                                 UINT32_C(0x464584));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x25, &x26, 0x0, x13,
                                                      x19);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(
        &x27, &x28, 0x0, ((x26 + (x14 + x10)) + x20), x23);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x29, &x30, x28, x5, x24);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x31, &x32, x30, x21,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x33, &x34, x27,
                                                 UINT64_C(0xdbf951d5883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x35, &x36, x33,
                                                 UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x37, &x38, x33,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x39, &x40, 0x0, x27,
                                                      x37);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x41, &x42, x40, x29,
                                                      x38);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x43, &x44, x42, x31,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x45, &x46, x44,
                                                      (x32 + (x22 + x18)), x35);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x47, &x48, (arg1[3]),
                                                 UINT32_C(0x464584));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x49, &x50, 0x0, x41,
                                                      x47);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x51, &x52, x50, x43,
                                                      x48);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x53, &x54, x52, x45,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x55, &x56, x49,
                                                 UINT64_C(0xdbf951d5883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x57, &x58, x55,
                                                 UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u64(&x59, &x60, x55,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x61, &x62, 0x0, x49,
                                                      x59);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x63, &x64, x62, x51,
                                                      x60);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x65, &x66, x64, x53,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u64(&x67, &x68, x66,
                                                      (x54 + (x46 + x36)), x57);
    x69 = (x68 + x58);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x70, &x71, 0x0, x63,
                                                       UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x72, &x73, x71, x65,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x74, &x75, x73, x67,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(
        &x76, &x77, x75, x69, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u64(&x78, &x79, x77, 0x0,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x80, x79, x70, x63);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x81, x79, x72, x65);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x82, x79, x74, x67);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x83, x79, x76, x69);
    out1[0] = x80;
    out1[1] = x81;
    out1[2] = x82;
    out1[3] = x83;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_id_GostR3410_2001_TestParamSet_nonzero(
    uint64_t *out1, const uint64_t arg1[4]) {
    uint64_t x1;
    x1 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | (arg1[3]))));
    *out1 = x1;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_selectznz(
    uint64_t out1[4], fiat_id_GostR3410_2001_TestParamSet_uint1 arg1,
    const uint64_t arg2[4], const uint64_t arg3[4]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x1, arg1, (arg2[0]),
                                                    (arg3[0]));
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x2, arg1, (arg2[1]),
                                                    (arg3[1]));
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x3, arg1, (arg2[2]),
                                                    (arg3[2]));
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u64(&x4, arg1, (arg2[3]),
                                                    (arg3[3]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_to_bytes(
    uint8_t out1[32], const uint64_t arg1[4]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint8_t x5;
    uint64_t x6;
    uint8_t x7;
    uint64_t x8;
    uint8_t x9;
    uint64_t x10;
    uint8_t x11;
    uint64_t x12;
    uint8_t x13;
    uint64_t x14;
    uint8_t x15;
    uint64_t x16;
    uint8_t x17;
    uint8_t x18;
    uint8_t x19;
    uint64_t x20;
    uint8_t x21;
    uint64_t x22;
    uint8_t x23;
    uint64_t x24;
    uint8_t x25;
    uint64_t x26;
    uint8_t x27;
    uint64_t x28;
    uint8_t x29;
    uint64_t x30;
    uint8_t x31;
    uint8_t x32;
    uint8_t x33;
    uint64_t x34;
    uint8_t x35;
    uint64_t x36;
    uint8_t x37;
    uint64_t x38;
    uint8_t x39;
    uint64_t x40;
    uint8_t x41;
    uint64_t x42;
    uint8_t x43;
    uint64_t x44;
    uint8_t x45;
    uint8_t x46;
    uint8_t x47;
    uint64_t x48;
    uint8_t x49;
    uint64_t x50;
    uint8_t x51;
    uint64_t x52;
    uint8_t x53;
    uint64_t x54;
    uint8_t x55;
    uint64_t x56;
    uint8_t x57;
    uint64_t x58;
    uint8_t x59;
    uint8_t x60;
    x1 = (arg1[3]);
    x2 = (arg1[2]);
    x3 = (arg1[1]);
    x4 = (arg1[0]);
    x5 = (uint8_t)(x4 & UINT8_C(0xff));
    x6 = (x4 >> 8);
    x7 = (uint8_t)(x6 & UINT8_C(0xff));
    x8 = (x6 >> 8);
    x9 = (uint8_t)(x8 & UINT8_C(0xff));
    x10 = (x8 >> 8);
    x11 = (uint8_t)(x10 & UINT8_C(0xff));
    x12 = (x10 >> 8);
    x13 = (uint8_t)(x12 & UINT8_C(0xff));
    x14 = (x12 >> 8);
    x15 = (uint8_t)(x14 & UINT8_C(0xff));
    x16 = (x14 >> 8);
    x17 = (uint8_t)(x16 & UINT8_C(0xff));
    x18 = (uint8_t)(x16 >> 8);
    x19 = (uint8_t)(x3 & UINT8_C(0xff));
    x20 = (x3 >> 8);
    x21 = (uint8_t)(x20 & UINT8_C(0xff));
    x22 = (x20 >> 8);
    x23 = (uint8_t)(x22 & UINT8_C(0xff));
    x24 = (x22 >> 8);
    x25 = (uint8_t)(x24 & UINT8_C(0xff));
    x26 = (x24 >> 8);
    x27 = (uint8_t)(x26 & UINT8_C(0xff));
    x28 = (x26 >> 8);
    x29 = (uint8_t)(x28 & UINT8_C(0xff));
    x30 = (x28 >> 8);
    x31 = (uint8_t)(x30 & UINT8_C(0xff));
    x32 = (uint8_t)(x30 >> 8);
    x33 = (uint8_t)(x2 & UINT8_C(0xff));
    x34 = (x2 >> 8);
    x35 = (uint8_t)(x34 & UINT8_C(0xff));
    x36 = (x34 >> 8);
    x37 = (uint8_t)(x36 & UINT8_C(0xff));
    x38 = (x36 >> 8);
    x39 = (uint8_t)(x38 & UINT8_C(0xff));
    x40 = (x38 >> 8);
    x41 = (uint8_t)(x40 & UINT8_C(0xff));
    x42 = (x40 >> 8);
    x43 = (uint8_t)(x42 & UINT8_C(0xff));
    x44 = (x42 >> 8);
    x45 = (uint8_t)(x44 & UINT8_C(0xff));
    x46 = (uint8_t)(x44 >> 8);
    x47 = (uint8_t)(x1 & UINT8_C(0xff));
    x48 = (x1 >> 8);
    x49 = (uint8_t)(x48 & UINT8_C(0xff));
    x50 = (x48 >> 8);
    x51 = (uint8_t)(x50 & UINT8_C(0xff));
    x52 = (x50 >> 8);
    x53 = (uint8_t)(x52 & UINT8_C(0xff));
    x54 = (x52 >> 8);
    x55 = (uint8_t)(x54 & UINT8_C(0xff));
    x56 = (x54 >> 8);
    x57 = (uint8_t)(x56 & UINT8_C(0xff));
    x58 = (x56 >> 8);
    x59 = (uint8_t)(x58 & UINT8_C(0xff));
    x60 = (uint8_t)(x58 >> 8);
    out1[0] = x5;
    out1[1] = x7;
    out1[2] = x9;
    out1[3] = x11;
    out1[4] = x13;
    out1[5] = x15;
    out1[6] = x17;
    out1[7] = x18;
    out1[8] = x19;
    out1[9] = x21;
    out1[10] = x23;
    out1[11] = x25;
    out1[12] = x27;
    out1[13] = x29;
    out1[14] = x31;
    out1[15] = x32;
    out1[16] = x33;
    out1[17] = x35;
    out1[18] = x37;
    out1[19] = x39;
    out1[20] = x41;
    out1[21] = x43;
    out1[22] = x45;
    out1[23] = x46;
    out1[24] = x47;
    out1[25] = x49;
    out1[26] = x51;
    out1[27] = x53;
    out1[28] = x55;
    out1[29] = x57;
    out1[30] = x59;
    out1[31] = x60;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
 * Preconditions:
 *   0 ≤ bytes_eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_from_bytes(
    uint64_t out1[4], const uint8_t arg1[32]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint8_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint8_t x16;
    uint64_t x17;
    uint64_t x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    uint64_t x23;
    uint8_t x24;
    uint64_t x25;
    uint64_t x26;
    uint64_t x27;
    uint64_t x28;
    uint64_t x29;
    uint64_t x30;
    uint64_t x31;
    uint8_t x32;
    uint64_t x33;
    uint64_t x34;
    uint64_t x35;
    uint64_t x36;
    uint64_t x37;
    uint64_t x38;
    uint64_t x39;
    uint64_t x40;
    uint64_t x41;
    uint64_t x42;
    uint64_t x43;
    uint64_t x44;
    uint64_t x45;
    uint64_t x46;
    uint64_t x47;
    uint64_t x48;
    uint64_t x49;
    uint64_t x50;
    uint64_t x51;
    uint64_t x52;
    uint64_t x53;
    uint64_t x54;
    uint64_t x55;
    uint64_t x56;
    uint64_t x57;
    uint64_t x58;
    uint64_t x59;
    uint64_t x60;
    x1 = ((uint64_t)(arg1[31]) << 56);
    x2 = ((uint64_t)(arg1[30]) << 48);
    x3 = ((uint64_t)(arg1[29]) << 40);
    x4 = ((uint64_t)(arg1[28]) << 32);
    x5 = ((uint64_t)(arg1[27]) << 24);
    x6 = ((uint64_t)(arg1[26]) << 16);
    x7 = ((uint64_t)(arg1[25]) << 8);
    x8 = (arg1[24]);
    x9 = ((uint64_t)(arg1[23]) << 56);
    x10 = ((uint64_t)(arg1[22]) << 48);
    x11 = ((uint64_t)(arg1[21]) << 40);
    x12 = ((uint64_t)(arg1[20]) << 32);
    x13 = ((uint64_t)(arg1[19]) << 24);
    x14 = ((uint64_t)(arg1[18]) << 16);
    x15 = ((uint64_t)(arg1[17]) << 8);
    x16 = (arg1[16]);
    x17 = ((uint64_t)(arg1[15]) << 56);
    x18 = ((uint64_t)(arg1[14]) << 48);
    x19 = ((uint64_t)(arg1[13]) << 40);
    x20 = ((uint64_t)(arg1[12]) << 32);
    x21 = ((uint64_t)(arg1[11]) << 24);
    x22 = ((uint64_t)(arg1[10]) << 16);
    x23 = ((uint64_t)(arg1[9]) << 8);
    x24 = (arg1[8]);
    x25 = ((uint64_t)(arg1[7]) << 56);
    x26 = ((uint64_t)(arg1[6]) << 48);
    x27 = ((uint64_t)(arg1[5]) << 40);
    x28 = ((uint64_t)(arg1[4]) << 32);
    x29 = ((uint64_t)(arg1[3]) << 24);
    x30 = ((uint64_t)(arg1[2]) << 16);
    x31 = ((uint64_t)(arg1[1]) << 8);
    x32 = (arg1[0]);
    x33 = (x31 + (uint64_t)x32);
    x34 = (x30 + x33);
    x35 = (x29 + x34);
    x36 = (x28 + x35);
    x37 = (x27 + x36);
    x38 = (x26 + x37);
    x39 = (x25 + x38);
    x40 = (x23 + (uint64_t)x24);
    x41 = (x22 + x40);
    x42 = (x21 + x41);
    x43 = (x20 + x42);
    x44 = (x19 + x43);
    x45 = (x18 + x44);
    x46 = (x17 + x45);
    x47 = (x15 + (uint64_t)x16);
    x48 = (x14 + x47);
    x49 = (x13 + x48);
    x50 = (x12 + x49);
    x51 = (x11 + x50);
    x52 = (x10 + x51);
    x53 = (x9 + x52);
    x54 = (x7 + (uint64_t)x8);
    x55 = (x6 + x54);
    x56 = (x5 + x55);
    x57 = (x4 + x56);
    x58 = (x3 + x57);
    x59 = (x2 + x58);
    x60 = (x1 + x59);
    out1[0] = x39;
    out1[1] = x46;
    out1[2] = x53;
    out1[3] = x60;
}

/* END verbatim fiat code */

/*-
 * Finite field inversion via FLT.
 * NB: this is not a real Fiat function, just named that way for consistency.
 * Autogenerated: ecp/id_GostR3410_2001_TestParamSet/fe_inv.op3
 * sliding window w=5
 */
static void fiat_id_GostR3410_2001_TestParamSet_inv(fe_t output,
                                                    const fe_t t1) {
    int i;
    /* temporary variables */
    fe_t acc, t15;

    fiat_id_GostR3410_2001_TestParamSet_square(acc, t1);
    fiat_id_GostR3410_2001_TestParamSet_mul(t15, t1, acc);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_TestParamSet_mul(t15, t15, acc);
    fiat_id_GostR3410_2001_TestParamSet_square(acc, t1);
    for (i = 0; i < 244; i++)
        fiat_id_GostR3410_2001_TestParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_TestParamSet_mul(acc, acc, t1);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_TestParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_TestParamSet_mul(acc, acc, t1);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_TestParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_TestParamSet_mul(output, acc, t15);
}

/* curve coefficient constants */

static const limb_t const_one[4] = {
    UINT64_C(0xFFFFFFFFFFFFFBCF), UINT64_C(0xFFFFFFFFFFFFFFFF),
    UINT64_C(0xFFFFFFFFFFFFFFFF), UINT64_C(0x7FFFFFFFFFFFFFFF)};

static const limb_t const_a[4] = {
    UINT64_C(0xFFFFFFFFFFFFC983), UINT64_C(0xFFFFFFFFFFFFFFFF),
    UINT64_C(0xFFFFFFFFFFFFFFFF), UINT64_C(0x7FFFFFFFFFFFFFFF)};

static const limb_t const_b3[4] = {
    UINT64_C(0x81733EE96AEAB71C), UINT64_C(0x00CD3D1CFC4E6FC7),
    UINT64_C(0x60AB503A75853407), UINT64_C(0x0A9EC8AE4556810A)};

/* LUT for scalar multiplication by comb interleaving */
static const pt_aff_t lut_cmb[27][16] = {
    {
        {{UINT64_C(0xFFFFFFFFFFFFF36D), UINT64_C(0xFFFFFFFFFFFFFFFF),
          UINT64_C(0xFFFFFFFFFFFFFFFF), UINT64_C(0x7FFFFFFFFFFFFFFF)},
         {UINT64_C(0x9AF45A5A471125F5), UINT64_C(0x7CE5090AF69BF9AE),
          UINT64_C(0x67617A63E4B6DDE6), UINT64_C(0x03F66B354AA3DAA4)}},
        {{UINT64_C(0xB39BDC16149B5D15), UINT64_C(0x87CE978A7309454F),
          UINT64_C(0xD22F32EF315A7A56), UINT64_C(0x4C7DE232B69A6B57)},
         {UINT64_C(0x9E2DAF6D466DC64D), UINT64_C(0x758C27B14B1C8A55),
          UINT64_C(0x74A0CB23BD647F1A), UINT64_C(0x27E748682C2F4C70)}},
        {{UINT64_C(0xF2D8F32E55A62594), UINT64_C(0x8323D57036BC547A),
          UINT64_C(0x497679EB98D4B25A), UINT64_C(0x061167F2B87E0534)},
         {UINT64_C(0xE1FFFDCE223E4DF8), UINT64_C(0x7C83AE78DCD891E9),
          UINT64_C(0x743985863C1B95D0), UINT64_C(0x11D7320574B3F5AB)}},
        {{UINT64_C(0x34B9C048ACB97F7C), UINT64_C(0x8232E73CE3B9BCC6),
          UINT64_C(0x81F4B63FDA2DB71D), UINT64_C(0x4EEE5393A2DF4C84)},
         {UINT64_C(0xCA6E63AEAC469C69), UINT64_C(0x27BC807C428E4F01),
          UINT64_C(0x4A2C23BA5F4EC124), UINT64_C(0x74847CFCAAE2668B)}},
        {{UINT64_C(0x4435585F6716AF4E), UINT64_C(0xB872D8B71CDB965F),
          UINT64_C(0x662F1962746FFAD0), UINT64_C(0x52761A24DB5D0187)},
         {UINT64_C(0xF6A09922A57E0E3D), UINT64_C(0x86C69342A9C12B63),
          UINT64_C(0x91FF20B65AF190C5), UINT64_C(0x10DB7A2A4EEEE1AE)}},
        {{UINT64_C(0xBB464A5374628B90), UINT64_C(0x6E7A1227057A4F25),
          UINT64_C(0x4C309D690B0FA41F), UINT64_C(0x7548260777FE7B93)},
         {UINT64_C(0xF2583EC70B612421), UINT64_C(0xFF2CFC835E2B15ED),
          UINT64_C(0x1E97A7DB8CABC5CF), UINT64_C(0x1EC08FAA925C149F)}},
        {{UINT64_C(0xBA0170E30E9FCBA9), UINT64_C(0x8976DF7C70D9939B),
          UINT64_C(0xEAE6E74B21AF14DD), UINT64_C(0x09F098680D0861F9)},
         {UINT64_C(0x4F7FE26E21A781FF), UINT64_C(0x1725B8D0D73DCEF7),
          UINT64_C(0x9DA632177E743498), UINT64_C(0x0F51D42C1B828B99)}},
        {{UINT64_C(0xBABB076B9AFE09BD), UINT64_C(0x4AC8922317C4050D),
          UINT64_C(0xCA3EA6E3DA3E57E8), UINT64_C(0x20AAA384A33242C0)},
         {UINT64_C(0x6D3A1F2DEF929BF5), UINT64_C(0xB34E2605E751A62D),
          UINT64_C(0xE1AC629FB8CF1F99), UINT64_C(0x7152D4E3F0BBA01A)}},
        {{UINT64_C(0xA97A6CE3943E5B8E), UINT64_C(0x1C0F6C7F2D053A9D),
          UINT64_C(0x9D4A91DE64457DE4), UINT64_C(0x1E19EA8FC6140057)},
         {UINT64_C(0xD4766CB6500995C8), UINT64_C(0xA019D41DE70CD7EE),
          UINT64_C(0xBA1828AA7AB0A162), UINT64_C(0x0CACA0630B7A4E93)}},
        {{UINT64_C(0x1E68315CA1B3FE03), UINT64_C(0x21FB277E1AAB6B20),
          UINT64_C(0x210305D76A90FB22), UINT64_C(0x4C3D3EEA2E51B9BC)},
         {UINT64_C(0xC5662C6D89C3A2E8), UINT64_C(0x66EA48181712BF9B),
          UINT64_C(0x417F8F042254FBAB), UINT64_C(0x2F57DF29B057EEC1)}},
        {{UINT64_C(0xF6975C9F6509AE4F), UINT64_C(0x58300438DC89C220),
          UINT64_C(0xE81DA879907FF785), UINT64_C(0x68D600E30910ED2F)},
         {UINT64_C(0xFBB25113B43BF686), UINT64_C(0x8B391E3F50A64FAE),
          UINT64_C(0x8C1190D23112B7ED), UINT64_C(0x617BCD41CCB4CA50)}},
        {{UINT64_C(0x75036E69DD780ACA), UINT64_C(0xC90A01DE6FBCD996),
          UINT64_C(0x75E1A8E80C851CEF), UINT64_C(0x7225D38AF71BDCC6)},
         {UINT64_C(0x74AE6935868B78D2), UINT64_C(0xE70570F31CDB5A1E),
          UINT64_C(0x3E700C48BEBD2FA4), UINT64_C(0x3E483638325D3214)}},
        {{UINT64_C(0x9F272CD5C0E6D8AD), UINT64_C(0x9E29687CE09743A2),
          UINT64_C(0xBE0E0D5993CD64B3), UINT64_C(0x5D57A75D504B58F0)},
         {UINT64_C(0x81A1A6E35D44B092), UINT64_C(0x38AD0169310D7868),
          UINT64_C(0xC8D3C9A6CC297B73), UINT64_C(0x34D98A19908E0814)}},
        {{UINT64_C(0xFFB946ADE5A57E1F), UINT64_C(0xF7EA0AA2191B6C5F),
          UINT64_C(0x52D070588DF529C1), UINT64_C(0x06B7BDE52AFDA727)},
         {UINT64_C(0x651E6DC990658555), UINT64_C(0x8F910D891FC416CE),
          UINT64_C(0x0BA4D84ECBF086D5), UINT64_C(0x73DA158C0C4A4B4A)}},
        {{UINT64_C(0xE22420A6521DB62C), UINT64_C(0x8EBC1A21BC90EB6F),
          UINT64_C(0xE1529AACE50F6EB4), UINT64_C(0x4025BF278BE235DB)},
         {UINT64_C(0x406077109FFE2B82), UINT64_C(0x7A6BB75B696B4634),
          UINT64_C(0x0CEF27A92B2F25D3), UINT64_C(0x6C9CFFD7CA0B7112)}},
        {{UINT64_C(0x12B39FF0EDA5C43B), UINT64_C(0x2E1FC66C54E0FE3F),
          UINT64_C(0xFB2DEA80248A9167), UINT64_C(0x11BCDA103B2BB322)},
         {UINT64_C(0xFDDF6E8416D2C928), UINT64_C(0x99DDF6A136E887F4),
          UINT64_C(0x1E56D2F3920092D6), UINT64_C(0x67433BF42D77AE5A)}},
    },
    {
        {{UINT64_C(0x6C204DDC321BFA62), UINT64_C(0xA96E42B82F138A80),
          UINT64_C(0x4C98E986E3EC1A7D), UINT64_C(0x223C8BC4136CADC4)},
         {UINT64_C(0xFA9F15D3BA3CE54A), UINT64_C(0xA103B9D719963D88),
          UINT64_C(0x1ED233542F811A21), UINT64_C(0x64D6B14C65A4E833)}},
        {{UINT64_C(0x2485175CCFBD1039), UINT64_C(0xC4DAE65B7C92D8EC),
          UINT64_C(0x6FC70F541859FD47), UINT64_C(0x6D54344433E8305C)},
         {UINT64_C(0x1A65FEC2944DDA07), UINT64_C(0x7BCF8391EF375B21),
          UINT64_C(0xDDCFC356BE4CD8D6), UINT64_C(0x4BF93B9E13850042)}},
        {{UINT64_C(0xBDF7A56C88B7F950), UINT64_C(0x3A60E5FC81B8590E),
          UINT64_C(0x475B94D16F6E6807), UINT64_C(0x2F1B9F062F0D49A8)},
         {UINT64_C(0x3C36DCF32E6A01D3), UINT64_C(0x807E1D5B30444003),
          UINT64_C(0xE3768486FECF5768), UINT64_C(0x73C4D0CFEF12B5CC)}},
        {{UINT64_C(0x9D76477CF4C6FF93), UINT64_C(0x03F16687C5A1A495),
          UINT64_C(0x5071DA3DB41748B2), UINT64_C(0x0F3A3784971D6A7D)},
         {UINT64_C(0x0B9A5AD62785A782), UINT64_C(0x957E72A009FF09F9),
          UINT64_C(0x3072C1DCAE3CF5F4), UINT64_C(0x63D463ACCD9CFD7E)}},
        {{UINT64_C(0xDA0DEE0BC77B516C), UINT64_C(0x446D7199E6AA0E1F),
          UINT64_C(0xCC0D1590BFFA705C), UINT64_C(0x6A6FC81CC35B59BA)},
         {UINT64_C(0x39DF210E593E3EB9), UINT64_C(0x17F331CED0DCC01F),
          UINT64_C(0x02E0E5EBBD176C5B), UINT64_C(0x68946CCC8A2D6290)}},
        {{UINT64_C(0x8D1400D609ECFEF2), UINT64_C(0x57D5F91BE1E76A98),
          UINT64_C(0x5CF76130A12DFF8D), UINT64_C(0x5C36192261002939)},
         {UINT64_C(0x8D45C8C1FB0FE974), UINT64_C(0x0C97725EF942ED70),
          UINT64_C(0xB1C6649873C5AA42), UINT64_C(0x4A121FC47E203187)}},
        {{UINT64_C(0x58430EE3FCEDA76C), UINT64_C(0x3496699AF5C88D62),
          UINT64_C(0x1C3FC81114273E7E), UINT64_C(0x3E38E9FC1D6D67DA)},
         {UINT64_C(0xBB683EA4AB685B3B), UINT64_C(0xB63F72B1B0904BB3),
          UINT64_C(0x5DFA23C547A75297), UINT64_C(0x09E80AA038B59560)}},
        {{UINT64_C(0x7D8325C67F4D22FC), UINT64_C(0xBFFB01B18C2FA282),
          UINT64_C(0x01A037DC4A89BE98), UINT64_C(0x092F652584EA8C8A)},
         {UINT64_C(0x873D33DAC52FD518), UINT64_C(0x0A245B1544AFDD41),
          UINT64_C(0x7899373798FA7FF5), UINT64_C(0x1BB48AD221D29087)}},
        {{UINT64_C(0x00C97A991A59313C), UINT64_C(0xBD4F29EE5CF9A6FF),
          UINT64_C(0xEA59D87AD839B62B), UINT64_C(0x16F18F4897CAB63C)},
         {UINT64_C(0xB339789A6F6C292F), UINT64_C(0xEC52E644D005ABB2),
          UINT64_C(0xEEAC93C9AE24DA46), UINT64_C(0x0ECB9957E5C43B4F)}},
        {{UINT64_C(0xD91B220220561AF7), UINT64_C(0xECA260DD55F2CFB8),
          UINT64_C(0xF03A8C1D17B91CCF), UINT64_C(0x55A0491F64B35D9A)},
         {UINT64_C(0x0A97E5CC1A2F8F39), UINT64_C(0x02C187D123B1D80B),
          UINT64_C(0xA9C13D26DB9FBA1A), UINT64_C(0x7CCDDBACF8051F0D)}},
        {{UINT64_C(0x05CA8EA5ED0E9DB8), UINT64_C(0xE888079F53A8EA3F),
          UINT64_C(0x6DDBC40D9209BFA2), UINT64_C(0x068E5BA980DCEAEA)},
         {UINT64_C(0xDB69D133B19D824B), UINT64_C(0x65154FB6E6A3A462),
          UINT64_C(0x9FCF733D020B2AC7), UINT64_C(0x15178DDEE1329315)}},
        {{UINT64_C(0x76F78865877EE476), UINT64_C(0x5824EACC12B471BA),
          UINT64_C(0x71BDFADFBBB640A8), UINT64_C(0x5181B08F9A631D09)},
         {UINT64_C(0x2913CCA5FFE978E8), UINT64_C(0x9CEF3612AEB89AA6),
          UINT64_C(0x93BB373EE02AD6DC), UINT64_C(0x5D7984F004144769)}},
        {{UINT64_C(0x3219DB074F98D2C3), UINT64_C(0xE3EF888FBD40ACCC),
          UINT64_C(0x07A30E3A31124C73), UINT64_C(0x5D9C820BB070C53F)},
         {UINT64_C(0x94D41768DA0661AB), UINT64_C(0x27FC266121FF87EB),
          UINT64_C(0xB8DCBC7FFF17A977), UINT64_C(0x71F75FF9392EB13D)}},
        {{UINT64_C(0xC5CED56C9AD71AB0), UINT64_C(0xE744EAB039D6C9F1),
          UINT64_C(0x6E49B00B839BD904), UINT64_C(0x0C0EDE2CD7003054)},
         {UINT64_C(0x792C3F801A6A1BB7), UINT64_C(0x6E5093B14B2C7885),
          UINT64_C(0x2887320913EA65F7), UINT64_C(0x085A2697F381C851)}},
        {{UINT64_C(0x84FC6B9DDA60A255), UINT64_C(0x12397EED4B495BC6),
          UINT64_C(0x4881DF6B71A5AA87), UINT64_C(0x57BB32599572CFE2)},
         {UINT64_C(0x306777593A10A65F), UINT64_C(0x670B82ECDB1758DD),
          UINT64_C(0xD84F3E8FD57B513E), UINT64_C(0x617A512A89088E78)}},
        {{UINT64_C(0x83971322AE3D7707), UINT64_C(0x66563CDE6D34D0B4),
          UINT64_C(0x95342D9BC13309ED), UINT64_C(0x62C2B1B6082A5887)},
         {UINT64_C(0xD94A8712C3C27158), UINT64_C(0xDE2C9C9DA844BF60),
          UINT64_C(0xDE897386CE3E4F3C), UINT64_C(0x2C22A82E6ACEBDF1)}},
    },
    {
        {{UINT64_C(0x2755028A0604E200), UINT64_C(0xADE23A7D44189101),
          UINT64_C(0xA6E418F4F0B7F9B7), UINT64_C(0x036F5503212EDC2A)},
         {UINT64_C(0xE069D06A3F5E0456), UINT64_C(0x2FAFF7C80F37F2D8),
          UINT64_C(0xFF08E8797F5EDE53), UINT64_C(0x7F97725D797E0427)}},
        {{UINT64_C(0xE44E39C1B32E5B1B), UINT64_C(0x25CD4614AD3EC706),
          UINT64_C(0x2E97B090E382C5D2), UINT64_C(0x3E1A1F6BB00D79F2)},
         {UINT64_C(0x27573C4EC2375837), UINT64_C(0xAD53D2C86C8D5CCD),
          UINT64_C(0x94EE5460FC09725A), UINT64_C(0x6E59250602DD0DF4)}},
        {{UINT64_C(0x6CFFA4BF3D0C7AC4), UINT64_C(0x663B121869ED4317),
          UINT64_C(0x933094F6C79AD5C1), UINT64_C(0x569F37EDFFC54767)},
         {UINT64_C(0x954EEE0C1F338782), UINT64_C(0x5BE69673A46CA276),
          UINT64_C(0x77BA000920CB26DC), UINT64_C(0x2211CAC3029316AE)}},
        {{UINT64_C(0xC8DEF3CB184EBD7C), UINT64_C(0x393370506A4DB0A0),
          UINT64_C(0x6FF7993A0BE1D82C), UINT64_C(0x01D7674AFC9252C0)},
         {UINT64_C(0xB10BA727F62D9268), UINT64_C(0x6E2338D8817B687B),
          UINT64_C(0x266443F2E47405F1), UINT64_C(0x6A1BD9CE6872B879)}},
        {{UINT64_C(0x192137652B2BD346), UINT64_C(0x962CA22CE2ACFB8E),
          UINT64_C(0x518CF45D62FECDE1), UINT64_C(0x529AE629A13D9E8D)},
         {UINT64_C(0xAF796DB0BB69D5E3), UINT64_C(0xA064209DD4E596B7),
          UINT64_C(0x9F3DFD4A47942C73), UINT64_C(0x7FAB6C6D7810D5EC)}},
        {{UINT64_C(0x55D1525066A3B287), UINT64_C(0x1ECC6A20EEFDDC75),
          UINT64_C(0xF683FA6026DE8C01), UINT64_C(0x4F5DE2A69FBA658C)},
         {UINT64_C(0xE748D78AC66D82F4), UINT64_C(0x2BA525EF3B24C76B),
          UINT64_C(0x5A9539E630EE69CE), UINT64_C(0x2DA4C4C2B7861B2D)}},
        {{UINT64_C(0x9D1E982D820743E6), UINT64_C(0x705D9237AB0CC42D),
          UINT64_C(0xBDD0166347C4E7D7), UINT64_C(0x3D48EE78F8E69896)},
         {UINT64_C(0x7A822BCD41132782), UINT64_C(0xBD41BEFAEE46F715),
          UINT64_C(0x8E5C3B5FD0B2F4B0), UINT64_C(0x690A53D45E47ED55)}},
        {{UINT64_C(0x390536C165A40E44), UINT64_C(0x4B4D79701C92235C),
          UINT64_C(0xCAC270848B7389E4), UINT64_C(0x7B5B23B219041D01)},
         {UINT64_C(0x7C18B9733B5FD5BA), UINT64_C(0xFD14865D84B72217),
          UINT64_C(0x5592547E267EDE4C), UINT64_C(0x22DB62E58B369753)}},
        {{UINT64_C(0x06083D33DDF15BDD), UINT64_C(0x5766555F361925F5),
          UINT64_C(0xECC0F110B7ACDEA7), UINT64_C(0x3E3F1B270A3453B5)},
         {UINT64_C(0x5A8B7DF96F7B980D), UINT64_C(0xEBA90E39B44756AC),
          UINT64_C(0x954D7ECDAC9A7DB2), UINT64_C(0x43F688D328EA7151)}},
        {{UINT64_C(0x51F645694638EFAE), UINT64_C(0x5840A5DB3D28BF3C),
          UINT64_C(0xDD486261134D3E8F), UINT64_C(0x09F17E2C7B6B466B)},
         {UINT64_C(0x30D3546378ED7016), UINT64_C(0x342E9701B86D8508),
          UINT64_C(0xA3FF656542B19533), UINT64_C(0x4405F02C061A4A81)}},
        {{UINT64_C(0x15C921C03D3AAF1E), UINT64_C(0x2DD720C77D297559),
          UINT64_C(0x93A07904CB80E3B2), UINT64_C(0x427C610B6B1EDB93)},
         {UINT64_C(0xD2CE818FF61E2F41), UINT64_C(0x1DA534218252FB3C),
          UINT64_C(0x37A4A997ED07538F), UINT64_C(0x48A928BF962454F2)}},
        {{UINT64_C(0x65091E4D7A420273), UINT64_C(0x6AF382AFE54C0B47),
          UINT64_C(0x150DAB088047A423), UINT64_C(0x22C3740A45BD197C)},
         {UINT64_C(0x64429AA0E07C3468), UINT64_C(0xC506B8C97B37FE10),
          UINT64_C(0x30E2FE783CC5062C), UINT64_C(0x2F3B5A5FA9242F2D)}},
        {{UINT64_C(0x2619A3B25A40BCA1), UINT64_C(0xD012DF23118C2FEA),
          UINT64_C(0x2868C8B7B73FE15C), UINT64_C(0x45A9CC5AEB10B475)},
         {UINT64_C(0x7111AB75069050AD), UINT64_C(0x0665182BEC2398A9),
          UINT64_C(0xD9A5126E9B86A240), UINT64_C(0x601CF0E040E2AED6)}},
        {{UINT64_C(0xE74C9DCDF48C8655), UINT64_C(0xEE703CA8900E89D5),
          UINT64_C(0x6C2DFF8B5390F052), UINT64_C(0x08588E891316CC4C)},
         {UINT64_C(0x0F2CC83A47E80C87), UINT64_C(0x23DE34CFD87824E4),
          UINT64_C(0xC530AF41541FE8F9), UINT64_C(0x0BF01DC0D142F1C0)}},
        {{UINT64_C(0x210B0B1E886C0C4A), UINT64_C(0x66369DF19C56A126),
          UINT64_C(0x5D79AE81EAC22A5E), UINT64_C(0x4E6C67D4D16F7DB6)},
         {UINT64_C(0x274572F6247CDE60), UINT64_C(0xF3C92AC754E8454B),
          UINT64_C(0x784EC1A1F08C32D1), UINT64_C(0x222716D8E1FE9C4E)}},
        {{UINT64_C(0xAF6AEF5D3FB1DB1E), UINT64_C(0xB8B55842C4C2A4D8),
          UINT64_C(0x258A2F44CA5AB578), UINT64_C(0x558A803F7D8B2D70)},
         {UINT64_C(0x9A7345C37E0247A3), UINT64_C(0x4E5A6904B4D920B1),
          UINT64_C(0xCF7FAA4176BCBBE1), UINT64_C(0x66CF993FEE112271)}},
    },
    {
        {{UINT64_C(0xDE7D208F84D2C56B), UINT64_C(0xD1C77403DDA20F33),
          UINT64_C(0xB73FDC099A6F337A), UINT64_C(0x1B2A380740CD2CBD)},
         {UINT64_C(0xB642FA2C65988D73), UINT64_C(0x117E75BC059DAB8E),
          UINT64_C(0xC7E2E935D6B279AA), UINT64_C(0x5EEB9654EEA2A445)}},
        {{UINT64_C(0xA84747C0A59D7A2A), UINT64_C(0x4478AD4A1004C5B8),
          UINT64_C(0xF55C2B1BA22DE791), UINT64_C(0x2FF6097D23F8F89F)},
         {UINT64_C(0xD079C875E117BC40), UINT64_C(0x14AEA36003CB43DD),
          UINT64_C(0x8C730D890A20D653), UINT64_C(0x6956274A02FD02D8)}},
        {{UINT64_C(0x9F5D0E9DD46293CF), UINT64_C(0x53748DD4F0D93AB7),
          UINT64_C(0x6F81339FB9C37CF0), UINT64_C(0x00B8677AF4B041FC)},
         {UINT64_C(0xF76E0FFEB5A6FE97), UINT64_C(0x6D3C71F5F7D198A2),
          UINT64_C(0xF91E840811420372), UINT64_C(0x36F9F35470036AED)}},
        {{UINT64_C(0x503AF4F25D446956), UINT64_C(0xCA08C5372DC9777C),
          UINT64_C(0xDB4BA888E1308D3A), UINT64_C(0x01EA28EA01DB98CB)},
         {UINT64_C(0x27CC52A9A7DF5FE0), UINT64_C(0x7DA5186B7DE31E0A),
          UINT64_C(0x63E32889F136FAD5), UINT64_C(0x1BB010A8A363AF23)}},
        {{UINT64_C(0x65828B54C0FE56C9), UINT64_C(0x7322CD514ED3935A),
          UINT64_C(0x42F068F437B4A727), UINT64_C(0x7AA9F9F0B4C02BE4)},
         {UINT64_C(0xBB77851ADEBB2DD4), UINT64_C(0x7757D5F6D105B81F),
          UINT64_C(0x7805369C52FA1512), UINT64_C(0x4CBC43AE38B6976A)}},
        {{UINT64_C(0x24FE8ABD4096725B), UINT64_C(0xC3FAC73A3895D1E2),
          UINT64_C(0xBCAF7757006A2360), UINT64_C(0x75AE96ADC03EBB33)},
         {UINT64_C(0x310744780BD1FB6F), UINT64_C(0x729E8E6AEA386CBE),
          UINT64_C(0xA8BBCC0B4845AAEC), UINT64_C(0x1A0A2D19E6582656)}},
        {{UINT64_C(0x332BC9BD69BD55F7), UINT64_C(0x93D987E2EFB6F780),
          UINT64_C(0xE57DE09614381F4D), UINT64_C(0x7BDF4217FF01C4D9)},
         {UINT64_C(0x2A07C4AB1956BF02), UINT64_C(0x7C7B3684553823D9),
          UINT64_C(0x8F750E8ED40F600C), UINT64_C(0x63F253E99693A3C3)}},
        {{UINT64_C(0x250ED8BFC62CE42B), UINT64_C(0xE8A1A295E70674E1),
          UINT64_C(0x05ED093D163A92F1), UINT64_C(0x515FF44B628969A0)},
         {UINT64_C(0xF617DF0341CE3AF8), UINT64_C(0xCADE131AF9E60202),
          UINT64_C(0xFE83C379363B87E9), UINT64_C(0x7196A80B493EF65F)}},
        {{UINT64_C(0x4B176FE6D7A2047B), UINT64_C(0x6981D18241DCA514),
          UINT64_C(0xDDC7EE8EDC74AC2E), UINT64_C(0x3A95A20385CC07D1)},
         {UINT64_C(0x8D4BA2D8841E3200), UINT64_C(0x837DDD9B5F654197),
          UINT64_C(0x388D358EFBFE4D06), UINT64_C(0x562DE2F261143A85)}},
        {{UINT64_C(0x3BA1F6E5CFACB903), UINT64_C(0xB5BBA41FBD97A3A2),
          UINT64_C(0xB86F117FCFCF2547), UINT64_C(0x506428593D9A13DB)},
         {UINT64_C(0xC15C82AE7B5F2A8F), UINT64_C(0x47E772DDEF89351E),
          UINT64_C(0x78C53901CAAC4CC7), UINT64_C(0x6B0F5D3068D72131)}},
        {{UINT64_C(0x47E17734A0B407E6), UINT64_C(0x29E0683034949A81),
          UINT64_C(0x63D83340CB1AC772), UINT64_C(0x178A6DD6EB84F909)},
         {UINT64_C(0xA9E948263C27D7BA), UINT64_C(0xC86AF96DDB027A4C),
          UINT64_C(0xE7D04E3456D5DF86), UINT64_C(0x7212EAC22E8D0EE3)}},
        {{UINT64_C(0xE7E5AA648A75F66B), UINT64_C(0x7E86B6AA8CFD9597),
          UINT64_C(0x1B7DDE0C834C0271), UINT64_C(0x397EAF2AD4AD306F)},
         {UINT64_C(0x0A3579061657E32B), UINT64_C(0xAAEB2DCF4957B3AF),
          UINT64_C(0x1C0CBD0269D3CEE9), UINT64_C(0x7434EC325A6E7D53)}},
        {{UINT64_C(0xEB5878F785559E86), UINT64_C(0xB9555F704A09C168),
          UINT64_C(0xBFFAC5DB80501134), UINT64_C(0x4CDBF53A05B53160)},
         {UINT64_C(0x1413BA295F90344B), UINT64_C(0xC6A9D1EDD0DD0CFD),
          UINT64_C(0x8C56AA29A0C31B73), UINT64_C(0x1C9B0B61F4E58E08)}},
        {{UINT64_C(0xBF8D22370E2F595A), UINT64_C(0x7A646816CBA13CD8),
          UINT64_C(0xBD2E93A15CD728B6), UINT64_C(0x30FDF85C07CF9009)},
         {UINT64_C(0x3496D94906122B98), UINT64_C(0xE63EC7415A80B3AF),
          UINT64_C(0xA2A39CF782838A44), UINT64_C(0x4A064F99C015E1D4)}},
        {{UINT64_C(0x9CCDF95B456CB242), UINT64_C(0xDA1CB24E6F4517DC),
          UINT64_C(0x60450E0F931A1115), UINT64_C(0x6780D774B5680A8D)},
         {UINT64_C(0xAFE48DCD1FDA4243), UINT64_C(0x6BDD541CAE9733C7),
          UINT64_C(0xCBBCC69CD79D1D52), UINT64_C(0x334F4F671A513B3E)}},
        {{UINT64_C(0xCE7712C4DF49E1A0), UINT64_C(0xB5444862E0B96135),
          UINT64_C(0x10564C4BF050D010), UINT64_C(0x0531AEC8FEBEFCC8)},
         {UINT64_C(0xD45B4BE770DF6D29), UINT64_C(0x1ACC2D706829054E),
          UINT64_C(0x9744CDE154E56E05), UINT64_C(0x3C5DE93E6EE02696)}},
    },
    {
        {{UINT64_C(0xF43A2B993951B674), UINT64_C(0xE82789E85E72FC98),
          UINT64_C(0x2AD4843686992601), UINT64_C(0x3FDEB17201A2B65A)},
         {UINT64_C(0x926B48393666322B), UINT64_C(0x68847D5C44B3FDB7),
          UINT64_C(0xD06C450DF2F5E247), UINT64_C(0x0CEC0646BBA7C892)}},
        {{UINT64_C(0x76446D2661F9C9DA), UINT64_C(0xEF2C7B98AC60376F),
          UINT64_C(0xEEA8CABE2410C057), UINT64_C(0x4C2CE2A73672A2B6)},
         {UINT64_C(0x3F77094512879BA5), UINT64_C(0x719D5BD0AD913022),
          UINT64_C(0x28A82DD936D445A4), UINT64_C(0x26382C23965965AA)}},
        {{UINT64_C(0x66709D92B8AA8419), UINT64_C(0xFAEFF2E40AB5C241),
          UINT64_C(0xABB7C5DD1DD46DEB), UINT64_C(0x7DD03C3339DB6CB5)},
         {UINT64_C(0x76CDD1EA9E160F01), UINT64_C(0x00598D5681C5CA37),
          UINT64_C(0x16D23B04241772EC), UINT64_C(0x5132B02852A6B807)}},
        {{UINT64_C(0x6D48D4B5CC041445), UINT64_C(0x0B1CD9231528DF63),
          UINT64_C(0x82EE4DC64A815F60), UINT64_C(0x29DA60590451E242)},
         {UINT64_C(0xCD90BFB017A8A6D0), UINT64_C(0x8BCF439252A7FC3D),
          UINT64_C(0x49AD55F21974860C), UINT64_C(0x20BBF0105EDCB1D2)}},
        {{UINT64_C(0xB4F0EA84A8F6C08C), UINT64_C(0x4341BEA7D50164F3),
          UINT64_C(0xE538901906320C0F), UINT64_C(0x69D4851A8BA6F033)},
         {UINT64_C(0x1CE5866077902045), UINT64_C(0xF3B88D85BD8579B3),
          UINT64_C(0xF84FF63A4FB0A17B), UINT64_C(0x09EE62EEDE6581BF)}},
        {{UINT64_C(0x8B8C15B57C0516DE), UINT64_C(0x3B448FC3A530B89F),
          UINT64_C(0xE385BBE5500B0251), UINT64_C(0x5F643F85ED70804B)},
         {UINT64_C(0x550D9B7D239E85A5), UINT64_C(0xDC910B5B8666E41F),
          UINT64_C(0x655221817D4E390F), UINT64_C(0x5DD2D3E83162FE10)}},
        {{UINT64_C(0x59609390DF024A25), UINT64_C(0xE66A77E908CCBA91),
          UINT64_C(0xC5CEA91A65E24DB6), UINT64_C(0x0888DFB53DCEA0A7)},
         {UINT64_C(0x8C8E58CC92FA0754), UINT64_C(0x99C259ABF7DC9538),
          UINT64_C(0x3A06D8ED9BEFE750), UINT64_C(0x71AF22E1FAACDC97)}},
        {{UINT64_C(0xCC41D094250AC059), UINT64_C(0xCD792A733BE3DA01),
          UINT64_C(0x2DA07802CC61EFE1), UINT64_C(0x293AFB0857053A5D)},
         {UINT64_C(0x3E7E48842FD8A8A0), UINT64_C(0x183FA5000B9B48D3),
          UINT64_C(0x9CAC07BE431AACF6), UINT64_C(0x4F82D7992DF89F10)}},
        {{UINT64_C(0xFD9F61A80A84935C), UINT64_C(0x78B948D0BB5A7E56),
          UINT64_C(0xDA4787660ACCEEB3), UINT64_C(0x47BDAE4453C3851D)},
         {UINT64_C(0x5AE2C60C0CFE8D0D), UINT64_C(0xAC8F79B31D8A79C9),
          UINT64_C(0xA958C15E0A79CA31), UINT64_C(0x1C46E20EF0952018)}},
        {{UINT64_C(0xAE552ECEF04AC529), UINT64_C(0xB295B601E2BFEFBC),
          UINT64_C(0xECC1EE5554733412), UINT64_C(0x28BCBA5312282094)},
         {UINT64_C(0x306C078150B25069), UINT64_C(0x10D5D23CE9A18FFE),
          UINT64_C(0xC34FC5C71BD5489F), UINT64_C(0x2B610028E191867D)}},
        {{UINT64_C(0x458A1CC13E17E84D), UINT64_C(0x6EAE343D5D7CFB98),
          UINT64_C(0xC6E0FDAA101F0B7E), UINT64_C(0x0B9F7C2C2A023288)},
         {UINT64_C(0xBEA893A86F3FCAA0), UINT64_C(0x7D711B2B452B07C0),
          UINT64_C(0x2895873798E2C88D), UINT64_C(0x553A0180DFD99A2A)}},
        {{UINT64_C(0x8D617BE80DBA5986), UINT64_C(0xDB763C1413D18594),
          UINT64_C(0x822CB0DAD2DAD82F), UINT64_C(0x37ACD99F93239947)},
         {UINT64_C(0x6A2A7070CDC08BE6), UINT64_C(0x86B3B66ACF6D63FF),
          UINT64_C(0x5BEFF3FB0F7D4A67), UINT64_C(0x05C25557EBC94AE5)}},
        {{UINT64_C(0x5D1DC08789183418), UINT64_C(0xA25C7AE26EA5A960),
          UINT64_C(0x074698B9D31F3AAE), UINT64_C(0x5A5B510B221788A4)},
         {UINT64_C(0x896A87871DCE95FE), UINT64_C(0x89E7B93D7F24020C),
          UINT64_C(0xFC19BF42865B4334), UINT64_C(0x0389FBF75B78B06D)}},
        {{UINT64_C(0x73B6DA7B0BB3A3E2), UINT64_C(0xDBC1267044D56755),
          UINT64_C(0x7AF2DE287CC1C589), UINT64_C(0x7E248FCB697CB6B7)},
         {UINT64_C(0x9410EC06C64202C0), UINT64_C(0x79C8215875EB3A8C),
          UINT64_C(0x74FDD2F6E95C5EA9), UINT64_C(0x2A40B5B51CCA72C7)}},
        {{UINT64_C(0x569842235C29E320), UINT64_C(0x8266392AE871D9E2),
          UINT64_C(0x9D86C6C77B391763), UINT64_C(0x5E9E61E202543C9E)},
         {UINT64_C(0xD62A9334D2501D1A), UINT64_C(0x9D19F54D9211135D),
          UINT64_C(0x66D0B9618FE81272), UINT64_C(0x6E64635AD09C2033)}},
        {{UINT64_C(0x93BD0AD806F84E11), UINT64_C(0x45F18F2B131AFDBF),
          UINT64_C(0x881F053F6058EB37), UINT64_C(0x36B8D656948AD0D5)},
         {UINT64_C(0x53DC2E02E1934E38), UINT64_C(0xA8AD5055C0435B6C),
          UINT64_C(0x0DF7BD114BD7154F), UINT64_C(0x6350B05E73BC98FC)}},
    },
    {
        {{UINT64_C(0x12AC549604BF927A), UINT64_C(0x9BB322DBE749323E),
          UINT64_C(0xC10C666DF6D99AD6), UINT64_C(0x0FDF8FB34C883E0A)},
         {UINT64_C(0x10667F92665272E8), UINT64_C(0xA30D4CE15BF8702F),
          UINT64_C(0x56314B47A2D6033D), UINT64_C(0x09EC90D9DAC1A10E)}},
        {{UINT64_C(0x364F06DDC9EB81D1), UINT64_C(0xFD181A564DC5CB76),
          UINT64_C(0x91CF010CE264567C), UINT64_C(0x71D9A95BA05C02FC)},
         {UINT64_C(0xAB5AFBA653967407), UINT64_C(0x3FC779139B0AA089),
          UINT64_C(0xDF1D4912AF29EF02), UINT64_C(0x01C3D61C5796A0A5)}},
        {{UINT64_C(0x11503A1CB376E8DE), UINT64_C(0x5CB17D6DB8B98321),
          UINT64_C(0x96C9D585BD8FE9C2), UINT64_C(0x048C8DA7D117171D)},
         {UINT64_C(0xDF7FABB8B582282A), UINT64_C(0x75C2A93724FD6BB7),
          UINT64_C(0xDF0DBD3200633701), UINT64_C(0x04FB7AEC039B3E72)}},
        {{UINT64_C(0xE60CCE960E20C09A), UINT64_C(0xAD295B31116E1C38),
          UINT64_C(0xCA6B625DC04477D0), UINT64_C(0x032FE03BFFA32E36)},
         {UINT64_C(0x46334FEEE2AAABC6), UINT64_C(0x9808B03CDA1C6871),
          UINT64_C(0x76D0E3AAF934A482), UINT64_C(0x2B0BF54AF9CB8F97)}},
        {{UINT64_C(0xB5D527172CA29D02), UINT64_C(0xF9DAEAFBDBEACF03),
          UINT64_C(0x3786E64B113A3811), UINT64_C(0x6A01A1A55C30569D)},
         {UINT64_C(0x0A91E160BA1C28B6), UINT64_C(0x5BFA32BA929D3F05),
          UINT64_C(0x1108F87540C51084), UINT64_C(0x37FD238342FD5AE1)}},
        {{UINT64_C(0xABF14EDE2A79BFB8), UINT64_C(0x08B34155AA34300C),
          UINT64_C(0x85C0DFA064077041), UINT64_C(0x3AE5D28DF542D447)},
         {UINT64_C(0xC303A0FEB74DC4FB), UINT64_C(0xB75292FA556E0B87),
          UINT64_C(0x785628B051BDC64C), UINT64_C(0x43FE786E13C579F6)}},
        {{UINT64_C(0xBC5898CB5F08790F), UINT64_C(0xA298A59A125644EC),
          UINT64_C(0xD2D9627BB048217A), UINT64_C(0x6DCEEF327B1F23F7)},
         {UINT64_C(0x7F02FC44FA7B9C6A), UINT64_C(0x90C6496073597BF7),
          UINT64_C(0x5DD7E4F42CB0B3A2), UINT64_C(0x5EC5F92C43E83553)}},
        {{UINT64_C(0xC06B4D4959E2C8E9), UINT64_C(0x7DBC82181DF8AD8B),
          UINT64_C(0x35570120DAE8B6D7), UINT64_C(0x4222A1BA0CDE2691)},
         {UINT64_C(0xD2F1EFA6C1693046), UINT64_C(0x2707228D7D36D9CD),
          UINT64_C(0xD668EE25062D499C), UINT64_C(0x7AC81BDFCE2621A0)}},
        {{UINT64_C(0x3A9F04BB16F6A215), UINT64_C(0x739BB2BC89E5494E),
          UINT64_C(0xCB8DBAE8D1CEB043), UINT64_C(0x6B177DF009A6B465)},
         {UINT64_C(0xB7C4980E1A529744), UINT64_C(0x3941B9970E9012B5),
          UINT64_C(0xDF317B9504C6D677), UINT64_C(0x17898D81829F51D6)}},
        {{UINT64_C(0x3D48FD66A12282BA), UINT64_C(0xB775465B899E5A1A),
          UINT64_C(0xDE0CCB9955D95C35), UINT64_C(0x4CB3CCDD950AB9DF)},
         {UINT64_C(0x0B4ABA02175C4CAE), UINT64_C(0x2DA7C698CF86187C),
          UINT64_C(0x3A4453DF9A9BF6CA), UINT64_C(0x53C86F9C8BB9F543)}},
        {{UINT64_C(0x806B815E5B7DB133), UINT64_C(0x2451D6AC118FA7C1),
          UINT64_C(0x32C148B6FB0BEFC3), UINT64_C(0x2E6ECEF6E433031E)},
         {UINT64_C(0x2B78F31754B2EE29), UINT64_C(0xBC321BF95A73BF01),
          UINT64_C(0xDF6F7840F8F7F981), UINT64_C(0x751A917A22280C40)}},
        {{UINT64_C(0x73EFA6314F9161C8), UINT64_C(0xB61C5E6821145C52),
          UINT64_C(0x609477736A04DC52), UINT64_C(0x758E38FF2C2073B2)},
         {UINT64_C(0xDC6FEA7303A54541), UINT64_C(0x5E77682CB6E65787),
          UINT64_C(0xAFEF6C1C37370FD0), UINT64_C(0x33DEEF00D5AC255A)}},
        {{UINT64_C(0x1AD81101061D35CC), UINT64_C(0xD55EED7D8A77D246),
          UINT64_C(0x8D59DC22926E64C3), UINT64_C(0x76C9D6CEAFC6FFA6)},
         {UINT64_C(0x945A89B53F4FCC0F), UINT64_C(0x65EB52CF9087F46A),
          UINT64_C(0xC3380377AE9F09DE), UINT64_C(0x59067EDD43DFD5FB)}},
        {{UINT64_C(0xCBB7BC66CF841445), UINT64_C(0x9ED681D3A3BE7C94),
          UINT64_C(0xF5CF59BE396C6DD5), UINT64_C(0x2598A5DCFA763634)},
         {UINT64_C(0xAD2B445A85CF4FDE), UINT64_C(0xC8CE3F42A0D92F4C),
          UINT64_C(0x78356D5BF01CD0F5), UINT64_C(0x26E44A455D50C9D7)}},
        {{UINT64_C(0x22EB53E34EDF35A5), UINT64_C(0xA0C6CDEFAF1A8A60),
          UINT64_C(0x1D31BA2CD07C1EBD), UINT64_C(0x513511A0D2C2ADE1)},
         {UINT64_C(0xBD3772D4C4449889), UINT64_C(0xAF5EF819D3F49C61),
          UINT64_C(0xAAF2159940047745), UINT64_C(0x2128938CA54B8080)}},
        {{UINT64_C(0x9761A94A73ADBEC8), UINT64_C(0x4710BBF01FB2F257),
          UINT64_C(0xFE52603EB3920007), UINT64_C(0x663937507DE06F13)},
         {UINT64_C(0x35F4E633965AC706), UINT64_C(0xF49DC41833F953E5),
          UINT64_C(0x1562AD5131CFE467), UINT64_C(0x035FB54D8ADB1F7A)}},
    },
    {
        {{UINT64_C(0xF632081FFD73062E), UINT64_C(0xB2740C19CB740B59),
          UINT64_C(0x2DFD957F8751E315), UINT64_C(0x5722E015C21039C2)},
         {UINT64_C(0x44781BFCA4E56D39), UINT64_C(0x894BD2F7DA2FBE63),
          UINT64_C(0x9E81007B5DE22DE0), UINT64_C(0x0CED0859C68788FC)}},
        {{UINT64_C(0x97DD8CF18DDA6292), UINT64_C(0x3E9191F727FCF7F1),
          UINT64_C(0x07885E32DAA6AD44), UINT64_C(0x624CE66EBE9F7E62)},
         {UINT64_C(0x0483DA421893A3D9), UINT64_C(0x1041B7EA8F2A105F),
          UINT64_C(0x5B706F99429A24B9), UINT64_C(0x30BFBCEE167C12E1)}},
        {{UINT64_C(0xEB2C7218C38251D8), UINT64_C(0x5FE5D8F6022B6411),
          UINT64_C(0xF62200C193DCCB63), UINT64_C(0x2CF0F8F1CFF221E6)},
         {UINT64_C(0xDCF1BCD69217EE42), UINT64_C(0x1904879C9DB2580B),
          UINT64_C(0x2DDB7E5DF6510164), UINT64_C(0x7BB299858A0EAC6B)}},
        {{UINT64_C(0x98313C0E0FCF8397), UINT64_C(0xB594D0B742C8EEF1),
          UINT64_C(0xBD31FC3497E842F7), UINT64_C(0x49476B9D8F3ADB9B)},
         {UINT64_C(0xD1B5FD3750B45445), UINT64_C(0x526C51CAD583A89F),
          UINT64_C(0x5D461F096782C060), UINT64_C(0x414023EC27274A60)}},
        {{UINT64_C(0x7C809B26EAE4285A), UINT64_C(0x939814BF0A066043),
          UINT64_C(0x9CBAC0BB6C640E3D), UINT64_C(0x647E22E130EB1B86)},
         {UINT64_C(0x21E2A42D3C7DFA0D), UINT64_C(0xFF8CC304E2CD0CCE),
          UINT64_C(0x3DC8C9203496964C), UINT64_C(0x5D91FE782B4DF7C2)}},
        {{UINT64_C(0xD5BBBD6E96D84346), UINT64_C(0x8363527BF91FFA8C),
          UINT64_C(0x931D0FDA7F408588), UINT64_C(0x2C51F17BB0B19D0F)},
         {UINT64_C(0x7A693804FF61C86D), UINT64_C(0xBAB4AC45B3FFD529),
          UINT64_C(0xEDEA275F4C171C84), UINT64_C(0x0520925CD59B94D9)}},
        {{UINT64_C(0xB6A620AAE8718BB4), UINT64_C(0x67851F0F88D37A61),
          UINT64_C(0xCBEE8DBC9984A787), UINT64_C(0x7190B766AE834635)},
         {UINT64_C(0x3A1D7DB4C9AC1A8E), UINT64_C(0x6EEBD5AD7B97BCB7),
          UINT64_C(0x609786259D0AB769), UINT64_C(0x5AD56C0C7C7F02DD)}},
        {{UINT64_C(0x2C0003DE2DB3B6F2), UINT64_C(0x3BE1CE3FEFCF1DD8),
          UINT64_C(0xE2F79872379E6B8A), UINT64_C(0x3F9640D80B898094)},
         {UINT64_C(0x11EBD93715B29D41), UINT64_C(0xD6A076B93EF17D8C),
          UINT64_C(0x0A2C0016B38ED3BA), UINT64_C(0x64329A02CCB161CC)}},
        {{UINT64_C(0xD135032DB1ED1DEA), UINT64_C(0x43F7684842F734A0),
          UINT64_C(0x1F6C12BD3C18D8C5), UINT64_C(0x7D7757B7C0A304E8)},
         {UINT64_C(0x3F0C2867DE3B6B9F), UINT64_C(0x72F98EBBB7201E4F),
          UINT64_C(0xCC408000940E748D), UINT64_C(0x34FE6D8FAD74B322)}},
        {{UINT64_C(0xA12A9359E6D884FE), UINT64_C(0xB080A081DE063103),
          UINT64_C(0x672DE27D97ABB854), UINT64_C(0x712B0883EE6F3485)},
         {UINT64_C(0xF430BF2D2044A2A2), UINT64_C(0x665610207D12027A),
          UINT64_C(0x5ED63AD22C539C3B), UINT64_C(0x7982AAD0FE5EE1D1)}},
        {{UINT64_C(0x873DC8F63BE94D26), UINT64_C(0x909236394B41BD76),
          UINT64_C(0xE439A4960CBE4B5C), UINT64_C(0x424F8D2411782BF1)},
         {UINT64_C(0x6612BD9949686ED9), UINT64_C(0x78157AA9FB04E27E),
          UINT64_C(0x844E1616805F809C), UINT64_C(0x717AEB3262CB8BCD)}},
        {{UINT64_C(0xE98C1A0E5248CF6A), UINT64_C(0xC84294A8B0E4ADF8),
          UINT64_C(0xD35748A4A7769275), UINT64_C(0x2C3867E103363C82)},
         {UINT64_C(0x2EC7AF438F43885A), UINT64_C(0x7979D1A23AE516C7),
          UINT64_C(0x059939EC8B81056C), UINT64_C(0x434AA4DD7E358480)}},
        {{UINT64_C(0x12EA1C874A5228EA), UINT64_C(0x47B481984D293B9F),
          UINT64_C(0x319CE379E9696688), UINT64_C(0x7C9FF5957CE6FD05)},
         {UINT64_C(0x15E954DF3093E3E4), UINT64_C(0xBC98307C304015AF),
          UINT64_C(0x66522DF8975C69C5), UINT64_C(0x4C9EBFB3963CE892)}},
        {{UINT64_C(0x1CEEF18A628FB125), UINT64_C(0xFB69A2344BF30BB6),
          UINT64_C(0x510EB33970C9C864), UINT64_C(0x1EE9D1ED8A89151D)},
         {UINT64_C(0x340940284EE1A486), UINT64_C(0x664401672FC79CEE),
          UINT64_C(0xB597625AC7DA3A75), UINT64_C(0x6E5B920E65205AF9)}},
        {{UINT64_C(0x749D0CA4D87C914C), UINT64_C(0x55ECBEBB0D60C59E),
          UINT64_C(0x916A1127A65B4652), UINT64_C(0x503964D44E4767A3)},
         {UINT64_C(0x8899A4C21B1F94D5), UINT64_C(0xEFFCAF5233E0D94D),
          UINT64_C(0x61B89B3FA3DAD87D), UINT64_C(0x3CB455F55088D6BE)}},
        {{UINT64_C(0x5088A52B70678C14), UINT64_C(0x212823D941B00FC3),
          UINT64_C(0x38D5CEB619865BDB), UINT64_C(0x2E9C7FD712E63491)},
         {UINT64_C(0x6656F91659E73913), UINT64_C(0x57AE9A47E9035A63),
          UINT64_C(0x970DCF2BF02B8DAE), UINT64_C(0x3366F8A6950FF8A9)}},
    },
    {
        {{UINT64_C(0x93DABD6FAC4A8F83), UINT64_C(0x272334881CFF0AAD),
          UINT64_C(0xBCAC3181F500EDFB), UINT64_C(0x27C6DB15B5297515)},
         {UINT64_C(0x9CD142D92F08A89F), UINT64_C(0x3C0054232EAD0A80),
          UINT64_C(0x82845F9544A7623A), UINT64_C(0x5104707072BC4862)}},
        {{UINT64_C(0x4303797ADC1B9159), UINT64_C(0x7842434B5D9C9AC1),
          UINT64_C(0x8A36ED2D6009FE2E), UINT64_C(0x11FE35C95106429C)},
         {UINT64_C(0xDF20A39323554A92), UINT64_C(0x59364A48932E37C2),
          UINT64_C(0x6D7DE6AE7754A5DF), UINT64_C(0x00CCC6A3462725AC)}},
        {{UINT64_C(0xB1F86CA5BAE83077), UINT64_C(0x82FE28A55110782C),
          UINT64_C(0x8031BBF3D942182C), UINT64_C(0x4F1F3815410D9F83)},
         {UINT64_C(0xE57F9907835ABA65), UINT64_C(0x0A8220C25AA10903),
          UINT64_C(0x2E9847178812602E), UINT64_C(0x0AEC467D2A7D2C6C)}},
        {{UINT64_C(0xC779F708C4DBED03), UINT64_C(0x10A30CD88582BD4E),
          UINT64_C(0xFA5646C5243FEAEE), UINT64_C(0x1CFAF38ECA459EF7)},
         {UINT64_C(0xCCDD014695BC8077), UINT64_C(0x4ECDE91965858C49),
          UINT64_C(0x562764C677FEE1B6), UINT64_C(0x3CF5A3AB43524407)}},
        {{UINT64_C(0x0CCEAADD0F6EF445), UINT64_C(0x690C12C1C297AFAF),
          UINT64_C(0xD67AA6EAC15B3D7B), UINT64_C(0x445D233C9FF8884E)},
         {UINT64_C(0xC38FFD096CAD3234), UINT64_C(0xA690FFD1C7002F6F),
          UINT64_C(0xD445E85111ACB469), UINT64_C(0x64EE138097166E52)}},
        {{UINT64_C(0x1EB031CCCEFBFB0A), UINT64_C(0x60F3DEF4AA40D6A9),
          UINT64_C(0x240F7CA5F96FCAFE), UINT64_C(0x53AF2F10E4450A06)},
         {UINT64_C(0xE8AF980FA84058EF), UINT64_C(0x3E30001734AFFC6E),
          UINT64_C(0x62D1D094C86B458C), UINT64_C(0x5338383D75732C7E)}},
        {{UINT64_C(0x6BD46AEB04D82638), UINT64_C(0x86940A3162E645A0),
          UINT64_C(0xD025B4B1A5736B40), UINT64_C(0x1056D9D0924E8E5E)},
         {UINT64_C(0x3D0495CC1DB58101), UINT64_C(0xC300C6E72D677581),
          UINT64_C(0xFE38B898610AECEC), UINT64_C(0x1C8B94E2D66F64ED)}},
        {{UINT64_C(0x5C9C3A3706D0C7EC), UINT64_C(0x6B4B5437B8A74918),
          UINT64_C(0x85689C989052A235), UINT64_C(0x4F7C2C8D87B53AA6)},
         {UINT64_C(0x9FCD866FD8F1D334), UINT64_C(0xDBAAA2276898223C),
          UINT64_C(0x933DE9DA95C7B35A), UINT64_C(0x329AE20F3EA949FD)}},
        {{UINT64_C(0xB83547AF948A2ECD), UINT64_C(0xEBF7C1E7BE34890C),
          UINT64_C(0x5F0F44F3F8211C33), UINT64_C(0x14A10BDBC6927638)},
         {UINT64_C(0x7FD885675B579BF5), UINT64_C(0xD7C712815B7417F0),
          UINT64_C(0x7C04F1112083502E), UINT64_C(0x42029128E9AD6283)}},
        {{UINT64_C(0x32FBFFAE2C5C0928), UINT64_C(0x4E31D3121469F1D3),
          UINT64_C(0x17307E28D79F51A2), UINT64_C(0x546C91AF79A51EBD)},
         {UINT64_C(0x041D464D668086A6), UINT64_C(0x4986BDE50DB695DB),
          UINT64_C(0xCBA5F6EEEF317AA0), UINT64_C(0x5879259F730221D3)}},
        {{UINT64_C(0xBD9C5CA5253BB4BA), UINT64_C(0xBBFC60790E2A75BB),
          UINT64_C(0xB5F11AE367AB9033), UINT64_C(0x6411CB1EAC2BFAFE)},
         {UINT64_C(0x750734FEBF5390B0), UINT64_C(0xA044BED4879A3D3D),
          UINT64_C(0xE1E9F0E4A0C47093), UINT64_C(0x3BCAD93EB64DA48C)}},
        {{UINT64_C(0xAFC6BCB6B37E16C2), UINT64_C(0xB54F56C02331B0CD),
          UINT64_C(0x725E81B45BBFBEE7), UINT64_C(0x2AE0C039E8B9D922)},
         {UINT64_C(0x85301041DB958319), UINT64_C(0xDFAE34DD0681C4A4),
          UINT64_C(0x906C9219CBF7BB2B), UINT64_C(0x1463E9EF10A1710A)}},
        {{UINT64_C(0x41E6C38821E6FC9D), UINT64_C(0x0B629A1E24A39EC8),
          UINT64_C(0xC62F60BE1AEF7A46), UINT64_C(0x59A50B54C5A16B6E)},
         {UINT64_C(0x41CA367A285B891E), UINT64_C(0x70A6CE6BE2F8AF59),
          UINT64_C(0x74058747CBCEEF98), UINT64_C(0x4B912170601C375F)}},
        {{UINT64_C(0x7D975CE2734EE866), UINT64_C(0x8D3572C6A09F5F14),
          UINT64_C(0x1DB4CC882232EE5E), UINT64_C(0x6C9790497C04C250)},
         {UINT64_C(0xB5EC7706AE1EBC20), UINT64_C(0x7BDBD34DE21AAA32),
          UINT64_C(0xAD4125FDC5D1C733), UINT64_C(0x28B0302D731E6B09)}},
        {{UINT64_C(0xD68EEC491521415E), UINT64_C(0x31963424092763C0),
          UINT64_C(0xCA90F48D0BFB513B), UINT64_C(0x4814DDFF573A056A)},
         {UINT64_C(0x7E67599C400E804D), UINT64_C(0x3545275051FD0596),
          UINT64_C(0x45EDD7FBDB331B66), UINT64_C(0x172DA8B3BDEDE107)}},
        {{UINT64_C(0xD46F284CB5BEB1C8), UINT64_C(0x5DE5D3F17B125701),
          UINT64_C(0xC3BA591E248053D1), UINT64_C(0x4E67F1F29C8F487C)},
         {UINT64_C(0x380D93E48C252EC5), UINT64_C(0x913F96F122BC5CF6),
          UINT64_C(0xC1F06BBDD7BAA634), UINT64_C(0x7B625179A30BF1B9)}},
    },
    {
        {{UINT64_C(0x125D398DABD424AC), UINT64_C(0xFE65DF039CC70479),
          UINT64_C(0x89A31794FB5EC82C), UINT64_C(0x63EFFB55A31C5DCA)},
         {UINT64_C(0x948F7571045B576A), UINT64_C(0xEC9F6FAB022B5FC8),
          UINT64_C(0x174DC936BD9F0DD2), UINT64_C(0x5EEA65E6F4C4EE8B)}},
        {{UINT64_C(0xE97070AE8B800D67), UINT64_C(0xB9CB66FAB59B433E),
          UINT64_C(0xC4496574C6141364), UINT64_C(0x530AA9B56A9677EA)},
         {UINT64_C(0x4A4E2EE375200533), UINT64_C(0x4C38A5090F20A9BE),
          UINT64_C(0x0A6FFBA4EA683510), UINT64_C(0x7340EFEE65732EA9)}},
        {{UINT64_C(0x3A5612E4E41C2B43), UINT64_C(0x31F51B80FCB5C0A8),
          UINT64_C(0x4C5BBA64BD1F03E6), UINT64_C(0x253872433694ADCA)},
         {UINT64_C(0xF114EFAF1F7E4D5C), UINT64_C(0xBEA5223A4EA3A59D),
          UINT64_C(0x82CEF46F67EB414D), UINT64_C(0x09D351C19B6CAC3D)}},
        {{UINT64_C(0xC69F25CE810F5054), UINT64_C(0xE33E5E97548A2CDF),
          UINT64_C(0x20B3F44236946D3C), UINT64_C(0x572C0F5C65DF2D3B)},
         {UINT64_C(0xFC5B2DF3CC953CC8), UINT64_C(0x934D54C0D1CCADC6),
          UINT64_C(0x828A906EA6E7B4DB), UINT64_C(0x610D36C15AD3076F)}},
        {{UINT64_C(0x960B0A0174F56E27), UINT64_C(0x9942C6ACCF3FEA75),
          UINT64_C(0x2E4D786D82C51490), UINT64_C(0x23A516369A4749C9)},
         {UINT64_C(0xD86AB36A2F7560FC), UINT64_C(0xDA66B49DDDB852A9),
          UINT64_C(0x84E1587D544C1023), UINT64_C(0x7AB8BC696AA3C1DA)}},
        {{UINT64_C(0xFD0397AFA5F30701), UINT64_C(0x96FFB15DDFC8B187),
          UINT64_C(0xF2C864531475E520), UINT64_C(0x71521986EF37300E)},
         {UINT64_C(0xD81F75A868006D45), UINT64_C(0xDF7814EACBC06D4D),
          UINT64_C(0x5BCF959B2E8E9150), UINT64_C(0x146D37D756668C18)}},
        {{UINT64_C(0x1ABD731288E8DC77), UINT64_C(0x0B34B877C1C3A4DB),
          UINT64_C(0x85739093F844BACE), UINT64_C(0x5DEDCF8F04A7CF80)},
         {UINT64_C(0xD8BB237ED87CDBDC), UINT64_C(0x89852174CCBA784F),
          UINT64_C(0x6843BAB8B2FAECC3), UINT64_C(0x15268302AA4BBA32)}},
        {{UINT64_C(0x3B58225AB23D3770), UINT64_C(0x9357EB5910CC9DE6),
          UINT64_C(0x8665F92A42ECF80E), UINT64_C(0x4819CC9DC875C031)},
         {UINT64_C(0x09CBE5D8C34B979B), UINT64_C(0x161E8AC07E1D0E63),
          UINT64_C(0x874DF24F282E36E8), UINT64_C(0x6528E6FA0712A0CD)}},
        {{UINT64_C(0xE37AD786107633E4), UINT64_C(0x122D7123CF1FE646),
          UINT64_C(0x1E6E682BCFA93AC0), UINT64_C(0x0A25F4EE276200DB)},
         {UINT64_C(0x44E290EDE25FBB01), UINT64_C(0x3E392DF5C3C1B418),
          UINT64_C(0xE5E1574583EBE689), UINT64_C(0x016139D24B999926)}},
        {{UINT64_C(0x048915B065D7DA58), UINT64_C(0x6EF7C4EFA78F3D9E),
          UINT64_C(0x78CCCE55AD614974), UINT64_C(0x43DB7DA054B95643)},
         {UINT64_C(0xFC423B70E53F1A67), UINT64_C(0x8F8BED814EFE2427),
          UINT64_C(0xF5D6AD5F95B045EB), UINT64_C(0x23582D5DD7407716)}},
        {{UINT64_C(0x9E5D24FB9F674472), UINT64_C(0x1AE1863668626041),
          UINT64_C(0x8977E68F7ABC4380), UINT64_C(0x7D9FF8E805AF2D04)},
         {UINT64_C(0x9D31195F4197C4E1), UINT64_C(0x9F3F6E114400F35E),
          UINT64_C(0x1A87D5867BBEF801), UINT64_C(0x42AE0380952BB025)}},
        {{UINT64_C(0xC6A3ED756B96482B), UINT64_C(0x58B38724A9C6DD2F),
          UINT64_C(0x464C8CE89297FB47), UINT64_C(0x0245797EFB6D6C55)},
         {UINT64_C(0xBE141C80C0B58C8F), UINT64_C(0xC4C405CB77766C48),
          UINT64_C(0xD57EE428D10C0F31), UINT64_C(0x03D4862B50E8FE7B)}},
        {{UINT64_C(0x21976F8A1DC3722C), UINT64_C(0x02EC30D55F476F0D),
          UINT64_C(0xD711E01DCA434B06), UINT64_C(0x551AC91099FF2488)},
         {UINT64_C(0x24AEC72DA56CA3C7), UINT64_C(0x2DD1219A891896CE),
          UINT64_C(0xD84BAD1967882925), UINT64_C(0x27E65D7F9D4778EF)}},
        {{UINT64_C(0x09F19C8F4685687F), UINT64_C(0xB7C7B9E3BBB58BD3),
          UINT64_C(0x349D03A78FA34DD5), UINT64_C(0x41F9D0038D59E889)},
         {UINT64_C(0xCF3367D42B3ED6FA), UINT64_C(0xCF3C6715378DA1ED),
          UINT64_C(0x86DC39034E935E9A), UINT64_C(0x50692CFFF08CB23A)}},
        {{UINT64_C(0x18CA772AC2D65C87), UINT64_C(0xC9092B384F1D0CB6),
          UINT64_C(0x91E71CF1BBD2015A), UINT64_C(0x4A09DAAC4F3DEF26)},
         {UINT64_C(0x7CCA7B4A735C9281), UINT64_C(0x2028F1441BF0AAEE),
          UINT64_C(0xCF72A082ACB5B748), UINT64_C(0x58957D5D43299B85)}},
        {{UINT64_C(0x64BB164E901F1789), UINT64_C(0xC68766E65AEF97BF),
          UINT64_C(0x30ECA3E2942B6DCE), UINT64_C(0x632676FAF9E798F3)},
         {UINT64_C(0xB52533D3F13896EE), UINT64_C(0xAD9128312D8A29C1),
          UINT64_C(0x12F1B9A4BC14E7FF), UINT64_C(0x4E1D23FD8828D196)}},
    },
    {
        {{UINT64_C(0xC4F89E00EF494793), UINT64_C(0xA6044BC3C93D2F55),
          UINT64_C(0x68E60B588797F8AF), UINT64_C(0x4D5969FA841E4B5E)},
         {UINT64_C(0xB1EE70FBD759BB2D), UINT64_C(0x9AC3043366D8AD01),
          UINT64_C(0xD93F23DB84E9F677), UINT64_C(0x2AD9D16FC53029A4)}},
        {{UINT64_C(0xD01FC16BDD882D23), UINT64_C(0x3BF921F1FA5B4128),
          UINT64_C(0x3D3FE145235BC9CE), UINT64_C(0x5955671662E686E1)},
         {UINT64_C(0xE329A7C279F99D69), UINT64_C(0xA67EF5ECA4F5F5F5),
          UINT64_C(0xF96A41EED5A34FF0), UINT64_C(0x09D0CF0674674B5F)}},
        {{UINT64_C(0x8CCDF71C6135B7E2), UINT64_C(0x91F1E33EAFB6AD6B),
          UINT64_C(0xC452F439DB0CFEDF), UINT64_C(0x15724711C05B06D4)},
         {UINT64_C(0x5FEE0E0EA3BC1277), UINT64_C(0xD6847FAD8D8BA081),
          UINT64_C(0x8B02666C0D4C8DDD), UINT64_C(0x149E5009C35559DB)}},
        {{UINT64_C(0xB4D0D2C95461D9CA), UINT64_C(0xFE7993B6CE0A3973),
          UINT64_C(0x42B2A500D6032E95), UINT64_C(0x4DEEE35A217131C6)},
         {UINT64_C(0x94E65C8CFFE7C2EB), UINT64_C(0x0DAD7785B19D4B4A),
          UINT64_C(0xEEBA6794925613F9), UINT64_C(0x6AF45BBEE30494CB)}},
        {{UINT64_C(0x41352A6132F43F67), UINT64_C(0x0D218DE948F886D3),
          UINT64_C(0xCDFC0C559B33B0F6), UINT64_C(0x21FC63536C5B90CD)},
         {UINT64_C(0x5D8CA5AD7898AFF2), UINT64_C(0xA743F80E24287C30),
          UINT64_C(0x4D0371319084A3A2), UINT64_C(0x52041EEDB5EFC978)}},
        {{UINT64_C(0x80B588EECC1BCFCB), UINT64_C(0xAD871A11E5CE0035),
          UINT64_C(0xF47224D0F966D746), UINT64_C(0x5215A9D2B387FCC2)},
         {UINT64_C(0xC54EB2E7695C02AF), UINT64_C(0x36FD06BCDFC8493D),
          UINT64_C(0x1CE8A9AA98CE7C76), UINT64_C(0x058DFCBF644D398B)}},
        {{UINT64_C(0xCD7E67DC5BB81464), UINT64_C(0xE7A19301047A7789),
          UINT64_C(0xCCC31EE5573E837B), UINT64_C(0x25EE99AFAF7703D5)},
         {UINT64_C(0x34FDD6DADDB3E807), UINT64_C(0x273D8288109092DD),
          UINT64_C(0xF8F2464FB7357633), UINT64_C(0x26B2CBADCCAA31D5)}},
        {{UINT64_C(0xBA9CFEDEF707F9F7), UINT64_C(0xA9A6896CAC4975FB),
          UINT64_C(0x62135D9DBB1C35E4), UINT64_C(0x13AE840FCBA133D2)},
         {UINT64_C(0x6ABF39134C2BA3A9), UINT64_C(0xE4D8508A6D8A62C1),
          UINT64_C(0xF256535466D96607), UINT64_C(0x5C368CCEB6CABAE8)}},
        {{UINT64_C(0x0C3B52E88B3999BB), UINT64_C(0xB752E28FEF691871),
          UINT64_C(0xA0460ABCF17D0D2D), UINT64_C(0x7DDCE3C1B7741F2C)},
         {UINT64_C(0x076A6BAB3673000F), UINT64_C(0xCDB1CD2B425E8A9D),
          UINT64_C(0x357FCFFF2606EAB5), UINT64_C(0x308644F8035DE7B4)}},
        {{UINT64_C(0xBA64A1276D6FF45E), UINT64_C(0x1F52B6AE6B0C3CEF),
          UINT64_C(0x91295179CBF496CB), UINT64_C(0x2B986FADA1B12BE4)},
         {UINT64_C(0x243D236644DBAF57), UINT64_C(0x48E22BBA346E88C2),
          UINT64_C(0xCDFB79578BBAFA0D), UINT64_C(0x094ED36E0D70670E)}},
        {{UINT64_C(0x2BAD1539A0D60407), UINT64_C(0xC1A9286E6E744111),
          UINT64_C(0x6D08C0DB81A6DCAA), UINT64_C(0x108F35EC80AFB34F)},
         {UINT64_C(0xBE79A6E31E3E34AE), UINT64_C(0x206EAA2816D524E5),
          UINT64_C(0x563B6E1C344ABA64), UINT64_C(0x6C362A613207CA68)}},
        {{UINT64_C(0x04D8145BEF9A9A0F), UINT64_C(0x8B57559BA15B6247),
          UINT64_C(0x72D53570303AFBF3), UINT64_C(0x01C36B41D6DB5736)},
         {UINT64_C(0x94D583C91173B5FA), UINT64_C(0x71F8E12D013C8AAA),
          UINT64_C(0xA4B5A532F29CB838), UINT64_C(0x4B1797007CE4EBA4)}},
        {{UINT64_C(0x69CFA7B00CE86FC3), UINT64_C(0x3705D7C0D60E076C),
          UINT64_C(0xB1A1464AB1091E10), UINT64_C(0x097945A97FE80950)},
         {UINT64_C(0xD9C71A959AA381E3), UINT64_C(0x2A929073A410FF56),
          UINT64_C(0x79EF8353F0FEB121), UINT64_C(0x1437C4B05F3107E5)}},
        {{UINT64_C(0xC5128C8B621DB2E5), UINT64_C(0x4E9C9B2E51A9499A),
          UINT64_C(0x11535880D8CD7594), UINT64_C(0x35A26F59B0697C07)},
         {UINT64_C(0xAB3F4B75C43B624E), UINT64_C(0x69F82105B8E03E6B),
          UINT64_C(0xFB268288FB04E036), UINT64_C(0x6A5E6BD3A0BDB41C)}},
        {{UINT64_C(0x8C716A1AC8082916), UINT64_C(0xB1D1B1524592472C),
          UINT64_C(0x63657A6D3AB6938A), UINT64_C(0x44882EB6F03214AE)},
         {UINT64_C(0x19575B8AC615AF7D), UINT64_C(0x14D740C135EE3D98),
          UINT64_C(0xBC478E8957768D2D), UINT64_C(0x30CC8FA213FC5E4C)}},
        {{UINT64_C(0x705607C54EBE1E7C), UINT64_C(0x631E5B88284EDA2B),
          UINT64_C(0x07E9E39C07F54DDB), UINT64_C(0x4E554D888DCF6BC5)},
         {UINT64_C(0x12E9FB200CBAB0FE), UINT64_C(0x6F3BC7CEBA5E007F),
          UINT64_C(0xA770BA1DBC871DF6), UINT64_C(0x541AA4C6FE01142C)}},
    },
    {
        {{UINT64_C(0xBFE26700F2412EC7), UINT64_C(0x0E975796CFE96AF4),
          UINT64_C(0x7D30BF7CDD6B04F7), UINT64_C(0x5421925DF1D8FCE4)},
         {UINT64_C(0x1CF5E9F5EC709107), UINT64_C(0x124FCFC2B4580AA9),
          UINT64_C(0x02F7012B67A835B3), UINT64_C(0x753FE01B47C0760F)}},
        {{UINT64_C(0x82FD5D47B1D2A896), UINT64_C(0x7EABC17554E75DDB),
          UINT64_C(0x724FC3A81AB080BC), UINT64_C(0x363D6016A75C31DD)},
         {UINT64_C(0x5D465FF2863F308F), UINT64_C(0x9EC70664E515ADCB),
          UINT64_C(0x4BD7A1A2B3BC206A), UINT64_C(0x2022576C4A167D34)}},
        {{UINT64_C(0xF5AC34515CD6AC65), UINT64_C(0x7629731E5839F554),
          UINT64_C(0xA3260AE393545A60), UINT64_C(0x49D190E8A7AD1979)},
         {UINT64_C(0x5AA8492FF0B35045), UINT64_C(0x4A5FAB7B2584E651),
          UINT64_C(0x5A05420E395E2AAE), UINT64_C(0x30613C78547B4038)}},
        {{UINT64_C(0x47E1C59DF9DAE7E6), UINT64_C(0x8D68839B247A5A9D),
          UINT64_C(0x663B5977C1A80D5E), UINT64_C(0x5E51F87240D8CF32)},
         {UINT64_C(0x88ADBF9EECE49494), UINT64_C(0x40B4AC5C1792BAE8),
          UINT64_C(0x278200D19A1B3314), UINT64_C(0x7D15320ED9F83584)}},
        {{UINT64_C(0xFE6DAA74EAF2BFF8), UINT64_C(0x6E4EE4C0C156AA6B),
          UINT64_C(0xD9310FF8D0F4E7D5), UINT64_C(0x552EEF9E7BB0C42D)},
         {UINT64_C(0x323FF6F1FDC69E1A), UINT64_C(0x00FA66B741D79365),
          UINT64_C(0x0006B16EA96B22B4), UINT64_C(0x71BBC653D20F07BE)}},
        {{UINT64_C(0x89A7B7EEA440FA1C), UINT64_C(0x52BB5278757CD658),
          UINT64_C(0xC5906F4BB0CDDEA4), UINT64_C(0x66AAAFEE5DE2D8DA)},
         {UINT64_C(0x4D5E016A53B6E226), UINT64_C(0xA2F73DC61993A1D7),
          UINT64_C(0x7CDD4C1DA09DD554), UINT64_C(0x6F723079AB416627)}},
        {{UINT64_C(0xE641639EC4E5C4AF), UINT64_C(0x8BC6100D371CC648),
          UINT64_C(0x7BD161B19B216E8A), UINT64_C(0x58098AEBF810DB32)},
         {UINT64_C(0xEE52BB465AD92372), UINT64_C(0x4B2C48E1EEF938CA),
          UINT64_C(0xE8FDE4D6AB43A5D0), UINT64_C(0x459274CDA5284C83)}},
        {{UINT64_C(0xA98925B0D015095D), UINT64_C(0xC8969F5F4611A1A5),
          UINT64_C(0xBDDCD62F2CE4663B), UINT64_C(0x1C9D9007A076C8BE)},
         {UINT64_C(0xE8DE8890749F7BE5), UINT64_C(0xC9E455E7FF208E75),
          UINT64_C(0xDCEE17A98F5FAC9A), UINT64_C(0x776B72D368A3A666)}},
        {{UINT64_C(0x28C7D648FEE0E89A), UINT64_C(0x621B370F463AF60D),
          UINT64_C(0x9DC1548E5ADC8ACD), UINT64_C(0x48032ACFA0B49504)},
         {UINT64_C(0x146C6EAC85E992D5), UINT64_C(0x5A2CB5775CB491E0),
          UINT64_C(0x669DD6D4454C120A), UINT64_C(0x3431AB3398203C39)}},
        {{UINT64_C(0xE87615039DE017BF), UINT64_C(0xAB117D2FB60AE61F),
          UINT64_C(0x0846463F827937FF), UINT64_C(0x45E6BD406BD89C65)},
         {UINT64_C(0x3160AD67A613BDB8), UINT64_C(0xBD5266F3B8714A49),
          UINT64_C(0xF7D29C4751A233E4), UINT64_C(0x6887B48D4DE6A90C)}},
        {{UINT64_C(0x087290A5DFDE1EF8), UINT64_C(0xC70CCB52A166950A),
          UINT64_C(0xAA7F095B4A170AAE), UINT64_C(0x15301F4E5517CA0B)},
         {UINT64_C(0x3C86B787302F1F84), UINT64_C(0x95D4153544676E39),
          UINT64_C(0xBFEC4AE39DF5F751), UINT64_C(0x4A0D3986304923D3)}},
        {{UINT64_C(0x70FAABA979B1390C), UINT64_C(0xA9067EEE62BA8B9E),
          UINT64_C(0x987895031E17DF6F), UINT64_C(0x5997E8AE78D5B295)},
         {UINT64_C(0x31E13AD7AE0C6768), UINT64_C(0x23262F05EF17A7B1),
          UINT64_C(0x1580322749B7B101), UINT64_C(0x1234A9C536B5BA70)}},
        {{UINT64_C(0xED65C961395793AC), UINT64_C(0x01157CD8CCDE1C47),
          UINT64_C(0x0D0240B01D5614DF), UINT64_C(0x0F0DA1EF568E83A5)},
         {UINT64_C(0x57C90846C0B783C1), UINT64_C(0x4501048C81E2F613),
          UINT64_C(0x03D8A69BA2709DC1), UINT64_C(0x06F365C4A97CCE0E)}},
        {{UINT64_C(0xEAF23159551580CD), UINT64_C(0x0F1E586A053DD5EE),
          UINT64_C(0xEB7A78DD3CBCC3D5), UINT64_C(0x39BBC65AB014B850)},
         {UINT64_C(0x13DA4E8579B61AC7), UINT64_C(0x33E78DCF0DA59E37),
          UINT64_C(0x4E65AF252A643C4C), UINT64_C(0x0DC38C9708869D03)}},
        {{UINT64_C(0x2B648345A3A38837), UINT64_C(0x2FA6D8F7905E261D),
          UINT64_C(0xA23BD78666A14946), UINT64_C(0x781633FD5E01CC9A)},
         {UINT64_C(0xB1352709E2C71AD1), UINT64_C(0x9D74505283A6D365),
          UINT64_C(0xD88B5CAE66567032), UINT64_C(0x27FC40DF53D875CA)}},
        {{UINT64_C(0xB254E54C47F7554F), UINT64_C(0x33AD0ED6D708614D),
          UINT64_C(0x830566A376CE908D), UINT64_C(0x73DF94BDAA1ADD5C)},
         {UINT64_C(0x23EC411F2DBDD8A3), UINT64_C(0x9BA473383A979FDC),
          UINT64_C(0x56A2C27FC667E9F7), UINT64_C(0x295647C7427E6BFB)}},
    },
    {
        {{UINT64_C(0x9B5F4652F8E48C13), UINT64_C(0xE979034F9EEF4BA3),
          UINT64_C(0xF95FD7767CF5AF6E), UINT64_C(0x4236C47E506CEB46)},
         {UINT64_C(0x0C02A249E08D2312), UINT64_C(0xAA5A38CCC056499A),
          UINT64_C(0xCB26A8E27C188B64), UINT64_C(0x38FB961D0AE373D5)}},
        {{UINT64_C(0xEB179C9E7B23470D), UINT64_C(0xAE70102F1EBC44E7),
          UINT64_C(0x8184C1D492E0EED0), UINT64_C(0x329882815C21BF08)},
         {UINT64_C(0x469589678180D11E), UINT64_C(0xEBD5518C7FD7278D),
          UINT64_C(0xFCEB7F68AD2B74F7), UINT64_C(0x082D2011F9C7B6DA)}},
        {{UINT64_C(0x65D5AED1BBE0299D), UINT64_C(0x0077F756CF565A0A),
          UINT64_C(0xD44FCD6B344BB90D), UINT64_C(0x6C2A19C0536F3F25)},
         {UINT64_C(0x32EE7439BB2A4D91), UINT64_C(0xA97E677AED9351E1),
          UINT64_C(0x6752EDCF413A16E0), UINT64_C(0x5DE1B0C71CE4FBE6)}},
        {{UINT64_C(0x6C10DA15D6009B36), UINT64_C(0xAAD05F4FE5D8CFBE),
          UINT64_C(0xD8BCE0B431D58B76), UINT64_C(0x08DE344E27B2811B)},
         {UINT64_C(0xD9A78AAE80B51E48), UINT64_C(0x1E1D0A813E41C63A),
          UINT64_C(0x844376DE8076B3C7), UINT64_C(0x73F0D4A35FDF9D53)}},
        {{UINT64_C(0xF1532922558C7719), UINT64_C(0x0F10188AA8221197),
          UINT64_C(0x51A97E5F5DDC1716), UINT64_C(0x0F583A9B444789E7)},
         {UINT64_C(0xAA8FC58D97D63B87), UINT64_C(0xA5AF048B1CFDA59C),
          UINT64_C(0x2A4A0C5F2DDB34EB), UINT64_C(0x66C0F0C7701E2E07)}},
        {{UINT64_C(0xC0BC88B836BE2ABF), UINT64_C(0x265CCE745C721B85),
          UINT64_C(0x483EBB01D54299BA), UINT64_C(0x18F11CBE348ED89E)},
         {UINT64_C(0x5E9AE7B9E42129D4), UINT64_C(0x6B3E9E8D81DE5B77),
          UINT64_C(0xB3ADBAC97A14A74A), UINT64_C(0x1B6CEBB20003B266)}},
        {{UINT64_C(0xD4D4DD1015EB200E), UINT64_C(0xEEAEA4C6FB87C57B),
          UINT64_C(0x48F0B95772FF6321), UINT64_C(0x187C4B75B782B01D)},
         {UINT64_C(0x3DC1AACDE9B4D622), UINT64_C(0x0358418E3F4ED519),
          UINT64_C(0x981A24F8773D019C), UINT64_C(0x6643CA913DB0B4F4)}},
        {{UINT64_C(0xE3254F4BD47670E3), UINT64_C(0x9822612530B1DDE9),
          UINT64_C(0x61EB6C86DA8AF160), UINT64_C(0x725C771618363269)},
         {UINT64_C(0xB051DC9F02F62462), UINT64_C(0xFF8C9EDF00AC5531),
          UINT64_C(0x3909C79B962A92A3), UINT64_C(0x25C90D9327790237)}},
        {{UINT64_C(0x0A5DF2CC88ADC475), UINT64_C(0x48D26967E5D27D0A),
          UINT64_C(0x21D5F616359FF194), UINT64_C(0x38ACD14189977CE2)},
         {UINT64_C(0x39B9BD92FDAA8ACB), UINT64_C(0xDB157DF2035B62D0),
          UINT64_C(0x4E33386EB7D252D9), UINT64_C(0x6BD2E33FCF196258)}},
        {{UINT64_C(0xE0806297CE8F10C5), UINT64_C(0x446AFD6D8A14B746),
          UINT64_C(0xD7931F29BF566190), UINT64_C(0x4D9CFBFA86FDB72A)},
         {UINT64_C(0x7752885195009F63), UINT64_C(0x5FE5013434C0FF45),
          UINT64_C(0xC38CABBB6E134B81), UINT64_C(0x2E60B277E36DB037)}},
        {{UINT64_C(0xA614CF6757184CA5), UINT64_C(0x6CBD8D6325BE01E3),
          UINT64_C(0xE313EE8DA0030BE3), UINT64_C(0x69AF03992B1E7C60)},
         {UINT64_C(0x519ABFBB50423F30), UINT64_C(0x200111FF486B9519),
          UINT64_C(0x6FF93CCB3351F692), UINT64_C(0x32EB3E543ED9BE71)}},
        {{UINT64_C(0x0851ACB954052EBD), UINT64_C(0x3A389B7B6D2336D7),
          UINT64_C(0x50A8792517C6ACD9), UINT64_C(0x031FE845B807D9B1)},
         {UINT64_C(0xA348BB01E22F7492), UINT64_C(0x9547ED3605F39661),
          UINT64_C(0x97DF675668EC4AC2), UINT64_C(0x5836FEFE85B7F81B)}},
        {{UINT64_C(0x4E4869A65F0B2ACB), UINT64_C(0xC4798F3FDEC46001),
          UINT64_C(0x281A4ED600903474), UINT64_C(0x04F22E9DEFB9AABD)},
         {UINT64_C(0x2AC92264FAA721A4), UINT64_C(0xBCE2FF0B276F8041),
          UINT64_C(0x5F605607E4943926), UINT64_C(0x388C5FAB55506DF7)}},
        {{UINT64_C(0xFF104F6DAB5687E2), UINT64_C(0x1B6DAFE93B2D0245),
          UINT64_C(0x6405C02681B2EC4B), UINT64_C(0x2B7676DAF489EBBC)},
         {UINT64_C(0xBAA158F06DA1F57A), UINT64_C(0x9CB044AD27A8457F),
          UINT64_C(0xC23737A5A3BBD6C9), UINT64_C(0x71FB5B471D2267E1)}},
        {{UINT64_C(0x779BD825D14F56E4), UINT64_C(0xD7E672A008396F23),
          UINT64_C(0x23FE3FC0D40BA6EE), UINT64_C(0x41E749E73B56A3AB)},
         {UINT64_C(0xD19471CE72042F67), UINT64_C(0x8A686DA74989D4D7),
          UINT64_C(0x52A709C64FA09BC9), UINT64_C(0x1DC21162B3B6AA64)}},
        {{UINT64_C(0x62C9838BF9B3BD1D), UINT64_C(0x1EE59E5A0CE6384C),
          UINT64_C(0xA9F5ABF6ECE8CC7F), UINT64_C(0x1961D80F80BDDA83)},
         {UINT64_C(0x7A40880CCA406FB1), UINT64_C(0x5035D307DFBCE2E4),
          UINT64_C(0x590259E03D637299), UINT64_C(0x1607AC9FD6C34E05)}},
    },
    {
        {{UINT64_C(0x4ABC27109D818B72), UINT64_C(0x2496CEA6092607B7),
          UINT64_C(0xFB1087E1055C4EC8), UINT64_C(0x50A30C6A258ADC7D)},
         {UINT64_C(0xAF4EB6B30FF502E3), UINT64_C(0x5D5D76AD190607AB),
          UINT64_C(0xC9C9B71134482C13), UINT64_C(0x574A971842213696)}},
        {{UINT64_C(0x7C90FAFD7018FC70), UINT64_C(0x36A045592B83291C),
          UINT64_C(0x6120B51E40D1B175), UINT64_C(0x45F10B203DCF9606)},
         {UINT64_C(0x3C6A9EFFF20C5636), UINT64_C(0xB2768BA3FFBBC648),
          UINT64_C(0x1C9DF90AB523B36C), UINT64_C(0x4148BF06D6FF34ED)}},
        {{UINT64_C(0x3D29821A3B5F9492), UINT64_C(0xAE12C78290B24561),
          UINT64_C(0xEF6FB2778A3BDC5F), UINT64_C(0x6034BF3BAC3BD74E)},
         {UINT64_C(0x131D57CD4ACB6F85), UINT64_C(0xDED1C4333BE79B31),
          UINT64_C(0xB091348978A896B8), UINT64_C(0x1247C0B7B287862C)}},
        {{UINT64_C(0xEB6428937C494054), UINT64_C(0x7922793022142D26),
          UINT64_C(0x8F1C8371943E8398), UINT64_C(0x583C7AEF60886DB7)},
         {UINT64_C(0xAFE460223A12EE0E), UINT64_C(0xE9C9253AB6CB8685),
          UINT64_C(0x5334F9DD6316A4C6), UINT64_C(0x4E2F13D8E6F1DEE9)}},
        {{UINT64_C(0x7499A5B4B37D8BA5), UINT64_C(0xA12AA6371C9BCDE2),
          UINT64_C(0xCC99471DBFD6AE86), UINT64_C(0x0996637892048D63)},
         {UINT64_C(0x42CBFA9D552E71A3), UINT64_C(0x84A8B153675C1716),
          UINT64_C(0xB9C07C0E4CF00A7D), UINT64_C(0x32E2322B0DA504DB)}},
        {{UINT64_C(0x569F581FE671EE59), UINT64_C(0x293522D7422E86C7),
          UINT64_C(0x5E4CEA7E15DCEF10), UINT64_C(0x67C8A9FC483C0FE3)},
         {UINT64_C(0x4DE5AC0947B79284), UINT64_C(0x22AB8FBD025016BA),
          UINT64_C(0x51318C232A099B37), UINT64_C(0x542EA0FA49E06623)}},
        {{UINT64_C(0xDD240F6428909F31), UINT64_C(0x46B66F9E101B7F01),
          UINT64_C(0x788C29CA20481C3F), UINT64_C(0x3218A509CA5D5182)},
         {UINT64_C(0x64BCC7AD63E9A2B9), UINT64_C(0x3D213CA2ADDF5C0B),
          UINT64_C(0x6D93ED4C9960D650), UINT64_C(0x3F13DB22284EE5F3)}},
        {{UINT64_C(0x5B678C3A6697E0D1), UINT64_C(0x25A171F416D9D878),
          UINT64_C(0xC20A6D80FAEC362B), UINT64_C(0x1BB3F14CC512EA4B)},
         {UINT64_C(0xECE5313B2AE35FA5), UINT64_C(0xE390A01FBBD76B87),
          UINT64_C(0xC78EA4C5882DA3FC), UINT64_C(0x771BCDAE42086A77)}},
        {{UINT64_C(0x8E9E3C8B565802E9), UINT64_C(0xC37A7B3553FA1BE7),
          UINT64_C(0x9D2F1A264408FB77), UINT64_C(0x0B3ECE36FF308B7B)},
         {UINT64_C(0x8FB35B361F30FC37), UINT64_C(0x463B44E283E1A3C9),
          UINT64_C(0x7218F09F3402233A), UINT64_C(0x1519638AFC9A6990)}},
        {{UINT64_C(0x51FB3E5D8EAAC478), UINT64_C(0x620E4826760ED4EC),
          UINT64_C(0x46FC5B1F1D865577), UINT64_C(0x15EF2AD95244A538)},
         {UINT64_C(0x8D7E477C4BF382BD), UINT64_C(0xCBF170C902A5C9EE),
          UINT64_C(0xB91A870C4AFB0EC1), UINT64_C(0x052FFC5169C31425)}},
        {{UINT64_C(0x1FD437462018D066), UINT64_C(0xBC5015174C67FC35),
          UINT64_C(0xE65BC2FBBC990EB6), UINT64_C(0x538CA6F973F87F92)},
         {UINT64_C(0x42FBDAE08352B03F), UINT64_C(0xF265B1E099A4C9B9),
          UINT64_C(0x6E3EAB2F185CA070), UINT64_C(0x6E6F4F7D37D0A2C1)}},
        {{UINT64_C(0x9B20D8EEC2D5D73E), UINT64_C(0x190521AE75844C15),
          UINT64_C(0x67663AC426AD08FE), UINT64_C(0x67AEEFEFF984EC06)},
         {UINT64_C(0x61C71142CBDD87EF), UINT64_C(0x0FA4995B63396E3B),
          UINT64_C(0x3196E55185C193B0), UINT64_C(0x36C0A2A8DACB3A3D)}},
        {{UINT64_C(0xEAB89FDC178A1115), UINT64_C(0xC7B764D8D7C31303),
          UINT64_C(0xA5B2D6FB90203755), UINT64_C(0x3C360BF9D5F8AEEE)},
         {UINT64_C(0x8DFDCD0502F1CC3C), UINT64_C(0x7F8A64D264E5269E),
          UINT64_C(0xA36196ECEA13FFD7), UINT64_C(0x35E2241577E3839F)}},
        {{UINT64_C(0x29E7AB0BE22E0C52), UINT64_C(0x68BF32C78B27DEDA),
          UINT64_C(0x52A762A2DC7971AE), UINT64_C(0x4CA4348718B0CDCC)},
         {UINT64_C(0xED429DA13FCEAF73), UINT64_C(0x49396E6F06718D19),
          UINT64_C(0xDECB93375BB3301C), UINT64_C(0x4B7723C10FF489B1)}},
        {{UINT64_C(0xAE321F09ABEE6B9B), UINT64_C(0xF251BF4D37318F60),
          UINT64_C(0xB0A8A251B63DC269), UINT64_C(0x514A25FC71817963)},
         {UINT64_C(0x518F574755C9B2E9), UINT64_C(0x3E56CC3E1C9B4845),
          UINT64_C(0xBDFD637A283AE1FA), UINT64_C(0x419BA4B4C3DE778E)}},
        {{UINT64_C(0xC7F18E93BCD2EB74), UINT64_C(0x171264C8FC61FB42),
          UINT64_C(0x27282E7685119033), UINT64_C(0x225006A4D7DB91C7)},
         {UINT64_C(0x628E0F3C1ECF5024), UINT64_C(0xDC5111E000859CDE),
          UINT64_C(0x4AB1764F1F220711), UINT64_C(0x7C6916F170DDED3C)}},
    },
    {
        {{UINT64_C(0xF9FFE8FC5F0CA58A), UINT64_C(0x09E34F3022879EBB),
          UINT64_C(0x648D6339ED7B0520), UINT64_C(0x0D6719D01AF5ECDC)},
         {UINT64_C(0x2878714D0B8590E4), UINT64_C(0x827D04ED90EC312B),
          UINT64_C(0xD415C8B43B5767C3), UINT64_C(0x4170F0ADC09FD18D)}},
        {{UINT64_C(0x9B649CFC3C601031), UINT64_C(0x0478603A636DDAE7),
          UINT64_C(0xDC972DFA914E100A), UINT64_C(0x519C55DF091621AE)},
         {UINT64_C(0x863046CBD4A9963D), UINT64_C(0xDF16763C5ACF7C0C),
          UINT64_C(0x4999A93EFF5468A4), UINT64_C(0x35543EFF424074A5)}},
        {{UINT64_C(0x27B1DBFADD33307C), UINT64_C(0xA0D04784927CA6F3),
          UINT64_C(0xBD3EBC5EA37CF855), UINT64_C(0x59D02EF549F5AA2C)},
         {UINT64_C(0xCDABE86FBDD57BF3), UINT64_C(0x7B3ADD2F37819D86),
          UINT64_C(0x7B90BA150413B7B0), UINT64_C(0x470717826B99685B)}},
        {{UINT64_C(0xB7C3218EEF0CE97F), UINT64_C(0xDAE3B56C0898C79C),
          UINT64_C(0x6349D83D0908877D), UINT64_C(0x0970C6C0C81E8C4E)},
         {UINT64_C(0x0E45C4A7A47F426C), UINT64_C(0xAB000A593FBB194E),
          UINT64_C(0x570FBBA53A6DD13E), UINT64_C(0x66045580C8F44A57)}},
        {{UINT64_C(0x5ABEB74912A72F7F), UINT64_C(0x15072A927AE56F4D),
          UINT64_C(0x1C77AE00222AB2C4), UINT64_C(0x591EAEC69AFE63DE)},
         {UINT64_C(0xB51D41AFDFD24304), UINT64_C(0xDE28DF26DFBCC096),
          UINT64_C(0x02F046C838A20DA7), UINT64_C(0x5EC3DBDC1AE0A45B)}},
        {{UINT64_C(0x7C19BD7563DD86C2), UINT64_C(0xDB1193118D78A57B),
          UINT64_C(0xF48BB4FA23C5C4E7), UINT64_C(0x65514C1C97DB0A05)},
         {UINT64_C(0x1BC1F2F043CAC49C), UINT64_C(0x975FEB512851B4BE),
          UINT64_C(0x0E0A4633DD60D530), UINT64_C(0x32BBBF1409B1D2C6)}},
        {{UINT64_C(0x79124749A670EAC0), UINT64_C(0x504D89D531DD893C),
          UINT64_C(0xDDCED74CE0654D63), UINT64_C(0x58956BE5E2208707)},
         {UINT64_C(0xBE6A3ECD437E7077), UINT64_C(0xB8AB332D574095C8),
          UINT64_C(0x4E79AC1C3869DA42), UINT64_C(0x79D4C3FB68859F51)}},
        {{UINT64_C(0x1E5FC1B97936A831), UINT64_C(0x1EA42ED2D74F1F41),
          UINT64_C(0x33D22EC1C4EA3228), UINT64_C(0x5705333F729BEBFE)},
         {UINT64_C(0xDBD1A67B64596076), UINT64_C(0x6BFF269DFA65BA98),
          UINT64_C(0x8451A9C26C47E715), UINT64_C(0x243D679D22898DB3)}},
        {{UINT64_C(0xE935D705B8323FD0), UINT64_C(0xE2DA88456937E5CB),
          UINT64_C(0x1C9DFFF84A5EAE1E), UINT64_C(0x796F0B9545DF7A79)},
         {UINT64_C(0xC24D573F640DBA32), UINT64_C(0x2B77521702E4B792),
          UINT64_C(0xD437EB6394D12C40), UINT64_C(0x6182AF6D4AD371F0)}},
        {{UINT64_C(0x133EDA5241FC7551), UINT64_C(0xA0088A2BE91714AF),
          UINT64_C(0xB41B9AC25E0A73C0), UINT64_C(0x4808BB5A1D3B3953)},
         {UINT64_C(0xD875AA142B9AE648), UINT64_C(0x4F38C9462408244C),
          UINT64_C(0x04B6B941FF051A87), UINT64_C(0x1D5B0B9E6DF48ECD)}},
        {{UINT64_C(0x27FD368A169E757F), UINT64_C(0x2ACB35607B94D9DB),
          UINT64_C(0x81903F4B4D4C9B5F), UINT64_C(0x641F806C169B81DE)},
         {UINT64_C(0x574E94449E957475), UINT64_C(0xE08814AEC6C8EE52),
          UINT64_C(0xD1AE71EC6C84FDDF), UINT64_C(0x44A56014FAA040D9)}},
        {{UINT64_C(0x06DA690875A48F60), UINT64_C(0x7BA6C9CBBB2CD408),
          UINT64_C(0x57D2D0FF3A1BCBFF), UINT64_C(0x186F1A8B8928CE36)},
         {UINT64_C(0x0FFD205B7A40F877), UINT64_C(0x2915BC8E01AF68F7),
          UINT64_C(0x816AC4DFC36A5FB1), UINT64_C(0x609B0A872C9E1F7D)}},
        {{UINT64_C(0x4032AC5EB97536FB), UINT64_C(0x53E6FE68A7C5EDB6),
          UINT64_C(0x2F4149305F0DCBA1), UINT64_C(0x209752562837E314)},
         {UINT64_C(0xDF5DC4963C3C1D27), UINT64_C(0x0DFDAAF371797C36),
          UINT64_C(0x5F3E9229DA504E04), UINT64_C(0x354EA88D8C234246)}},
        {{UINT64_C(0xAF6741C30922D317), UINT64_C(0x7429853B9DF0A572),
          UINT64_C(0x0EA1AE041DC207A8), UINT64_C(0x2C1DAA1C450075F5)},
         {UINT64_C(0x27C71F166ED729B4), UINT64_C(0x785718A653AB8EC0),
          UINT64_C(0x1EEC7BBFA8465487), UINT64_C(0x78DA9B044C578BA9)}},
        {{UINT64_C(0xFF9ED65EB3B707FA), UINT64_C(0xF8C8301FF5D28D33),
          UINT64_C(0xB15D498FA65F5C0F), UINT64_C(0x6DEF256DB0EF2B89)},
         {UINT64_C(0x0D40A6B252184EF6), UINT64_C(0xC702EBE52BF06F5A),
          UINT64_C(0x13E50E184BA041AA), UINT64_C(0x53552D887EC4C784)}},
        {{UINT64_C(0x2CD09B19F28ABB3A), UINT64_C(0x4F5C040F724EDB9B),
          UINT64_C(0xD6820590E0DCBD16), UINT64_C(0x45D84DE91B7155A3)},
         {UINT64_C(0x995BDD01A251B1BA), UINT64_C(0x607F951737CAA4DC),
          UINT64_C(0x747FEA1CA15D9674), UINT64_C(0x646C187673E97C97)}},
    },
    {
        {{UINT64_C(0x1951682B6FAC1486), UINT64_C(0x8B578E1E4A4D14C5),
          UINT64_C(0x083FA101B7384D42), UINT64_C(0x13380CE9ED1C8A87)},
         {UINT64_C(0xC7052ED8732A493B), UINT64_C(0xD5FEF40FB32E3D69),
          UINT64_C(0xA64ACE8788833566), UINT64_C(0x6E36CFDB4177DC00)}},
        {{UINT64_C(0xAA14E281E742C3B4), UINT64_C(0xB75E7B2AEE5AF40A),
          UINT64_C(0x3FC5FF0B1616EFA2), UINT64_C(0x090259B0AD763298)},
         {UINT64_C(0x4105B57E38753438), UINT64_C(0x70ED1A00CF2D8926),
          UINT64_C(0x78921395322F40BB), UINT64_C(0x3AEE819967A3FF56)}},
        {{UINT64_C(0x88073D0011EA75FC), UINT64_C(0xD23D279606A4B4EB),
          UINT64_C(0x1FD22F9ED85D3A6B), UINT64_C(0x6B5EA051AFB43B70)},
         {UINT64_C(0x96C9C176D99BE576), UINT64_C(0x85AC2B6C4C47261E),
          UINT64_C(0x2726395999A9C378), UINT64_C(0x6D36E9FE8B5CABDA)}},
        {{UINT64_C(0xC9FC7661A58F614C), UINT64_C(0x82AA317D2E45AE73),
          UINT64_C(0xDCB1925FC8CB9CC7), UINT64_C(0x1341C1AA27813205)},
         {UINT64_C(0xDD06745B6CD478AB), UINT64_C(0x0C2534B21E28F6A3),
          UINT64_C(0xE21833459D27FE63), UINT64_C(0x7F1E2A3306466147)}},
        {{UINT64_C(0x378D727E5AEE2471), UINT64_C(0xB718FC17D47739B6),
          UINT64_C(0xDA27CB9B4145E8EF), UINT64_C(0x3F8AB1A30EF2AB20)},
         {UINT64_C(0xA89ADD37E16C0141), UINT64_C(0x2127823B59DF1C95),
          UINT64_C(0x53F90B73B7455CC2), UINT64_C(0x7F9605861183FBE5)}},
        {{UINT64_C(0x56D0475AE77235C3), UINT64_C(0xED2907C5B18ED61A),
          UINT64_C(0x2D02C4CB7D73F6F8), UINT64_C(0x35EF69B4C42E7AED)},
         {UINT64_C(0x53A6120A31B7324A), UINT64_C(0x982DD22159F1A395),
          UINT64_C(0x03ECA86F835CFD94), UINT64_C(0x4CBA837D73CA1BD5)}},
        {{UINT64_C(0x64F66D3941B17E6D), UINT64_C(0x3C869BF5CB14F3B3),
          UINT64_C(0x1EBA045A28350EFA), UINT64_C(0x7ACFB882C7CDEC47)},
         {UINT64_C(0x7ACFD28D8FB3097B), UINT64_C(0xDA397C3162986426),
          UINT64_C(0xD49F84212A1A7A94), UINT64_C(0x7B372E2DFAB65156)}},
        {{UINT64_C(0x3ADBDD0701D9DB0F), UINT64_C(0x617521E694FF0CFB),
          UINT64_C(0x5BA5905C3F5BD583), UINT64_C(0x6F89603378670CD1)},
         {UINT64_C(0x0A59C447FB98EA11), UINT64_C(0x59B918CC653EDC59),
          UINT64_C(0x00BF4D2A9F72C01E), UINT64_C(0x748455D147DEE00F)}},
        {{UINT64_C(0xE371A7A8386E7491), UINT64_C(0xF71711CC621A3484),
          UINT64_C(0x1568256EE0015C3B), UINT64_C(0x5ACEF7A67D3FFDE9)},
         {UINT64_C(0x02ED70E5B08E4219), UINT64_C(0x7ECE1726832AC3AA),
          UINT64_C(0xC3C0D32B951D1CA2), UINT64_C(0x4C99166438DECC59)}},
        {{UINT64_C(0xB99DF8BA96EB21A4), UINT64_C(0xB88D25F42BBF8E6D),
          UINT64_C(0x16B3E0B1686DAA3C), UINT64_C(0x1131456170D47C57)},
         {UINT64_C(0x8DCDC3D13338342D), UINT64_C(0xE6D39B0188E028A7),
          UINT64_C(0xB781F1ED72855B5E), UINT64_C(0x0E0D82F6CC192572)}},
        {{UINT64_C(0xC86A8E5DCF1E20AA), UINT64_C(0x1A87AEF3F9AB96D5),
          UINT64_C(0xA8941635F3D19051), UINT64_C(0x67B1D0A2654FFF15)},
         {UINT64_C(0x266FD5ED92862ACD), UINT64_C(0xB72587BED11DEEAC),
          UINT64_C(0x5CF0D2E2D09320AA), UINT64_C(0x68456EBA515E0277)}},
        {{UINT64_C(0x86A5461C771F64CA), UINT64_C(0xB7A220B748FF8D7A),
          UINT64_C(0x9A0DD72AD7A568D1), UINT64_C(0x18F5E1DCF644D858)},
         {UINT64_C(0xB7AE1BC23E00364F), UINT64_C(0xD7EA31F3CEE8D9F7),
          UINT64_C(0xD18DA30FDCDB883D), UINT64_C(0x179CFCA5CBA00F48)}},
        {{UINT64_C(0x496F2C0139E7860C), UINT64_C(0xACDF8B4027F15EAF),
          UINT64_C(0x8871966C687AC815), UINT64_C(0x6228F1B58DB8FDB5)},
         {UINT64_C(0x8644656AF30ECF2B), UINT64_C(0x15576CC2AE1DEAFF),
          UINT64_C(0x93D86D56697AB3FC), UINT64_C(0x3E4A428E811E3FF2)}},
        {{UINT64_C(0xFB85DE3D91B9F5DF), UINT64_C(0xCDB595D4B20A9C71),
          UINT64_C(0x55CB08F3B44D671E), UINT64_C(0x780FC2E5FCD7D5ED)},
         {UINT64_C(0x815AB41F7F939366), UINT64_C(0xA7597A02ECD52B20),
          UINT64_C(0x9BE078F04648E3C5), UINT64_C(0x7A3E217917BD3DC2)}},
        {{UINT64_C(0x22758C419D9E5E53), UINT64_C(0x44D675F49EF09FAE),
          UINT64_C(0x1AB7986D27159F97), UINT64_C(0x72B3F02BB6B9465B)},
         {UINT64_C(0xA372FAC7FE56F578), UINT64_C(0x33FA6479DA534F4A),
          UINT64_C(0xB0003307DF63BF2D), UINT64_C(0x34D40B4DB80D0F64)}},
        {{UINT64_C(0x8A8929DC3D2B9FC2), UINT64_C(0x7D12E86C55EE75E5),
          UINT64_C(0xB3FE1AD392E1A870), UINT64_C(0x27148C94729CFE4C)},
         {UINT64_C(0x6A8C3B5218BA868B), UINT64_C(0xDD2006E47F038A9C),
          UINT64_C(0x4606FA9EB7124908), UINT64_C(0x434A8C07F4940CB1)}},
    },
    {
        {{UINT64_C(0x15F36EBEF98B91EA), UINT64_C(0x94D802DEC1ED17B1),
          UINT64_C(0x3C45FA08085D77F8), UINT64_C(0x0A30B3C302FF571A)},
         {UINT64_C(0x70F5852D264C93D0), UINT64_C(0x5E51BCAB191AEE57),
          UINT64_C(0xD5C14AE9FAD8E96E), UINT64_C(0x73B00534D4BC414B)}},
        {{UINT64_C(0x21CF876B12AFF5E7), UINT64_C(0x3E9F664CF75799A6),
          UINT64_C(0xC23B7D199A0E73CD), UINT64_C(0x77AAB691427EEA36)},
         {UINT64_C(0x2E74F972604EE854), UINT64_C(0x8712C7A0F867C81A),
          UINT64_C(0x6085980F953A4C56), UINT64_C(0x2DB997070F7707E1)}},
        {{UINT64_C(0x5ECC087F78BDB7A7), UINT64_C(0x43CC156C04C693F2),
          UINT64_C(0x965067CF039BD7F1), UINT64_C(0x72140E566E3FAE2F)},
         {UINT64_C(0x26452E4DE019DED1), UINT64_C(0x6F4C23492EDEF154),
          UINT64_C(0xA7066D7F054DFC0F), UINT64_C(0x544E6F6D3381AB44)}},
        {{UINT64_C(0x9B6E94699214C791), UINT64_C(0xD74F9C5586938BDC),
          UINT64_C(0x0F1527F6FC2928FD), UINT64_C(0x5B0FBF0F63C3A053)},
         {UINT64_C(0xAC1F442CFC41FF10), UINT64_C(0x34EF88EF787B4932),
          UINT64_C(0xF8120F08316732AC), UINT64_C(0x7BCCF12CA655DC4A)}},
        {{UINT64_C(0x750DF97FA6C7760E), UINT64_C(0xF1A0A827609BF215),
          UINT64_C(0x7348C1B467FD04B4), UINT64_C(0x6A581016615C8145)},
         {UINT64_C(0x9DC012259A11AAFC), UINT64_C(0x24F65B053F2B0C8B),
          UINT64_C(0xA27CB8BFDCB1B2A4), UINT64_C(0x3C44B811E48C1A71)}},
        {{UINT64_C(0xBC059AF2F780B295), UINT64_C(0xDF58928C0B6B247D),
          UINT64_C(0x224D4C3C01903F3D), UINT64_C(0x7152E120818EE0AC)},
         {UINT64_C(0x6C8F474554BFF1BE), UINT64_C(0x98A6C7EC431ADEF7),
          UINT64_C(0xDCB6BB7591B2CFB6), UINT64_C(0x145F6D397E83A5BB)}},
        {{UINT64_C(0x827C000C81D23BC1), UINT64_C(0x5CDC1135403956FC),
          UINT64_C(0xD967A5B13C751158), UINT64_C(0x52AF85BC96201D7D)},
         {UINT64_C(0x522BC492644558F7), UINT64_C(0xF74A35AFED7A060D),
          UINT64_C(0x10E5F9FD4DC4619E), UINT64_C(0x06071F1F324F60BB)}},
        {{UINT64_C(0xC5FFD5EF65921C34), UINT64_C(0x46CE1A69302BAA5D),
          UINT64_C(0x89CC84EC4E22FF1D), UINT64_C(0x16A481AE68131754)},
         {UINT64_C(0x2A06A156B89039F5), UINT64_C(0x40B6401BB3A95AB9),
          UINT64_C(0xFFCC53EB313820C3), UINT64_C(0x256B00E7EA959F76)}},
        {{UINT64_C(0xCCE87FC954FBDD74), UINT64_C(0xEC258542B23C6E1D),
          UINT64_C(0x5BE392B49E5E1928), UINT64_C(0x65AF311047A8A759)},
         {UINT64_C(0x943F7A2547DFFD31), UINT64_C(0xDCCDA18651E896FA),
          UINT64_C(0x71A93B1E933E747F), UINT64_C(0x44F5C468DFB043AD)}},
        {{UINT64_C(0xF6AEC52C786FCCBA), UINT64_C(0x23D49DCF6D51FA78),
          UINT64_C(0x0F81463B9B40D8E6), UINT64_C(0x18B9D932708D3DA2)},
         {UINT64_C(0x796F94EDF986DC6D), UINT64_C(0x33B2CCC1FC2622C3),
          UINT64_C(0x16790DFB9CCEC606), UINT64_C(0x6F5D1452CFD31481)}},
        {{UINT64_C(0x91F15DDC6C3A15D6), UINT64_C(0x45D12F404D360E75),
          UINT64_C(0xF2E28EE81DAFFC9C), UINT64_C(0x5CC6A0566CDF5566)},
         {UINT64_C(0x855166D21779B9BF), UINT64_C(0x92BA5EF4CF94D9FE),
          UINT64_C(0x1266FB2A985BC1DD), UINT64_C(0x4572CE8FCA3018AD)}},
        {{UINT64_C(0x8729A12DBE4BB604), UINT64_C(0x6A29C8494E99E9AB),
          UINT64_C(0x54AE50117A89894D), UINT64_C(0x5E66A255CDB0EEBD)},
         {UINT64_C(0x006736EACBEE153B), UINT64_C(0x8A36CC2D225E7B86),
          UINT64_C(0xF731E430EC0598EC), UINT64_C(0x49338E4D7FD9A11F)}},
        {{UINT64_C(0xE038CE03DA6DABAA), UINT64_C(0x13A08DCE7C1BCE0C),
          UINT64_C(0x12D00DD0DA89EFBF), UINT64_C(0x70A13FB96FCF0510)},
         {UINT64_C(0x16ED1C925CDB03E2), UINT64_C(0xDF1AB61D08E9EE4B),
          UINT64_C(0x48983DA803AF3E3D), UINT64_C(0x63CCA113429DB770)}},
        {{UINT64_C(0x6D9AC1EBCFB805E5), UINT64_C(0x47C3FE6950FA37B8),
          UINT64_C(0xD308EC732C33D457), UINT64_C(0x3CB08E00D4CCA340)},
         {UINT64_C(0xC078DAD0BE862794), UINT64_C(0x2D147F83F4E10A57),
          UINT64_C(0xE91820FF3DE1B3D5), UINT64_C(0x3D85DD726F30491B)}},
        {{UINT64_C(0xD486A022F5CBDD3A), UINT64_C(0x2663134ACAC0B99E),
          UINT64_C(0x42DE13F55F3ABFCA), UINT64_C(0x4967A225B365B973)},
         {UINT64_C(0x99C98A2510F1F997), UINT64_C(0x23F057C97714FAB2),
          UINT64_C(0xCE07CA6E1BA2338D), UINT64_C(0x3BA69161069F65D7)}},
        {{UINT64_C(0xCCD8C86FC026FB0E), UINT64_C(0xF49F1FEA50407A8C),
          UINT64_C(0x72FEA37B7F19A1DB), UINT64_C(0x22A03E253F457DB7)},
         {UINT64_C(0x2D6C62B271F736D2), UINT64_C(0xCC99F8E7A5ACB4E5),
          UINT64_C(0x8F7DBF2E0DE5F380), UINT64_C(0x24494786352B4933)}},
    },
    {
        {{UINT64_C(0xF020E7A9AE2A5E8F), UINT64_C(0x5ADC788BD14C5F02),
          UINT64_C(0xC5E5AFE465C84DB4), UINT64_C(0x392FACC435C2633C)},
         {UINT64_C(0x47D5007042DEE269), UINT64_C(0x76706ED76EB7849C),
          UINT64_C(0x6BF56D56316548CB), UINT64_C(0x4A466066D37FF4DF)}},
        {{UINT64_C(0xC8EBBFB5C30283AD), UINT64_C(0x31E9CF963544E645),
          UINT64_C(0x90EA9A4988886B50), UINT64_C(0x5E4B8C88021D3D5D)},
         {UINT64_C(0xA4DB92250DFEB658), UINT64_C(0x8AA95DB61910FDAE),
          UINT64_C(0x82E9A997DE400EB9), UINT64_C(0x238967E996769A04)}},
        {{UINT64_C(0x1ABB076A89E2DF0A), UINT64_C(0xDA8B09B007065929),
          UINT64_C(0x332BE8A563BD349B), UINT64_C(0x0EB973CEA2D35385)},
         {UINT64_C(0x67F7AE639C7D375E), UINT64_C(0xA235818DE7AE90B1),
          UINT64_C(0x2B59C26E817493B0), UINT64_C(0x39DC105033C4ACD6)}},
        {{UINT64_C(0x11801ACE7B7DB3F5), UINT64_C(0x79C214C38CC97CA5),
          UINT64_C(0xB4BFE1ABBF2674BF), UINT64_C(0x598EA7DC43252011)},
         {UINT64_C(0x217FF6D3B08F8EF5), UINT64_C(0x9797BBC98B9226B7),
          UINT64_C(0xAB8E98C97B0EDB09), UINT64_C(0x240EC22D083A401F)}},
        {{UINT64_C(0x55A75BCF459ABC3D), UINT64_C(0xB2F9859864ECC2DC),
          UINT64_C(0x271C47C39EE84779), UINT64_C(0x0166E5D4BF9BDBF2)},
         {UINT64_C(0xD205380F4215B666), UINT64_C(0xF704139664E9FE64),
          UINT64_C(0x4C737E942BB0DA40), UINT64_C(0x2E763521C8119691)}},
        {{UINT64_C(0x79550B60FD2F8593), UINT64_C(0x47E00AFD0C17A56F),
          UINT64_C(0x0D900A9DB44157CF), UINT64_C(0x016CF746A81BED76)},
         {UINT64_C(0xC21E861BAC47A84B), UINT64_C(0x0E14387A1724BD47),
          UINT64_C(0xC209303E2077F7BC), UINT64_C(0x33B5EB59BAD12F0B)}},
        {{UINT64_C(0x7152354F9850FC1F), UINT64_C(0x1239576F83637934),
          UINT64_C(0xB00C4E4E82AF46BA), UINT64_C(0x563D5062EC3FEEFF)},
         {UINT64_C(0xEF25E37333D67B7F), UINT64_C(0x3A80A50E50D9845E),
          UINT64_C(0x1DCED1E9A5787EF5), UINT64_C(0x15723E9AA0F87C3C)}},
        {{UINT64_C(0x217435112B4A156D), UINT64_C(0xB75C041CCD12BD2B),
          UINT64_C(0x6947368C79F393A6), UINT64_C(0x32CDE49E76420E56)},
         {UINT64_C(0x67FBA31543D612FF), UINT64_C(0x697F7FAEE3B87BC2),
          UINT64_C(0x980DAFBC7391129A), UINT64_C(0x438B28586F707469)}},
        {{UINT64_C(0xDA8AD16D5E9D085F), UINT64_C(0xE636F1AF768FA87C),
          UINT64_C(0x08520756B85FF1F1), UINT64_C(0x1B8184816ABB31BE)},
         {UINT64_C(0x25B3DCB92E686F1A), UINT64_C(0xE12821342B0CB829),
          UINT64_C(0x626232BC3B9B759C), UINT64_C(0x797316BB38C4338E)}},
        {{UINT64_C(0xF8365B644A62DCBD), UINT64_C(0xC2CF51BA6BF0EFED),
          UINT64_C(0x37E379EFABF74764), UINT64_C(0x5DC32071A350D603)},
         {UINT64_C(0x5465CC805B732100), UINT64_C(0x3231B4E3B3BB5366),
          UINT64_C(0x23F5385ED0D067CE), UINT64_C(0x76CD762167D33451)}},
        {{UINT64_C(0xC6C93A0555D857DD), UINT64_C(0xB4B6F1768F308F7F),
          UINT64_C(0x2371CD88C0F13577), UINT64_C(0x1E507D6C70807D9D)},
         {UINT64_C(0x7A77CCE1C73E8E2F), UINT64_C(0x1DD96274FCCBDEEB),
          UINT64_C(0xA4DBEA5D03F378B8), UINT64_C(0x44B4DF552A1C347F)}},
        {{UINT64_C(0x9853D2828D067A47), UINT64_C(0xBF0ADAF486813E74),
          UINT64_C(0xFDE1F24D39409037), UINT64_C(0x0E629604973B045D)},
         {UINT64_C(0x9880A74B3BB92FAB), UINT64_C(0xBC4E3405C6C4D6C6),
          UINT64_C(0x98C243185184A2D6), UINT64_C(0x07D65412C210C183)}},
        {{UINT64_C(0x3938E528441A5FBC), UINT64_C(0x2CCD837DCCC66B22),
          UINT64_C(0x075FADE75E606282), UINT64_C(0x321811654BB0E76A)},
         {UINT64_C(0xE7240305FC929890), UINT64_C(0x1FA427C8E03AAA52),
          UINT64_C(0xF23C879B0BC7B9F8), UINT64_C(0x699A1235D6BBC908)}},
        {{UINT64_C(0x20C2978114124B8A), UINT64_C(0x0C6464B348000278),
          UINT64_C(0xF1939127D644E10C), UINT64_C(0x47A479E64EC07EE3)},
         {UINT64_C(0xB631576877023389), UINT64_C(0xC0FD319D8BFDD90F),
          UINT64_C(0x0EBEC2006CB022D4), UINT64_C(0x6810DF3D302F58EF)}},
        {{UINT64_C(0xCF97FA07ACB1C3F2), UINT64_C(0xACC60D84A2C3F2F1),
          UINT64_C(0x4EF3CAAC5DEB73D4), UINT64_C(0x654D0D90D5472C1D)},
         {UINT64_C(0x5A39A718E4729062), UINT64_C(0x84B286B08324E0F2),
          UINT64_C(0xA07A01CBD21E8457), UINT64_C(0x0EC091C7B094714E)}},
        {{UINT64_C(0x7AB81940895736BD), UINT64_C(0x9AE791B7E4679DF5),
          UINT64_C(0x36163D81F064109B), UINT64_C(0x3DDEE4A40E956B07)},
         {UINT64_C(0xE146E7EEFEAAE47C), UINT64_C(0x81C0C2A76A8EEC03),
          UINT64_C(0x10BB8DD9A8C315CB), UINT64_C(0x2CB423D8D21B9AB0)}},
    },
    {
        {{UINT64_C(0x5B11D3C7166A5B9A), UINT64_C(0x973627BB8768861D),
          UINT64_C(0x82A5E2CD5A3E442A), UINT64_C(0x13F6C741DDE63678)},
         {UINT64_C(0x8DAA3C74D892738E), UINT64_C(0x0A07D651A932376F),
          UINT64_C(0xE12612C56892504B), UINT64_C(0x619D2B1DCA3FF301)}},
        {{UINT64_C(0x2B6D686F1B07CEB7), UINT64_C(0x90C0260C298D0996),
          UINT64_C(0x8CAAB926102BC73C), UINT64_C(0x445A6487AEB3911C)},
         {UINT64_C(0x7EE1E54757F17290), UINT64_C(0xC055478B417711BF),
          UINT64_C(0x29EF9FEC5CFA42C2), UINT64_C(0x5A022DE42B8EA0D6)}},
        {{UINT64_C(0x81A5EC18AEEB2675), UINT64_C(0xA867C5AAAD1BBA8A),
          UINT64_C(0xAECB36888DB47EBC), UINT64_C(0x77CE00BC26D1038F)},
         {UINT64_C(0xADC635EF3E68504B), UINT64_C(0x0EFC21DEDAE8AF4F),
          UINT64_C(0xDE57FD43AC70C4C9), UINT64_C(0x123360BEE78FFC0D)}},
        {{UINT64_C(0xD608DB32D82B61DB), UINT64_C(0x05AF2A908E45C853),
          UINT64_C(0xF1B8213E9D3B0032), UINT64_C(0x2312F8ABCAD15361)},
         {UINT64_C(0xDC8D8E32C29EE818), UINT64_C(0x07D7A475DE5CD587),
          UINT64_C(0x766109130C6C38B8), UINT64_C(0x0131B6C6D7984BD9)}},
        {{UINT64_C(0xC05CD4D0CF69C844), UINT64_C(0x747C092D81A9B005),
          UINT64_C(0x0D793551D9E39F54), UINT64_C(0x3BBB00DA7FFEF17C)},
         {UINT64_C(0x6CAB83D9655AD7C1), UINT64_C(0x601BECD066A8F590),
          UINT64_C(0xFADB086DAE51811B), UINT64_C(0x7768A5D8D69F734B)}},
        {{UINT64_C(0x3BB9B347F0E2385E), UINT64_C(0x376C8C48F7D39F23),
          UINT64_C(0xE656C1A4D82EC840), UINT64_C(0x328B25C9FC2AC59A)},
         {UINT64_C(0xD02B2F39A046BEE6), UINT64_C(0xDBAB19A580066D6C),
          UINT64_C(0x6A2E8F67E938B7F7), UINT64_C(0x645A57A1AA7F2661)}},
        {{UINT64_C(0x6227904D9A006FAE), UINT64_C(0xA975FC4CB598CB72),
          UINT64_C(0x945BFC2FA1120B82), UINT64_C(0x437A8AB42AC15CE5)},
         {UINT64_C(0xA512A1070F53317C), UINT64_C(0x7B552554FF9BD7D6),
          UINT64_C(0xF81213E754155AF9), UINT64_C(0x0923F42CFDCE0842)}},
        {{UINT64_C(0x135239165216BB55), UINT64_C(0xF27E4C7A599CA117),
          UINT64_C(0x464D040A7DD95BE1), UINT64_C(0x408974863C417D05)},
         {UINT64_C(0x0A3D16BF7C88E5D7), UINT64_C(0x0B94C661C13B286F),
          UINT64_C(0xF73C7126E2214821), UINT64_C(0x4B3D5BF0F2F6DAFA)}},
        {{UINT64_C(0xCFABD8A2F1A4332A), UINT64_C(0x56DB1546BAAC9A51),
          UINT64_C(0x8CC5204B04416247), UINT64_C(0x75EC13BFF0583310)},
         {UINT64_C(0x0D68896ED35B55D0), UINT64_C(0xE89274E267FC14D9),
          UINT64_C(0x18D425C0FC322878), UINT64_C(0x69477DD7916C714A)}},
        {{UINT64_C(0x427CBB6C9BDDF0F9), UINT64_C(0xCF6941E2DB9F52CB),
          UINT64_C(0xEF144DF635E60DFA), UINT64_C(0x27B5246EB61DF45C)},
         {UINT64_C(0x0E124518B8D3D1D9), UINT64_C(0xBB3BA1348B313B95),
          UINT64_C(0x050DCBDF0FA2B7A9), UINT64_C(0x50DBCF6D1D0A99B5)}},
        {{UINT64_C(0x8A8B22CB3924A1E5), UINT64_C(0x86CB4C5A118F9D55),
          UINT64_C(0xE5330ACC5B339C53), UINT64_C(0x6D5FDDF966A35A67)},
         {UINT64_C(0xC95007196F6438A5), UINT64_C(0x9723F2BA07E5394E),
          UINT64_C(0xA9CE2117866B45A8), UINT64_C(0x1B737D8D045CA2CA)}},
        {{UINT64_C(0x6093F5A56EE00E30), UINT64_C(0x5CAB98D45DE0A6FC),
          UINT64_C(0xADFB652C65DE754F), UINT64_C(0x679900D1862EFD1D)},
         {UINT64_C(0x6E5C230FAFC5D235), UINT64_C(0x3A1E557912CF6DD3),
          UINT64_C(0x241C20FB03FB4FA0), UINT64_C(0x562FFAE320F6C013)}},
        {{UINT64_C(0x6EFC732F397F25EC), UINT64_C(0x304D1F7DBC1F03B8),
          UINT64_C(0xA2FA60018890DADE), UINT64_C(0x4F91F97C51A25539)},
         {UINT64_C(0xE75F9C5048F4EF02), UINT64_C(0xCC53F460218AEE9D),
          UINT64_C(0xE7B4048910D76649), UINT64_C(0x148F90A242ECDBA4)}},
        {{UINT64_C(0xBF45023A1F683AD6), UINT64_C(0x2EA5F70C95E868D1),
          UINT64_C(0x47A19F33A97F2DE3), UINT64_C(0x3C8CCA9E8A76ED9F)},
         {UINT64_C(0x01562C6EE1A268D0), UINT64_C(0x9EB6EBACBA4EF01E),
          UINT64_C(0x835E64D4342410FB), UINT64_C(0x06F96B87FFF4594D)}},
        {{UINT64_C(0xE49A383AD233612B), UINT64_C(0x3CA5421FC9C14F64),
          UINT64_C(0x25192E1BBB53DF81), UINT64_C(0x3C1451FEA94C046C)},
         {UINT64_C(0x72B270F80423FAA8), UINT64_C(0xFF63513D3763888A),
          UINT64_C(0xB22F2F20C1745190), UINT64_C(0x2E005A7A35DEA32C)}},
        {{UINT64_C(0x6B5A4E7A6305B2EB), UINT64_C(0xF017BCA19CCD05D2),
          UINT64_C(0xB37027C9D19AD8CB), UINT64_C(0x2CFCB4700CBB36A6)},
         {UINT64_C(0x17F4FE51663F3485), UINT64_C(0x7DC20A170DC3467B),
          UINT64_C(0x6B56BA3F4AF63CBD), UINT64_C(0x4E7CF2890D5D64AF)}},
    },
    {
        {{UINT64_C(0xE2C5CD1F7F59D2E9), UINT64_C(0x6B9ACEB79D7FBE1E),
          UINT64_C(0x84F0441DA20225B0), UINT64_C(0x15875CDA8B369FBC)},
         {UINT64_C(0xED1332770659E294), UINT64_C(0x7FAA913E7AE02043),
          UINT64_C(0xCA0E58DA9DCEDE14), UINT64_C(0x5F6A70FDCDE68547)}},
        {{UINT64_C(0x524B790DE7282711), UINT64_C(0x4B4F6246BCA05694),
          UINT64_C(0x85169ECB949AF774), UINT64_C(0x5B168842CC743068)},
         {UINT64_C(0xB8D0E9F231FB3BA3), UINT64_C(0x56DD4BC362D471C7),
          UINT64_C(0xB14D689CE2A34F75), UINT64_C(0x7F4E171702E8D2D2)}},
        {{UINT64_C(0x8EE3491AB17090B9), UINT64_C(0x67C071166B7EDAF4),
          UINT64_C(0x6876E4CE4D0E6CCE), UINT64_C(0x6D2FBB64BC5A86BE)},
         {UINT64_C(0x0431C67A070FA8C3), UINT64_C(0x91EFF9BE0F5D65F4),
          UINT64_C(0x332985E2E07088DF), UINT64_C(0x006D2583676EADA8)}},
        {{UINT64_C(0xA1FBCC370AA747D6), UINT64_C(0xADEA4A90B0DFDF3C),
          UINT64_C(0x650162C7401ED81B), UINT64_C(0x0FBC4841A8B15E22)},
         {UINT64_C(0x1044B4E8BF98CDAC), UINT64_C(0x37071115ECD1C668),
          UINT64_C(0x29B93C17233C220C), UINT64_C(0x4BEBC3CCE69BC0C0)}},
        {{UINT64_C(0xD1A16E3746BF7E51), UINT64_C(0x889C7782F7A7370C),
          UINT64_C(0xC73F396E3CCB474D), UINT64_C(0x1C508F18B9D67A2E)},
         {UINT64_C(0x3F17E9676B03B7E7), UINT64_C(0x3928F1D8F857BB26),
          UINT64_C(0x3086FB2EC0EA8620), UINT64_C(0x15DC32C21BE7C3E4)}},
        {{UINT64_C(0xF48D4C3211F4D949), UINT64_C(0xE14A4AE3B0357C05),
          UINT64_C(0x77A1121F151D91AE), UINT64_C(0x33F85C2FE8C6869D)},
         {UINT64_C(0x8EA3BB4C364B77B0), UINT64_C(0x1F155B919BD43E50),
          UINT64_C(0xA6C2873054748E7D), UINT64_C(0x5AA34DDAE7DDC539)}},
        {{UINT64_C(0xF0F80DDAA6CF8A82), UINT64_C(0x87DE6D6C091663B5),
          UINT64_C(0x9479873402FE5519), UINT64_C(0x109D411F96722130)},
         {UINT64_C(0xBC47CA73E661041F), UINT64_C(0x071D605965741541),
          UINT64_C(0x7CD4DF6607E08735), UINT64_C(0x175E1F77E68FC807)}},
        {{UINT64_C(0xB88BDAB8DA58865B), UINT64_C(0x14AD911220ED2B89),
          UINT64_C(0x2B21AEDF039BF0A3), UINT64_C(0x789717779D4B77E9)},
         {UINT64_C(0x133DA2ACD6612EF3), UINT64_C(0x6260FCF512AD1785),
          UINT64_C(0xDBA784DA9DF08843), UINT64_C(0x1A30C4CF4449FBD1)}},
        {{UINT64_C(0xB6FECE874EF7ACA2), UINT64_C(0x9CE7B61A13F7C58C),
          UINT64_C(0x6B0223C9F8719A60), UINT64_C(0x21199AA5A3B3B088)},
         {UINT64_C(0x4A7171966938BB02), UINT64_C(0x2E9A17C9E7ABC263),
          UINT64_C(0x83F796234BAB12B7), UINT64_C(0x15C0C4AF49D7CFBD)}},
        {{UINT64_C(0x99B3413956D2957F), UINT64_C(0xA51B8DFD07218BB6),
          UINT64_C(0x47CA4323FC91D7C9), UINT64_C(0x44B01E753DCFD5F0)},
         {UINT64_C(0x29F9D18E8CE894F3), UINT64_C(0x22BCC54095227C6F),
          UINT64_C(0x815CD9363FC75409), UINT64_C(0x0D58B325D8989472)}},
        {{UINT64_C(0x8B4C6980B6C80208), UINT64_C(0xA5D974978FB77CCD),
          UINT64_C(0x1B8965719477132F), UINT64_C(0x348ABC213AE45F53)},
         {UINT64_C(0xE438C1C314BCDB96), UINT64_C(0x63150CF98007C1BF),
          UINT64_C(0xDB861A338508B903), UINT64_C(0x421DFB017B04ECD6)}},
        {{UINT64_C(0xF2FCE58B19430E7B), UINT64_C(0x851A5F03D0F8ECB7),
          UINT64_C(0xE756C1670A5A1833), UINT64_C(0x25A51405227F866C)},
         {UINT64_C(0x40F34CB03C6EE5F3), UINT64_C(0xF4010401F244B5CF),
          UINT64_C(0x0E21BDED01349BCF), UINT64_C(0x1B129D8204547F42)}},
        {{UINT64_C(0x802EC4800927D153), UINT64_C(0x0F75E4FE72541520),
          UINT64_C(0xA4A1557A026C4613), UINT64_C(0x25E8DAFB7D92BC18)},
         {UINT64_C(0x1D87A14312F15F05), UINT64_C(0x79390E3C7B6B4240),
          UINT64_C(0xFC199D76492E6273), UINT64_C(0x0053F1C47EB090C0)}},
        {{UINT64_C(0xE790F1CAACEE6DFC), UINT64_C(0xC8FB4626DFEA04FF),
          UINT64_C(0xBF03627F627D88D7), UINT64_C(0x1B3698843D81A75A)},
         {UINT64_C(0x83405DDA917FA19D), UINT64_C(0xFFB23FF98C7DDCD2),
          UINT64_C(0x644F54C740F10B48), UINT64_C(0x4636FADF17FF713A)}},
        {{UINT64_C(0xDA62ECC227F417E4), UINT64_C(0xC0DBE48FFD8662BE),
          UINT64_C(0x729EE4AA1011E73C), UINT64_C(0x4BAE5D3C3E11C84B)},
         {UINT64_C(0x854DFFF86CEF6CDA), UINT64_C(0x7939228CCB7131EA),
          UINT64_C(0x58B3744AD3EBC607), UINT64_C(0x6EB9248F2049E239)}},
        {{UINT64_C(0x0265CAE9ED0D4E57), UINT64_C(0x92166D028AA65AEF),
          UINT64_C(0x2E337CDA198345D6), UINT64_C(0x6775330CABE1AD7B)},
         {UINT64_C(0xA9A828A8BF6FBC7D), UINT64_C(0x33A56F8DCBFEA393),
          UINT64_C(0x2DB72F77D811EC51), UINT64_C(0x3DDFCD268327C78E)}},
    },
    {
        {{UINT64_C(0x7CF8A521B46AA2C4), UINT64_C(0xE3B20937ACF0D567),
          UINT64_C(0xD47D8D1BA440648E), UINT64_C(0x674E79201E9791A1)},
         {UINT64_C(0x27B714EB18366462), UINT64_C(0x1526E5588476F588),
          UINT64_C(0x72C8D3746C240D70), UINT64_C(0x066BBAFB805C1265)}},
        {{UINT64_C(0x15F1CFF5457034E1), UINT64_C(0xCF7C6550DD819FA7),
          UINT64_C(0x57C2CD5377AC7AD6), UINT64_C(0x7DB2A8BEAFED669D)},
         {UINT64_C(0x2DAFD95FD4697340), UINT64_C(0x382FF89215A6B6E7),
          UINT64_C(0x036FC753BF4A6B1B), UINT64_C(0x3E7AC46DE4012711)}},
        {{UINT64_C(0xBA5ECDED5752A34D), UINT64_C(0xB08749D46BAA08DD),
          UINT64_C(0x8A2B98974A4A47A8), UINT64_C(0x7230966FE42DCE02)},
         {UINT64_C(0xA6FF614A58654FF5), UINT64_C(0x7F3531D1AB3C2A7E),
          UINT64_C(0x0282A2F00D0ED417), UINT64_C(0x2DC7B872EA9755A3)}},
        {{UINT64_C(0x7678D7652392536A), UINT64_C(0x0C2025F1574C657D),
          UINT64_C(0x01701C80795413DC), UINT64_C(0x63F0D4965396279E)},
         {UINT64_C(0xB0F9968AFA32EA64), UINT64_C(0x81265D155BB393DE),
          UINT64_C(0xC05ECC6D0BCD8C10), UINT64_C(0x4F3769F92824457E)}},
        {{UINT64_C(0x9AA58686F13DB92E), UINT64_C(0x1155CDF4ED2E1B18),
          UINT64_C(0xA06E919409823F5A), UINT64_C(0x7F1BBE734257AB0E)},
         {UINT64_C(0x2DFB6472ABA6FCD1), UINT64_C(0x04BE6BCAD73D850E),
          UINT64_C(0x72AAEC34297D312B), UINT64_C(0x31F4C02C7509D9F5)}},
        {{UINT64_C(0xAA9BA0007CA72AD5), UINT64_C(0x21EE29457FBCB4D6),
          UINT64_C(0x0E210AAB1CF8580A), UINT64_C(0x600479FE0FA8DE10)},
         {UINT64_C(0x246FD26554322F70), UINT64_C(0xC60BE9BB60DF1893),
          UINT64_C(0x04D4F99D05137E38), UINT64_C(0x6ACB9E016164C176)}},
        {{UINT64_C(0x126F2C7EC1DB7B6C), UINT64_C(0x4C3B30B5CF4DD3C0),
          UINT64_C(0x827D57A2F782A489), UINT64_C(0x41B897DEE52621F0)},
         {UINT64_C(0xED31C55ADDA0A3CD), UINT64_C(0x21C91BB2A11AD179),
          UINT64_C(0x60E606B843FD6E23), UINT64_C(0x31B8138D51ED7FA6)}},
        {{UINT64_C(0x1387B313E72E4BC5), UINT64_C(0xDCCCB09C82EBFC72),
          UINT64_C(0xF0B01202AA4432D6), UINT64_C(0x632599C47C52B69D)},
         {UINT64_C(0x3922D0C0BCE9A04C), UINT64_C(0xC2397D88B53F4268),
          UINT64_C(0x50AE5ED900669858), UINT64_C(0x1B2BD4C216C7696B)}},
        {{UINT64_C(0x6FAE1B082BF7DF06), UINT64_C(0x870B3FE85210DB3B),
          UINT64_C(0x680BE4229BDC0B91), UINT64_C(0x56BA83C6BCC970AD)},
         {UINT64_C(0x1AE91BAC859D6C78), UINT64_C(0xC5BDD5FB2895A1A6),
          UINT64_C(0xA169E73C550610F5), UINT64_C(0x01B467670CC7D3EA)}},
        {{UINT64_C(0x1E147A510EC5ECE2), UINT64_C(0x9B612A1FD0E2C46C),
          UINT64_C(0x664FDD555E293783), UINT64_C(0x52070E1567DC4DBC)},
         {UINT64_C(0x449B53E54A4903FB), UINT64_C(0x79B53583A8D30103),
          UINT64_C(0x616C97F3AF7CC314), UINT64_C(0x6BEB304C2849862C)}},
        {{UINT64_C(0xB9C636D6019F0313), UINT64_C(0x0B08E7CBD3E0188D),
          UINT64_C(0xEAEB1715D704DE15), UINT64_C(0x4990282C837E7543)},
         {UINT64_C(0xCBB0BD49FBD3A061), UINT64_C(0x3454A8AC1DA124AE),
          UINT64_C(0x0D524A0237D64EAB), UINT64_C(0x766807490B3E4ADE)}},
        {{UINT64_C(0xC293E01195B04835), UINT64_C(0x76D304BA23D0C885),
          UINT64_C(0x36A63627D6552D80), UINT64_C(0x3B4FA680C504CCAB)},
         {UINT64_C(0xF25B3A04E1FC08DF), UINT64_C(0x786380E562D080F8),
          UINT64_C(0x0A731427DAC0D110), UINT64_C(0x1D65288FD628429A)}},
        {{UINT64_C(0x3CE5E929DC94453E), UINT64_C(0xEC7CF988B6073324),
          UINT64_C(0x023361E7DCB35234), UINT64_C(0x3AF20624F5E89B7C)},
         {UINT64_C(0x860F188EA5B2B103), UINT64_C(0x5EAC84CECB6D112F),
          UINT64_C(0x63B200C3914C9FFD), UINT64_C(0x327870A055A1FDCB)}},
        {{UINT64_C(0x4F94633C155280ED), UINT64_C(0xF98321D53654B8AA),
          UINT64_C(0x9C057A23489AE89A), UINT64_C(0x1124A1FBD59CA3B5)},
         {UINT64_C(0x2F4CE0521F64AFD7), UINT64_C(0x841EE4417C789152),
          UINT64_C(0x93531ED459A98374), UINT64_C(0x69A4F48C36BB8F07)}},
        {{UINT64_C(0xD8FFD2435FD512A7), UINT64_C(0xF48C96F19BEA1738),
          UINT64_C(0xF70E1F6A0FFB4553), UINT64_C(0x29DB63B15FF91D21)},
         {UINT64_C(0xC1355C2377BF7279), UINT64_C(0xD3946EE9A2FC904D),
          UINT64_C(0x07223881E7B7A9F4), UINT64_C(0x212D896756E08ED6)}},
        {{UINT64_C(0x32B8C22A45503451), UINT64_C(0x9E4FDAF1E6AB7B3D),
          UINT64_C(0x7A300E3D04A31294), UINT64_C(0x0F529DFD05FE2AEB)},
         {UINT64_C(0x7EFFEA9E9951B6FB), UINT64_C(0x18C60266336B9A2B),
          UINT64_C(0xB78A5EE16C8D0EEC), UINT64_C(0x68C17FE446ED0B23)}},
    },
    {
        {{UINT64_C(0xF707FAD596B3222E), UINT64_C(0xD6AF61610223F804),
          UINT64_C(0x13FFDC744F43A0E9), UINT64_C(0x6A3B70E93347F487)},
         {UINT64_C(0xBDDF02A46A4AF4F5), UINT64_C(0x61B451E1E4C69950),
          UINT64_C(0xFF854590F9E3BB99), UINT64_C(0x46EB1F697CD54C54)}},
        {{UINT64_C(0x70E643B68E6848D3), UINT64_C(0xC58B8519848C2587),
          UINT64_C(0x2F195C54EDF4A38E), UINT64_C(0x206E6A323D2A52E8)},
         {UINT64_C(0x234845B5417595BF), UINT64_C(0x90354373FF5AE3CB),
          UINT64_C(0x13BE31CE89C0E555), UINT64_C(0x2D18AA43CC67E26F)}},
        {{UINT64_C(0xC74EE8C4F041BD17), UINT64_C(0x655CF527C2B3CC64),
          UINT64_C(0x6735CF0A160FF053), UINT64_C(0x35DAB9EB04218A0D)},
         {UINT64_C(0x32BB2E9ACBC34E46), UINT64_C(0xF780CEAF7D190342),
          UINT64_C(0x161C0C1A9F0DA1A4), UINT64_C(0x7B198C9EE7642FD6)}},
        {{UINT64_C(0x936C763E122FD0B4), UINT64_C(0xA3819ED9A7E0C435),
          UINT64_C(0x86228B04CAAE6D7B), UINT64_C(0x2E1160187A3C65B4)},
         {UINT64_C(0xF55BB1F3D4EB0345), UINT64_C(0x858A0BF40630B569),
          UINT64_C(0x8CC22657CB78A626), UINT64_C(0x7CD93BDEB45E3005)}},
        {{UINT64_C(0xCAA1F45998E517AB), UINT64_C(0x36E60281B34A6F5C),
          UINT64_C(0x877A49F30B46F47F), UINT64_C(0x0179824B9E7BE761)},
         {UINT64_C(0x6830A2B2D455D9C0), UINT64_C(0xB734BA0A7BA31962),
          UINT64_C(0x344665A4065C3B51), UINT64_C(0x0B1D2210562E7F1D)}},
        {{UINT64_C(0x289BAFCA0B2E22E8), UINT64_C(0x038929A083390107),
          UINT64_C(0x968A014D0683E782), UINT64_C(0x5A1AD5C853D34463)},
         {UINT64_C(0xA26133349527B2CA), UINT64_C(0xE8471271310B745F),
          UINT64_C(0x49C81A2631387F59), UINT64_C(0x1B955AF70343C691)}},
        {{UINT64_C(0x069328ADA4A9FCA4), UINT64_C(0x14EF09A7624FCB94),
          UINT64_C(0x21C76F0DE3E0CECD), UINT64_C(0x5F470B866C1BCE0F)},
         {UINT64_C(0x79319A3FB15BC8B4), UINT64_C(0xB1407CB1DB06AFA1),
          UINT64_C(0xD69E9E09911116E0), UINT64_C(0x6E77524E0756579E)}},
        {{UINT64_C(0xD3EC5EBCE2D851D5), UINT64_C(0xC888BC2303B63143),
          UINT64_C(0x5F3DE41EDB0C357F), UINT64_C(0x646FFBD3C3D47D37)},
         {UINT64_C(0xE53F8BEB0692639B), UINT64_C(0x7E194E37D4FBC3D4),
          UINT64_C(0xE1988A22452B2A2E), UINT64_C(0x5D359A15B013F9E1)}},
        {{UINT64_C(0xA48160A7B2A6627D), UINT64_C(0x5EFDC8483CE8789E),
          UINT64_C(0x264CBFF1B1CD14EE), UINT64_C(0x288823D444D84222)},
         {UINT64_C(0x2F091B233A6DB1F8), UINT64_C(0xBFD737B5CEA89B44),
          UINT64_C(0x682AB86C17F5E969), UINT64_C(0x7653005CABB0FA87)}},
        {{UINT64_C(0x619C2629D4B8A43A), UINT64_C(0xBFDAF433B6DAF943),
          UINT64_C(0xDC7AA1EE6D640DB8), UINT64_C(0x35ADEEA83B08D55C)},
         {UINT64_C(0x30935454D7AF5382), UINT64_C(0x1F9C51A13D68A24A),
          UINT64_C(0xDBD13CFC78BDBEA9), UINT64_C(0x003B6D9931210A3F)}},
        {{UINT64_C(0xD4547A329C2B515D), UINT64_C(0x4AF29AA8FECDAAA9),
          UINT64_C(0x85C80ECDE401D5AD), UINT64_C(0x2830332D8AA315A1)},
         {UINT64_C(0x5675882371DCE198), UINT64_C(0x55AC9D106ACBDEE3),
          UINT64_C(0xF6D468CF575CF4BB), UINT64_C(0x46E4FA98576B5C4A)}},
        {{UINT64_C(0xAD20F82020D859EF), UINT64_C(0x380915882A5462B0),
          UINT64_C(0x35F45C9F2135DA7D), UINT64_C(0x6B426F91F7F20DBD)},
         {UINT64_C(0x4A0D8CBEF96E77D2), UINT64_C(0x8FC36F5BCC51D3F4),
          UINT64_C(0x7A1870DDBE16A0A8), UINT64_C(0x29C3E2B3114DB780)}},
        {{UINT64_C(0xFF692A4C21779E6E), UINT64_C(0x698231ABA6026EC1),
          UINT64_C(0xDAB0D835EF03E21B), UINT64_C(0x770BFFACC846D56F)},
         {UINT64_C(0xCD28722D3B8B0747), UINT64_C(0x3DEFE04032AE95E5),
          UINT64_C(0x6F5D816A0F9857D6), UINT64_C(0x2E483FEDFC630F5E)}},
        {{UINT64_C(0xDBF82EC4967C7140), UINT64_C(0x6265CAD10D20A2A5),
          UINT64_C(0x1509652B5862DEFE), UINT64_C(0x699DD93994A284E5)},
         {UINT64_C(0xC01166460B2CC732), UINT64_C(0x583FE01294C3EF86),
          UINT64_C(0xCD5DAEA8CD353430), UINT64_C(0x2B39A746C7ADA62B)}},
        {{UINT64_C(0xF449B989E4257BBC), UINT64_C(0x95BA21BAA90DCCE6),
          UINT64_C(0xDD53AD5C93CA4ACD), UINT64_C(0x7FCF27380BB4213B)},
         {UINT64_C(0x0E57C1C0C2E7E54E), UINT64_C(0xD1769DAEA1A0E975),
          UINT64_C(0x68F62C4EC3B6E13B), UINT64_C(0x75152F9A781242D8)}},
        {{UINT64_C(0x4D58276824B8B820), UINT64_C(0x36E37AC45BBD9F84),
          UINT64_C(0x1F34414ADA076F12), UINT64_C(0x08A77C283E0333C6)},
         {UINT64_C(0xBB1F017DD9193382), UINT64_C(0x56E9AA2483A5612D),
          UINT64_C(0x6959B02BD0B4554F), UINT64_C(0x2479BC56E4559B52)}},
    },
    {
        {{UINT64_C(0x96D631C60F570A8E), UINT64_C(0xE3F566A3D714B807),
          UINT64_C(0x564DD512EF7E1550), UINT64_C(0x1C5CF24A79FA2F58)},
         {UINT64_C(0x973BA599897958DB), UINT64_C(0x93951D1711A9CBB1),
          UINT64_C(0x86BA17F6A37A969A), UINT64_C(0x4807CAC7A069B195)}},
        {{UINT64_C(0xB64AC0D46665B35E), UINT64_C(0xBA9CD3947EF72C68),
          UINT64_C(0x838807B29C4CBC44), UINT64_C(0x2675D26882770197)},
         {UINT64_C(0xBFC2F13717087FA9), UINT64_C(0x811E644BE7B79B31),
          UINT64_C(0x597CE23FC963A061), UINT64_C(0x40BC32E42EA0DEB0)}},
        {{UINT64_C(0xC0AEFB5027C85959), UINT64_C(0x76D1087E058E0FDD),
          UINT64_C(0x6ADA5AAF7E51A6F8), UINT64_C(0x424B16E0054A058D)},
         {UINT64_C(0x9A2C20A963AF9766), UINT64_C(0x4C1CB5323CF18DAB),
          UINT64_C(0x599CD9296C5D6A00), UINT64_C(0x57C39BAE8AA311BF)}},
        {{UINT64_C(0x3FDF5B46CD987F02), UINT64_C(0x57755078353175C4),
          UINT64_C(0x80223EC0CD578394), UINT64_C(0x04BBA6ACAEB7D278)},
         {UINT64_C(0xD27FD2BE8688BFB2), UINT64_C(0xB2F80278C27A62E5),
          UINT64_C(0x8BA6FB07339429D8), UINT64_C(0x57737FF63AB70AA0)}},
        {{UINT64_C(0x0140E47F8EAEB3C9), UINT64_C(0xB91C9798735AC8EA),
          UINT64_C(0x325E031283D4EFAA), UINT64_C(0x1E7DA3BED9C5888E)},
         {UINT64_C(0xA210CDA6F7F1EB13), UINT64_C(0xEDC1F6B3936EA9E9),
          UINT64_C(0x46E831C41B097F65), UINT64_C(0x008576011939A0AE)}},
        {{UINT64_C(0x7C26F7111F68BB40), UINT64_C(0xEA69C84539DDBE6D),
          UINT64_C(0x590BF426E5316F22), UINT64_C(0x40CDC921CC2DF9C9)},
         {UINT64_C(0x28A32DDEF3F991C6), UINT64_C(0xD75B59E65356CA78),
          UINT64_C(0xB5DD3861D1F5F318), UINT64_C(0x09EB1A2DE7929834)}},
        {{UINT64_C(0x701F9A2DDBC0370D), UINT64_C(0x559D0FAF2870B59D),
          UINT64_C(0xE89E5DF055367B5D), UINT64_C(0x22BBD4FC74005A58)},
         {UINT64_C(0x7ACED1E499CDC76B), UINT64_C(0xD41C827CE3C219D3),
          UINT64_C(0x5AF3F2AE8221D91F), UINT64_C(0x6D62C990E5B6BC98)}},
        {{UINT64_C(0x23B2A0BF7FFC9D0F), UINT64_C(0xED98F71D974CA299),
          UINT64_C(0x10F8C07A151D559B), UINT64_C(0x40E46FC38E949C62)},
         {UINT64_C(0x0CF53E34BBE55338), UINT64_C(0xF2D6CF26115520D4),
          UINT64_C(0x915FF09A590B4E23), UINT64_C(0x072E4233BEDC75F2)}},
        {{UINT64_C(0xB67A6B60997E9BFA), UINT64_C(0xE7686AC9973BC3E7),
          UINT64_C(0x9525B4490B228320), UINT64_C(0x6C7275837ADE8F19)},
         {UINT64_C(0x3D064298062FF3D5), UINT64_C(0x5483826C07E22768),
          UINT64_C(0xF4ADE9211F7A64A4), UINT64_C(0x70BDDCF7BD92EB25)}},
        {{UINT64_C(0xA8DB36115D8A9E36), UINT64_C(0xAA6A5F33FA81065A),
          UINT64_C(0x8EC120A3366DDA90), UINT64_C(0x2AA0AB25D8A15CF7)},
         {UINT64_C(0x5E11E169A0DFFB9C), UINT64_C(0x8C7572E9118408A7),
          UINT64_C(0x4EEFD13E35833ADF), UINT64_C(0x2C6732E8FC2C1811)}},
        {{UINT64_C(0x15D063F9B1537DF6), UINT64_C(0x864176B30414FCFD),
          UINT64_C(0x9C0A194C8FF9E32E), UINT64_C(0x4DB14C6FDDE1540B)},
         {UINT64_C(0xFAA4AED431F6493F), UINT64_C(0x2C479F1DD3C41A46),
          UINT64_C(0xC31196678E5E85A2), UINT64_C(0x7E567C8084E9A76C)}},
        {{UINT64_C(0xB9E2C92A689A6B95), UINT64_C(0xCCEAC3833B635B01),
          UINT64_C(0x04FEA46534AAB952), UINT64_C(0x772E502763B5CF63)},
         {UINT64_C(0xCB94F5D225830581), UINT64_C(0x791004AFC77FB7DE),
          UINT64_C(0x53273C335140E4AE), UINT64_C(0x0C2D329EA524419F)}},
        {{UINT64_C(0xB7CEDA36B307B0E4), UINT64_C(0x12DF7FD00F8F9667),
          UINT64_C(0x74274002BF62BD94), UINT64_C(0x6765C73DC436C319)},
         {UINT64_C(0x79B64CE5F6EEC946), UINT64_C(0x3B1B4B43DAB258B6),
          UINT64_C(0x377819A3EE1F8B84), UINT64_C(0x1F45F1D676D0EB1F)}},
        {{UINT64_C(0xCC5BF9B358C953AD), UINT64_C(0x8303250F7BAD1D2C),
          UINT64_C(0xBCA7BC36F164972B), UINT64_C(0x2CACF8A9B1DFDA64)},
         {UINT64_C(0xB03A59B9D4E2A06F), UINT64_C(0xFED68E681B7FB8FD),
          UINT64_C(0x08F75A527E747AE6), UINT64_C(0x3299EA6B37A4420B)}},
        {{UINT64_C(0x49A00BE6932E5BA6), UINT64_C(0x4921250556114C4B),
          UINT64_C(0x786B7D31376183C7), UINT64_C(0x01F9E229DD8A5EAF)},
         {UINT64_C(0xE9B8E99053094AD4), UINT64_C(0x2EDA305CBFAEDFA8),
          UINT64_C(0x344437267F9E3BC8), UINT64_C(0x1729519C6B55B3C3)}},
        {{UINT64_C(0xEA5A68C050A597D6), UINT64_C(0xA65147D4F1E86D1B),
          UINT64_C(0x554FA36B8B47CDEB), UINT64_C(0x7F38364B9F24FFED)},
         {UINT64_C(0x657C7E051D2A8E2B), UINT64_C(0x8270F1A7E3F64D62),
          UINT64_C(0xFD258B59953AF5A2), UINT64_C(0x6DE0114143510AA3)}},
    },
    {
        {{UINT64_C(0x483904280D7A5CBE), UINT64_C(0xD37E8C1FDE441E5E),
          UINT64_C(0x908C88B80DE31C8C), UINT64_C(0x7C0E24BB0ACD87CE)},
         {UINT64_C(0x4A78117725ECCCE8), UINT64_C(0xC06C2F7ACBDA746F),
          UINT64_C(0xDB9E9A08AB565DD4), UINT64_C(0x1E9B44C0BE776F5B)}},
        {{UINT64_C(0x7CFD4E5085B54ABC), UINT64_C(0x41A4A4DCE7A44F8B),
          UINT64_C(0x751C5052A4422576), UINT64_C(0x534FE0B2D56B6CB1)},
         {UINT64_C(0x22DAA5CDD5D767D0), UINT64_C(0x9C1999AB0AF8E22C),
          UINT64_C(0xC70C093299259068), UINT64_C(0x459D212EFD0839F0)}},
        {{UINT64_C(0xA207E7DEFD32D79B), UINT64_C(0xA7B54991410B479F),
          UINT64_C(0x806912B6D68E5CDC), UINT64_C(0x1CB7B68C92AB8B64)},
         {UINT64_C(0x3DB85378DF98339F), UINT64_C(0xA24101DC83EA7A18),
          UINT64_C(0x8892367CE25522C5), UINT64_C(0x491A8BB37753A2C3)}},
        {{UINT64_C(0x571C547E8C7875A7), UINT64_C(0x7E5F23E4E9747C13),
          UINT64_C(0x00F3BBB21058548D), UINT64_C(0x7081F172E2397102)},
         {UINT64_C(0xB4351B8A6B573034), UINT64_C(0xB35A4F44C1A094F0),
          UINT64_C(0xE2C1DAEDAE951E96), UINT64_C(0x5CF2A742B9DAA081)}},
        {{UINT64_C(0xB4F0D3F09828ED9F), UINT64_C(0x6DB312FBA9251386),
          UINT64_C(0xC9A4583F537203F2), UINT64_C(0x5E0996399CE76D40)},
         {UINT64_C(0x3381B894C9F8CEA8), UINT64_C(0x8242DAF8626E07E8),
          UINT64_C(0x64A0B68C6077DFD9), UINT64_C(0x3CC462C0563CF051)}},
        {{UINT64_C(0x8937364C87AF4A45), UINT64_C(0x8C4ACBFA2DE0FD60),
          UINT64_C(0xF10AED11472A5D8A), UINT64_C(0x3F5674B55380C2E6)},
         {UINT64_C(0x8F4FD0F52BF8A452), UINT64_C(0xB436E388C7390418),
          UINT64_C(0xAFAB7B7CE6EE9406), UINT64_C(0x4F623177951739BA)}},
        {{UINT64_C(0x90B0ED35A9B50F2A), UINT64_C(0x46DC3F91AC6CF217),
          UINT64_C(0x2F1420312C7B119C), UINT64_C(0x55A93CBC07D79225)},
         {UINT64_C(0x45E0DD7DB304A642), UINT64_C(0xB743DFCDD572D446),
          UINT64_C(0x867B02EBAC74B368), UINT64_C(0x67B2B86C169B94B0)}},
        {{UINT64_C(0x18396DA7483CFEDB), UINT64_C(0x6C6E03708A3A07C2),
          UINT64_C(0xF32A1AFEAB554998), UINT64_C(0x408C911987D1C136)},
         {UINT64_C(0x755F63254BBE0B78), UINT64_C(0xDC4A7319D1178550),
          UINT64_C(0x44B49813B3B9E459), UINT64_C(0x0294B9A94C3D3620)}},
        {{UINT64_C(0x6480F6FE067FA6FF), UINT64_C(0x67891400F307A52E),
          UINT64_C(0x9F846EF87F865DA8), UINT64_C(0x318DAC55AE02F671)},
         {UINT64_C(0x91119652E288A317), UINT64_C(0x4D7CF2B8038C61B8),
          UINT64_C(0x098F80DD5154C1A8), UINT64_C(0x10C04F87D239A2D4)}},
        {{UINT64_C(0x134609265CA6F183), UINT64_C(0x5E97AD18D52001ED),
          UINT64_C(0x7DCD2477E14843DF), UINT64_C(0x27DAB27698A30426)},
         {UINT64_C(0x7939CAE3E120D80C), UINT64_C(0xC9F4646651E5B81A),
          UINT64_C(0xED620322E2E49D52), UINT64_C(0x3C0F5A2EFA172BBB)}},
        {{UINT64_C(0xBFFE87425DB1196B), UINT64_C(0xCD45F8ED49B7214E),
          UINT64_C(0x923ABA47C35F5C33), UINT64_C(0x16ED1F1083F3EE48)},
         {UINT64_C(0x042E6DF099274930), UINT64_C(0xE8AE1DCFC5F8EA16),
          UINT64_C(0x004462CBF02EA2B2), UINT64_C(0x427F9381D284B04E)}},
        {{UINT64_C(0x4CD481F875EFACC5), UINT64_C(0xD98C3FD421C83368),
          UINT64_C(0x4335E7C83894CE88), UINT64_C(0x18321F87955A298C)},
         {UINT64_C(0x073DD00AD1716E18), UINT64_C(0x66D82A5FFE0BFE61),
          UINT64_C(0x7D869E202310C532), UINT64_C(0x29A376FB19BF4704)}},
        {{UINT64_C(0xA1B12B35C149B5B0), UINT64_C(0x3411B2311E828959),
          UINT64_C(0x56417519560D99FB), UINT64_C(0x4E0EB143EBB52124)},
         {UINT64_C(0x7B594B5E6AEF3801), UINT64_C(0x00AEE12E9ECB536E),
          UINT64_C(0x6BF0FB2956E23145), UINT64_C(0x2B2D83B961AE8E98)}},
        {{UINT64_C(0x9CB3E2E86AC27F2D), UINT64_C(0x82BACA965A6280AA),
          UINT64_C(0xCBC6C01B2C6B7C8F), UINT64_C(0x390511BCD0C01ABD)},
         {UINT64_C(0xB322D97249551C0D), UINT64_C(0x7905E82E7B6489C8),
          UINT64_C(0x4DD0CE8B40EEC20D), UINT64_C(0x5C0B3EE72409298A)}},
        {{UINT64_C(0x4418D685B635FB99), UINT64_C(0x652EA6083ACE8B39),
          UINT64_C(0xE586FBDC46FC4047), UINT64_C(0x3C832D34D8CC13D8)},
         {UINT64_C(0x14CC9F23F7AA54A1), UINT64_C(0x80D094E607153B9F),
          UINT64_C(0x0776E5406A2EED8E), UINT64_C(0x03CC3BFC77249085)}},
        {{UINT64_C(0x5F8F281F1308C1A8), UINT64_C(0x31C8E737D1AFC4B7),
          UINT64_C(0x6778529841AE8EF2), UINT64_C(0x17716086FD028A4B)},
         {UINT64_C(0x1A2083E0F922E100), UINT64_C(0xD67EC9D1D53FE691),
          UINT64_C(0x2DF8B6EDECCA8DEB), UINT64_C(0x3B595EE4BCCC999E)}},
    },
    {
        {{UINT64_C(0x11F03F895A4B8C04), UINT64_C(0x254C36487DAE8E6B),
          UINT64_C(0xAB6EAAF1637CDB83), UINT64_C(0x41F52243FDDED8F6)},
         {UINT64_C(0x487078E1BBDF3270), UINT64_C(0x98853B49339CEA28),
          UINT64_C(0x8AF0522BAB3EDE57), UINT64_C(0x734D711F85EB4CC0)}},
        {{UINT64_C(0xFD1F46ADF86BA644), UINT64_C(0xA5332B97A3299855),
          UINT64_C(0x61BE90DBD9493634), UINT64_C(0x308F09B1C2705911)},
         {UINT64_C(0xD59F1B1A0B7918A5), UINT64_C(0x9CF333D0CF6399E6),
          UINT64_C(0xD09C63CDFBB26B6B), UINT64_C(0x76C27913A6536647)}},
        {{UINT64_C(0x3DF1811FAAAB555C), UINT64_C(0x60853351886C828B),
          UINT64_C(0xF6CA7707F1E87F41), UINT64_C(0x5B4F6EDF7D7082E6)},
         {UINT64_C(0xADE518E03F672DE7), UINT64_C(0x00ED0B84022541B2),
          UINT64_C(0x04FE5DD6618E8969), UINT64_C(0x2F5F5C65DB9CCA4D)}},
        {{UINT64_C(0x00B69B4596BDAE2C), UINT64_C(0x06DB22CF770604C4),
          UINT64_C(0xC2EB7F8F856585C3), UINT64_C(0x6E3225390413C614)},
         {UINT64_C(0x22C09EA870A46872), UINT64_C(0x143E73BC1FF23734),
          UINT64_C(0xCAC5E2DD575C20B4), UINT64_C(0x225E53903FEBE787)}},
        {{UINT64_C(0x594FEA4EBE9C512D), UINT64_C(0x5850709292CB73AE),
          UINT64_C(0xFD8EFC7DB0CE2096), UINT64_C(0x3B58C199E031D6AB)},
         {UINT64_C(0x55DA1CBD479F23E4), UINT64_C(0x060C6BB5A6DB6137),
          UINT64_C(0xD8319CF86864488E), UINT64_C(0x6C15A31B21B02EDA)}},
        {{UINT64_C(0x13C483728CA7084D), UINT64_C(0xF7554E59A171ECE5),
          UINT64_C(0x7425C5D823A97699), UINT64_C(0x6F2C68DA71E1120E)},
         {UINT64_C(0x9591B9B624324B64), UINT64_C(0x2DA33472C02AC704),
          UINT64_C(0xC5DE7FC981EE1295), UINT64_C(0x6A646A445D6E93C6)}},
        {{UINT64_C(0x48684061A39D6554), UINT64_C(0xB70ABF61C3DF57B6),
          UINT64_C(0x9824AFD658B9EEE3), UINT64_C(0x46EBE9D13A14A733)},
         {UINT64_C(0x8E70F95DD74F8E94), UINT64_C(0xA9D922A26AFCA4E2),
          UINT64_C(0x519A97536988CC16), UINT64_C(0x711DEF16D545AF8A)}},
        {{UINT64_C(0x362A5D95811A2BF7), UINT64_C(0x42A84A33566B90CE),
          UINT64_C(0x25CBC7607C41EC87), UINT64_C(0x6B77E39CD4B7DBEE)},
         {UINT64_C(0xA98B8201833015A4), UINT64_C(0xE412E217C31B26F4),
          UINT64_C(0x518BE8F0E0090782), UINT64_C(0x08D9F4B63DB51D4E)}},
        {{UINT64_C(0x2C80CE87297D421E), UINT64_C(0x2FD137F8ADBA1498),
          UINT64_C(0xA2ED3D472899AA14), UINT64_C(0x2AC924A5FE4F365A)},
         {UINT64_C(0xAC0389B7666DC0A0), UINT64_C(0x3CC997398ABF3D9E),
          UINT64_C(0x33060DB6DFBFF83A), UINT64_C(0x54EEE2150339C3B8)}},
        {{UINT64_C(0x06C3A4F5820F7E4D), UINT64_C(0x86F083E208C3D311),
          UINT64_C(0x47E29984FE4B0476), UINT64_C(0x218F52E2CA7DF6CF)},
         {UINT64_C(0x59317E26BF2C2084), UINT64_C(0xEA9C865B289A10CF),
          UINT64_C(0x7AA1E50B2074FEA3), UINT64_C(0x708A1D8C4B3EFC31)}},
        {{UINT64_C(0x34C5C63E864817D7), UINT64_C(0x0F614043D89E995B),
          UINT64_C(0x60CE8BCE975E2A03), UINT64_C(0x70916E2978493E0C)},
         {UINT64_C(0xBD0748F9216782C6), UINT64_C(0x0051C65AED32FB72),
          UINT64_C(0x9DC5F5584DD64705), UINT64_C(0x674F1A63EEC14B50)}},
        {{UINT64_C(0x73D6E68EDB633FD1), UINT64_C(0x7B5F8303F52F9537),
          UINT64_C(0x980FDDDC88A74CFB), UINT64_C(0x6419C18F47FC32D1)},
         {UINT64_C(0x93727B4C870B5D59), UINT64_C(0x4BCE05DECF28021D),
          UINT64_C(0x3C059B47AB4F0CE5), UINT64_C(0x77CA7F67B85FFDBB)}},
        {{UINT64_C(0xDBEADDCEC525088E), UINT64_C(0x561E12BE390D2221),
          UINT64_C(0xCD224FC1D9BA7AF0), UINT64_C(0x03744552394DC073)},
         {UINT64_C(0xCFC67B4921BB6B6E), UINT64_C(0xD234FD8D1B5F8E6A),
          UINT64_C(0x6DDBC18B40B7F8B0), UINT64_C(0x79F40857DAACCC74)}},
        {{UINT64_C(0x30E5F9909DD71B9C), UINT64_C(0x00FCBFA5291124EF),
          UINT64_C(0xBE595A2549B8C570), UINT64_C(0x5B4B8141BC094446)},
         {UINT64_C(0xB22B4F04469191B6), UINT64_C(0x10845AC8D73C4D38),
          UINT64_C(0x39C9F0FBED0C8224), UINT64_C(0x7E009DFBF5813BEE)}},
        {{UINT64_C(0xA47C2989A61D09C0), UINT64_C(0x3706F45659E55A9C),
          UINT64_C(0x2373976FEA0259B9), UINT64_C(0x13FC0E09077D20CC)},
         {UINT64_C(0xBB24DD05E78D29CF), UINT64_C(0xD8757A67822CFA02),
          UINT64_C(0x36CA74863C55A4C6), UINT64_C(0x4234E6893EEABBE1)}},
        {{UINT64_C(0xA2F54D14B46BDB51), UINT64_C(0x8A530B78675BB770),
          UINT64_C(0x617D7E8EDE9F1F8B), UINT64_C(0x799B3E442DCC4712)},
         {UINT64_C(0x658A31D8B486FE8C), UINT64_C(0x45BAFC29163D4AF0),
          UINT64_C(0x3A2C7F66A5289C8D), UINT64_C(0x4ECC3C7DB91FF3DB)}},
    },
    {
        {{UINT64_C(0x738CF1C7DF4DFD43), UINT64_C(0x72943A2DE987084C),
          UINT64_C(0xEA21C05F2491FF24), UINT64_C(0x3D3F4ED7DA050094)},
         {UINT64_C(0xF90644E461C4054D), UINT64_C(0x253792143A50E82A),
          UINT64_C(0x47EDB006C7DEF970), UINT64_C(0x0F8F031C0F53F307)}},
        {{UINT64_C(0x50FEB6D8724976D5), UINT64_C(0x57AA499FF40C7720),
          UINT64_C(0x6B80AC540DAAF428), UINT64_C(0x7AC6845E1F6FC276)},
         {UINT64_C(0x8EC7FAB117A4B9C5), UINT64_C(0x8336DD62ED0C8F97),
          UINT64_C(0x6014A510B7B7104E), UINT64_C(0x4991A03BA2911C30)}},
        {{UINT64_C(0x6D353975CBCC9BA3), UINT64_C(0x23E97E28C4564492),
          UINT64_C(0xDF432FDAF8AEED3E), UINT64_C(0x11DB40DD6F6B472C)},
         {UINT64_C(0x5B87005B95AA0174), UINT64_C(0x1DB4108089D9F1A8),
          UINT64_C(0x5A6BC444689DF208), UINT64_C(0x16153F87BF38FF8D)}},
        {{UINT64_C(0xD217003FFFD3C814), UINT64_C(0x1ADE64C3FD50AF95),
          UINT64_C(0x1936332C9FFB8BEB), UINT64_C(0x6EE322DCD70CD8D8)},
         {UINT64_C(0xE40A0419F2A60976), UINT64_C(0xA62F6FA1EF93B05B),
          UINT64_C(0x5978206C596575FF), UINT64_C(0x5CDCA200B68BFE5C)}},
        {{UINT64_C(0x3FB16AEDB7949E33), UINT64_C(0x3453892840304A1B),
          UINT64_C(0x7FA35A343BCA4239), UINT64_C(0x22FD1AEFEE76919E)},
         {UINT64_C(0x1F8FE6A40F6A5D50), UINT64_C(0x27CC704F26BBA46B),
          UINT64_C(0x230FD0CA3420CC52), UINT64_C(0x3E9E4DA4B3A83D85)}},
        {{UINT64_C(0x1D82390E7F5CC75E), UINT64_C(0x7025624549D0A605),
          UINT64_C(0x5B8778134FF4BC44), UINT64_C(0x28E6A057B5EC02E4)},
         {UINT64_C(0xBC7A10DA2E89FB84), UINT64_C(0x3AF182E520E1EA00),
          UINT64_C(0x4B590FFA9C507274), UINT64_C(0x26BA94D6AA7FD65B)}},
        {{UINT64_C(0xC02CC77C238CC195), UINT64_C(0x3F175C97A97EE3E4),
          UINT64_C(0x8A28FA23DFA1F9DC), UINT64_C(0x35CAC0FF1F968D15)},
         {UINT64_C(0x0FC41B3337C7C773), UINT64_C(0x71E06B10BC999443),
          UINT64_C(0x073A1ABA2C87B0A4), UINT64_C(0x29F29B129E5E8B70)}},
        {{UINT64_C(0xAA25F348E491FE70), UINT64_C(0x9371F94BC1713992),
          UINT64_C(0x674B478C4FA08818), UINT64_C(0x6F3C31FEB1407431)},
         {UINT64_C(0xBB7D37FBD93DD5E1), UINT64_C(0xE34A40B87E04EE7A),
          UINT64_C(0xCF82360DF3C33528), UINT64_C(0x0A3B8FF501477712)}},
        {{UINT64_C(0xA45914716B718511), UINT64_C(0x7B0CE8DED2FD6B9B),
          UINT64_C(0xC42544FA6845DBEF), UINT64_C(0x456A698563AF476A)},
         {UINT64_C(0x5DD611F69CDE4E74), UINT64_C(0x860956832B346AEB),
          UINT64_C(0xD15C5DA06E75B3D7), UINT64_C(0x220FFD73C72D5D2C)}},
        {{UINT64_C(0x478DA345D2ED888F), UINT64_C(0xA69D4FB9E04CBCC7),
          UINT64_C(0xA427150AB3F1179D), UINT64_C(0x1DD3B8C2D5CEA78A)},
         {UINT64_C(0x9462EFF0B8628A22), UINT64_C(0xB2FFFF4AB2CB44A5),
          UINT64_C(0x8234A3FF24039BA8), UINT64_C(0x01BE7202916DE889)}},
        {{UINT64_C(0x510669856DFCEF0B), UINT64_C(0x25729D98DF20CDEE),
          UINT64_C(0x872FD39D9693E5EF), UINT64_C(0x72D03AE12D859635)},
         {UINT64_C(0x3F28F84EDACAEB82), UINT64_C(0x9EB40FD6CB5284D7),
          UINT64_C(0x66C2DCA6C5F54041), UINT64_C(0x4BDBA3821C1F2461)}},
        {{UINT64_C(0xE53421970E0ED176), UINT64_C(0xF588547AA225A47F),
          UINT64_C(0xC83B54ED1FEB2259), UINT64_C(0x1B03791392F3733D)},
         {UINT64_C(0x935C97822271ECFA), UINT64_C(0x5F7E94A653CFE07C),
          UINT64_C(0xBFF5B0E61B40CA19), UINT64_C(0x36C7851D459445E1)}},
        {{UINT64_C(0xB6547971588C9748), UINT64_C(0xCFD8E81B11970562),
          UINT64_C(0x41333C80702FE4FA), UINT64_C(0x2F153C8C962A993B)},
         {UINT64_C(0x028BBD6A8BDA48AC), UINT64_C(0x7B076F88FE1DB02A),
          UINT64_C(0xC9560400078FB3FC), UINT64_C(0x5DCC0946035907EA)}},
        {{UINT64_C(0x93D7CF33A6233F1C), UINT64_C(0x03184BC4DF2A187C),
          UINT64_C(0x291149BCE83DAC32), UINT64_C(0x575F4279FAEDF216)},
         {UINT64_C(0x101427B4086FC141), UINT64_C(0xC924F2AED288562E),
          UINT64_C(0xDB610463EEF5799A), UINT64_C(0x20F187676A09661D)}},
        {{UINT64_C(0xE39BB775F59D0C20), UINT64_C(0x18DA90E2723A4EF2),
          UINT64_C(0x8E747A7BF56B381B), UINT64_C(0x7EF67224F98F26DC)},
         {UINT64_C(0xB1373AF5E1F94B99), UINT64_C(0x1076FBA60C3B6AA8),
          UINT64_C(0x7FCD0017A3A7811C), UINT64_C(0x6D1A697346554E7E)}},
        {{UINT64_C(0xE5734077B9CED2C2), UINT64_C(0xC94D17F81F770914),
          UINT64_C(0x58B47BCB1CD248EB), UINT64_C(0x2E06538C24804B6F)},
         {UINT64_C(0x275D933F32E7CA19), UINT64_C(0x1B982B491FC9241E),
          UINT64_C(0x8B8A6ED53986B6AC), UINT64_C(0x1756822135B4EA6A)}},
    },
    {
        {{UINT64_C(0x090AD05AE796327F), UINT64_C(0xA78DAE5EAD21DD4B),
          UINT64_C(0x8EEC9EDB9C2F8CBE), UINT64_C(0x33E375E0653E0F2D)},
         {UINT64_C(0xDA19EFF28D67AC72), UINT64_C(0xBFC7E62B2737AB8C),
          UINT64_C(0xBBF8BD1D4CF53C12), UINT64_C(0x5ABFE23F45C6D555)}},
        {{UINT64_C(0x32460B330DE39342), UINT64_C(0x3567454AB8977067),
          UINT64_C(0x10A1E47DF954592C), UINT64_C(0x4DE8C6EF4DD019C4)},
         {UINT64_C(0x1F1D296B1BDAAAFA), UINT64_C(0x4E6B8E8F3A75AD99),
          UINT64_C(0x259015E1A27FE061), UINT64_C(0x6B6A48209F320632)}},
        {{UINT64_C(0x8AA089AFA0B5E605), UINT64_C(0x1D6C1EEE1B4058FD),
          UINT64_C(0x1D920534B4E89BEF), UINT64_C(0x722A3A3516163340)},
         {UINT64_C(0xA3B9178CF33B49B2), UINT64_C(0xFF8FE9BB65558E90),
          UINT64_C(0x94766BC09794EFAE), UINT64_C(0x79A1EFA2FDFAEB42)}},
        {{UINT64_C(0x2FE44B97BCB6D558), UINT64_C(0xB4F4F402DB8B0A79),
          UINT64_C(0xF53D8AB1247C32E5), UINT64_C(0x3B883CE54DA4C009)},
         {UINT64_C(0xB46168BD2EC9F1C6), UINT64_C(0xD40BDE7B6B8FE01A),
          UINT64_C(0x60A5C168CDFE509F), UINT64_C(0x3314D87823BE249E)}},
        {{UINT64_C(0x02511A854D9F5769), UINT64_C(0x8398F9BDB49D6A8E),
          UINT64_C(0xE8D773F35D2D7135), UINT64_C(0x09B3B8AB9DECC331)},
         {UINT64_C(0x8D2B269B584C11D9), UINT64_C(0xF76619446B6B86A9),
          UINT64_C(0x719A3620C7659AF7), UINT64_C(0x3CFC8DF037C27DBE)}},
        {{UINT64_C(0x5EE0BE061145B14B), UINT64_C(0xAC6950E423193ED6),
          UINT64_C(0x7291C44CDF244C7F), UINT64_C(0x4650C16243D744EA)},
         {UINT64_C(0x60B92D3F34A084D8), UINT64_C(0xBBD44A0E376E5414),
          UINT64_C(0x5C0E488A0980F36C), UINT64_C(0x4E53FCCAD7991A09)}},
        {{UINT64_C(0x7A2ADBCF367B55C2), UINT64_C(0x96A88B751FED467E),
          UINT64_C(0x8E75E37EFB263845), UINT64_C(0x4C2E47B8EB508DD0)},
         {UINT64_C(0x20BF51DEB19FCD14), UINT64_C(0xD907174914CB67D0),
          UINT64_C(0xEC90714B29EBDA7C), UINT64_C(0x4ACADAA6634C0F2E)}},
        {{UINT64_C(0xA516B9B8EC715EC9), UINT64_C(0xC7DCA26342B8A87B),
          UINT64_C(0x2CE450C9DA27B456), UINT64_C(0x3C97481200A8819F)},
         {UINT64_C(0xF4822C23ECDED574), UINT64_C(0xFA737FAD19FA48D4),
          UINT64_C(0xE34B2F2A45D718E0), UINT64_C(0x1D6F19FEBEA7B540)}},
        {{UINT64_C(0xADC8FCE798E24789), UINT64_C(0xFE2F890C45869609),
          UINT64_C(0x6466E03C78A35C19), UINT64_C(0x24C70FEDC1F34AA9)},
         {UINT64_C(0x89530F7557747DD1), UINT64_C(0x343DE05B2B8CDE2D),
          UINT64_C(0xC33134E335CC8D5A), UINT64_C(0x3CCEFC38AC9B4F2B)}},
        {{UINT64_C(0x84C904B8EF923364), UINT64_C(0x46E1FECFBDDD31D8),
          UINT64_C(0xA8126DD6FAE79B6B), UINT64_C(0x4A53C034FBF05C9A)},
         {UINT64_C(0x44CA3ACBBE8F255F), UINT64_C(0x6F0FD374EC319885),
          UINT64_C(0xADBCB4AAF1836DC2), UINT64_C(0x6CC3A59665187EE9)}},
        {{UINT64_C(0x941E7821B397B5E7), UINT64_C(0xD3457371FEE2A9D5),
          UINT64_C(0x9F69BE4466382F60), UINT64_C(0x6DCEAD04A1F49E9B)},
         {UINT64_C(0xDC6BC23B3BF21647), UINT64_C(0x1500FD7FB5271BE9),
          UINT64_C(0x9B0994DDF23FDF3D), UINT64_C(0x38A2ECEB45065CF7)}},
        {{UINT64_C(0x2667CEFE0DCA8BF4), UINT64_C(0x8227ACB3E46EB469),
          UINT64_C(0x4C20677DA75C5B8B), UINT64_C(0x224FC5B4B36ACDFE)},
         {UINT64_C(0xA0007E147A6A01D3), UINT64_C(0x15C79558F8A64EED),
          UINT64_C(0xFB58A76A93DEDC09), UINT64_C(0x2057DDDC26F10A98)}},
        {{UINT64_C(0x1FF658AEBDB27AE4), UINT64_C(0x7F30DF57DDD96647),
          UINT64_C(0x63490B8DC7294313), UINT64_C(0x0EAEC5735435869E)},
         {UINT64_C(0x85F05C49DF115B78), UINT64_C(0x95739C0C62992F5D),
          UINT64_C(0x72F143192B573963), UINT64_C(0x05600E6486328FF4)}},
        {{UINT64_C(0x9BE7331FEAB0F425), UINT64_C(0x2E4CF5AA74447C20),
          UINT64_C(0x9B26F51266243D2A), UINT64_C(0x77C9672284AB5627)},
         {UINT64_C(0xEC545427601673B4), UINT64_C(0xEF6A34FB2F127AF7),
          UINT64_C(0x519559C1E2DFD269), UINT64_C(0x34D7D7548258E37A)}},
        {{UINT64_C(0xC113747B5E8B5281), UINT64_C(0x0C085456E04D779B),
          UINT64_C(0x3E3260521CCBCFC6), UINT64_C(0x5C954CC12A37D19F)},
         {UINT64_C(0xB1A4A5B39124435B), UINT64_C(0x5E8B8D4118ED98E7),
          UINT64_C(0xC973D969144A3793), UINT64_C(0x0CB98CC888DD8B49)}},
        {{UINT64_C(0x0E0233B2B48D04DF), UINT64_C(0x1B3916E07BEAA4A5),
          UINT64_C(0xA24A4BE4B672BE8C), UINT64_C(0x7A61506D845AB94D)},
         {UINT64_C(0x160DFA0FE7F4CA3B), UINT64_C(0xA9562C89D84C1148),
          UINT64_C(0x52979B9592A276EB), UINT64_C(0x17869B53924E86E9)}},
    },
    {
        {{UINT64_C(0x5D39F4781A86D0D8), UINT64_C(0xDE5932DAFB8BC8A9),
          UINT64_C(0xD706C6D72F5B4B70), UINT64_C(0x53F450FC8A36AFC2)},
         {UINT64_C(0xE1DC35401E550B3B), UINT64_C(0x475507DC8B7EB6D2),
          UINT64_C(0xF803F78ADFA2E5F7), UINT64_C(0x40B5F263C48097FF)}},
        {{UINT64_C(0x336FB00E226CDB1F), UINT64_C(0xDDC1BB0288215C40),
          UINT64_C(0x6C4DD40E73C07FD0), UINT64_C(0x4D0D2E498F7D15E7)},
         {UINT64_C(0xAF96E9B3D2061402), UINT64_C(0x15A3084A1372FCF8),
          UINT64_C(0x91B571E6307B02D6), UINT64_C(0x2239592F53AE7705)}},
        {{UINT64_C(0x7D8615A1C20B6645), UINT64_C(0xF4875767C7C4465B),
          UINT64_C(0xF6D3E718861702AB), UINT64_C(0x7F014A53131F726A)},
         {UINT64_C(0x30809F8FDAAB77CA), UINT64_C(0x7CE8DC6128F944D3),
          UINT64_C(0xF915111D9AEEF6A1), UINT64_C(0x246D7CC8206902FD)}},
        {{UINT64_C(0x7677488BEF806225), UINT64_C(0x994C8104F4C75EAE),
          UINT64_C(0x17586D4E4E0C8988), UINT64_C(0x70E5258090E33A2A)},
         {UINT64_C(0xB993F26A022D2FED), UINT64_C(0x955C130D689FBFBD),
          UINT64_C(0x0D3D1C63A3612E8E), UINT64_C(0x423D73E1B91A8DE6)}},
        {{UINT64_C(0x7274BE083027164F), UINT64_C(0xDE907B4942FDB769),
          UINT64_C(0x61D74449B697060D), UINT64_C(0x18A5FDC226602CC9)},
         {UINT64_C(0xB08DC02B049CAF4A), UINT64_C(0xC84AF48578DBA1F1),
          UINT64_C(0x0A5B35197178E4DF), UINT64_C(0x6EC7A7A55B26D0FE)}},
        {{UINT64_C(0xDEF1782F88554F05), UINT64_C(0xB73E7333D8D6DF47),
          UINT64_C(0x1DDF902290E9C67A), UINT64_C(0x5D217B51D56181AC)},
         {UINT64_C(0x7A338C7BE27F90EE), UINT64_C(0xB97CCD2A0D84A177),
          UINT64_C(0x3E1016017C5E3FA9), UINT64_C(0x2706E77C30FF0918)}},
        {{UINT64_C(0x1BD1274F72A7CB9F), UINT64_C(0x8B60357A0622DB90),
          UINT64_C(0x0140E14A2151BB23), UINT64_C(0x358D7DDAE9A30C4C)},
         {UINT64_C(0x3B15306089BFB2C6), UINT64_C(0x47462C79B6757C69),
          UINT64_C(0x2B22239DB43EF986), UINT64_C(0x6793671F0B774DE3)}},
        {{UINT64_C(0x99EDB02EF6F8EDC6), UINT64_C(0x24432760C4257DD9),
          UINT64_C(0x4FDD73010336EED2), UINT64_C(0x44879709F6C6506B)},
         {UINT64_C(0x107C7DE213F18D89), UINT64_C(0x71C71DFBA5701FBD),
          UINT64_C(0x97017E24C7DE3E0B), UINT64_C(0x0F8D7E09FC9EDDC2)}},
        {{UINT64_C(0x7A0BB3B13897E01D), UINT64_C(0x7FD4F504C5892BDE),
          UINT64_C(0x2EA9AA77AB752928), UINT64_C(0x19A82F559078B466)},
         {UINT64_C(0xEF2842C555A0F0D9), UINT64_C(0x5501EEE915B6F2B4),
          UINT64_C(0x9665EA6F942AA4B4), UINT64_C(0x015F41F40E707C32)}},
        {{UINT64_C(0x1B4D6A919C6B6FD6), UINT64_C(0xCFD2CEE968217AFC),
          UINT64_C(0xC5076256BBC9284D), UINT64_C(0x4C7F4EEFAC36547B)},
         {UINT64_C(0xAB1AAD2C65EE1907), UINT64_C(0xBCFE8C77BAC25425),
          UINT64_C(0x38BA0F85C9048A35), UINT64_C(0x300E6AC460A035F6)}},
        {{UINT64_C(0xA8EDBC5E34707CC6), UINT64_C(0x3DA6BC5156ADFC16),
          UINT64_C(0x5C7CB5E1CA8B6F3F), UINT64_C(0x76E4A0282D612DFA)},
         {UINT64_C(0x75AB66FD64F49D39), UINT64_C(0x5AF9879DC387A739),
          UINT64_C(0x839648083E9EDBCF), UINT64_C(0x555D8BBD7F4C4FFE)}},
        {{UINT64_C(0xAAE8A2FE3C5590B0), UINT64_C(0x461C6CCC8AB34213),
          UINT64_C(0xB2F3E8229E719B77), UINT64_C(0x25B8FCA8663188BB)},
         {UINT64_C(0xAA7A047B72548131), UINT64_C(0x0878FFEE189FA6F0),
          UINT64_C(0x9E7FB402CE3E17C3), UINT64_C(0x6F260D9344418277)}},
        {{UINT64_C(0x0EF1C290B703B647), UINT64_C(0x995009FA651673E4),
          UINT64_C(0x661F76D7BE46362D), UINT64_C(0x74B00FD123E56E7A)},
         {UINT64_C(0x9557D0ABA1A50E4B), UINT64_C(0xC5A1CF95587688CE),
          UINT64_C(0x2A14D1B27AE08ECA), UINT64_C(0x2DA8816C3C23D507)}},
        {{UINT64_C(0x51CB405FB9934883), UINT64_C(0xC99A67D401A6864B),
          UINT64_C(0xCCF622336CDFFFC3), UINT64_C(0x2938F9F998FE0B79)},
         {UINT64_C(0x7766691139A5AA28), UINT64_C(0xDF56CBB52427BFC0),
          UINT64_C(0xA39BE968189EB66D), UINT64_C(0x71E6E105A64FD2AB)}},
        {{UINT64_C(0xA0C6F79560F9D20B), UINT64_C(0xE06DC8BB765670CC),
          UINT64_C(0x9FA1DD58A67275E0), UINT64_C(0x0F7F670DE2D23BBB)},
         {UINT64_C(0xF8F07CF333FB15EA), UINT64_C(0x1D09B592723A0271),
          UINT64_C(0xF14029234E6FCAAB), UINT64_C(0x05BE1273AE301940)}},
        {{UINT64_C(0x2D83906C114AFD1E), UINT64_C(0x091474FDC88E5761),
          UINT64_C(0xAFF18EEBEF9E4F9B), UINT64_C(0x136ECAE5F4E646ED)},
         {UINT64_C(0xEF4526D0EB01808F), UINT64_C(0x3923EBBA940C0AEC),
          UINT64_C(0xAB34160CA437F460), UINT64_C(0x7A46966E421AD57C)}},
    }};

/*-
 * Q := 2P, both projective, Q and P same pointers OK
 * Autogenerated: op3/dbl_proj_any.op3
 * https://eprint.iacr.org/2015/1060 Alg 3
 */
static void point_double(pt_prj_t *Q, const pt_prj_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4;
    /* constants */
    const limb_t *a = const_a;
    const limb_t *b3 = const_b3;
    /* set pointers for legacy curve arith */
    const limb_t *X = P->X;
    const limb_t *Y = P->Y;
    const limb_t *Z = P->Z;
    limb_t *X3 = Q->X;
    limb_t *Y3 = Q->Y;
    limb_t *Z3 = Q->Z;

    /* the curve arith formula */
    fiat_id_GostR3410_2001_TestParamSet_square(t0, X);
    fiat_id_GostR3410_2001_TestParamSet_square(t1, Y);
    fiat_id_GostR3410_2001_TestParamSet_square(t2, Z);
    fiat_id_GostR3410_2001_TestParamSet_mul(t3, X, Y);
    fiat_id_GostR3410_2001_TestParamSet_add(t3, t3, t3);
    fiat_id_GostR3410_2001_TestParamSet_mul(t4, Y, Z);
    fiat_id_GostR3410_2001_TestParamSet_mul(Z3, X, Z);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, Z3, Z3);
    fiat_id_GostR3410_2001_TestParamSet_mul(X3, a, Z3);
    fiat_id_GostR3410_2001_TestParamSet_mul(Y3, b3, t2);
    fiat_id_GostR3410_2001_TestParamSet_add(Y3, X3, Y3);
    fiat_id_GostR3410_2001_TestParamSet_sub(X3, t1, Y3);
    fiat_id_GostR3410_2001_TestParamSet_add(Y3, t1, Y3);
    fiat_id_GostR3410_2001_TestParamSet_mul(Y3, X3, Y3);
    fiat_id_GostR3410_2001_TestParamSet_mul(X3, t3, X3);
    fiat_id_GostR3410_2001_TestParamSet_mul(Z3, b3, Z3);
    fiat_id_GostR3410_2001_TestParamSet_mul(t2, a, t2);
    fiat_id_GostR3410_2001_TestParamSet_sub(t3, t0, t2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t3, a, t3);
    fiat_id_GostR3410_2001_TestParamSet_add(t3, t3, Z3);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, t0, t0);
    fiat_id_GostR3410_2001_TestParamSet_add(t0, Z3, t0);
    fiat_id_GostR3410_2001_TestParamSet_add(t0, t0, t2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, t0, t3);
    fiat_id_GostR3410_2001_TestParamSet_add(Y3, Y3, t0);
    fiat_id_GostR3410_2001_TestParamSet_add(t2, t4, t4);
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, t2, t3);
    fiat_id_GostR3410_2001_TestParamSet_sub(X3, X3, t0);
    fiat_id_GostR3410_2001_TestParamSet_mul(Z3, t2, t1);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, Z3, Z3);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, Z3, Z3);
}

/*-
 * R := Q + P where R and Q are projective, P affine.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_mixed_any.op3
 * https://eprint.iacr.org/2015/1060 Alg 2
 */
static void point_add_mixed(pt_prj_t *R, const pt_prj_t *Q, const pt_aff_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4, t5;
    /* constants */
    const limb_t *a = const_a;
    const limb_t *b3 = const_b3;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    fe_t X3;
    fe_t Y3;
    fe_t Z3;
    limb_t nz;

    /* check P for affine inf */
    fiat_id_GostR3410_2001_TestParamSet_nonzero(&nz, P->Y);

    /* the curve arith formula */
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, X1, X2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t1, Y1, Y2);
    fiat_id_GostR3410_2001_TestParamSet_add(t3, X2, Y2);
    fiat_id_GostR3410_2001_TestParamSet_add(t4, X1, Y1);
    fiat_id_GostR3410_2001_TestParamSet_mul(t3, t3, t4);
    fiat_id_GostR3410_2001_TestParamSet_add(t4, t0, t1);
    fiat_id_GostR3410_2001_TestParamSet_sub(t3, t3, t4);
    fiat_id_GostR3410_2001_TestParamSet_mul(t4, X2, Z1);
    fiat_id_GostR3410_2001_TestParamSet_add(t4, t4, X1);
    fiat_id_GostR3410_2001_TestParamSet_mul(t5, Y2, Z1);
    fiat_id_GostR3410_2001_TestParamSet_add(t5, t5, Y1);
    fiat_id_GostR3410_2001_TestParamSet_mul(Z3, a, t4);
    fiat_id_GostR3410_2001_TestParamSet_mul(X3, b3, Z1);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, X3, Z3);
    fiat_id_GostR3410_2001_TestParamSet_sub(X3, t1, Z3);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, t1, Z3);
    fiat_id_GostR3410_2001_TestParamSet_mul(Y3, X3, Z3);
    fiat_id_GostR3410_2001_TestParamSet_add(t1, t0, t0);
    fiat_id_GostR3410_2001_TestParamSet_add(t1, t1, t0);
    fiat_id_GostR3410_2001_TestParamSet_mul(t2, a, Z1);
    fiat_id_GostR3410_2001_TestParamSet_mul(t4, b3, t4);
    fiat_id_GostR3410_2001_TestParamSet_add(t1, t1, t2);
    fiat_id_GostR3410_2001_TestParamSet_sub(t2, t0, t2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t2, a, t2);
    fiat_id_GostR3410_2001_TestParamSet_add(t4, t4, t2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, t1, t4);
    fiat_id_GostR3410_2001_TestParamSet_add(Y3, Y3, t0);
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, t5, t4);
    fiat_id_GostR3410_2001_TestParamSet_mul(X3, t3, X3);
    fiat_id_GostR3410_2001_TestParamSet_sub(X3, X3, t0);
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, t3, t1);
    fiat_id_GostR3410_2001_TestParamSet_mul(Z3, t5, Z3);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, Z3, t0);

    /* if P is inf, throw all that away and take Q */
    fiat_id_GostR3410_2001_TestParamSet_selectznz(R->X, nz, Q->X, X3);
    fiat_id_GostR3410_2001_TestParamSet_selectznz(R->Y, nz, Q->Y, Y3);
    fiat_id_GostR3410_2001_TestParamSet_selectznz(R->Z, nz, Q->Z, Z3);
}

/*-
 * R := Q + P all projective.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_proj_any.op3
 * https://eprint.iacr.org/2015/1060 Alg 1
 */
static void point_add_proj(pt_prj_t *R, const pt_prj_t *Q, const pt_prj_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4, t5;
    /* constants */
    const limb_t *a = const_a;
    const limb_t *b3 = const_b3;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    const limb_t *Z2 = P->Z;
    limb_t *X3 = R->X;
    limb_t *Y3 = R->Y;
    limb_t *Z3 = R->Z;

    /* the curve arith formula */
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, X1, X2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t1, Y1, Y2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t2, Z1, Z2);
    fiat_id_GostR3410_2001_TestParamSet_add(t3, X1, Y1);
    fiat_id_GostR3410_2001_TestParamSet_add(t4, X2, Y2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t3, t3, t4);
    fiat_id_GostR3410_2001_TestParamSet_add(t4, t0, t1);
    fiat_id_GostR3410_2001_TestParamSet_sub(t3, t3, t4);
    fiat_id_GostR3410_2001_TestParamSet_add(t4, X1, Z1);
    fiat_id_GostR3410_2001_TestParamSet_add(t5, X2, Z2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t4, t4, t5);
    fiat_id_GostR3410_2001_TestParamSet_add(t5, t0, t2);
    fiat_id_GostR3410_2001_TestParamSet_sub(t4, t4, t5);
    fiat_id_GostR3410_2001_TestParamSet_add(t5, Y1, Z1);
    fiat_id_GostR3410_2001_TestParamSet_add(X3, Y2, Z2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t5, t5, X3);
    fiat_id_GostR3410_2001_TestParamSet_add(X3, t1, t2);
    fiat_id_GostR3410_2001_TestParamSet_sub(t5, t5, X3);
    fiat_id_GostR3410_2001_TestParamSet_mul(Z3, a, t4);
    fiat_id_GostR3410_2001_TestParamSet_mul(X3, b3, t2);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, X3, Z3);
    fiat_id_GostR3410_2001_TestParamSet_sub(X3, t1, Z3);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, t1, Z3);
    fiat_id_GostR3410_2001_TestParamSet_mul(Y3, X3, Z3);
    fiat_id_GostR3410_2001_TestParamSet_add(t1, t0, t0);
    fiat_id_GostR3410_2001_TestParamSet_add(t1, t1, t0);
    fiat_id_GostR3410_2001_TestParamSet_mul(t2, a, t2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t4, b3, t4);
    fiat_id_GostR3410_2001_TestParamSet_add(t1, t1, t2);
    fiat_id_GostR3410_2001_TestParamSet_sub(t2, t0, t2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t2, a, t2);
    fiat_id_GostR3410_2001_TestParamSet_add(t4, t4, t2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, t1, t4);
    fiat_id_GostR3410_2001_TestParamSet_add(Y3, Y3, t0);
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, t5, t4);
    fiat_id_GostR3410_2001_TestParamSet_mul(X3, t3, X3);
    fiat_id_GostR3410_2001_TestParamSet_sub(X3, X3, t0);
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, t3, t1);
    fiat_id_GostR3410_2001_TestParamSet_mul(Z3, t5, Z3);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, Z3, t0);
}

/* constants */
#define RADIX 5
#define DRADIX (1 << RADIX)
#define DRADIX_WNAF ((DRADIX) << 1)

/*-
 * precomp for wnaf scalar multiplication:
 * precomp[0] = 1P
 * precomp[1] = 3P
 * precomp[2] = 5P
 * precomp[3] = 7P
 * precomp[4] = 9P
 * ...
 */
static void precomp_wnaf(pt_prj_t precomp[DRADIX / 2], const pt_aff_t *P) {
    int i;

    fe_copy(precomp[0].X, P->X);
    fe_copy(precomp[0].Y, P->Y);
    fe_copy(precomp[0].Z, const_one);
    point_double(&precomp[DRADIX / 2 - 1], &precomp[0]);

    for (i = 1; i < DRADIX / 2; i++)
        point_add_proj(&precomp[i], &precomp[DRADIX / 2 - 1], &precomp[i - 1]);
}

/* fetch a scalar bit */
static int scalar_get_bit(const unsigned char in[32], int idx) {
    int widx, rshift;

    widx = idx >> 3;
    rshift = idx & 0x7;

    if (idx < 0 || widx >= 32) return 0;

    return (in[widx] >> rshift) & 0x1;
}

/*-
 * Compute "regular" wnaf representation of a scalar.
 * See "Exponent Recoding and Regular Exponentiation Algorithms",
 * Tunstall et al., AfricaCrypt 2009, Alg 6.
 * It forces an odd scalar and outputs digits in
 * {\pm 1, \pm 3, \pm 5, \pm 7, \pm 9, ...}
 * i.e. signed odd digits with _no zeroes_ -- that makes it "regular".
 */
static void scalar_rwnaf(int8_t out[52], const unsigned char in[32]) {
    int i;
    int8_t window, d;

    window = (in[0] & (DRADIX_WNAF - 1)) | 1;
    for (i = 0; i < 51; i++) {
        d = (window & (DRADIX_WNAF - 1)) - DRADIX;
        out[i] = d;
        window = (window - d) >> RADIX;
        window += scalar_get_bit(in, (i + 1) * RADIX + 1) << 1;
        window += scalar_get_bit(in, (i + 1) * RADIX + 2) << 2;
        window += scalar_get_bit(in, (i + 1) * RADIX + 3) << 3;
        window += scalar_get_bit(in, (i + 1) * RADIX + 4) << 4;
        window += scalar_get_bit(in, (i + 1) * RADIX + 5) << 5;
    }
    out[i] = window;
}

/*-
 * Compute "textbook" wnaf representation of a scalar.
 * NB: not constant time
 */
static void scalar_wnaf(int8_t out[257], const unsigned char in[32]) {
    int i;
    int8_t window, d;

    window = in[0] & (DRADIX_WNAF - 1);
    for (i = 0; i < 257; i++) {
        d = 0;
        if ((window & 1) && ((d = window & (DRADIX_WNAF - 1)) & DRADIX))
            d -= DRADIX_WNAF;
        out[i] = d;
        window = (window - d) >> 1;
        window += scalar_get_bit(in, i + 1 + RADIX) << RADIX;
    }
}

/*-
 * Simultaneous scalar multiplication: interleaved "textbook" wnaf.
 * NB: not constant time
 */
static void var_smul_wnaf_two(pt_aff_t *out, const unsigned char a[32],
                              const unsigned char b[32], const pt_aff_t *P) {
    int i, d, is_neg, is_inf = 1, flipped = 0;
    int8_t anaf[257] = {0};
    int8_t bnaf[257] = {0};
    pt_prj_t Q = {0};
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_wnaf(anaf, a);
    scalar_wnaf(bnaf, b);

    for (i = 256; i >= 0; i--) {
        if (!is_inf) point_double(&Q, &Q);
        if ((d = bnaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_id_GostR3410_2001_TestParamSet_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &precomp[d].X);
                fe_copy(Q.Y, &precomp[d].Y);
                fe_copy(Q.Z, &precomp[d].Z);
                is_inf = 0;
            } else
                point_add_proj(&Q, &Q, &precomp[d]);
        }
        if ((d = anaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_id_GostR3410_2001_TestParamSet_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &lut_cmb[0][d].X);
                fe_copy(Q.Y, &lut_cmb[0][d].Y);
                fe_copy(Q.Z, const_one);
                is_inf = 0;
            } else
                point_add_mixed(&Q, &Q, &lut_cmb[0][d]);
        }
    }

    if (is_inf) {
        /* initialize accumulator to inf: all-zero scalars */
        fe_set_zero(Q.X);
        fe_copy(Q.Y, const_one);
        fe_set_zero(Q.Z);
    }

    if (flipped) {
        /* correct sign */
        fiat_id_GostR3410_2001_TestParamSet_opp(Q.Y, Q.Y);
    }

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_GostR3410_2001_TestParamSet_inv(Q.Z, Q.Z);
    fiat_id_GostR3410_2001_TestParamSet_mul(out->X, Q.X, Q.Z);
    fiat_id_GostR3410_2001_TestParamSet_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Variable point scalar multiplication with "regular" wnaf.
 */
static void var_smul_rwnaf(pt_aff_t *out, const unsigned char scalar[32],
                           const pt_aff_t *P) {
    int i, j, d, diff, is_neg;
    int8_t rnaf[52] = {0};
    pt_prj_t Q = {0}, lut = {0};
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_rwnaf(rnaf, scalar);

#if defined(_MSC_VER)
    /* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    /* initialize accumulator to high digit */
    d = (rnaf[51] - 1) >> 1;
    for (j = 0; j < DRADIX / 2; j++) {
        diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
        fiat_id_GostR3410_2001_TestParamSet_selectznz(Q.X, diff, Q.X,
                                                      precomp[j].X);
        fiat_id_GostR3410_2001_TestParamSet_selectznz(Q.Y, diff, Q.Y,
                                                      precomp[j].Y);
        fiat_id_GostR3410_2001_TestParamSet_selectznz(Q.Z, diff, Q.Z,
                                                      precomp[j].Z);
    }

    for (i = 50; i >= 0; i--) {
        for (j = 0; j < RADIX; j++) point_double(&Q, &Q);
        d = rnaf[i];
        /* is_neg = (d < 0) ? 1 : 0 */
        is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
        /* d = abs(d) */
        d = (d ^ -is_neg) + is_neg;
        d = (d - 1) >> 1;
        for (j = 0; j < DRADIX / 2; j++) {
            diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
            fiat_id_GostR3410_2001_TestParamSet_selectznz(lut.X, diff, lut.X,
                                                          precomp[j].X);
            fiat_id_GostR3410_2001_TestParamSet_selectznz(lut.Y, diff, lut.Y,
                                                          precomp[j].Y);
            fiat_id_GostR3410_2001_TestParamSet_selectznz(lut.Z, diff, lut.Z,
                                                          precomp[j].Z);
        }
        /* negate lut point if digit is negative */
        fiat_id_GostR3410_2001_TestParamSet_opp(out->Y, lut.Y);
        fiat_id_GostR3410_2001_TestParamSet_selectznz(lut.Y, is_neg, lut.Y,
                                                      out->Y);
        point_add_proj(&Q, &Q, &lut);
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, precomp[0].X);
    fiat_id_GostR3410_2001_TestParamSet_opp(lut.Y, precomp[0].Y);
    fe_copy(lut.Z, precomp[0].Z);
    point_add_proj(&lut, &lut, &Q);
    fiat_id_GostR3410_2001_TestParamSet_selectznz(Q.X, scalar[0] & 1, lut.X,
                                                  Q.X);
    fiat_id_GostR3410_2001_TestParamSet_selectznz(Q.Y, scalar[0] & 1, lut.Y,
                                                  Q.Y);
    fiat_id_GostR3410_2001_TestParamSet_selectznz(Q.Z, scalar[0] & 1, lut.Z,
                                                  Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_GostR3410_2001_TestParamSet_inv(Q.Z, Q.Z);
    fiat_id_GostR3410_2001_TestParamSet_mul(out->X, Q.X, Q.Z);
    fiat_id_GostR3410_2001_TestParamSet_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Fixed scalar multiplication: comb with interleaving.
 */
static void fixed_smul_cmb(pt_aff_t *out, const unsigned char scalar[32]) {
    int i, j, k, d, diff, is_neg = 0;
    int8_t rnaf[52] = {0};
    pt_prj_t Q = {0}, R = {0};
    pt_aff_t lut = {0};

    scalar_rwnaf(rnaf, scalar);

    /* initalize accumulator to inf */
    fe_set_zero(Q.X);
    fe_copy(Q.Y, const_one);
    fe_set_zero(Q.Z);

#if defined(_MSC_VER)
    /* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    for (i = 1; i >= 0; i--) {
        for (j = 0; i != 1 && j < RADIX; j++) point_double(&Q, &Q);
        for (j = 0; j < 27; j++) {
            if (j * 2 + i > 51) continue;
            d = rnaf[j * 2 + i];
            /* is_neg = (d < 0) ? 1 : 0 */
            is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
            /* d = abs(d) */
            d = (d ^ -is_neg) + is_neg;
            d = (d - 1) >> 1;
            for (k = 0; k < DRADIX / 2; k++) {
                diff = (1 - (-(d ^ k) >> (8 * sizeof(int) - 1))) & 1;
                fiat_id_GostR3410_2001_TestParamSet_selectznz(
                    lut.X, diff, lut.X, lut_cmb[j][k].X);
                fiat_id_GostR3410_2001_TestParamSet_selectznz(
                    lut.Y, diff, lut.Y, lut_cmb[j][k].Y);
            }
            /* negate lut point if digit is negative */
            fiat_id_GostR3410_2001_TestParamSet_opp(out->Y, lut.Y);
            fiat_id_GostR3410_2001_TestParamSet_selectznz(lut.Y, is_neg, lut.Y,
                                                          out->Y);
            point_add_mixed(&Q, &Q, &lut);
        }
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, lut_cmb[0][0].X);
    fiat_id_GostR3410_2001_TestParamSet_opp(lut.Y, lut_cmb[0][0].Y);
    point_add_mixed(&R, &Q, &lut);
    fiat_id_GostR3410_2001_TestParamSet_selectznz(Q.X, scalar[0] & 1, R.X, Q.X);
    fiat_id_GostR3410_2001_TestParamSet_selectznz(Q.Y, scalar[0] & 1, R.Y, Q.Y);
    fiat_id_GostR3410_2001_TestParamSet_selectznz(Q.Z, scalar[0] & 1, R.Z, Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_GostR3410_2001_TestParamSet_inv(Q.Z, Q.Z);
    fiat_id_GostR3410_2001_TestParamSet_mul(out->X, Q.X, Q.Z);
    fiat_id_GostR3410_2001_TestParamSet_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Wrapper: simultaneous scalar mutiplication.
 * outx, outy := a * G + b * P
 * where P = (inx, iny).
 * Everything is LE byte ordering.
 */
static void point_mul_two(unsigned char outx[32], unsigned char outy[32],
                          const unsigned char a[32], const unsigned char b[32],
                          const unsigned char inx[32],
                          const unsigned char iny[32]) {
    pt_aff_t P;

    fiat_id_GostR3410_2001_TestParamSet_from_bytes(P.X, inx);
    fiat_id_GostR3410_2001_TestParamSet_from_bytes(P.Y, iny);
    fiat_id_GostR3410_2001_TestParamSet_to_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_TestParamSet_to_montgomery(P.Y, P.Y);
    /* simultaneous scalar multiplication */
    var_smul_wnaf_two(&P, a, b, &P);

    fiat_id_GostR3410_2001_TestParamSet_from_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_TestParamSet_from_montgomery(P.Y, P.Y);
    fiat_id_GostR3410_2001_TestParamSet_to_bytes(outx, P.X);
    fiat_id_GostR3410_2001_TestParamSet_to_bytes(outy, P.Y);
}

/*-
 * Wrapper: fixed scalar mutiplication.
 * outx, outy := scalar * G
 * Everything is LE byte ordering.
 */
static void point_mul_g(unsigned char outx[32], unsigned char outy[32],
                        const unsigned char scalar[32]) {
    pt_aff_t P;

    /* fixed scmul function */
    fixed_smul_cmb(&P, scalar);
    fiat_id_GostR3410_2001_TestParamSet_from_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_TestParamSet_from_montgomery(P.Y, P.Y);
    fiat_id_GostR3410_2001_TestParamSet_to_bytes(outx, P.X);
    fiat_id_GostR3410_2001_TestParamSet_to_bytes(outy, P.Y);
}

/*-
 * Wrapper: variable point scalar mutiplication.
 * outx, outy := scalar * P
 * where P = (inx, iny).
 * Everything is LE byte ordering.
 */
static void point_mul(unsigned char outx[32], unsigned char outy[32],
                      const unsigned char scalar[32],
                      const unsigned char inx[32],
                      const unsigned char iny[32]) {
    pt_aff_t P;

    fiat_id_GostR3410_2001_TestParamSet_from_bytes(P.X, inx);
    fiat_id_GostR3410_2001_TestParamSet_from_bytes(P.Y, iny);
    fiat_id_GostR3410_2001_TestParamSet_to_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_TestParamSet_to_montgomery(P.Y, P.Y);
    /* var scmul function */
    var_smul_rwnaf(&P, scalar, &P);
    fiat_id_GostR3410_2001_TestParamSet_from_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_TestParamSet_from_montgomery(P.Y, P.Y);
    fiat_id_GostR3410_2001_TestParamSet_to_bytes(outx, P.X);
    fiat_id_GostR3410_2001_TestParamSet_to_bytes(outy, P.Y);
}


#include <openssl/ec.h>

/* the zero field element */
static const unsigned char const_zb[32] = {0};

/*-
 * An OpenSSL wrapper for simultaneous scalar multiplication.
 * r := n * G + m * q
 */
    int
    point_mul_two_id_GostR3410_2001_TestParamSet(const EC_GROUP *group,
                                                 EC_POINT *r, const BIGNUM *n,
                                                 const EC_POINT *q,
                                                 const BIGNUM *m, BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[32];
    unsigned char b_y[32];
    unsigned char b_n[32];
    unsigned char b_m[32];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL
        /* pull out coords as bytes */
        || !EC_POINT_get_affine_coordinates(group, q, x, y, ctx) ||
        BN_bn2lebinpad(x, b_x, 32) != 32 || BN_bn2lebinpad(y, b_y, 32) != 32 ||
        BN_bn2lebinpad(n, b_n, 32) != 32 || BN_bn2lebinpad(m, b_m, 32) != 32)
        goto err;
    /* do the simultaneous scalar multiplication */
    point_mul_two(b_x, b_y, b_n, b_m, b_x, b_y);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 32) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 32) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 32, x) == NULL ||
            BN_lebin2bn(b_y, 32, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}

/*-
 * An OpenSSL wrapper for variable point scalar multiplication.
 * r := m * q
 */
    int
    point_mul_id_GostR3410_2001_TestParamSet(const EC_GROUP *group, EC_POINT *r,
                                             const EC_POINT *q, const BIGNUM *m,
                                             BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[32];
    unsigned char b_y[32];
    unsigned char b_m[32];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL
        /* pull out coords as bytes */
        || !EC_POINT_get_affine_coordinates(group, q, x, y, ctx) ||
        BN_bn2lebinpad(x, b_x, 32) != 32 || BN_bn2lebinpad(y, b_y, 32) != 32 ||
        BN_bn2lebinpad(m, b_m, 32) != 32)
        goto err;
    /* do the variable scalar multiplication */
    point_mul(b_x, b_y, b_m, b_x, b_y);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 32) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 32) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 32, x) == NULL ||
            BN_lebin2bn(b_y, 32, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}

/*-
 * An OpenSSL wrapper for fixed scalar multiplication.
 * r := n * G
 */
    int
    point_mul_g_id_GostR3410_2001_TestParamSet(const EC_GROUP *group,
                                               EC_POINT *r, const BIGNUM *n,
                                               BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[32];
    unsigned char b_y[32];
    unsigned char b_n[32];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL || BN_bn2lebinpad(n, b_n, 32) != 32)
        goto err;
    /* do the fixed scalar multiplication */
    point_mul_g(b_x, b_y, b_n);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 32) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 32) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 32, x) == NULL ||
            BN_lebin2bn(b_y, 32, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}



#else /* __SIZEOF_INT128__ */

#include <stdint.h>
#include <string.h>
#define LIMB_BITS 32
#define LIMB_CNT 8
/* Field elements */
typedef uint32_t fe_t[LIMB_CNT];
typedef uint32_t limb_t;

#ifdef OPENSSL_NO_ASM
#define FIAT_ID_GOSTR3410_2001_TESTPARAMSET_NO_ASM
#endif

#define fe_copy(d, s) memcpy(d, s, sizeof(fe_t))
#define fe_set_zero(d) memset(d, 0, sizeof(fe_t))

/* Projective points */
typedef struct {
    fe_t X;
    fe_t Y;
    fe_t Z;
} pt_prj_t;

/* Affine points */
typedef struct {
    fe_t X;
    fe_t Y;
} pt_aff_t;

/* BEGIN verbatim fiat code https://github.com/mit-plv/fiat-crypto */
/*-
 * MIT License
 *
 * Copyright (c) 2020 the fiat-crypto authors (see the AUTHORS file)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* Autogenerated: word_by_word_montgomery --static --use-value-barrier id_GostR3410_2001_TestParamSet 32 '2^255 + 1073' */
/* curve description: id_GostR3410_2001_TestParamSet */
/* machine_wordsize = 32 (from "32") */
/* requested operations: (all) */
/* m = 0x8000000000000000000000000000000000000000000000000000000000000431 (from "2^255 + 1073") */
/*                                                                    */
/* NOTE: In addition to the bounds specified above each function, all */
/*   functions synthesized for this Montgomery arithmetic require the */
/*   input to be strictly less than the prime modulus (m), and also   */
/*   require the input to be in the unique saturated representation.  */
/*   All functions also ensure that these two properties are true of  */
/*   return values.                                                   */
/*  */
/* Computed values: */
/* eval z = z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) */
/* bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) */

#include <stdint.h>
typedef unsigned char fiat_id_GostR3410_2001_TestParamSet_uint1;
typedef signed char fiat_id_GostR3410_2001_TestParamSet_int1;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif

#if !defined(FIAT_ID_GOSTR3410_2001_TESTPARAMSET_NO_ASM) && \
    (defined(__GNUC__) || defined(__clang__))
static __inline__ uint32_t
fiat_id_GostR3410_2001_TestParamSet_value_barrier_u32(uint32_t a) {
    __asm__("" : "+r"(a) : /* no inputs */);
    return a;
}
#else
#define fiat_id_GostR3410_2001_TestParamSet_value_barrier_u32(x) (x)
#endif

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^32
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(
    uint32_t *out1, fiat_id_GostR3410_2001_TestParamSet_uint1 *out2,
    fiat_id_GostR3410_2001_TestParamSet_uint1 arg1, uint32_t arg2,
    uint32_t arg3) {
    uint64_t x1;
    uint32_t x2;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x3;
    x1 = ((arg1 + (uint64_t)arg2) + arg3);
    x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
    x3 = (fiat_id_GostR3410_2001_TestParamSet_uint1)(x1 >> 32);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^32
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(
    uint32_t *out1, fiat_id_GostR3410_2001_TestParamSet_uint1 *out2,
    fiat_id_GostR3410_2001_TestParamSet_uint1 arg1, uint32_t arg2,
    uint32_t arg3) {
    int64_t x1;
    fiat_id_GostR3410_2001_TestParamSet_int1 x2;
    uint32_t x3;
    x1 = ((arg2 - (int64_t)arg1) - arg3);
    x2 = (fiat_id_GostR3410_2001_TestParamSet_int1)(x1 >> 32);
    x3 = (uint32_t)(x1 & UINT32_C(0xffffffff));
    *out1 = x3;
    *out2 = (fiat_id_GostR3410_2001_TestParamSet_uint1)(0x0 - x2);
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_mulx_u32 is a multiplication, returning the full double-width result.
 * Postconditions:
 *   out1 = (arg1 * arg2) mod 2^32
 *   out2 = ⌊arg1 * arg2 / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffff]
 *   arg2: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0xffffffff]
 */
static void fiat_id_GostR3410_2001_TestParamSet_mulx_u32(uint32_t *out1,
                                                         uint32_t *out2,
                                                         uint32_t arg1,
                                                         uint32_t arg2) {
    uint64_t x1;
    uint32_t x2;
    uint32_t x3;
    x1 = ((uint64_t)arg1 * arg2);
    x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
    x3 = (uint32_t)(x1 >> 32);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static void fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(
    uint32_t *out1, fiat_id_GostR3410_2001_TestParamSet_uint1 arg1,
    uint32_t arg2, uint32_t arg3) {
    fiat_id_GostR3410_2001_TestParamSet_uint1 x1;
    uint32_t x2;
    uint32_t x3;
    x1 = (!(!arg1));
    x2 = ((fiat_id_GostR3410_2001_TestParamSet_int1)(0x0 - x1) &
          UINT32_C(0xffffffff));
    x3 =
        ((fiat_id_GostR3410_2001_TestParamSet_value_barrier_u32(x2) & arg3) |
         (fiat_id_GostR3410_2001_TestParamSet_value_barrier_u32((~x2)) & arg2));
    *out1 = x3;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_mul multiplies two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_mul(uint32_t out1[8],
                                                    const uint32_t arg1[8],
                                                    const uint32_t arg2[8]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint32_t x24;
    uint32_t x25;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x26;
    uint32_t x27;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x28;
    uint32_t x29;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x30;
    uint32_t x31;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x32;
    uint32_t x33;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x34;
    uint32_t x35;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x36;
    uint32_t x37;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    uint32_t x43;
    uint32_t x44;
    uint32_t x45;
    uint32_t x46;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x47;
    uint32_t x48;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x49;
    uint32_t x50;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x51;
    uint32_t x52;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x53;
    uint32_t x54;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x55;
    uint32_t x56;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x57;
    uint32_t x58;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x59;
    uint32_t x60;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x61;
    uint32_t x62;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x63;
    uint32_t x64;
    uint32_t x65;
    uint32_t x66;
    uint32_t x67;
    uint32_t x68;
    uint32_t x69;
    uint32_t x70;
    uint32_t x71;
    uint32_t x72;
    uint32_t x73;
    uint32_t x74;
    uint32_t x75;
    uint32_t x76;
    uint32_t x77;
    uint32_t x78;
    uint32_t x79;
    uint32_t x80;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x81;
    uint32_t x82;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x83;
    uint32_t x84;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x85;
    uint32_t x86;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x87;
    uint32_t x88;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x89;
    uint32_t x90;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x91;
    uint32_t x92;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x93;
    uint32_t x94;
    uint32_t x95;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x96;
    uint32_t x97;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x98;
    uint32_t x99;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x100;
    uint32_t x101;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x102;
    uint32_t x103;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x104;
    uint32_t x105;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x106;
    uint32_t x107;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x108;
    uint32_t x109;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x110;
    uint32_t x111;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x112;
    uint32_t x113;
    uint32_t x114;
    uint32_t x115;
    uint32_t x116;
    uint32_t x117;
    uint32_t x118;
    uint32_t x119;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x120;
    uint32_t x121;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x122;
    uint32_t x123;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x124;
    uint32_t x125;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x126;
    uint32_t x127;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x128;
    uint32_t x129;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x130;
    uint32_t x131;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x132;
    uint32_t x133;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x134;
    uint32_t x135;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x136;
    uint32_t x137;
    uint32_t x138;
    uint32_t x139;
    uint32_t x140;
    uint32_t x141;
    uint32_t x142;
    uint32_t x143;
    uint32_t x144;
    uint32_t x145;
    uint32_t x146;
    uint32_t x147;
    uint32_t x148;
    uint32_t x149;
    uint32_t x150;
    uint32_t x151;
    uint32_t x152;
    uint32_t x153;
    uint32_t x154;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x155;
    uint32_t x156;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x157;
    uint32_t x158;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x159;
    uint32_t x160;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x161;
    uint32_t x162;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x163;
    uint32_t x164;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x165;
    uint32_t x166;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x167;
    uint32_t x168;
    uint32_t x169;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x170;
    uint32_t x171;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x172;
    uint32_t x173;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x174;
    uint32_t x175;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x176;
    uint32_t x177;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x178;
    uint32_t x179;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x180;
    uint32_t x181;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x182;
    uint32_t x183;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x184;
    uint32_t x185;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x186;
    uint32_t x187;
    uint32_t x188;
    uint32_t x189;
    uint32_t x190;
    uint32_t x191;
    uint32_t x192;
    uint32_t x193;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x194;
    uint32_t x195;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x196;
    uint32_t x197;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x198;
    uint32_t x199;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x200;
    uint32_t x201;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x202;
    uint32_t x203;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x204;
    uint32_t x205;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x206;
    uint32_t x207;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x208;
    uint32_t x209;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x210;
    uint32_t x211;
    uint32_t x212;
    uint32_t x213;
    uint32_t x214;
    uint32_t x215;
    uint32_t x216;
    uint32_t x217;
    uint32_t x218;
    uint32_t x219;
    uint32_t x220;
    uint32_t x221;
    uint32_t x222;
    uint32_t x223;
    uint32_t x224;
    uint32_t x225;
    uint32_t x226;
    uint32_t x227;
    uint32_t x228;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x229;
    uint32_t x230;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x231;
    uint32_t x232;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x233;
    uint32_t x234;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x235;
    uint32_t x236;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x237;
    uint32_t x238;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x239;
    uint32_t x240;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x241;
    uint32_t x242;
    uint32_t x243;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x244;
    uint32_t x245;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x246;
    uint32_t x247;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x248;
    uint32_t x249;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x250;
    uint32_t x251;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x252;
    uint32_t x253;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x254;
    uint32_t x255;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x256;
    uint32_t x257;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x258;
    uint32_t x259;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x260;
    uint32_t x261;
    uint32_t x262;
    uint32_t x263;
    uint32_t x264;
    uint32_t x265;
    uint32_t x266;
    uint32_t x267;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x268;
    uint32_t x269;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x270;
    uint32_t x271;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x272;
    uint32_t x273;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x274;
    uint32_t x275;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x276;
    uint32_t x277;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x278;
    uint32_t x279;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x280;
    uint32_t x281;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x282;
    uint32_t x283;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x284;
    uint32_t x285;
    uint32_t x286;
    uint32_t x287;
    uint32_t x288;
    uint32_t x289;
    uint32_t x290;
    uint32_t x291;
    uint32_t x292;
    uint32_t x293;
    uint32_t x294;
    uint32_t x295;
    uint32_t x296;
    uint32_t x297;
    uint32_t x298;
    uint32_t x299;
    uint32_t x300;
    uint32_t x301;
    uint32_t x302;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x303;
    uint32_t x304;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x305;
    uint32_t x306;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x307;
    uint32_t x308;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x309;
    uint32_t x310;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x311;
    uint32_t x312;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x313;
    uint32_t x314;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x315;
    uint32_t x316;
    uint32_t x317;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x318;
    uint32_t x319;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x320;
    uint32_t x321;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x322;
    uint32_t x323;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x324;
    uint32_t x325;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x326;
    uint32_t x327;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x328;
    uint32_t x329;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x330;
    uint32_t x331;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x332;
    uint32_t x333;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x334;
    uint32_t x335;
    uint32_t x336;
    uint32_t x337;
    uint32_t x338;
    uint32_t x339;
    uint32_t x340;
    uint32_t x341;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x342;
    uint32_t x343;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x344;
    uint32_t x345;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x346;
    uint32_t x347;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x348;
    uint32_t x349;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x350;
    uint32_t x351;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x352;
    uint32_t x353;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x354;
    uint32_t x355;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x356;
    uint32_t x357;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x358;
    uint32_t x359;
    uint32_t x360;
    uint32_t x361;
    uint32_t x362;
    uint32_t x363;
    uint32_t x364;
    uint32_t x365;
    uint32_t x366;
    uint32_t x367;
    uint32_t x368;
    uint32_t x369;
    uint32_t x370;
    uint32_t x371;
    uint32_t x372;
    uint32_t x373;
    uint32_t x374;
    uint32_t x375;
    uint32_t x376;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x377;
    uint32_t x378;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x379;
    uint32_t x380;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x381;
    uint32_t x382;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x383;
    uint32_t x384;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x385;
    uint32_t x386;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x387;
    uint32_t x388;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x389;
    uint32_t x390;
    uint32_t x391;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x392;
    uint32_t x393;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x394;
    uint32_t x395;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x396;
    uint32_t x397;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x398;
    uint32_t x399;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x400;
    uint32_t x401;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x402;
    uint32_t x403;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x404;
    uint32_t x405;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x406;
    uint32_t x407;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x408;
    uint32_t x409;
    uint32_t x410;
    uint32_t x411;
    uint32_t x412;
    uint32_t x413;
    uint32_t x414;
    uint32_t x415;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x416;
    uint32_t x417;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x418;
    uint32_t x419;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x420;
    uint32_t x421;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x422;
    uint32_t x423;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x424;
    uint32_t x425;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x426;
    uint32_t x427;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x428;
    uint32_t x429;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x430;
    uint32_t x431;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x432;
    uint32_t x433;
    uint32_t x434;
    uint32_t x435;
    uint32_t x436;
    uint32_t x437;
    uint32_t x438;
    uint32_t x439;
    uint32_t x440;
    uint32_t x441;
    uint32_t x442;
    uint32_t x443;
    uint32_t x444;
    uint32_t x445;
    uint32_t x446;
    uint32_t x447;
    uint32_t x448;
    uint32_t x449;
    uint32_t x450;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x451;
    uint32_t x452;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x453;
    uint32_t x454;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x455;
    uint32_t x456;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x457;
    uint32_t x458;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x459;
    uint32_t x460;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x461;
    uint32_t x462;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x463;
    uint32_t x464;
    uint32_t x465;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x466;
    uint32_t x467;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x468;
    uint32_t x469;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x470;
    uint32_t x471;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x472;
    uint32_t x473;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x474;
    uint32_t x475;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x476;
    uint32_t x477;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x478;
    uint32_t x479;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x480;
    uint32_t x481;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x482;
    uint32_t x483;
    uint32_t x484;
    uint32_t x485;
    uint32_t x486;
    uint32_t x487;
    uint32_t x488;
    uint32_t x489;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x490;
    uint32_t x491;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x492;
    uint32_t x493;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x494;
    uint32_t x495;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x496;
    uint32_t x497;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x498;
    uint32_t x499;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x500;
    uint32_t x501;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x502;
    uint32_t x503;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x504;
    uint32_t x505;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x506;
    uint32_t x507;
    uint32_t x508;
    uint32_t x509;
    uint32_t x510;
    uint32_t x511;
    uint32_t x512;
    uint32_t x513;
    uint32_t x514;
    uint32_t x515;
    uint32_t x516;
    uint32_t x517;
    uint32_t x518;
    uint32_t x519;
    uint32_t x520;
    uint32_t x521;
    uint32_t x522;
    uint32_t x523;
    uint32_t x524;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x525;
    uint32_t x526;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x527;
    uint32_t x528;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x529;
    uint32_t x530;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x531;
    uint32_t x532;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x533;
    uint32_t x534;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x535;
    uint32_t x536;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x537;
    uint32_t x538;
    uint32_t x539;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x540;
    uint32_t x541;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x542;
    uint32_t x543;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x544;
    uint32_t x545;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x546;
    uint32_t x547;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x548;
    uint32_t x549;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x550;
    uint32_t x551;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x552;
    uint32_t x553;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x554;
    uint32_t x555;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x556;
    uint32_t x557;
    uint32_t x558;
    uint32_t x559;
    uint32_t x560;
    uint32_t x561;
    uint32_t x562;
    uint32_t x563;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x564;
    uint32_t x565;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x566;
    uint32_t x567;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x568;
    uint32_t x569;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x570;
    uint32_t x571;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x572;
    uint32_t x573;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x574;
    uint32_t x575;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x576;
    uint32_t x577;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x578;
    uint32_t x579;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x580;
    uint32_t x581;
    uint32_t x582;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x583;
    uint32_t x584;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x585;
    uint32_t x586;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x587;
    uint32_t x588;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x589;
    uint32_t x590;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x591;
    uint32_t x592;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x593;
    uint32_t x594;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x595;
    uint32_t x596;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x597;
    uint32_t x598;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x599;
    uint32_t x600;
    uint32_t x601;
    uint32_t x602;
    uint32_t x603;
    uint32_t x604;
    uint32_t x605;
    uint32_t x606;
    uint32_t x607;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[4]);
    x5 = (arg1[5]);
    x6 = (arg1[6]);
    x7 = (arg1[7]);
    x8 = (arg1[0]);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x9, &x10, x8, (arg2[7]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x11, &x12, x8, (arg2[6]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x13, &x14, x8, (arg2[5]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x15, &x16, x8, (arg2[4]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x17, &x18, x8, (arg2[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x19, &x20, x8, (arg2[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x21, &x22, x8, (arg2[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x23, &x24, x8, (arg2[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x25, &x26, 0x0, x24,
                                                      x21);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x27, &x28, x26, x22,
                                                      x19);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x29, &x30, x28, x20,
                                                      x17);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x31, &x32, x30, x18,
                                                      x15);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x33, &x34, x32, x16,
                                                      x13);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x35, &x36, x34, x14,
                                                      x11);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x37, &x38, x36, x12, x9);
    x39 = (x38 + x10);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x40, &x41, x23,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x42, &x43, x40,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x44, &x45, x40,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x46, &x47, 0x0, x23,
                                                      x44);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x48, &x49, x47, x25,
                                                      x45);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x50, &x51, x49, x27,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x52, &x53, x51, x29,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x54, &x55, x53, x31,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x56, &x57, x55, x33,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x58, &x59, x57, x35,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x60, &x61, x59, x37,
                                                      x42);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x62, &x63, x61, x39,
                                                      x43);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x64, &x65, x1, (arg2[7]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x66, &x67, x1, (arg2[6]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x68, &x69, x1, (arg2[5]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x70, &x71, x1, (arg2[4]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x72, &x73, x1, (arg2[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x74, &x75, x1, (arg2[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x76, &x77, x1, (arg2[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x78, &x79, x1, (arg2[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x80, &x81, 0x0, x79,
                                                      x76);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x82, &x83, x81, x77,
                                                      x74);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x84, &x85, x83, x75,
                                                      x72);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x86, &x87, x85, x73,
                                                      x70);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x88, &x89, x87, x71,
                                                      x68);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x90, &x91, x89, x69,
                                                      x66);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x92, &x93, x91, x67,
                                                      x64);
    x94 = (x93 + x65);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x95, &x96, 0x0, x48,
                                                      x78);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x97, &x98, x96, x50,
                                                      x80);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x99, &x100, x98, x52,
                                                      x82);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x101, &x102, x100, x54,
                                                      x84);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x103, &x104, x102, x56,
                                                      x86);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x105, &x106, x104, x58,
                                                      x88);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x107, &x108, x106, x60,
                                                      x90);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x109, &x110, x108, x62,
                                                      x92);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x111, &x112, x110, x63,
                                                      x94);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x113, &x114, x95,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x115, &x116, x113,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x117, &x118, x113,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x119, &x120, 0x0, x95,
                                                      x117);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x121, &x122, x120, x97,
                                                      x118);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x123, &x124, x122, x99,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x125, &x126, x124, x101,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x127, &x128, x126, x103,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x129, &x130, x128, x105,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x131, &x132, x130, x107,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x133, &x134, x132, x109,
                                                      x115);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x135, &x136, x134, x111,
                                                      x116);
    x137 = ((uint32_t)x136 + x112);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x138, &x139, x2, (arg2[7]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x140, &x141, x2, (arg2[6]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x142, &x143, x2, (arg2[5]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x144, &x145, x2, (arg2[4]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x146, &x147, x2, (arg2[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x148, &x149, x2, (arg2[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x150, &x151, x2, (arg2[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x152, &x153, x2, (arg2[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x154, &x155, 0x0, x153,
                                                      x150);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x156, &x157, x155, x151,
                                                      x148);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x158, &x159, x157, x149,
                                                      x146);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x160, &x161, x159, x147,
                                                      x144);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x162, &x163, x161, x145,
                                                      x142);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x164, &x165, x163, x143,
                                                      x140);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x166, &x167, x165, x141,
                                                      x138);
    x168 = (x167 + x139);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x169, &x170, 0x0, x121,
                                                      x152);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x171, &x172, x170, x123,
                                                      x154);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x173, &x174, x172, x125,
                                                      x156);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x175, &x176, x174, x127,
                                                      x158);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x177, &x178, x176, x129,
                                                      x160);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x179, &x180, x178, x131,
                                                      x162);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x181, &x182, x180, x133,
                                                      x164);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x183, &x184, x182, x135,
                                                      x166);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x185, &x186, x184, x137,
                                                      x168);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x187, &x188, x169,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x189, &x190, x187,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x191, &x192, x187,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x193, &x194, 0x0, x169,
                                                      x191);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x195, &x196, x194, x171,
                                                      x192);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x197, &x198, x196, x173,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x199, &x200, x198, x175,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x201, &x202, x200, x177,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x203, &x204, x202, x179,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x205, &x206, x204, x181,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x207, &x208, x206, x183,
                                                      x189);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x209, &x210, x208, x185,
                                                      x190);
    x211 = ((uint32_t)x210 + x186);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x212, &x213, x3, (arg2[7]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x214, &x215, x3, (arg2[6]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x216, &x217, x3, (arg2[5]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x218, &x219, x3, (arg2[4]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x220, &x221, x3, (arg2[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x222, &x223, x3, (arg2[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x224, &x225, x3, (arg2[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x226, &x227, x3, (arg2[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x228, &x229, 0x0, x227,
                                                      x224);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x230, &x231, x229, x225,
                                                      x222);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x232, &x233, x231, x223,
                                                      x220);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x234, &x235, x233, x221,
                                                      x218);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x236, &x237, x235, x219,
                                                      x216);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x238, &x239, x237, x217,
                                                      x214);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x240, &x241, x239, x215,
                                                      x212);
    x242 = (x241 + x213);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x243, &x244, 0x0, x195,
                                                      x226);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x245, &x246, x244, x197,
                                                      x228);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x247, &x248, x246, x199,
                                                      x230);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x249, &x250, x248, x201,
                                                      x232);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x251, &x252, x250, x203,
                                                      x234);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x253, &x254, x252, x205,
                                                      x236);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x255, &x256, x254, x207,
                                                      x238);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x257, &x258, x256, x209,
                                                      x240);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x259, &x260, x258, x211,
                                                      x242);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x261, &x262, x243,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x263, &x264, x261,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x265, &x266, x261,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x267, &x268, 0x0, x243,
                                                      x265);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x269, &x270, x268, x245,
                                                      x266);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x271, &x272, x270, x247,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x273, &x274, x272, x249,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x275, &x276, x274, x251,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x277, &x278, x276, x253,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x279, &x280, x278, x255,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x281, &x282, x280, x257,
                                                      x263);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x283, &x284, x282, x259,
                                                      x264);
    x285 = ((uint32_t)x284 + x260);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x286, &x287, x4, (arg2[7]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x288, &x289, x4, (arg2[6]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x290, &x291, x4, (arg2[5]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x292, &x293, x4, (arg2[4]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x294, &x295, x4, (arg2[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x296, &x297, x4, (arg2[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x298, &x299, x4, (arg2[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x300, &x301, x4, (arg2[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x302, &x303, 0x0, x301,
                                                      x298);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x304, &x305, x303, x299,
                                                      x296);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x306, &x307, x305, x297,
                                                      x294);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x308, &x309, x307, x295,
                                                      x292);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x310, &x311, x309, x293,
                                                      x290);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x312, &x313, x311, x291,
                                                      x288);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x314, &x315, x313, x289,
                                                      x286);
    x316 = (x315 + x287);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x317, &x318, 0x0, x269,
                                                      x300);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x319, &x320, x318, x271,
                                                      x302);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x321, &x322, x320, x273,
                                                      x304);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x323, &x324, x322, x275,
                                                      x306);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x325, &x326, x324, x277,
                                                      x308);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x327, &x328, x326, x279,
                                                      x310);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x329, &x330, x328, x281,
                                                      x312);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x331, &x332, x330, x283,
                                                      x314);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x333, &x334, x332, x285,
                                                      x316);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x335, &x336, x317,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x337, &x338, x335,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x339, &x340, x335,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x341, &x342, 0x0, x317,
                                                      x339);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x343, &x344, x342, x319,
                                                      x340);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x345, &x346, x344, x321,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x347, &x348, x346, x323,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x349, &x350, x348, x325,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x351, &x352, x350, x327,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x353, &x354, x352, x329,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x355, &x356, x354, x331,
                                                      x337);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x357, &x358, x356, x333,
                                                      x338);
    x359 = ((uint32_t)x358 + x334);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x360, &x361, x5, (arg2[7]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x362, &x363, x5, (arg2[6]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x364, &x365, x5, (arg2[5]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x366, &x367, x5, (arg2[4]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x368, &x369, x5, (arg2[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x370, &x371, x5, (arg2[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x372, &x373, x5, (arg2[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x374, &x375, x5, (arg2[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x376, &x377, 0x0, x375,
                                                      x372);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x378, &x379, x377, x373,
                                                      x370);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x380, &x381, x379, x371,
                                                      x368);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x382, &x383, x381, x369,
                                                      x366);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x384, &x385, x383, x367,
                                                      x364);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x386, &x387, x385, x365,
                                                      x362);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x388, &x389, x387, x363,
                                                      x360);
    x390 = (x389 + x361);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x391, &x392, 0x0, x343,
                                                      x374);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x393, &x394, x392, x345,
                                                      x376);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x395, &x396, x394, x347,
                                                      x378);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x397, &x398, x396, x349,
                                                      x380);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x399, &x400, x398, x351,
                                                      x382);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x401, &x402, x400, x353,
                                                      x384);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x403, &x404, x402, x355,
                                                      x386);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x405, &x406, x404, x357,
                                                      x388);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x407, &x408, x406, x359,
                                                      x390);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x409, &x410, x391,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x411, &x412, x409,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x413, &x414, x409,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x415, &x416, 0x0, x391,
                                                      x413);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x417, &x418, x416, x393,
                                                      x414);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x419, &x420, x418, x395,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x421, &x422, x420, x397,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x423, &x424, x422, x399,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x425, &x426, x424, x401,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x427, &x428, x426, x403,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x429, &x430, x428, x405,
                                                      x411);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x431, &x432, x430, x407,
                                                      x412);
    x433 = ((uint32_t)x432 + x408);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x434, &x435, x6, (arg2[7]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x436, &x437, x6, (arg2[6]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x438, &x439, x6, (arg2[5]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x440, &x441, x6, (arg2[4]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x442, &x443, x6, (arg2[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x444, &x445, x6, (arg2[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x446, &x447, x6, (arg2[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x448, &x449, x6, (arg2[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x450, &x451, 0x0, x449,
                                                      x446);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x452, &x453, x451, x447,
                                                      x444);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x454, &x455, x453, x445,
                                                      x442);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x456, &x457, x455, x443,
                                                      x440);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x458, &x459, x457, x441,
                                                      x438);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x460, &x461, x459, x439,
                                                      x436);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x462, &x463, x461, x437,
                                                      x434);
    x464 = (x463 + x435);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x465, &x466, 0x0, x417,
                                                      x448);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x467, &x468, x466, x419,
                                                      x450);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x469, &x470, x468, x421,
                                                      x452);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x471, &x472, x470, x423,
                                                      x454);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x473, &x474, x472, x425,
                                                      x456);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x475, &x476, x474, x427,
                                                      x458);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x477, &x478, x476, x429,
                                                      x460);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x479, &x480, x478, x431,
                                                      x462);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x481, &x482, x480, x433,
                                                      x464);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x483, &x484, x465,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x485, &x486, x483,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x487, &x488, x483,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x489, &x490, 0x0, x465,
                                                      x487);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x491, &x492, x490, x467,
                                                      x488);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x493, &x494, x492, x469,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x495, &x496, x494, x471,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x497, &x498, x496, x473,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x499, &x500, x498, x475,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x501, &x502, x500, x477,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x503, &x504, x502, x479,
                                                      x485);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x505, &x506, x504, x481,
                                                      x486);
    x507 = ((uint32_t)x506 + x482);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x508, &x509, x7, (arg2[7]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x510, &x511, x7, (arg2[6]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x512, &x513, x7, (arg2[5]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x514, &x515, x7, (arg2[4]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x516, &x517, x7, (arg2[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x518, &x519, x7, (arg2[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x520, &x521, x7, (arg2[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x522, &x523, x7, (arg2[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x524, &x525, 0x0, x523,
                                                      x520);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x526, &x527, x525, x521,
                                                      x518);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x528, &x529, x527, x519,
                                                      x516);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x530, &x531, x529, x517,
                                                      x514);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x532, &x533, x531, x515,
                                                      x512);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x534, &x535, x533, x513,
                                                      x510);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x536, &x537, x535, x511,
                                                      x508);
    x538 = (x537 + x509);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x539, &x540, 0x0, x491,
                                                      x522);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x541, &x542, x540, x493,
                                                      x524);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x543, &x544, x542, x495,
                                                      x526);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x545, &x546, x544, x497,
                                                      x528);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x547, &x548, x546, x499,
                                                      x530);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x549, &x550, x548, x501,
                                                      x532);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x551, &x552, x550, x503,
                                                      x534);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x553, &x554, x552, x505,
                                                      x536);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x555, &x556, x554, x507,
                                                      x538);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x557, &x558, x539,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x559, &x560, x557,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x561, &x562, x557,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x563, &x564, 0x0, x539,
                                                      x561);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x565, &x566, x564, x541,
                                                      x562);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x567, &x568, x566, x543,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x569, &x570, x568, x545,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x571, &x572, x570, x547,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x573, &x574, x572, x549,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x575, &x576, x574, x551,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x577, &x578, x576, x553,
                                                      x559);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x579, &x580, x578, x555,
                                                      x560);
    x581 = ((uint32_t)x580 + x556);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x582, &x583, 0x0, x565,
                                                       UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x584, &x585, x583, x567,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x586, &x587, x585, x569,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x588, &x589, x587, x571,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x590, &x591, x589, x573,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x592, &x593, x591, x575,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x594, &x595, x593, x577,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x596, &x597, x595, x579,
                                                       UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x598, &x599, x597, x581,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x600, x599, x582, x565);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x601, x599, x584, x567);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x602, x599, x586, x569);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x603, x599, x588, x571);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x604, x599, x590, x573);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x605, x599, x592, x575);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x606, x599, x594, x577);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x607, x599, x596, x579);
    out1[0] = x600;
    out1[1] = x601;
    out1[2] = x602;
    out1[3] = x603;
    out1[4] = x604;
    out1[5] = x605;
    out1[6] = x606;
    out1[7] = x607;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_square squares a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_square(uint32_t out1[8],
                                                       const uint32_t arg1[8]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint32_t x24;
    uint32_t x25;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x26;
    uint32_t x27;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x28;
    uint32_t x29;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x30;
    uint32_t x31;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x32;
    uint32_t x33;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x34;
    uint32_t x35;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x36;
    uint32_t x37;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    uint32_t x43;
    uint32_t x44;
    uint32_t x45;
    uint32_t x46;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x47;
    uint32_t x48;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x49;
    uint32_t x50;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x51;
    uint32_t x52;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x53;
    uint32_t x54;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x55;
    uint32_t x56;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x57;
    uint32_t x58;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x59;
    uint32_t x60;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x61;
    uint32_t x62;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x63;
    uint32_t x64;
    uint32_t x65;
    uint32_t x66;
    uint32_t x67;
    uint32_t x68;
    uint32_t x69;
    uint32_t x70;
    uint32_t x71;
    uint32_t x72;
    uint32_t x73;
    uint32_t x74;
    uint32_t x75;
    uint32_t x76;
    uint32_t x77;
    uint32_t x78;
    uint32_t x79;
    uint32_t x80;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x81;
    uint32_t x82;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x83;
    uint32_t x84;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x85;
    uint32_t x86;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x87;
    uint32_t x88;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x89;
    uint32_t x90;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x91;
    uint32_t x92;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x93;
    uint32_t x94;
    uint32_t x95;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x96;
    uint32_t x97;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x98;
    uint32_t x99;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x100;
    uint32_t x101;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x102;
    uint32_t x103;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x104;
    uint32_t x105;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x106;
    uint32_t x107;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x108;
    uint32_t x109;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x110;
    uint32_t x111;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x112;
    uint32_t x113;
    uint32_t x114;
    uint32_t x115;
    uint32_t x116;
    uint32_t x117;
    uint32_t x118;
    uint32_t x119;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x120;
    uint32_t x121;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x122;
    uint32_t x123;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x124;
    uint32_t x125;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x126;
    uint32_t x127;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x128;
    uint32_t x129;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x130;
    uint32_t x131;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x132;
    uint32_t x133;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x134;
    uint32_t x135;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x136;
    uint32_t x137;
    uint32_t x138;
    uint32_t x139;
    uint32_t x140;
    uint32_t x141;
    uint32_t x142;
    uint32_t x143;
    uint32_t x144;
    uint32_t x145;
    uint32_t x146;
    uint32_t x147;
    uint32_t x148;
    uint32_t x149;
    uint32_t x150;
    uint32_t x151;
    uint32_t x152;
    uint32_t x153;
    uint32_t x154;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x155;
    uint32_t x156;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x157;
    uint32_t x158;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x159;
    uint32_t x160;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x161;
    uint32_t x162;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x163;
    uint32_t x164;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x165;
    uint32_t x166;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x167;
    uint32_t x168;
    uint32_t x169;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x170;
    uint32_t x171;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x172;
    uint32_t x173;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x174;
    uint32_t x175;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x176;
    uint32_t x177;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x178;
    uint32_t x179;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x180;
    uint32_t x181;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x182;
    uint32_t x183;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x184;
    uint32_t x185;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x186;
    uint32_t x187;
    uint32_t x188;
    uint32_t x189;
    uint32_t x190;
    uint32_t x191;
    uint32_t x192;
    uint32_t x193;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x194;
    uint32_t x195;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x196;
    uint32_t x197;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x198;
    uint32_t x199;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x200;
    uint32_t x201;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x202;
    uint32_t x203;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x204;
    uint32_t x205;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x206;
    uint32_t x207;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x208;
    uint32_t x209;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x210;
    uint32_t x211;
    uint32_t x212;
    uint32_t x213;
    uint32_t x214;
    uint32_t x215;
    uint32_t x216;
    uint32_t x217;
    uint32_t x218;
    uint32_t x219;
    uint32_t x220;
    uint32_t x221;
    uint32_t x222;
    uint32_t x223;
    uint32_t x224;
    uint32_t x225;
    uint32_t x226;
    uint32_t x227;
    uint32_t x228;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x229;
    uint32_t x230;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x231;
    uint32_t x232;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x233;
    uint32_t x234;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x235;
    uint32_t x236;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x237;
    uint32_t x238;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x239;
    uint32_t x240;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x241;
    uint32_t x242;
    uint32_t x243;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x244;
    uint32_t x245;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x246;
    uint32_t x247;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x248;
    uint32_t x249;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x250;
    uint32_t x251;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x252;
    uint32_t x253;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x254;
    uint32_t x255;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x256;
    uint32_t x257;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x258;
    uint32_t x259;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x260;
    uint32_t x261;
    uint32_t x262;
    uint32_t x263;
    uint32_t x264;
    uint32_t x265;
    uint32_t x266;
    uint32_t x267;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x268;
    uint32_t x269;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x270;
    uint32_t x271;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x272;
    uint32_t x273;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x274;
    uint32_t x275;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x276;
    uint32_t x277;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x278;
    uint32_t x279;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x280;
    uint32_t x281;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x282;
    uint32_t x283;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x284;
    uint32_t x285;
    uint32_t x286;
    uint32_t x287;
    uint32_t x288;
    uint32_t x289;
    uint32_t x290;
    uint32_t x291;
    uint32_t x292;
    uint32_t x293;
    uint32_t x294;
    uint32_t x295;
    uint32_t x296;
    uint32_t x297;
    uint32_t x298;
    uint32_t x299;
    uint32_t x300;
    uint32_t x301;
    uint32_t x302;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x303;
    uint32_t x304;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x305;
    uint32_t x306;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x307;
    uint32_t x308;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x309;
    uint32_t x310;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x311;
    uint32_t x312;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x313;
    uint32_t x314;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x315;
    uint32_t x316;
    uint32_t x317;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x318;
    uint32_t x319;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x320;
    uint32_t x321;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x322;
    uint32_t x323;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x324;
    uint32_t x325;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x326;
    uint32_t x327;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x328;
    uint32_t x329;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x330;
    uint32_t x331;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x332;
    uint32_t x333;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x334;
    uint32_t x335;
    uint32_t x336;
    uint32_t x337;
    uint32_t x338;
    uint32_t x339;
    uint32_t x340;
    uint32_t x341;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x342;
    uint32_t x343;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x344;
    uint32_t x345;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x346;
    uint32_t x347;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x348;
    uint32_t x349;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x350;
    uint32_t x351;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x352;
    uint32_t x353;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x354;
    uint32_t x355;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x356;
    uint32_t x357;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x358;
    uint32_t x359;
    uint32_t x360;
    uint32_t x361;
    uint32_t x362;
    uint32_t x363;
    uint32_t x364;
    uint32_t x365;
    uint32_t x366;
    uint32_t x367;
    uint32_t x368;
    uint32_t x369;
    uint32_t x370;
    uint32_t x371;
    uint32_t x372;
    uint32_t x373;
    uint32_t x374;
    uint32_t x375;
    uint32_t x376;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x377;
    uint32_t x378;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x379;
    uint32_t x380;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x381;
    uint32_t x382;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x383;
    uint32_t x384;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x385;
    uint32_t x386;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x387;
    uint32_t x388;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x389;
    uint32_t x390;
    uint32_t x391;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x392;
    uint32_t x393;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x394;
    uint32_t x395;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x396;
    uint32_t x397;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x398;
    uint32_t x399;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x400;
    uint32_t x401;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x402;
    uint32_t x403;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x404;
    uint32_t x405;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x406;
    uint32_t x407;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x408;
    uint32_t x409;
    uint32_t x410;
    uint32_t x411;
    uint32_t x412;
    uint32_t x413;
    uint32_t x414;
    uint32_t x415;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x416;
    uint32_t x417;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x418;
    uint32_t x419;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x420;
    uint32_t x421;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x422;
    uint32_t x423;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x424;
    uint32_t x425;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x426;
    uint32_t x427;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x428;
    uint32_t x429;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x430;
    uint32_t x431;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x432;
    uint32_t x433;
    uint32_t x434;
    uint32_t x435;
    uint32_t x436;
    uint32_t x437;
    uint32_t x438;
    uint32_t x439;
    uint32_t x440;
    uint32_t x441;
    uint32_t x442;
    uint32_t x443;
    uint32_t x444;
    uint32_t x445;
    uint32_t x446;
    uint32_t x447;
    uint32_t x448;
    uint32_t x449;
    uint32_t x450;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x451;
    uint32_t x452;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x453;
    uint32_t x454;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x455;
    uint32_t x456;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x457;
    uint32_t x458;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x459;
    uint32_t x460;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x461;
    uint32_t x462;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x463;
    uint32_t x464;
    uint32_t x465;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x466;
    uint32_t x467;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x468;
    uint32_t x469;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x470;
    uint32_t x471;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x472;
    uint32_t x473;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x474;
    uint32_t x475;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x476;
    uint32_t x477;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x478;
    uint32_t x479;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x480;
    uint32_t x481;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x482;
    uint32_t x483;
    uint32_t x484;
    uint32_t x485;
    uint32_t x486;
    uint32_t x487;
    uint32_t x488;
    uint32_t x489;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x490;
    uint32_t x491;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x492;
    uint32_t x493;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x494;
    uint32_t x495;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x496;
    uint32_t x497;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x498;
    uint32_t x499;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x500;
    uint32_t x501;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x502;
    uint32_t x503;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x504;
    uint32_t x505;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x506;
    uint32_t x507;
    uint32_t x508;
    uint32_t x509;
    uint32_t x510;
    uint32_t x511;
    uint32_t x512;
    uint32_t x513;
    uint32_t x514;
    uint32_t x515;
    uint32_t x516;
    uint32_t x517;
    uint32_t x518;
    uint32_t x519;
    uint32_t x520;
    uint32_t x521;
    uint32_t x522;
    uint32_t x523;
    uint32_t x524;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x525;
    uint32_t x526;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x527;
    uint32_t x528;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x529;
    uint32_t x530;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x531;
    uint32_t x532;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x533;
    uint32_t x534;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x535;
    uint32_t x536;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x537;
    uint32_t x538;
    uint32_t x539;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x540;
    uint32_t x541;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x542;
    uint32_t x543;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x544;
    uint32_t x545;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x546;
    uint32_t x547;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x548;
    uint32_t x549;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x550;
    uint32_t x551;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x552;
    uint32_t x553;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x554;
    uint32_t x555;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x556;
    uint32_t x557;
    uint32_t x558;
    uint32_t x559;
    uint32_t x560;
    uint32_t x561;
    uint32_t x562;
    uint32_t x563;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x564;
    uint32_t x565;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x566;
    uint32_t x567;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x568;
    uint32_t x569;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x570;
    uint32_t x571;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x572;
    uint32_t x573;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x574;
    uint32_t x575;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x576;
    uint32_t x577;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x578;
    uint32_t x579;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x580;
    uint32_t x581;
    uint32_t x582;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x583;
    uint32_t x584;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x585;
    uint32_t x586;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x587;
    uint32_t x588;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x589;
    uint32_t x590;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x591;
    uint32_t x592;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x593;
    uint32_t x594;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x595;
    uint32_t x596;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x597;
    uint32_t x598;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x599;
    uint32_t x600;
    uint32_t x601;
    uint32_t x602;
    uint32_t x603;
    uint32_t x604;
    uint32_t x605;
    uint32_t x606;
    uint32_t x607;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[4]);
    x5 = (arg1[5]);
    x6 = (arg1[6]);
    x7 = (arg1[7]);
    x8 = (arg1[0]);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x9, &x10, x8, (arg1[7]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x11, &x12, x8, (arg1[6]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x13, &x14, x8, (arg1[5]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x15, &x16, x8, (arg1[4]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x17, &x18, x8, (arg1[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x19, &x20, x8, (arg1[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x21, &x22, x8, (arg1[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x23, &x24, x8, (arg1[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x25, &x26, 0x0, x24,
                                                      x21);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x27, &x28, x26, x22,
                                                      x19);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x29, &x30, x28, x20,
                                                      x17);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x31, &x32, x30, x18,
                                                      x15);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x33, &x34, x32, x16,
                                                      x13);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x35, &x36, x34, x14,
                                                      x11);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x37, &x38, x36, x12, x9);
    x39 = (x38 + x10);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x40, &x41, x23,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x42, &x43, x40,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x44, &x45, x40,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x46, &x47, 0x0, x23,
                                                      x44);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x48, &x49, x47, x25,
                                                      x45);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x50, &x51, x49, x27,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x52, &x53, x51, x29,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x54, &x55, x53, x31,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x56, &x57, x55, x33,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x58, &x59, x57, x35,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x60, &x61, x59, x37,
                                                      x42);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x62, &x63, x61, x39,
                                                      x43);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x64, &x65, x1, (arg1[7]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x66, &x67, x1, (arg1[6]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x68, &x69, x1, (arg1[5]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x70, &x71, x1, (arg1[4]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x72, &x73, x1, (arg1[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x74, &x75, x1, (arg1[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x76, &x77, x1, (arg1[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x78, &x79, x1, (arg1[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x80, &x81, 0x0, x79,
                                                      x76);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x82, &x83, x81, x77,
                                                      x74);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x84, &x85, x83, x75,
                                                      x72);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x86, &x87, x85, x73,
                                                      x70);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x88, &x89, x87, x71,
                                                      x68);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x90, &x91, x89, x69,
                                                      x66);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x92, &x93, x91, x67,
                                                      x64);
    x94 = (x93 + x65);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x95, &x96, 0x0, x48,
                                                      x78);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x97, &x98, x96, x50,
                                                      x80);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x99, &x100, x98, x52,
                                                      x82);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x101, &x102, x100, x54,
                                                      x84);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x103, &x104, x102, x56,
                                                      x86);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x105, &x106, x104, x58,
                                                      x88);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x107, &x108, x106, x60,
                                                      x90);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x109, &x110, x108, x62,
                                                      x92);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x111, &x112, x110, x63,
                                                      x94);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x113, &x114, x95,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x115, &x116, x113,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x117, &x118, x113,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x119, &x120, 0x0, x95,
                                                      x117);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x121, &x122, x120, x97,
                                                      x118);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x123, &x124, x122, x99,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x125, &x126, x124, x101,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x127, &x128, x126, x103,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x129, &x130, x128, x105,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x131, &x132, x130, x107,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x133, &x134, x132, x109,
                                                      x115);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x135, &x136, x134, x111,
                                                      x116);
    x137 = ((uint32_t)x136 + x112);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x138, &x139, x2, (arg1[7]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x140, &x141, x2, (arg1[6]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x142, &x143, x2, (arg1[5]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x144, &x145, x2, (arg1[4]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x146, &x147, x2, (arg1[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x148, &x149, x2, (arg1[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x150, &x151, x2, (arg1[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x152, &x153, x2, (arg1[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x154, &x155, 0x0, x153,
                                                      x150);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x156, &x157, x155, x151,
                                                      x148);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x158, &x159, x157, x149,
                                                      x146);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x160, &x161, x159, x147,
                                                      x144);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x162, &x163, x161, x145,
                                                      x142);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x164, &x165, x163, x143,
                                                      x140);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x166, &x167, x165, x141,
                                                      x138);
    x168 = (x167 + x139);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x169, &x170, 0x0, x121,
                                                      x152);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x171, &x172, x170, x123,
                                                      x154);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x173, &x174, x172, x125,
                                                      x156);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x175, &x176, x174, x127,
                                                      x158);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x177, &x178, x176, x129,
                                                      x160);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x179, &x180, x178, x131,
                                                      x162);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x181, &x182, x180, x133,
                                                      x164);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x183, &x184, x182, x135,
                                                      x166);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x185, &x186, x184, x137,
                                                      x168);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x187, &x188, x169,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x189, &x190, x187,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x191, &x192, x187,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x193, &x194, 0x0, x169,
                                                      x191);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x195, &x196, x194, x171,
                                                      x192);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x197, &x198, x196, x173,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x199, &x200, x198, x175,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x201, &x202, x200, x177,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x203, &x204, x202, x179,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x205, &x206, x204, x181,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x207, &x208, x206, x183,
                                                      x189);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x209, &x210, x208, x185,
                                                      x190);
    x211 = ((uint32_t)x210 + x186);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x212, &x213, x3, (arg1[7]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x214, &x215, x3, (arg1[6]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x216, &x217, x3, (arg1[5]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x218, &x219, x3, (arg1[4]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x220, &x221, x3, (arg1[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x222, &x223, x3, (arg1[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x224, &x225, x3, (arg1[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x226, &x227, x3, (arg1[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x228, &x229, 0x0, x227,
                                                      x224);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x230, &x231, x229, x225,
                                                      x222);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x232, &x233, x231, x223,
                                                      x220);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x234, &x235, x233, x221,
                                                      x218);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x236, &x237, x235, x219,
                                                      x216);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x238, &x239, x237, x217,
                                                      x214);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x240, &x241, x239, x215,
                                                      x212);
    x242 = (x241 + x213);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x243, &x244, 0x0, x195,
                                                      x226);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x245, &x246, x244, x197,
                                                      x228);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x247, &x248, x246, x199,
                                                      x230);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x249, &x250, x248, x201,
                                                      x232);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x251, &x252, x250, x203,
                                                      x234);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x253, &x254, x252, x205,
                                                      x236);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x255, &x256, x254, x207,
                                                      x238);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x257, &x258, x256, x209,
                                                      x240);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x259, &x260, x258, x211,
                                                      x242);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x261, &x262, x243,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x263, &x264, x261,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x265, &x266, x261,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x267, &x268, 0x0, x243,
                                                      x265);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x269, &x270, x268, x245,
                                                      x266);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x271, &x272, x270, x247,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x273, &x274, x272, x249,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x275, &x276, x274, x251,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x277, &x278, x276, x253,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x279, &x280, x278, x255,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x281, &x282, x280, x257,
                                                      x263);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x283, &x284, x282, x259,
                                                      x264);
    x285 = ((uint32_t)x284 + x260);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x286, &x287, x4, (arg1[7]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x288, &x289, x4, (arg1[6]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x290, &x291, x4, (arg1[5]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x292, &x293, x4, (arg1[4]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x294, &x295, x4, (arg1[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x296, &x297, x4, (arg1[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x298, &x299, x4, (arg1[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x300, &x301, x4, (arg1[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x302, &x303, 0x0, x301,
                                                      x298);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x304, &x305, x303, x299,
                                                      x296);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x306, &x307, x305, x297,
                                                      x294);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x308, &x309, x307, x295,
                                                      x292);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x310, &x311, x309, x293,
                                                      x290);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x312, &x313, x311, x291,
                                                      x288);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x314, &x315, x313, x289,
                                                      x286);
    x316 = (x315 + x287);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x317, &x318, 0x0, x269,
                                                      x300);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x319, &x320, x318, x271,
                                                      x302);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x321, &x322, x320, x273,
                                                      x304);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x323, &x324, x322, x275,
                                                      x306);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x325, &x326, x324, x277,
                                                      x308);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x327, &x328, x326, x279,
                                                      x310);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x329, &x330, x328, x281,
                                                      x312);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x331, &x332, x330, x283,
                                                      x314);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x333, &x334, x332, x285,
                                                      x316);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x335, &x336, x317,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x337, &x338, x335,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x339, &x340, x335,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x341, &x342, 0x0, x317,
                                                      x339);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x343, &x344, x342, x319,
                                                      x340);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x345, &x346, x344, x321,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x347, &x348, x346, x323,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x349, &x350, x348, x325,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x351, &x352, x350, x327,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x353, &x354, x352, x329,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x355, &x356, x354, x331,
                                                      x337);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x357, &x358, x356, x333,
                                                      x338);
    x359 = ((uint32_t)x358 + x334);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x360, &x361, x5, (arg1[7]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x362, &x363, x5, (arg1[6]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x364, &x365, x5, (arg1[5]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x366, &x367, x5, (arg1[4]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x368, &x369, x5, (arg1[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x370, &x371, x5, (arg1[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x372, &x373, x5, (arg1[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x374, &x375, x5, (arg1[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x376, &x377, 0x0, x375,
                                                      x372);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x378, &x379, x377, x373,
                                                      x370);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x380, &x381, x379, x371,
                                                      x368);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x382, &x383, x381, x369,
                                                      x366);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x384, &x385, x383, x367,
                                                      x364);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x386, &x387, x385, x365,
                                                      x362);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x388, &x389, x387, x363,
                                                      x360);
    x390 = (x389 + x361);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x391, &x392, 0x0, x343,
                                                      x374);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x393, &x394, x392, x345,
                                                      x376);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x395, &x396, x394, x347,
                                                      x378);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x397, &x398, x396, x349,
                                                      x380);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x399, &x400, x398, x351,
                                                      x382);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x401, &x402, x400, x353,
                                                      x384);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x403, &x404, x402, x355,
                                                      x386);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x405, &x406, x404, x357,
                                                      x388);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x407, &x408, x406, x359,
                                                      x390);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x409, &x410, x391,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x411, &x412, x409,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x413, &x414, x409,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x415, &x416, 0x0, x391,
                                                      x413);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x417, &x418, x416, x393,
                                                      x414);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x419, &x420, x418, x395,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x421, &x422, x420, x397,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x423, &x424, x422, x399,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x425, &x426, x424, x401,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x427, &x428, x426, x403,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x429, &x430, x428, x405,
                                                      x411);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x431, &x432, x430, x407,
                                                      x412);
    x433 = ((uint32_t)x432 + x408);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x434, &x435, x6, (arg1[7]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x436, &x437, x6, (arg1[6]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x438, &x439, x6, (arg1[5]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x440, &x441, x6, (arg1[4]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x442, &x443, x6, (arg1[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x444, &x445, x6, (arg1[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x446, &x447, x6, (arg1[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x448, &x449, x6, (arg1[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x450, &x451, 0x0, x449,
                                                      x446);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x452, &x453, x451, x447,
                                                      x444);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x454, &x455, x453, x445,
                                                      x442);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x456, &x457, x455, x443,
                                                      x440);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x458, &x459, x457, x441,
                                                      x438);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x460, &x461, x459, x439,
                                                      x436);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x462, &x463, x461, x437,
                                                      x434);
    x464 = (x463 + x435);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x465, &x466, 0x0, x417,
                                                      x448);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x467, &x468, x466, x419,
                                                      x450);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x469, &x470, x468, x421,
                                                      x452);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x471, &x472, x470, x423,
                                                      x454);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x473, &x474, x472, x425,
                                                      x456);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x475, &x476, x474, x427,
                                                      x458);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x477, &x478, x476, x429,
                                                      x460);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x479, &x480, x478, x431,
                                                      x462);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x481, &x482, x480, x433,
                                                      x464);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x483, &x484, x465,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x485, &x486, x483,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x487, &x488, x483,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x489, &x490, 0x0, x465,
                                                      x487);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x491, &x492, x490, x467,
                                                      x488);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x493, &x494, x492, x469,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x495, &x496, x494, x471,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x497, &x498, x496, x473,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x499, &x500, x498, x475,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x501, &x502, x500, x477,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x503, &x504, x502, x479,
                                                      x485);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x505, &x506, x504, x481,
                                                      x486);
    x507 = ((uint32_t)x506 + x482);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x508, &x509, x7, (arg1[7]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x510, &x511, x7, (arg1[6]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x512, &x513, x7, (arg1[5]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x514, &x515, x7, (arg1[4]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x516, &x517, x7, (arg1[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x518, &x519, x7, (arg1[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x520, &x521, x7, (arg1[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x522, &x523, x7, (arg1[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x524, &x525, 0x0, x523,
                                                      x520);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x526, &x527, x525, x521,
                                                      x518);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x528, &x529, x527, x519,
                                                      x516);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x530, &x531, x529, x517,
                                                      x514);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x532, &x533, x531, x515,
                                                      x512);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x534, &x535, x533, x513,
                                                      x510);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x536, &x537, x535, x511,
                                                      x508);
    x538 = (x537 + x509);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x539, &x540, 0x0, x491,
                                                      x522);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x541, &x542, x540, x493,
                                                      x524);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x543, &x544, x542, x495,
                                                      x526);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x545, &x546, x544, x497,
                                                      x528);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x547, &x548, x546, x499,
                                                      x530);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x549, &x550, x548, x501,
                                                      x532);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x551, &x552, x550, x503,
                                                      x534);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x553, &x554, x552, x505,
                                                      x536);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x555, &x556, x554, x507,
                                                      x538);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x557, &x558, x539,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x559, &x560, x557,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x561, &x562, x557,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x563, &x564, 0x0, x539,
                                                      x561);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x565, &x566, x564, x541,
                                                      x562);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x567, &x568, x566, x543,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x569, &x570, x568, x545,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x571, &x572, x570, x547,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x573, &x574, x572, x549,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x575, &x576, x574, x551,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x577, &x578, x576, x553,
                                                      x559);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x579, &x580, x578, x555,
                                                      x560);
    x581 = ((uint32_t)x580 + x556);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x582, &x583, 0x0, x565,
                                                       UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x584, &x585, x583, x567,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x586, &x587, x585, x569,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x588, &x589, x587, x571,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x590, &x591, x589, x573,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x592, &x593, x591, x575,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x594, &x595, x593, x577,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x596, &x597, x595, x579,
                                                       UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x598, &x599, x597, x581,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x600, x599, x582, x565);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x601, x599, x584, x567);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x602, x599, x586, x569);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x603, x599, x588, x571);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x604, x599, x590, x573);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x605, x599, x592, x575);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x606, x599, x594, x577);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x607, x599, x596, x579);
    out1[0] = x600;
    out1[1] = x601;
    out1[2] = x602;
    out1[3] = x603;
    out1[4] = x604;
    out1[5] = x605;
    out1[6] = x606;
    out1[7] = x607;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_add adds two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_add(uint32_t out1[8],
                                                    const uint32_t arg1[8],
                                                    const uint32_t arg2[8]) {
    uint32_t x1;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x2;
    uint32_t x3;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x4;
    uint32_t x5;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x6;
    uint32_t x7;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x8;
    uint32_t x9;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x10;
    uint32_t x11;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x12;
    uint32_t x13;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x14;
    uint32_t x15;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x16;
    uint32_t x17;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x18;
    uint32_t x19;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x20;
    uint32_t x21;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x22;
    uint32_t x23;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x24;
    uint32_t x25;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x26;
    uint32_t x27;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x28;
    uint32_t x29;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x30;
    uint32_t x31;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x32;
    uint32_t x33;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x34;
    uint32_t x35;
    uint32_t x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x1, &x2, 0x0, (arg1[0]),
                                                      (arg2[0]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x3, &x4, x2, (arg1[1]),
                                                      (arg2[1]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x5, &x6, x4, (arg1[2]),
                                                      (arg2[2]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x7, &x8, x6, (arg1[3]),
                                                      (arg2[3]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x9, &x10, x8, (arg1[4]),
                                                      (arg2[4]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x11, &x12, x10,
                                                      (arg1[5]), (arg2[5]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x13, &x14, x12,
                                                      (arg1[6]), (arg2[6]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x15, &x16, x14,
                                                      (arg1[7]), (arg2[7]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x17, &x18, 0x0, x1,
                                                       UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x19, &x20, x18, x3,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x21, &x22, x20, x5,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x23, &x24, x22, x7,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x25, &x26, x24, x9,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x27, &x28, x26, x11,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x29, &x30, x28, x13,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x31, &x32, x30, x15,
                                                       UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x33, &x34, x32, x16,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x35, x34, x17, x1);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x36, x34, x19, x3);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x37, x34, x21, x5);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x38, x34, x23, x7);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x39, x34, x25, x9);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x40, x34, x27, x11);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x41, x34, x29, x13);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x42, x34, x31, x15);
    out1[0] = x35;
    out1[1] = x36;
    out1[2] = x37;
    out1[3] = x38;
    out1[4] = x39;
    out1[5] = x40;
    out1[6] = x41;
    out1[7] = x42;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_sub subtracts two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_sub(uint32_t out1[8],
                                                    const uint32_t arg1[8],
                                                    const uint32_t arg2[8]) {
    uint32_t x1;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x2;
    uint32_t x3;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x4;
    uint32_t x5;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x6;
    uint32_t x7;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x8;
    uint32_t x9;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x10;
    uint32_t x11;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x12;
    uint32_t x13;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x14;
    uint32_t x15;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x16;
    uint32_t x17;
    uint32_t x18;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x19;
    uint32_t x20;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x21;
    uint32_t x22;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x23;
    uint32_t x24;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x25;
    uint32_t x26;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x27;
    uint32_t x28;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x29;
    uint32_t x30;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x31;
    uint32_t x32;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x33;
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x1, &x2, 0x0, (arg1[0]),
                                                       (arg2[0]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x3, &x4, x2, (arg1[1]),
                                                       (arg2[1]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x5, &x6, x4, (arg1[2]),
                                                       (arg2[2]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x7, &x8, x6, (arg1[3]),
                                                       (arg2[3]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x9, &x10, x8, (arg1[4]),
                                                       (arg2[4]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x11, &x12, x10,
                                                       (arg1[5]), (arg2[5]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x13, &x14, x12,
                                                       (arg1[6]), (arg2[6]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x15, &x16, x14,
                                                       (arg1[7]), (arg2[7]));
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x17, x16, 0x0,
                                                    UINT32_C(0xffffffff));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x18, &x19, 0x0, x1,
                                                      (x17 & UINT16_C(0x431)));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x20, &x21, x19, x3, 0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x22, &x23, x21, x5, 0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x24, &x25, x23, x7, 0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x26, &x27, x25, x9, 0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x28, &x29, x27, x11,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x30, &x31, x29, x13,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(
        &x32, &x33, x31, x15, (x17 & UINT32_C(0x80000000)));
    out1[0] = x18;
    out1[1] = x20;
    out1[2] = x22;
    out1[3] = x24;
    out1[4] = x26;
    out1[5] = x28;
    out1[6] = x30;
    out1[7] = x32;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_opp negates a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_opp(uint32_t out1[8],
                                                    const uint32_t arg1[8]) {
    uint32_t x1;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x2;
    uint32_t x3;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x4;
    uint32_t x5;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x6;
    uint32_t x7;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x8;
    uint32_t x9;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x10;
    uint32_t x11;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x12;
    uint32_t x13;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x14;
    uint32_t x15;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x16;
    uint32_t x17;
    uint32_t x18;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x19;
    uint32_t x20;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x21;
    uint32_t x22;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x23;
    uint32_t x24;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x25;
    uint32_t x26;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x27;
    uint32_t x28;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x29;
    uint32_t x30;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x31;
    uint32_t x32;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x33;
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x1, &x2, 0x0, 0x0,
                                                       (arg1[0]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x3, &x4, x2, 0x0,
                                                       (arg1[1]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x5, &x6, x4, 0x0,
                                                       (arg1[2]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x7, &x8, x6, 0x0,
                                                       (arg1[3]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x9, &x10, x8, 0x0,
                                                       (arg1[4]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x11, &x12, x10, 0x0,
                                                       (arg1[5]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x13, &x14, x12, 0x0,
                                                       (arg1[6]));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x15, &x16, x14, 0x0,
                                                       (arg1[7]));
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x17, x16, 0x0,
                                                    UINT32_C(0xffffffff));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x18, &x19, 0x0, x1,
                                                      (x17 & UINT16_C(0x431)));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x20, &x21, x19, x3, 0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x22, &x23, x21, x5, 0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x24, &x25, x23, x7, 0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x26, &x27, x25, x9, 0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x28, &x29, x27, x11,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x30, &x31, x29, x13,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(
        &x32, &x33, x31, x15, (x17 & UINT32_C(0x80000000)));
    out1[0] = x18;
    out1[1] = x20;
    out1[2] = x22;
    out1[3] = x24;
    out1[4] = x26;
    out1[5] = x28;
    out1[6] = x30;
    out1[7] = x32;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_from_montgomery translates a field element out of the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^8) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_from_montgomery(
    uint32_t out1[8], const uint32_t arg1[8]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x9;
    uint32_t x10;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x19;
    uint32_t x20;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x21;
    uint32_t x22;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x23;
    uint32_t x24;
    uint32_t x25;
    uint32_t x26;
    uint32_t x27;
    uint32_t x28;
    uint32_t x29;
    uint32_t x30;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x31;
    uint32_t x32;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x33;
    uint32_t x34;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x35;
    uint32_t x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x43;
    uint32_t x44;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x45;
    uint32_t x46;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x47;
    uint32_t x48;
    uint32_t x49;
    uint32_t x50;
    uint32_t x51;
    uint32_t x52;
    uint32_t x53;
    uint32_t x54;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x55;
    uint32_t x56;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x57;
    uint32_t x58;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x59;
    uint32_t x60;
    uint32_t x61;
    uint32_t x62;
    uint32_t x63;
    uint32_t x64;
    uint32_t x65;
    uint32_t x66;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x67;
    uint32_t x68;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x69;
    uint32_t x70;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x71;
    uint32_t x72;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x73;
    uint32_t x74;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x75;
    uint32_t x76;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x77;
    uint32_t x78;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x79;
    uint32_t x80;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x81;
    uint32_t x82;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x83;
    uint32_t x84;
    uint32_t x85;
    uint32_t x86;
    uint32_t x87;
    uint32_t x88;
    uint32_t x89;
    uint32_t x90;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x91;
    uint32_t x92;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x93;
    uint32_t x94;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x95;
    uint32_t x96;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x97;
    uint32_t x98;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x99;
    uint32_t x100;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x101;
    uint32_t x102;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x103;
    uint32_t x104;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x105;
    uint32_t x106;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x107;
    uint32_t x108;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x109;
    uint32_t x110;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x111;
    uint32_t x112;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x113;
    uint32_t x114;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x115;
    uint32_t x116;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x117;
    uint32_t x118;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x119;
    uint32_t x120;
    uint32_t x121;
    uint32_t x122;
    uint32_t x123;
    uint32_t x124;
    uint32_t x125;
    uint32_t x126;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x127;
    uint32_t x128;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x129;
    uint32_t x130;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x131;
    uint32_t x132;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x133;
    uint32_t x134;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x135;
    uint32_t x136;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x137;
    uint32_t x138;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x139;
    uint32_t x140;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x141;
    uint32_t x142;
    uint32_t x143;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x144;
    uint32_t x145;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x146;
    uint32_t x147;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x148;
    uint32_t x149;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x150;
    uint32_t x151;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x152;
    uint32_t x153;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x154;
    uint32_t x155;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x156;
    uint32_t x157;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x158;
    uint32_t x159;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x160;
    uint32_t x161;
    uint32_t x162;
    uint32_t x163;
    uint32_t x164;
    uint32_t x165;
    uint32_t x166;
    uint32_t x167;
    uint32_t x168;
    x1 = (arg1[0]);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x2, &x3, x1,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x4, &x5, x2,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x6, &x7, x2, UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x8, &x9, 0x0, x1, x6);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x10, &x11, 0x0,
                                                      (x9 + x7), (arg1[1]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x12, &x13, x10,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x14, &x15, x12,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x16, &x17, x12,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x18, &x19, 0x0, x5, x14);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x20, &x21, 0x0, x10,
                                                      x16);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(
        &x22, &x23, 0x0, (((uint32_t)x21 + x11) + x17), (arg1[2]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x24, &x25, x22,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x26, &x27, x24,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x28, &x29, x24,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x30, &x31, 0x0,
                                                      (x19 + x15), x26);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x32, &x33, 0x0, x22,
                                                      x28);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(
        &x34, &x35, 0x0, (((uint32_t)x33 + x23) + x29), (arg1[3]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x36, &x37, x34,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x38, &x39, x36,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x40, &x41, x36,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x42, &x43, 0x0,
                                                      (x31 + x27), x38);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x44, &x45, 0x0, x34,
                                                      x40);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(
        &x46, &x47, 0x0, (((uint32_t)x45 + x35) + x41), (arg1[4]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x48, &x49, x46,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x50, &x51, x48,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x52, &x53, x48,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x54, &x55, 0x0,
                                                      (x43 + x39), x50);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x56, &x57, 0x0, x46,
                                                      x52);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(
        &x58, &x59, 0x0, (((uint32_t)x57 + x47) + x53), (arg1[5]));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x60, &x61, x58,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x62, &x63, x60,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x64, &x65, x60,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x66, &x67, 0x0,
                                                      (x55 + x51), x62);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x68, &x69, 0x0, x58,
                                                      x64);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(
        &x70, &x71, 0x0, (((uint32_t)x69 + x59) + x65), (arg1[6]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x72, &x73, x71, x4, 0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x74, &x75, x73, x18,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x76, &x77, x75, x30,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x78, &x79, x77, x42,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x80, &x81, x79, x54,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x82, &x83, x81, x66,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x84, &x85, x70,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x86, &x87, x84,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x88, &x89, x84,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x90, &x91, 0x0, x70,
                                                      x88);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x92, &x93, x91, x72,
                                                      x89);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x94, &x95, x93, x74,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x96, &x97, x95, x76,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x98, &x99, x97, x78,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x100, &x101, x99, x80,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x102, &x103, x101, x82,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x104, &x105, x103,
                                                      (x83 + (x67 + x63)), x86);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x106, &x107, 0x0, x92,
                                                      (arg1[7]));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x108, &x109, x107, x94,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x110, &x111, x109, x96,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x112, &x113, x111, x98,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x114, &x115, x113, x100,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x116, &x117, x115, x102,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x118, &x119, x117, x104,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x120, &x121, x106,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x122, &x123, x120,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x124, &x125, x120,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x126, &x127, 0x0, x106,
                                                      x124);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x128, &x129, x127, x108,
                                                      x125);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x130, &x131, x129, x110,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x132, &x133, x131, x112,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x134, &x135, x133, x114,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x136, &x137, x135, x116,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x138, &x139, x137, x118,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(
        &x140, &x141, x139, (x119 + (x105 + x87)), x122);
    x142 = (x141 + x123);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x143, &x144, 0x0, x128,
                                                       UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x145, &x146, x144, x130,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x147, &x148, x146, x132,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x149, &x150, x148, x134,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x151, &x152, x150, x136,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x153, &x154, x152, x138,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x155, &x156, x154, x140,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x157, &x158, x156, x142,
                                                       UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x159, &x160, x158, 0x0,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x161, x160, x143, x128);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x162, x160, x145, x130);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x163, x160, x147, x132);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x164, x160, x149, x134);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x165, x160, x151, x136);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x166, x160, x153, x138);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x167, x160, x155, x140);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x168, x160, x157, x142);
    out1[0] = x161;
    out1[1] = x162;
    out1[2] = x163;
    out1[3] = x164;
    out1[4] = x165;
    out1[5] = x166;
    out1[6] = x167;
    out1[7] = x168;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_to_montgomery translates a field element into the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_to_montgomery(
    uint32_t out1[8], const uint32_t arg1[8]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x12;
    uint32_t x13;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x22;
    uint32_t x23;
    uint32_t x24;
    uint32_t x25;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x26;
    uint32_t x27;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x28;
    uint32_t x29;
    uint32_t x30;
    uint32_t x31;
    uint32_t x32;
    uint32_t x33;
    uint32_t x34;
    uint32_t x35;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x40;
    uint32_t x41;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x42;
    uint32_t x43;
    uint32_t x44;
    uint32_t x45;
    uint32_t x46;
    uint32_t x47;
    uint32_t x48;
    uint32_t x49;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x50;
    uint32_t x51;
    uint32_t x52;
    uint32_t x53;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x54;
    uint32_t x55;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x56;
    uint32_t x57;
    uint32_t x58;
    uint32_t x59;
    uint32_t x60;
    uint32_t x61;
    uint32_t x62;
    uint32_t x63;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x64;
    uint32_t x65;
    uint32_t x66;
    uint32_t x67;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x68;
    uint32_t x69;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x70;
    uint32_t x71;
    uint32_t x72;
    uint32_t x73;
    uint32_t x74;
    uint32_t x75;
    uint32_t x76;
    uint32_t x77;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x78;
    uint32_t x79;
    uint32_t x80;
    uint32_t x81;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x82;
    uint32_t x83;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x84;
    uint32_t x85;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x86;
    uint32_t x87;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x88;
    uint32_t x89;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x90;
    uint32_t x91;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x92;
    uint32_t x93;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x94;
    uint32_t x95;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x96;
    uint32_t x97;
    uint32_t x98;
    uint32_t x99;
    uint32_t x100;
    uint32_t x101;
    uint32_t x102;
    uint32_t x103;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x104;
    uint32_t x105;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x106;
    uint32_t x107;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x108;
    uint32_t x109;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x110;
    uint32_t x111;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x112;
    uint32_t x113;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x114;
    uint32_t x115;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x116;
    uint32_t x117;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x118;
    uint32_t x119;
    uint32_t x120;
    uint32_t x121;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x122;
    uint32_t x123;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x124;
    uint32_t x125;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x126;
    uint32_t x127;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x128;
    uint32_t x129;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x130;
    uint32_t x131;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x132;
    uint32_t x133;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x134;
    uint32_t x135;
    uint32_t x136;
    uint32_t x137;
    uint32_t x138;
    uint32_t x139;
    uint32_t x140;
    uint32_t x141;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x142;
    uint32_t x143;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x144;
    uint32_t x145;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x146;
    uint32_t x147;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x148;
    uint32_t x149;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x150;
    uint32_t x151;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x152;
    uint32_t x153;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x154;
    uint32_t x155;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x156;
    uint32_t x157;
    uint32_t x158;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x159;
    uint32_t x160;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x161;
    uint32_t x162;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x163;
    uint32_t x164;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x165;
    uint32_t x166;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x167;
    uint32_t x168;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x169;
    uint32_t x170;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x171;
    uint32_t x172;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x173;
    uint32_t x174;
    fiat_id_GostR3410_2001_TestParamSet_uint1 x175;
    uint32_t x176;
    uint32_t x177;
    uint32_t x178;
    uint32_t x179;
    uint32_t x180;
    uint32_t x181;
    uint32_t x182;
    uint32_t x183;
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x1, &x2, (arg1[0]),
                                                 UINT32_C(0x464584));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x3, &x4, x1,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x5, &x6, x3,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x7, &x8, x3, UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x9, &x10, (arg1[1]),
                                                 UINT32_C(0x464584));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x11, &x12, 0x0, x1, x7);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x13, &x14, 0x0,
                                                      ((x12 + x2) + x8), x9);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x15, &x16, x13,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x17, &x18, x15,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x19, &x20, x15,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x21, &x22, 0x0, x6, x17);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x23, &x24, (arg1[2]),
                                                 UINT32_C(0x464584));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x25, &x26, 0x0, x13,
                                                      x19);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(
        &x27, &x28, 0x0, ((x26 + (x14 + x10)) + x20), x23);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x29, &x30, x27,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x31, &x32, x29,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x33, &x34, x29,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x35, &x36, 0x0,
                                                      (x22 + x18), x31);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x37, &x38, (arg1[3]),
                                                 UINT32_C(0x464584));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x39, &x40, 0x0, x27,
                                                      x33);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(
        &x41, &x42, 0x0, ((x40 + (x28 + x24)) + x34), x37);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x43, &x44, x41,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x45, &x46, x43,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x47, &x48, x43,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x49, &x50, 0x0,
                                                      (x36 + x32), x45);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x51, &x52, (arg1[4]),
                                                 UINT32_C(0x464584));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x53, &x54, 0x0, x41,
                                                      x47);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(
        &x55, &x56, 0x0, ((x54 + (x42 + x38)) + x48), x51);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x57, &x58, x55,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x59, &x60, x57,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x61, &x62, x57,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x63, &x64, 0x0,
                                                      (x50 + x46), x59);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x65, &x66, (arg1[5]),
                                                 UINT32_C(0x464584));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x67, &x68, 0x0, x55,
                                                      x61);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(
        &x69, &x70, 0x0, ((x68 + (x56 + x52)) + x62), x65);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x71, &x72, x69,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x73, &x74, x71,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x75, &x76, x71,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x77, &x78, 0x0,
                                                      (x64 + x60), x73);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x79, &x80, (arg1[6]),
                                                 UINT32_C(0x464584));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x81, &x82, 0x0, x69,
                                                      x75);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(
        &x83, &x84, 0x0, ((x82 + (x70 + x66)) + x76), x79);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x85, &x86, x84, x5, x80);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x87, &x88, x86, x21,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x89, &x90, x88, x35,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x91, &x92, x90, x49,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x93, &x94, x92, x63,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x95, &x96, x94, x77,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x97, &x98, x83,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x99, &x100, x97,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x101, &x102, x97,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x103, &x104, 0x0, x83,
                                                      x101);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x105, &x106, x104, x85,
                                                      x102);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x107, &x108, x106, x87,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x109, &x110, x108, x89,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x111, &x112, x110, x91,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x113, &x114, x112, x93,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x115, &x116, x114, x95,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x117, &x118, x116,
                                                      (x96 + (x78 + x74)), x99);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x119, &x120, (arg1[7]),
                                                 UINT32_C(0x464584));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x121, &x122, 0x0, x105,
                                                      x119);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x123, &x124, x122, x107,
                                                      x120);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x125, &x126, x124, x109,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x127, &x128, x126, x111,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x129, &x130, x128, x113,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x131, &x132, x130, x115,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x133, &x134, x132, x117,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x135, &x136, x121,
                                                 UINT32_C(0x883b2b2f));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x137, &x138, x135,
                                                 UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_mulx_u32(&x139, &x140, x135,
                                                 UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x141, &x142, 0x0, x121,
                                                      x139);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x143, &x144, x142, x123,
                                                      x140);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x145, &x146, x144, x125,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x147, &x148, x146, x127,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x149, &x150, x148, x129,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x151, &x152, x150, x131,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(&x153, &x154, x152, x133,
                                                      0x0);
    fiat_id_GostR3410_2001_TestParamSet_addcarryx_u32(
        &x155, &x156, x154, (x134 + (x118 + x100)), x137);
    x157 = (x156 + x138);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x158, &x159, 0x0, x143,
                                                       UINT16_C(0x431));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x160, &x161, x159, x145,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x162, &x163, x161, x147,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x164, &x165, x163, x149,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x166, &x167, x165, x151,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x168, &x169, x167, x153,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x170, &x171, x169, x155,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x172, &x173, x171, x157,
                                                       UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_TestParamSet_subborrowx_u32(&x174, &x175, x173, 0x0,
                                                       0x0);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x176, x175, x158, x143);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x177, x175, x160, x145);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x178, x175, x162, x147);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x179, x175, x164, x149);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x180, x175, x166, x151);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x181, x175, x168, x153);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x182, x175, x170, x155);
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x183, x175, x172, x157);
    out1[0] = x176;
    out1[1] = x177;
    out1[2] = x178;
    out1[3] = x179;
    out1[4] = x180;
    out1[5] = x181;
    out1[6] = x182;
    out1[7] = x183;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static void fiat_id_GostR3410_2001_TestParamSet_nonzero(
    uint32_t *out1, const uint32_t arg1[8]) {
    uint32_t x1;
    x1 =
        ((arg1[0]) |
         ((arg1[1]) |
          ((arg1[2]) |
           ((arg1[3]) | ((arg1[4]) | ((arg1[5]) | ((arg1[6]) | (arg1[7]))))))));
    *out1 = x1;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_selectznz(
    uint32_t out1[8], fiat_id_GostR3410_2001_TestParamSet_uint1 arg1,
    const uint32_t arg2[8], const uint32_t arg3[8]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x1, arg1, (arg2[0]),
                                                    (arg3[0]));
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x2, arg1, (arg2[1]),
                                                    (arg3[1]));
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x3, arg1, (arg2[2]),
                                                    (arg3[2]));
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x4, arg1, (arg2[3]),
                                                    (arg3[3]));
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x5, arg1, (arg2[4]),
                                                    (arg3[4]));
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x6, arg1, (arg2[5]),
                                                    (arg3[5]));
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x7, arg1, (arg2[6]),
                                                    (arg3[6]));
    fiat_id_GostR3410_2001_TestParamSet_cmovznz_u32(&x8, arg1, (arg2[7]),
                                                    (arg3[7]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1[7] = x8;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_to_bytes(
    uint8_t out1[32], const uint32_t arg1[8]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint8_t x9;
    uint32_t x10;
    uint8_t x11;
    uint32_t x12;
    uint8_t x13;
    uint8_t x14;
    uint8_t x15;
    uint32_t x16;
    uint8_t x17;
    uint32_t x18;
    uint8_t x19;
    uint8_t x20;
    uint8_t x21;
    uint32_t x22;
    uint8_t x23;
    uint32_t x24;
    uint8_t x25;
    uint8_t x26;
    uint8_t x27;
    uint32_t x28;
    uint8_t x29;
    uint32_t x30;
    uint8_t x31;
    uint8_t x32;
    uint8_t x33;
    uint32_t x34;
    uint8_t x35;
    uint32_t x36;
    uint8_t x37;
    uint8_t x38;
    uint8_t x39;
    uint32_t x40;
    uint8_t x41;
    uint32_t x42;
    uint8_t x43;
    uint8_t x44;
    uint8_t x45;
    uint32_t x46;
    uint8_t x47;
    uint32_t x48;
    uint8_t x49;
    uint8_t x50;
    uint8_t x51;
    uint32_t x52;
    uint8_t x53;
    uint32_t x54;
    uint8_t x55;
    uint8_t x56;
    x1 = (arg1[7]);
    x2 = (arg1[6]);
    x3 = (arg1[5]);
    x4 = (arg1[4]);
    x5 = (arg1[3]);
    x6 = (arg1[2]);
    x7 = (arg1[1]);
    x8 = (arg1[0]);
    x9 = (uint8_t)(x8 & UINT8_C(0xff));
    x10 = (x8 >> 8);
    x11 = (uint8_t)(x10 & UINT8_C(0xff));
    x12 = (x10 >> 8);
    x13 = (uint8_t)(x12 & UINT8_C(0xff));
    x14 = (uint8_t)(x12 >> 8);
    x15 = (uint8_t)(x7 & UINT8_C(0xff));
    x16 = (x7 >> 8);
    x17 = (uint8_t)(x16 & UINT8_C(0xff));
    x18 = (x16 >> 8);
    x19 = (uint8_t)(x18 & UINT8_C(0xff));
    x20 = (uint8_t)(x18 >> 8);
    x21 = (uint8_t)(x6 & UINT8_C(0xff));
    x22 = (x6 >> 8);
    x23 = (uint8_t)(x22 & UINT8_C(0xff));
    x24 = (x22 >> 8);
    x25 = (uint8_t)(x24 & UINT8_C(0xff));
    x26 = (uint8_t)(x24 >> 8);
    x27 = (uint8_t)(x5 & UINT8_C(0xff));
    x28 = (x5 >> 8);
    x29 = (uint8_t)(x28 & UINT8_C(0xff));
    x30 = (x28 >> 8);
    x31 = (uint8_t)(x30 & UINT8_C(0xff));
    x32 = (uint8_t)(x30 >> 8);
    x33 = (uint8_t)(x4 & UINT8_C(0xff));
    x34 = (x4 >> 8);
    x35 = (uint8_t)(x34 & UINT8_C(0xff));
    x36 = (x34 >> 8);
    x37 = (uint8_t)(x36 & UINT8_C(0xff));
    x38 = (uint8_t)(x36 >> 8);
    x39 = (uint8_t)(x3 & UINT8_C(0xff));
    x40 = (x3 >> 8);
    x41 = (uint8_t)(x40 & UINT8_C(0xff));
    x42 = (x40 >> 8);
    x43 = (uint8_t)(x42 & UINT8_C(0xff));
    x44 = (uint8_t)(x42 >> 8);
    x45 = (uint8_t)(x2 & UINT8_C(0xff));
    x46 = (x2 >> 8);
    x47 = (uint8_t)(x46 & UINT8_C(0xff));
    x48 = (x46 >> 8);
    x49 = (uint8_t)(x48 & UINT8_C(0xff));
    x50 = (uint8_t)(x48 >> 8);
    x51 = (uint8_t)(x1 & UINT8_C(0xff));
    x52 = (x1 >> 8);
    x53 = (uint8_t)(x52 & UINT8_C(0xff));
    x54 = (x52 >> 8);
    x55 = (uint8_t)(x54 & UINT8_C(0xff));
    x56 = (uint8_t)(x54 >> 8);
    out1[0] = x9;
    out1[1] = x11;
    out1[2] = x13;
    out1[3] = x14;
    out1[4] = x15;
    out1[5] = x17;
    out1[6] = x19;
    out1[7] = x20;
    out1[8] = x21;
    out1[9] = x23;
    out1[10] = x25;
    out1[11] = x26;
    out1[12] = x27;
    out1[13] = x29;
    out1[14] = x31;
    out1[15] = x32;
    out1[16] = x33;
    out1[17] = x35;
    out1[18] = x37;
    out1[19] = x38;
    out1[20] = x39;
    out1[21] = x41;
    out1[22] = x43;
    out1[23] = x44;
    out1[24] = x45;
    out1[25] = x47;
    out1[26] = x49;
    out1[27] = x50;
    out1[28] = x51;
    out1[29] = x53;
    out1[30] = x55;
    out1[31] = x56;
}

/*
 * The function fiat_id_GostR3410_2001_TestParamSet_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
 * Preconditions:
 *   0 ≤ bytes_eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_TestParamSet_from_bytes(
    uint32_t out1[8], const uint8_t arg1[32]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint8_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint8_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint8_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint8_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint8_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint8_t x24;
    uint32_t x25;
    uint32_t x26;
    uint32_t x27;
    uint8_t x28;
    uint32_t x29;
    uint32_t x30;
    uint32_t x31;
    uint8_t x32;
    uint32_t x33;
    uint32_t x34;
    uint32_t x35;
    uint32_t x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    uint32_t x43;
    uint32_t x44;
    uint32_t x45;
    uint32_t x46;
    uint32_t x47;
    uint32_t x48;
    uint32_t x49;
    uint32_t x50;
    uint32_t x51;
    uint32_t x52;
    uint32_t x53;
    uint32_t x54;
    uint32_t x55;
    uint32_t x56;
    x1 = ((uint32_t)(arg1[31]) << 24);
    x2 = ((uint32_t)(arg1[30]) << 16);
    x3 = ((uint32_t)(arg1[29]) << 8);
    x4 = (arg1[28]);
    x5 = ((uint32_t)(arg1[27]) << 24);
    x6 = ((uint32_t)(arg1[26]) << 16);
    x7 = ((uint32_t)(arg1[25]) << 8);
    x8 = (arg1[24]);
    x9 = ((uint32_t)(arg1[23]) << 24);
    x10 = ((uint32_t)(arg1[22]) << 16);
    x11 = ((uint32_t)(arg1[21]) << 8);
    x12 = (arg1[20]);
    x13 = ((uint32_t)(arg1[19]) << 24);
    x14 = ((uint32_t)(arg1[18]) << 16);
    x15 = ((uint32_t)(arg1[17]) << 8);
    x16 = (arg1[16]);
    x17 = ((uint32_t)(arg1[15]) << 24);
    x18 = ((uint32_t)(arg1[14]) << 16);
    x19 = ((uint32_t)(arg1[13]) << 8);
    x20 = (arg1[12]);
    x21 = ((uint32_t)(arg1[11]) << 24);
    x22 = ((uint32_t)(arg1[10]) << 16);
    x23 = ((uint32_t)(arg1[9]) << 8);
    x24 = (arg1[8]);
    x25 = ((uint32_t)(arg1[7]) << 24);
    x26 = ((uint32_t)(arg1[6]) << 16);
    x27 = ((uint32_t)(arg1[5]) << 8);
    x28 = (arg1[4]);
    x29 = ((uint32_t)(arg1[3]) << 24);
    x30 = ((uint32_t)(arg1[2]) << 16);
    x31 = ((uint32_t)(arg1[1]) << 8);
    x32 = (arg1[0]);
    x33 = (x31 + (uint32_t)x32);
    x34 = (x30 + x33);
    x35 = (x29 + x34);
    x36 = (x27 + (uint32_t)x28);
    x37 = (x26 + x36);
    x38 = (x25 + x37);
    x39 = (x23 + (uint32_t)x24);
    x40 = (x22 + x39);
    x41 = (x21 + x40);
    x42 = (x19 + (uint32_t)x20);
    x43 = (x18 + x42);
    x44 = (x17 + x43);
    x45 = (x15 + (uint32_t)x16);
    x46 = (x14 + x45);
    x47 = (x13 + x46);
    x48 = (x11 + (uint32_t)x12);
    x49 = (x10 + x48);
    x50 = (x9 + x49);
    x51 = (x7 + (uint32_t)x8);
    x52 = (x6 + x51);
    x53 = (x5 + x52);
    x54 = (x3 + (uint32_t)x4);
    x55 = (x2 + x54);
    x56 = (x1 + x55);
    out1[0] = x35;
    out1[1] = x38;
    out1[2] = x41;
    out1[3] = x44;
    out1[4] = x47;
    out1[5] = x50;
    out1[6] = x53;
    out1[7] = x56;
}

/* END verbatim fiat code */

/*-
 * Finite field inversion via FLT.
 * NB: this is not a real Fiat function, just named that way for consistency.
 * Autogenerated: ecp/id_GostR3410_2001_TestParamSet/fe_inv.op3
 * sliding window w=5
 */
static void fiat_id_GostR3410_2001_TestParamSet_inv(fe_t output,
                                                    const fe_t t1) {
    int i;
    /* temporary variables */
    fe_t acc, t15;

    fiat_id_GostR3410_2001_TestParamSet_square(acc, t1);
    fiat_id_GostR3410_2001_TestParamSet_mul(t15, t1, acc);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_TestParamSet_mul(t15, t15, acc);
    fiat_id_GostR3410_2001_TestParamSet_square(acc, t1);
    for (i = 0; i < 244; i++)
        fiat_id_GostR3410_2001_TestParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_TestParamSet_mul(acc, acc, t1);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_TestParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_TestParamSet_mul(acc, acc, t1);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_TestParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_TestParamSet_mul(output, acc, t15);
}

/* curve coefficient constants */

static const limb_t const_one[8] = {UINT32_C(0xFFFFFBCF), UINT32_C(0xFFFFFFFF),
                                    UINT32_C(0xFFFFFFFF), UINT32_C(0xFFFFFFFF),
                                    UINT32_C(0xFFFFFFFF), UINT32_C(0xFFFFFFFF),
                                    UINT32_C(0xFFFFFFFF), UINT32_C(0x7FFFFFFF)};

static const limb_t const_a[8] = {UINT32_C(0xFFFFC983), UINT32_C(0xFFFFFFFF),
                                  UINT32_C(0xFFFFFFFF), UINT32_C(0xFFFFFFFF),
                                  UINT32_C(0xFFFFFFFF), UINT32_C(0xFFFFFFFF),
                                  UINT32_C(0xFFFFFFFF), UINT32_C(0x7FFFFFFF)};

static const limb_t const_b3[8] = {UINT32_C(0x6AEAB71C), UINT32_C(0x81733EE9),
                                   UINT32_C(0xFC4E6FC7), UINT32_C(0x00CD3D1C),
                                   UINT32_C(0x75853407), UINT32_C(0x60AB503A),
                                   UINT32_C(0x4556810A), UINT32_C(0x0A9EC8AE)};

/* LUT for scalar multiplication by comb interleaving */
static const pt_aff_t lut_cmb[27][16] = {
    {
        {{UINT32_C(0xFFFFF36D), UINT32_C(0xFFFFFFFF), UINT32_C(0xFFFFFFFF),
          UINT32_C(0xFFFFFFFF), UINT32_C(0xFFFFFFFF), UINT32_C(0xFFFFFFFF),
          UINT32_C(0xFFFFFFFF), UINT32_C(0x7FFFFFFF)},
         {UINT32_C(0x471125F5), UINT32_C(0x9AF45A5A), UINT32_C(0xF69BF9AE),
          UINT32_C(0x7CE5090A), UINT32_C(0xE4B6DDE6), UINT32_C(0x67617A63),
          UINT32_C(0x4AA3DAA4), UINT32_C(0x03F66B35)}},
        {{UINT32_C(0x149B5D15), UINT32_C(0xB39BDC16), UINT32_C(0x7309454F),
          UINT32_C(0x87CE978A), UINT32_C(0x315A7A56), UINT32_C(0xD22F32EF),
          UINT32_C(0xB69A6B57), UINT32_C(0x4C7DE232)},
         {UINT32_C(0x466DC64D), UINT32_C(0x9E2DAF6D), UINT32_C(0x4B1C8A55),
          UINT32_C(0x758C27B1), UINT32_C(0xBD647F1A), UINT32_C(0x74A0CB23),
          UINT32_C(0x2C2F4C70), UINT32_C(0x27E74868)}},
        {{UINT32_C(0x55A62594), UINT32_C(0xF2D8F32E), UINT32_C(0x36BC547A),
          UINT32_C(0x8323D570), UINT32_C(0x98D4B25A), UINT32_C(0x497679EB),
          UINT32_C(0xB87E0534), UINT32_C(0x061167F2)},
         {UINT32_C(0x223E4DF8), UINT32_C(0xE1FFFDCE), UINT32_C(0xDCD891E9),
          UINT32_C(0x7C83AE78), UINT32_C(0x3C1B95D0), UINT32_C(0x74398586),
          UINT32_C(0x74B3F5AB), UINT32_C(0x11D73205)}},
        {{UINT32_C(0xACB97F7C), UINT32_C(0x34B9C048), UINT32_C(0xE3B9BCC6),
          UINT32_C(0x8232E73C), UINT32_C(0xDA2DB71D), UINT32_C(0x81F4B63F),
          UINT32_C(0xA2DF4C84), UINT32_C(0x4EEE5393)},
         {UINT32_C(0xAC469C69), UINT32_C(0xCA6E63AE), UINT32_C(0x428E4F01),
          UINT32_C(0x27BC807C), UINT32_C(0x5F4EC124), UINT32_C(0x4A2C23BA),
          UINT32_C(0xAAE2668B), UINT32_C(0x74847CFC)}},
        {{UINT32_C(0x6716AF4E), UINT32_C(0x4435585F), UINT32_C(0x1CDB965F),
          UINT32_C(0xB872D8B7), UINT32_C(0x746FFAD0), UINT32_C(0x662F1962),
          UINT32_C(0xDB5D0187), UINT32_C(0x52761A24)},
         {UINT32_C(0xA57E0E3D), UINT32_C(0xF6A09922), UINT32_C(0xA9C12B63),
          UINT32_C(0x86C69342), UINT32_C(0x5AF190C5), UINT32_C(0x91FF20B6),
          UINT32_C(0x4EEEE1AE), UINT32_C(0x10DB7A2A)}},
        {{UINT32_C(0x74628B90), UINT32_C(0xBB464A53), UINT32_C(0x057A4F25),
          UINT32_C(0x6E7A1227), UINT32_C(0x0B0FA41F), UINT32_C(0x4C309D69),
          UINT32_C(0x77FE7B93), UINT32_C(0x75482607)},
         {UINT32_C(0x0B612421), UINT32_C(0xF2583EC7), UINT32_C(0x5E2B15ED),
          UINT32_C(0xFF2CFC83), UINT32_C(0x8CABC5CF), UINT32_C(0x1E97A7DB),
          UINT32_C(0x925C149F), UINT32_C(0x1EC08FAA)}},
        {{UINT32_C(0x0E9FCBA9), UINT32_C(0xBA0170E3), UINT32_C(0x70D9939B),
          UINT32_C(0x8976DF7C), UINT32_C(0x21AF14DD), UINT32_C(0xEAE6E74B),
          UINT32_C(0x0D0861F9), UINT32_C(0x09F09868)},
         {UINT32_C(0x21A781FF), UINT32_C(0x4F7FE26E), UINT32_C(0xD73DCEF7),
          UINT32_C(0x1725B8D0), UINT32_C(0x7E743498), UINT32_C(0x9DA63217),
          UINT32_C(0x1B828B99), UINT32_C(0x0F51D42C)}},
        {{UINT32_C(0x9AFE09BD), UINT32_C(0xBABB076B), UINT32_C(0x17C4050D),
          UINT32_C(0x4AC89223), UINT32_C(0xDA3E57E8), UINT32_C(0xCA3EA6E3),
          UINT32_C(0xA33242C0), UINT32_C(0x20AAA384)},
         {UINT32_C(0xEF929BF5), UINT32_C(0x6D3A1F2D), UINT32_C(0xE751A62D),
          UINT32_C(0xB34E2605), UINT32_C(0xB8CF1F99), UINT32_C(0xE1AC629F),
          UINT32_C(0xF0BBA01A), UINT32_C(0x7152D4E3)}},
        {{UINT32_C(0x943E5B8E), UINT32_C(0xA97A6CE3), UINT32_C(0x2D053A9D),
          UINT32_C(0x1C0F6C7F), UINT32_C(0x64457DE4), UINT32_C(0x9D4A91DE),
          UINT32_C(0xC6140057), UINT32_C(0x1E19EA8F)},
         {UINT32_C(0x500995C8), UINT32_C(0xD4766CB6), UINT32_C(0xE70CD7EE),
          UINT32_C(0xA019D41D), UINT32_C(0x7AB0A162), UINT32_C(0xBA1828AA),
          UINT32_C(0x0B7A4E93), UINT32_C(0x0CACA063)}},
        {{UINT32_C(0xA1B3FE03), UINT32_C(0x1E68315C), UINT32_C(0x1AAB6B20),
          UINT32_C(0x21FB277E), UINT32_C(0x6A90FB22), UINT32_C(0x210305D7),
          UINT32_C(0x2E51B9BC), UINT32_C(0x4C3D3EEA)},
         {UINT32_C(0x89C3A2E8), UINT32_C(0xC5662C6D), UINT32_C(0x1712BF9B),
          UINT32_C(0x66EA4818), UINT32_C(0x2254FBAB), UINT32_C(0x417F8F04),
          UINT32_C(0xB057EEC1), UINT32_C(0x2F57DF29)}},
        {{UINT32_C(0x6509AE4F), UINT32_C(0xF6975C9F), UINT32_C(0xDC89C220),
          UINT32_C(0x58300438), UINT32_C(0x907FF785), UINT32_C(0xE81DA879),
          UINT32_C(0x0910ED2F), UINT32_C(0x68D600E3)},
         {UINT32_C(0xB43BF686), UINT32_C(0xFBB25113), UINT32_C(0x50A64FAE),
          UINT32_C(0x8B391E3F), UINT32_C(0x3112B7ED), UINT32_C(0x8C1190D2),
          UINT32_C(0xCCB4CA50), UINT32_C(0x617BCD41)}},
        {{UINT32_C(0xDD780ACA), UINT32_C(0x75036E69), UINT32_C(0x6FBCD996),
          UINT32_C(0xC90A01DE), UINT32_C(0x0C851CEF), UINT32_C(0x75E1A8E8),
          UINT32_C(0xF71BDCC6), UINT32_C(0x7225D38A)},
         {UINT32_C(0x868B78D2), UINT32_C(0x74AE6935), UINT32_C(0x1CDB5A1E),
          UINT32_C(0xE70570F3), UINT32_C(0xBEBD2FA4), UINT32_C(0x3E700C48),
          UINT32_C(0x325D3214), UINT32_C(0x3E483638)}},
        {{UINT32_C(0xC0E6D8AD), UINT32_C(0x9F272CD5), UINT32_C(0xE09743A2),
          UINT32_C(0x9E29687C), UINT32_C(0x93CD64B3), UINT32_C(0xBE0E0D59),
          UINT32_C(0x504B58F0), UINT32_C(0x5D57A75D)},
         {UINT32_C(0x5D44B092), UINT32_C(0x81A1A6E3), UINT32_C(0x310D7868),
          UINT32_C(0x38AD0169), UINT32_C(0xCC297B73), UINT32_C(0xC8D3C9A6),
          UINT32_C(0x908E0814), UINT32_C(0x34D98A19)}},
        {{UINT32_C(0xE5A57E1F), UINT32_C(0xFFB946AD), UINT32_C(0x191B6C5F),
          UINT32_C(0xF7EA0AA2), UINT32_C(0x8DF529C1), UINT32_C(0x52D07058),
          UINT32_C(0x2AFDA727), UINT32_C(0x06B7BDE5)},
         {UINT32_C(0x90658555), UINT32_C(0x651E6DC9), UINT32_C(0x1FC416CE),
          UINT32_C(0x8F910D89), UINT32_C(0xCBF086D5), UINT32_C(0x0BA4D84E),
          UINT32_C(0x0C4A4B4A), UINT32_C(0x73DA158C)}},
        {{UINT32_C(0x521DB62C), UINT32_C(0xE22420A6), UINT32_C(0xBC90EB6F),
          UINT32_C(0x8EBC1A21), UINT32_C(0xE50F6EB4), UINT32_C(0xE1529AAC),
          UINT32_C(0x8BE235DB), UINT32_C(0x4025BF27)},
         {UINT32_C(0x9FFE2B82), UINT32_C(0x40607710), UINT32_C(0x696B4634),
          UINT32_C(0x7A6BB75B), UINT32_C(0x2B2F25D3), UINT32_C(0x0CEF27A9),
          UINT32_C(0xCA0B7112), UINT32_C(0x6C9CFFD7)}},
        {{UINT32_C(0xEDA5C43B), UINT32_C(0x12B39FF0), UINT32_C(0x54E0FE3F),
          UINT32_C(0x2E1FC66C), UINT32_C(0x248A9167), UINT32_C(0xFB2DEA80),
          UINT32_C(0x3B2BB322), UINT32_C(0x11BCDA10)},
         {UINT32_C(0x16D2C928), UINT32_C(0xFDDF6E84), UINT32_C(0x36E887F4),
          UINT32_C(0x99DDF6A1), UINT32_C(0x920092D6), UINT32_C(0x1E56D2F3),
          UINT32_C(0x2D77AE5A), UINT32_C(0x67433BF4)}},
    },
    {
        {{UINT32_C(0x321BFA62), UINT32_C(0x6C204DDC), UINT32_C(0x2F138A80),
          UINT32_C(0xA96E42B8), UINT32_C(0xE3EC1A7D), UINT32_C(0x4C98E986),
          UINT32_C(0x136CADC4), UINT32_C(0x223C8BC4)},
         {UINT32_C(0xBA3CE54A), UINT32_C(0xFA9F15D3), UINT32_C(0x19963D88),
          UINT32_C(0xA103B9D7), UINT32_C(0x2F811A21), UINT32_C(0x1ED23354),
          UINT32_C(0x65A4E833), UINT32_C(0x64D6B14C)}},
        {{UINT32_C(0xCFBD1039), UINT32_C(0x2485175C), UINT32_C(0x7C92D8EC),
          UINT32_C(0xC4DAE65B), UINT32_C(0x1859FD47), UINT32_C(0x6FC70F54),
          UINT32_C(0x33E8305C), UINT32_C(0x6D543444)},
         {UINT32_C(0x944DDA07), UINT32_C(0x1A65FEC2), UINT32_C(0xEF375B21),
          UINT32_C(0x7BCF8391), UINT32_C(0xBE4CD8D6), UINT32_C(0xDDCFC356),
          UINT32_C(0x13850042), UINT32_C(0x4BF93B9E)}},
        {{UINT32_C(0x88B7F950), UINT32_C(0xBDF7A56C), UINT32_C(0x81B8590E),
          UINT32_C(0x3A60E5FC), UINT32_C(0x6F6E6807), UINT32_C(0x475B94D1),
          UINT32_C(0x2F0D49A8), UINT32_C(0x2F1B9F06)},
         {UINT32_C(0x2E6A01D3), UINT32_C(0x3C36DCF3), UINT32_C(0x30444003),
          UINT32_C(0x807E1D5B), UINT32_C(0xFECF5768), UINT32_C(0xE3768486),
          UINT32_C(0xEF12B5CC), UINT32_C(0x73C4D0CF)}},
        {{UINT32_C(0xF4C6FF93), UINT32_C(0x9D76477C), UINT32_C(0xC5A1A495),
          UINT32_C(0x03F16687), UINT32_C(0xB41748B2), UINT32_C(0x5071DA3D),
          UINT32_C(0x971D6A7D), UINT32_C(0x0F3A3784)},
         {UINT32_C(0x2785A782), UINT32_C(0x0B9A5AD6), UINT32_C(0x09FF09F9),
          UINT32_C(0x957E72A0), UINT32_C(0xAE3CF5F4), UINT32_C(0x3072C1DC),
          UINT32_C(0xCD9CFD7E), UINT32_C(0x63D463AC)}},
        {{UINT32_C(0xC77B516C), UINT32_C(0xDA0DEE0B), UINT32_C(0xE6AA0E1F),
          UINT32_C(0x446D7199), UINT32_C(0xBFFA705C), UINT32_C(0xCC0D1590),
          UINT32_C(0xC35B59BA), UINT32_C(0x6A6FC81C)},
         {UINT32_C(0x593E3EB9), UINT32_C(0x39DF210E), UINT32_C(0xD0DCC01F),
          UINT32_C(0x17F331CE), UINT32_C(0xBD176C5B), UINT32_C(0x02E0E5EB),
          UINT32_C(0x8A2D6290), UINT32_C(0x68946CCC)}},
        {{UINT32_C(0x09ECFEF2), UINT32_C(0x8D1400D6), UINT32_C(0xE1E76A98),
          UINT32_C(0x57D5F91B), UINT32_C(0xA12DFF8D), UINT32_C(0x5CF76130),
          UINT32_C(0x61002939), UINT32_C(0x5C361922)},
         {UINT32_C(0xFB0FE974), UINT32_C(0x8D45C8C1), UINT32_C(0xF942ED70),
          UINT32_C(0x0C97725E), UINT32_C(0x73C5AA42), UINT32_C(0xB1C66498),
          UINT32_C(0x7E203187), UINT32_C(0x4A121FC4)}},
        {{UINT32_C(0xFCEDA76C), UINT32_C(0x58430EE3), UINT32_C(0xF5C88D62),
          UINT32_C(0x3496699A), UINT32_C(0x14273E7E), UINT32_C(0x1C3FC811),
          UINT32_C(0x1D6D67DA), UINT32_C(0x3E38E9FC)},
         {UINT32_C(0xAB685B3B), UINT32_C(0xBB683EA4), UINT32_C(0xB0904BB3),
          UINT32_C(0xB63F72B1), UINT32_C(0x47A75297), UINT32_C(0x5DFA23C5),
          UINT32_C(0x38B59560), UINT32_C(0x09E80AA0)}},
        {{UINT32_C(0x7F4D22FC), UINT32_C(0x7D8325C6), UINT32_C(0x8C2FA282),
          UINT32_C(0xBFFB01B1), UINT32_C(0x4A89BE98), UINT32_C(0x01A037DC),
          UINT32_C(0x84EA8C8A), UINT32_C(0x092F6525)},
         {UINT32_C(0xC52FD518), UINT32_C(0x873D33DA), UINT32_C(0x44AFDD41),
          UINT32_C(0x0A245B15), UINT32_C(0x98FA7FF5), UINT32_C(0x78993737),
          UINT32_C(0x21D29087), UINT32_C(0x1BB48AD2)}},
        {{UINT32_C(0x1A59313C), UINT32_C(0x00C97A99), UINT32_C(0x5CF9A6FF),
          UINT32_C(0xBD4F29EE), UINT32_C(0xD839B62B), UINT32_C(0xEA59D87A),
          UINT32_C(0x97CAB63C), UINT32_C(0x16F18F48)},
         {UINT32_C(0x6F6C292F), UINT32_C(0xB339789A), UINT32_C(0xD005ABB2),
          UINT32_C(0xEC52E644), UINT32_C(0xAE24DA46), UINT32_C(0xEEAC93C9),
          UINT32_C(0xE5C43B4F), UINT32_C(0x0ECB9957)}},
        {{UINT32_C(0x20561AF7), UINT32_C(0xD91B2202), UINT32_C(0x55F2CFB8),
          UINT32_C(0xECA260DD), UINT32_C(0x17B91CCF), UINT32_C(0xF03A8C1D),
          UINT32_C(0x64B35D9A), UINT32_C(0x55A0491F)},
         {UINT32_C(0x1A2F8F39), UINT32_C(0x0A97E5CC), UINT32_C(0x23B1D80B),
          UINT32_C(0x02C187D1), UINT32_C(0xDB9FBA1A), UINT32_C(0xA9C13D26),
          UINT32_C(0xF8051F0D), UINT32_C(0x7CCDDBAC)}},
        {{UINT32_C(0xED0E9DB8), UINT32_C(0x05CA8EA5), UINT32_C(0x53A8EA3F),
          UINT32_C(0xE888079F), UINT32_C(0x9209BFA2), UINT32_C(0x6DDBC40D),
          UINT32_C(0x80DCEAEA), UINT32_C(0x068E5BA9)},
         {UINT32_C(0xB19D824B), UINT32_C(0xDB69D133), UINT32_C(0xE6A3A462),
          UINT32_C(0x65154FB6), UINT32_C(0x020B2AC7), UINT32_C(0x9FCF733D),
          UINT32_C(0xE1329315), UINT32_C(0x15178DDE)}},
        {{UINT32_C(0x877EE476), UINT32_C(0x76F78865), UINT32_C(0x12B471BA),
          UINT32_C(0x5824EACC), UINT32_C(0xBBB640A8), UINT32_C(0x71BDFADF),
          UINT32_C(0x9A631D09), UINT32_C(0x5181B08F)},
         {UINT32_C(0xFFE978E8), UINT32_C(0x2913CCA5), UINT32_C(0xAEB89AA6),
          UINT32_C(0x9CEF3612), UINT32_C(0xE02AD6DC), UINT32_C(0x93BB373E),
          UINT32_C(0x04144769), UINT32_C(0x5D7984F0)}},
        {{UINT32_C(0x4F98D2C3), UINT32_C(0x3219DB07), UINT32_C(0xBD40ACCC),
          UINT32_C(0xE3EF888F), UINT32_C(0x31124C73), UINT32_C(0x07A30E3A),
          UINT32_C(0xB070C53F), UINT32_C(0x5D9C820B)},
         {UINT32_C(0xDA0661AB), UINT32_C(0x94D41768), UINT32_C(0x21FF87EB),
          UINT32_C(0x27FC2661), UINT32_C(0xFF17A977), UINT32_C(0xB8DCBC7F),
          UINT32_C(0x392EB13D), UINT32_C(0x71F75FF9)}},
        {{UINT32_C(0x9AD71AB0), UINT32_C(0xC5CED56C), UINT32_C(0x39D6C9F1),
          UINT32_C(0xE744EAB0), UINT32_C(0x839BD904), UINT32_C(0x6E49B00B),
          UINT32_C(0xD7003054), UINT32_C(0x0C0EDE2C)},
         {UINT32_C(0x1A6A1BB7), UINT32_C(0x792C3F80), UINT32_C(0x4B2C7885),
          UINT32_C(0x6E5093B1), UINT32_C(0x13EA65F7), UINT32_C(0x28873209),
          UINT32_C(0xF381C851), UINT32_C(0x085A2697)}},
        {{UINT32_C(0xDA60A255), UINT32_C(0x84FC6B9D), UINT32_C(0x4B495BC6),
          UINT32_C(0x12397EED), UINT32_C(0x71A5AA87), UINT32_C(0x4881DF6B),
          UINT32_C(0x9572CFE2), UINT32_C(0x57BB3259)},
         {UINT32_C(0x3A10A65F), UINT32_C(0x30677759), UINT32_C(0xDB1758DD),
          UINT32_C(0x670B82EC), UINT32_C(0xD57B513E), UINT32_C(0xD84F3E8F),
          UINT32_C(0x89088E78), UINT32_C(0x617A512A)}},
        {{UINT32_C(0xAE3D7707), UINT32_C(0x83971322), UINT32_C(0x6D34D0B4),
          UINT32_C(0x66563CDE), UINT32_C(0xC13309ED), UINT32_C(0x95342D9B),
          UINT32_C(0x082A5887), UINT32_C(0x62C2B1B6)},
         {UINT32_C(0xC3C27158), UINT32_C(0xD94A8712), UINT32_C(0xA844BF60),
          UINT32_C(0xDE2C9C9D), UINT32_C(0xCE3E4F3C), UINT32_C(0xDE897386),
          UINT32_C(0x6ACEBDF1), UINT32_C(0x2C22A82E)}},
    },
    {
        {{UINT32_C(0x0604E200), UINT32_C(0x2755028A), UINT32_C(0x44189101),
          UINT32_C(0xADE23A7D), UINT32_C(0xF0B7F9B7), UINT32_C(0xA6E418F4),
          UINT32_C(0x212EDC2A), UINT32_C(0x036F5503)},
         {UINT32_C(0x3F5E0456), UINT32_C(0xE069D06A), UINT32_C(0x0F37F2D8),
          UINT32_C(0x2FAFF7C8), UINT32_C(0x7F5EDE53), UINT32_C(0xFF08E879),
          UINT32_C(0x797E0427), UINT32_C(0x7F97725D)}},
        {{UINT32_C(0xB32E5B1B), UINT32_C(0xE44E39C1), UINT32_C(0xAD3EC706),
          UINT32_C(0x25CD4614), UINT32_C(0xE382C5D2), UINT32_C(0x2E97B090),
          UINT32_C(0xB00D79F2), UINT32_C(0x3E1A1F6B)},
         {UINT32_C(0xC2375837), UINT32_C(0x27573C4E), UINT32_C(0x6C8D5CCD),
          UINT32_C(0xAD53D2C8), UINT32_C(0xFC09725A), UINT32_C(0x94EE5460),
          UINT32_C(0x02DD0DF4), UINT32_C(0x6E592506)}},
        {{UINT32_C(0x3D0C7AC4), UINT32_C(0x6CFFA4BF), UINT32_C(0x69ED4317),
          UINT32_C(0x663B1218), UINT32_C(0xC79AD5C1), UINT32_C(0x933094F6),
          UINT32_C(0xFFC54767), UINT32_C(0x569F37ED)},
         {UINT32_C(0x1F338782), UINT32_C(0x954EEE0C), UINT32_C(0xA46CA276),
          UINT32_C(0x5BE69673), UINT32_C(0x20CB26DC), UINT32_C(0x77BA0009),
          UINT32_C(0x029316AE), UINT32_C(0x2211CAC3)}},
        {{UINT32_C(0x184EBD7C), UINT32_C(0xC8DEF3CB), UINT32_C(0x6A4DB0A0),
          UINT32_C(0x39337050), UINT32_C(0x0BE1D82C), UINT32_C(0x6FF7993A),
          UINT32_C(0xFC9252C0), UINT32_C(0x01D7674A)},
         {UINT32_C(0xF62D9268), UINT32_C(0xB10BA727), UINT32_C(0x817B687B),
          UINT32_C(0x6E2338D8), UINT32_C(0xE47405F1), UINT32_C(0x266443F2),
          UINT32_C(0x6872B879), UINT32_C(0x6A1BD9CE)}},
        {{UINT32_C(0x2B2BD346), UINT32_C(0x19213765), UINT32_C(0xE2ACFB8E),
          UINT32_C(0x962CA22C), UINT32_C(0x62FECDE1), UINT32_C(0x518CF45D),
          UINT32_C(0xA13D9E8D), UINT32_C(0x529AE629)},
         {UINT32_C(0xBB69D5E3), UINT32_C(0xAF796DB0), UINT32_C(0xD4E596B7),
          UINT32_C(0xA064209D), UINT32_C(0x47942C73), UINT32_C(0x9F3DFD4A),
          UINT32_C(0x7810D5EC), UINT32_C(0x7FAB6C6D)}},
        {{UINT32_C(0x66A3B287), UINT32_C(0x55D15250), UINT32_C(0xEEFDDC75),
          UINT32_C(0x1ECC6A20), UINT32_C(0x26DE8C01), UINT32_C(0xF683FA60),
          UINT32_C(0x9FBA658C), UINT32_C(0x4F5DE2A6)},
         {UINT32_C(0xC66D82F4), UINT32_C(0xE748D78A), UINT32_C(0x3B24C76B),
          UINT32_C(0x2BA525EF), UINT32_C(0x30EE69CE), UINT32_C(0x5A9539E6),
          UINT32_C(0xB7861B2D), UINT32_C(0x2DA4C4C2)}},
        {{UINT32_C(0x820743E6), UINT32_C(0x9D1E982D), UINT32_C(0xAB0CC42D),
          UINT32_C(0x705D9237), UINT32_C(0x47C4E7D7), UINT32_C(0xBDD01663),
          UINT32_C(0xF8E69896), UINT32_C(0x3D48EE78)},
         {UINT32_C(0x41132782), UINT32_C(0x7A822BCD), UINT32_C(0xEE46F715),
          UINT32_C(0xBD41BEFA), UINT32_C(0xD0B2F4B0), UINT32_C(0x8E5C3B5F),
          UINT32_C(0x5E47ED55), UINT32_C(0x690A53D4)}},
        {{UINT32_C(0x65A40E44), UINT32_C(0x390536C1), UINT32_C(0x1C92235C),
          UINT32_C(0x4B4D7970), UINT32_C(0x8B7389E4), UINT32_C(0xCAC27084),
          UINT32_C(0x19041D01), UINT32_C(0x7B5B23B2)},
         {UINT32_C(0x3B5FD5BA), UINT32_C(0x7C18B973), UINT32_C(0x84B72217),
          UINT32_C(0xFD14865D), UINT32_C(0x267EDE4C), UINT32_C(0x5592547E),
          UINT32_C(0x8B369753), UINT32_C(0x22DB62E5)}},
        {{UINT32_C(0xDDF15BDD), UINT32_C(0x06083D33), UINT32_C(0x361925F5),
          UINT32_C(0x5766555F), UINT32_C(0xB7ACDEA7), UINT32_C(0xECC0F110),
          UINT32_C(0x0A3453B5), UINT32_C(0x3E3F1B27)},
         {UINT32_C(0x6F7B980D), UINT32_C(0x5A8B7DF9), UINT32_C(0xB44756AC),
          UINT32_C(0xEBA90E39), UINT32_C(0xAC9A7DB2), UINT32_C(0x954D7ECD),
          UINT32_C(0x28EA7151), UINT32_C(0x43F688D3)}},
        {{UINT32_C(0x4638EFAE), UINT32_C(0x51F64569), UINT32_C(0x3D28BF3C),
          UINT32_C(0x5840A5DB), UINT32_C(0x134D3E8F), UINT32_C(0xDD486261),
          UINT32_C(0x7B6B466B), UINT32_C(0x09F17E2C)},
         {UINT32_C(0x78ED7016), UINT32_C(0x30D35463), UINT32_C(0xB86D8508),
          UINT32_C(0x342E9701), UINT32_C(0x42B19533), UINT32_C(0xA3FF6565),
          UINT32_C(0x061A4A81), UINT32_C(0x4405F02C)}},
        {{UINT32_C(0x3D3AAF1E), UINT32_C(0x15C921C0), UINT32_C(0x7D297559),
          UINT32_C(0x2DD720C7), UINT32_C(0xCB80E3B2), UINT32_C(0x93A07904),
          UINT32_C(0x6B1EDB93), UINT32_C(0x427C610B)},
         {UINT32_C(0xF61E2F41), UINT32_C(0xD2CE818F), UINT32_C(0x8252FB3C),
          UINT32_C(0x1DA53421), UINT32_C(0xED07538F), UINT32_C(0x37A4A997),
          UINT32_C(0x962454F2), UINT32_C(0x48A928BF)}},
        {{UINT32_C(0x7A420273), UINT32_C(0x65091E4D), UINT32_C(0xE54C0B47),
          UINT32_C(0x6AF382AF), UINT32_C(0x8047A423), UINT32_C(0x150DAB08),
          UINT32_C(0x45BD197C), UINT32_C(0x22C3740A)},
         {UINT32_C(0xE07C3468), UINT32_C(0x64429AA0), UINT32_C(0x7B37FE10),
          UINT32_C(0xC506B8C9), UINT32_C(0x3CC5062C), UINT32_C(0x30E2FE78),
          UINT32_C(0xA9242F2D), UINT32_C(0x2F3B5A5F)}},
        {{UINT32_C(0x5A40BCA1), UINT32_C(0x2619A3B2), UINT32_C(0x118C2FEA),
          UINT32_C(0xD012DF23), UINT32_C(0xB73FE15C), UINT32_C(0x2868C8B7),
          UINT32_C(0xEB10B475), UINT32_C(0x45A9CC5A)},
         {UINT32_C(0x069050AD), UINT32_C(0x7111AB75), UINT32_C(0xEC2398A9),
          UINT32_C(0x0665182B), UINT32_C(0x9B86A240), UINT32_C(0xD9A5126E),
          UINT32_C(0x40E2AED6), UINT32_C(0x601CF0E0)}},
        {{UINT32_C(0xF48C8655), UINT32_C(0xE74C9DCD), UINT32_C(0x900E89D5),
          UINT32_C(0xEE703CA8), UINT32_C(0x5390F052), UINT32_C(0x6C2DFF8B),
          UINT32_C(0x1316CC4C), UINT32_C(0x08588E89)},
         {UINT32_C(0x47E80C87), UINT32_C(0x0F2CC83A), UINT32_C(0xD87824E4),
          UINT32_C(0x23DE34CF), UINT32_C(0x541FE8F9), UINT32_C(0xC530AF41),
          UINT32_C(0xD142F1C0), UINT32_C(0x0BF01DC0)}},
        {{UINT32_C(0x886C0C4A), UINT32_C(0x210B0B1E), UINT32_C(0x9C56A126),
          UINT32_C(0x66369DF1), UINT32_C(0xEAC22A5E), UINT32_C(0x5D79AE81),
          UINT32_C(0xD16F7DB6), UINT32_C(0x4E6C67D4)},
         {UINT32_C(0x247CDE60), UINT32_C(0x274572F6), UINT32_C(0x54E8454B),
          UINT32_C(0xF3C92AC7), UINT32_C(0xF08C32D1), UINT32_C(0x784EC1A1),
          UINT32_C(0xE1FE9C4E), UINT32_C(0x222716D8)}},
        {{UINT32_C(0x3FB1DB1E), UINT32_C(0xAF6AEF5D), UINT32_C(0xC4C2A4D8),
          UINT32_C(0xB8B55842), UINT32_C(0xCA5AB578), UINT32_C(0x258A2F44),
          UINT32_C(0x7D8B2D70), UINT32_C(0x558A803F)},
         {UINT32_C(0x7E0247A3), UINT32_C(0x9A7345C3), UINT32_C(0xB4D920B1),
          UINT32_C(0x4E5A6904), UINT32_C(0x76BCBBE1), UINT32_C(0xCF7FAA41),
          UINT32_C(0xEE112271), UINT32_C(0x66CF993F)}},
    },
    {
        {{UINT32_C(0x84D2C56B), UINT32_C(0xDE7D208F), UINT32_C(0xDDA20F33),
          UINT32_C(0xD1C77403), UINT32_C(0x9A6F337A), UINT32_C(0xB73FDC09),
          UINT32_C(0x40CD2CBD), UINT32_C(0x1B2A3807)},
         {UINT32_C(0x65988D73), UINT32_C(0xB642FA2C), UINT32_C(0x059DAB8E),
          UINT32_C(0x117E75BC), UINT32_C(0xD6B279AA), UINT32_C(0xC7E2E935),
          UINT32_C(0xEEA2A445), UINT32_C(0x5EEB9654)}},
        {{UINT32_C(0xA59D7A2A), UINT32_C(0xA84747C0), UINT32_C(0x1004C5B8),
          UINT32_C(0x4478AD4A), UINT32_C(0xA22DE791), UINT32_C(0xF55C2B1B),
          UINT32_C(0x23F8F89F), UINT32_C(0x2FF6097D)},
         {UINT32_C(0xE117BC40), UINT32_C(0xD079C875), UINT32_C(0x03CB43DD),
          UINT32_C(0x14AEA360), UINT32_C(0x0A20D653), UINT32_C(0x8C730D89),
          UINT32_C(0x02FD02D8), UINT32_C(0x6956274A)}},
        {{UINT32_C(0xD46293CF), UINT32_C(0x9F5D0E9D), UINT32_C(0xF0D93AB7),
          UINT32_C(0x53748DD4), UINT32_C(0xB9C37CF0), UINT32_C(0x6F81339F),
          UINT32_C(0xF4B041FC), UINT32_C(0x00B8677A)},
         {UINT32_C(0xB5A6FE97), UINT32_C(0xF76E0FFE), UINT32_C(0xF7D198A2),
          UINT32_C(0x6D3C71F5), UINT32_C(0x11420372), UINT32_C(0xF91E8408),
          UINT32_C(0x70036AED), UINT32_C(0x36F9F354)}},
        {{UINT32_C(0x5D446956), UINT32_C(0x503AF4F2), UINT32_C(0x2DC9777C),
          UINT32_C(0xCA08C537), UINT32_C(0xE1308D3A), UINT32_C(0xDB4BA888),
          UINT32_C(0x01DB98CB), UINT32_C(0x01EA28EA)},
         {UINT32_C(0xA7DF5FE0), UINT32_C(0x27CC52A9), UINT32_C(0x7DE31E0A),
          UINT32_C(0x7DA5186B), UINT32_C(0xF136FAD5), UINT32_C(0x63E32889),
          UINT32_C(0xA363AF23), UINT32_C(0x1BB010A8)}},
        {{UINT32_C(0xC0FE56C9), UINT32_C(0x65828B54), UINT32_C(0x4ED3935A),
          UINT32_C(0x7322CD51), UINT32_C(0x37B4A727), UINT32_C(0x42F068F4),
          UINT32_C(0xB4C02BE4), UINT32_C(0x7AA9F9F0)},
         {UINT32_C(0xDEBB2DD4), UINT32_C(0xBB77851A), UINT32_C(0xD105B81F),
          UINT32_C(0x7757D5F6), UINT32_C(0x52FA1512), UINT32_C(0x7805369C),
          UINT32_C(0x38B6976A), UINT32_C(0x4CBC43AE)}},
        {{UINT32_C(0x4096725B), UINT32_C(0x24FE8ABD), UINT32_C(0x3895D1E2),
          UINT32_C(0xC3FAC73A), UINT32_C(0x006A2360), UINT32_C(0xBCAF7757),
          UINT32_C(0xC03EBB33), UINT32_C(0x75AE96AD)},
         {UINT32_C(0x0BD1FB6F), UINT32_C(0x31074478), UINT32_C(0xEA386CBE),
          UINT32_C(0x729E8E6A), UINT32_C(0x4845AAEC), UINT32_C(0xA8BBCC0B),
          UINT32_C(0xE6582656), UINT32_C(0x1A0A2D19)}},
        {{UINT32_C(0x69BD55F7), UINT32_C(0x332BC9BD), UINT32_C(0xEFB6F780),
          UINT32_C(0x93D987E2), UINT32_C(0x14381F4D), UINT32_C(0xE57DE096),
          UINT32_C(0xFF01C4D9), UINT32_C(0x7BDF4217)},
         {UINT32_C(0x1956BF02), UINT32_C(0x2A07C4AB), UINT32_C(0x553823D9),
          UINT32_C(0x7C7B3684), UINT32_C(0xD40F600C), UINT32_C(0x8F750E8E),
          UINT32_C(0x9693A3C3), UINT32_C(0x63F253E9)}},
        {{UINT32_C(0xC62CE42B), UINT32_C(0x250ED8BF), UINT32_C(0xE70674E1),
          UINT32_C(0xE8A1A295), UINT32_C(0x163A92F1), UINT32_C(0x05ED093D),
          UINT32_C(0x628969A0), UINT32_C(0x515FF44B)},
         {UINT32_C(0x41CE3AF8), UINT32_C(0xF617DF03), UINT32_C(0xF9E60202),
          UINT32_C(0xCADE131A), UINT32_C(0x363B87E9), UINT32_C(0xFE83C379),
          UINT32_C(0x493EF65F), UINT32_C(0x7196A80B)}},
        {{UINT32_C(0xD7A2047B), UINT32_C(0x4B176FE6), UINT32_C(0x41DCA514),
          UINT32_C(0x6981D182), UINT32_C(0xDC74AC2E), UINT32_C(0xDDC7EE8E),
          UINT32_C(0x85CC07D1), UINT32_C(0x3A95A203)},
         {UINT32_C(0x841E3200), UINT32_C(0x8D4BA2D8), UINT32_C(0x5F654197),
          UINT32_C(0x837DDD9B), UINT32_C(0xFBFE4D06), UINT32_C(0x388D358E),
          UINT32_C(0x61143A85), UINT32_C(0x562DE2F2)}},
        {{UINT32_C(0xCFACB903), UINT32_C(0x3BA1F6E5), UINT32_C(0xBD97A3A2),
          UINT32_C(0xB5BBA41F), UINT32_C(0xCFCF2547), UINT32_C(0xB86F117F),
          UINT32_C(0x3D9A13DB), UINT32_C(0x50642859)},
         {UINT32_C(0x7B5F2A8F), UINT32_C(0xC15C82AE), UINT32_C(0xEF89351E),
          UINT32_C(0x47E772DD), UINT32_C(0xCAAC4CC7), UINT32_C(0x78C53901),
          UINT32_C(0x68D72131), UINT32_C(0x6B0F5D30)}},
        {{UINT32_C(0xA0B407E6), UINT32_C(0x47E17734), UINT32_C(0x34949A81),
          UINT32_C(0x29E06830), UINT32_C(0xCB1AC772), UINT32_C(0x63D83340),
          UINT32_C(0xEB84F909), UINT32_C(0x178A6DD6)},
         {UINT32_C(0x3C27D7BA), UINT32_C(0xA9E94826), UINT32_C(0xDB027A4C),
          UINT32_C(0xC86AF96D), UINT32_C(0x56D5DF86), UINT32_C(0xE7D04E34),
          UINT32_C(0x2E8D0EE3), UINT32_C(0x7212EAC2)}},
        {{UINT32_C(0x8A75F66B), UINT32_C(0xE7E5AA64), UINT32_C(0x8CFD9597),
          UINT32_C(0x7E86B6AA), UINT32_C(0x834C0271), UINT32_C(0x1B7DDE0C),
          UINT32_C(0xD4AD306F), UINT32_C(0x397EAF2A)},
         {UINT32_C(0x1657E32B), UINT32_C(0x0A357906), UINT32_C(0x4957B3AF),
          UINT32_C(0xAAEB2DCF), UINT32_C(0x69D3CEE9), UINT32_C(0x1C0CBD02),
          UINT32_C(0x5A6E7D53), UINT32_C(0x7434EC32)}},
        {{UINT32_C(0x85559E86), UINT32_C(0xEB5878F7), UINT32_C(0x4A09C168),
          UINT32_C(0xB9555F70), UINT32_C(0x80501134), UINT32_C(0xBFFAC5DB),
          UINT32_C(0x05B53160), UINT32_C(0x4CDBF53A)},
         {UINT32_C(0x5F90344B), UINT32_C(0x1413BA29), UINT32_C(0xD0DD0CFD),
          UINT32_C(0xC6A9D1ED), UINT32_C(0xA0C31B73), UINT32_C(0x8C56AA29),
          UINT32_C(0xF4E58E08), UINT32_C(0x1C9B0B61)}},
        {{UINT32_C(0x0E2F595A), UINT32_C(0xBF8D2237), UINT32_C(0xCBA13CD8),
          UINT32_C(0x7A646816), UINT32_C(0x5CD728B6), UINT32_C(0xBD2E93A1),
          UINT32_C(0x07CF9009), UINT32_C(0x30FDF85C)},
         {UINT32_C(0x06122B98), UINT32_C(0x3496D949), UINT32_C(0x5A80B3AF),
          UINT32_C(0xE63EC741), UINT32_C(0x82838A44), UINT32_C(0xA2A39CF7),
          UINT32_C(0xC015E1D4), UINT32_C(0x4A064F99)}},
        {{UINT32_C(0x456CB242), UINT32_C(0x9CCDF95B), UINT32_C(0x6F4517DC),
          UINT32_C(0xDA1CB24E), UINT32_C(0x931A1115), UINT32_C(0x60450E0F),
          UINT32_C(0xB5680A8D), UINT32_C(0x6780D774)},
         {UINT32_C(0x1FDA4243), UINT32_C(0xAFE48DCD), UINT32_C(0xAE9733C7),
          UINT32_C(0x6BDD541C), UINT32_C(0xD79D1D52), UINT32_C(0xCBBCC69C),
          UINT32_C(0x1A513B3E), UINT32_C(0x334F4F67)}},
        {{UINT32_C(0xDF49E1A0), UINT32_C(0xCE7712C4), UINT32_C(0xE0B96135),
          UINT32_C(0xB5444862), UINT32_C(0xF050D010), UINT32_C(0x10564C4B),
          UINT32_C(0xFEBEFCC8), UINT32_C(0x0531AEC8)},
         {UINT32_C(0x70DF6D29), UINT32_C(0xD45B4BE7), UINT32_C(0x6829054E),
          UINT32_C(0x1ACC2D70), UINT32_C(0x54E56E05), UINT32_C(0x9744CDE1),
          UINT32_C(0x6EE02696), UINT32_C(0x3C5DE93E)}},
    },
    {
        {{UINT32_C(0x3951B674), UINT32_C(0xF43A2B99), UINT32_C(0x5E72FC98),
          UINT32_C(0xE82789E8), UINT32_C(0x86992601), UINT32_C(0x2AD48436),
          UINT32_C(0x01A2B65A), UINT32_C(0x3FDEB172)},
         {UINT32_C(0x3666322B), UINT32_C(0x926B4839), UINT32_C(0x44B3FDB7),
          UINT32_C(0x68847D5C), UINT32_C(0xF2F5E247), UINT32_C(0xD06C450D),
          UINT32_C(0xBBA7C892), UINT32_C(0x0CEC0646)}},
        {{UINT32_C(0x61F9C9DA), UINT32_C(0x76446D26), UINT32_C(0xAC60376F),
          UINT32_C(0xEF2C7B98), UINT32_C(0x2410C057), UINT32_C(0xEEA8CABE),
          UINT32_C(0x3672A2B6), UINT32_C(0x4C2CE2A7)},
         {UINT32_C(0x12879BA5), UINT32_C(0x3F770945), UINT32_C(0xAD913022),
          UINT32_C(0x719D5BD0), UINT32_C(0x36D445A4), UINT32_C(0x28A82DD9),
          UINT32_C(0x965965AA), UINT32_C(0x26382C23)}},
        {{UINT32_C(0xB8AA8419), UINT32_C(0x66709D92), UINT32_C(0x0AB5C241),
          UINT32_C(0xFAEFF2E4), UINT32_C(0x1DD46DEB), UINT32_C(0xABB7C5DD),
          UINT32_C(0x39DB6CB5), UINT32_C(0x7DD03C33)},
         {UINT32_C(0x9E160F01), UINT32_C(0x76CDD1EA), UINT32_C(0x81C5CA37),
          UINT32_C(0x00598D56), UINT32_C(0x241772EC), UINT32_C(0x16D23B04),
          UINT32_C(0x52A6B807), UINT32_C(0x5132B028)}},
        {{UINT32_C(0xCC041445), UINT32_C(0x6D48D4B5), UINT32_C(0x1528DF63),
          UINT32_C(0x0B1CD923), UINT32_C(0x4A815F60), UINT32_C(0x82EE4DC6),
          UINT32_C(0x0451E242), UINT32_C(0x29DA6059)},
         {UINT32_C(0x17A8A6D0), UINT32_C(0xCD90BFB0), UINT32_C(0x52A7FC3D),
          UINT32_C(0x8BCF4392), UINT32_C(0x1974860C), UINT32_C(0x49AD55F2),
          UINT32_C(0x5EDCB1D2), UINT32_C(0x20BBF010)}},
        {{UINT32_C(0xA8F6C08C), UINT32_C(0xB4F0EA84), UINT32_C(0xD50164F3),
          UINT32_C(0x4341BEA7), UINT32_C(0x06320C0F), UINT32_C(0xE5389019),
          UINT32_C(0x8BA6F033), UINT32_C(0x69D4851A)},
         {UINT32_C(0x77902045), UINT32_C(0x1CE58660), UINT32_C(0xBD8579B3),
          UINT32_C(0xF3B88D85), UINT32_C(0x4FB0A17B), UINT32_C(0xF84FF63A),
          UINT32_C(0xDE6581BF), UINT32_C(0x09EE62EE)}},
        {{UINT32_C(0x7C0516DE), UINT32_C(0x8B8C15B5), UINT32_C(0xA530B89F),
          UINT32_C(0x3B448FC3), UINT32_C(0x500B0251), UINT32_C(0xE385BBE5),
          UINT32_C(0xED70804B), UINT32_C(0x5F643F85)},
         {UINT32_C(0x239E85A5), UINT32_C(0x550D9B7D), UINT32_C(0x8666E41F),
          UINT32_C(0xDC910B5B), UINT32_C(0x7D4E390F), UINT32_C(0x65522181),
          UINT32_C(0x3162FE10), UINT32_C(0x5DD2D3E8)}},
        {{UINT32_C(0xDF024A25), UINT32_C(0x59609390), UINT32_C(0x08CCBA91),
          UINT32_C(0xE66A77E9), UINT32_C(0x65E24DB6), UINT32_C(0xC5CEA91A),
          UINT32_C(0x3DCEA0A7), UINT32_C(0x0888DFB5)},
         {UINT32_C(0x92FA0754), UINT32_C(0x8C8E58CC), UINT32_C(0xF7DC9538),
          UINT32_C(0x99C259AB), UINT32_C(0x9BEFE750), UINT32_C(0x3A06D8ED),
          UINT32_C(0xFAACDC97), UINT32_C(0x71AF22E1)}},
        {{UINT32_C(0x250AC059), UINT32_C(0xCC41D094), UINT32_C(0x3BE3DA01),
          UINT32_C(0xCD792A73), UINT32_C(0xCC61EFE1), UINT32_C(0x2DA07802),
          UINT32_C(0x57053A5D), UINT32_C(0x293AFB08)},
         {UINT32_C(0x2FD8A8A0), UINT32_C(0x3E7E4884), UINT32_C(0x0B9B48D3),
          UINT32_C(0x183FA500), UINT32_C(0x431AACF6), UINT32_C(0x9CAC07BE),
          UINT32_C(0x2DF89F10), UINT32_C(0x4F82D799)}},
        {{UINT32_C(0x0A84935C), UINT32_C(0xFD9F61A8), UINT32_C(0xBB5A7E56),
          UINT32_C(0x78B948D0), UINT32_C(0x0ACCEEB3), UINT32_C(0xDA478766),
          UINT32_C(0x53C3851D), UINT32_C(0x47BDAE44)},
         {UINT32_C(0x0CFE8D0D), UINT32_C(0x5AE2C60C), UINT32_C(0x1D8A79C9),
          UINT32_C(0xAC8F79B3), UINT32_C(0x0A79CA31), UINT32_C(0xA958C15E),
          UINT32_C(0xF0952018), UINT32_C(0x1C46E20E)}},
        {{UINT32_C(0xF04AC529), UINT32_C(0xAE552ECE), UINT32_C(0xE2BFEFBC),
          UINT32_C(0xB295B601), UINT32_C(0x54733412), UINT32_C(0xECC1EE55),
          UINT32_C(0x12282094), UINT32_C(0x28BCBA53)},
         {UINT32_C(0x50B25069), UINT32_C(0x306C0781), UINT32_C(0xE9A18FFE),
          UINT32_C(0x10D5D23C), UINT32_C(0x1BD5489F), UINT32_C(0xC34FC5C7),
          UINT32_C(0xE191867D), UINT32_C(0x2B610028)}},
        {{UINT32_C(0x3E17E84D), UINT32_C(0x458A1CC1), UINT32_C(0x5D7CFB98),
          UINT32_C(0x6EAE343D), UINT32_C(0x101F0B7E), UINT32_C(0xC6E0FDAA),
          UINT32_C(0x2A023288), UINT32_C(0x0B9F7C2C)},
         {UINT32_C(0x6F3FCAA0), UINT32_C(0xBEA893A8), UINT32_C(0x452B07C0),
          UINT32_C(0x7D711B2B), UINT32_C(0x98E2C88D), UINT32_C(0x28958737),
          UINT32_C(0xDFD99A2A), UINT32_C(0x553A0180)}},
        {{UINT32_C(0x0DBA5986), UINT32_C(0x8D617BE8), UINT32_C(0x13D18594),
          UINT32_C(0xDB763C14), UINT32_C(0xD2DAD82F), UINT32_C(0x822CB0DA),
          UINT32_C(0x93239947), UINT32_C(0x37ACD99F)},
         {UINT32_C(0xCDC08BE6), UINT32_C(0x6A2A7070), UINT32_C(0xCF6D63FF),
          UINT32_C(0x86B3B66A), UINT32_C(0x0F7D4A67), UINT32_C(0x5BEFF3FB),
          UINT32_C(0xEBC94AE5), UINT32_C(0x05C25557)}},
        {{UINT32_C(0x89183418), UINT32_C(0x5D1DC087), UINT32_C(0x6EA5A960),
          UINT32_C(0xA25C7AE2), UINT32_C(0xD31F3AAE), UINT32_C(0x074698B9),
          UINT32_C(0x221788A4), UINT32_C(0x5A5B510B)},
         {UINT32_C(0x1DCE95FE), UINT32_C(0x896A8787), UINT32_C(0x7F24020C),
          UINT32_C(0x89E7B93D), UINT32_C(0x865B4334), UINT32_C(0xFC19BF42),
          UINT32_C(0x5B78B06D), UINT32_C(0x0389FBF7)}},
        {{UINT32_C(0x0BB3A3E2), UINT32_C(0x73B6DA7B), UINT32_C(0x44D56755),
          UINT32_C(0xDBC12670), UINT32_C(0x7CC1C589), UINT32_C(0x7AF2DE28),
          UINT32_C(0x697CB6B7), UINT32_C(0x7E248FCB)},
         {UINT32_C(0xC64202C0), UINT32_C(0x9410EC06), UINT32_C(0x75EB3A8C),
          UINT32_C(0x79C82158), UINT32_C(0xE95C5EA9), UINT32_C(0x74FDD2F6),
          UINT32_C(0x1CCA72C7), UINT32_C(0x2A40B5B5)}},
        {{UINT32_C(0x5C29E320), UINT32_C(0x56984223), UINT32_C(0xE871D9E2),
          UINT32_C(0x8266392A), UINT32_C(0x7B391763), UINT32_C(0x9D86C6C7),
          UINT32_C(0x02543C9E), UINT32_C(0x5E9E61E2)},
         {UINT32_C(0xD2501D1A), UINT32_C(0xD62A9334), UINT32_C(0x9211135D),
          UINT32_C(0x9D19F54D), UINT32_C(0x8FE81272), UINT32_C(0x66D0B961),
          UINT32_C(0xD09C2033), UINT32_C(0x6E64635A)}},
        {{UINT32_C(0x06F84E11), UINT32_C(0x93BD0AD8), UINT32_C(0x131AFDBF),
          UINT32_C(0x45F18F2B), UINT32_C(0x6058EB37), UINT32_C(0x881F053F),
          UINT32_C(0x948AD0D5), UINT32_C(0x36B8D656)},
         {UINT32_C(0xE1934E38), UINT32_C(0x53DC2E02), UINT32_C(0xC0435B6C),
          UINT32_C(0xA8AD5055), UINT32_C(0x4BD7154F), UINT32_C(0x0DF7BD11),
          UINT32_C(0x73BC98FC), UINT32_C(0x6350B05E)}},
    },
    {
        {{UINT32_C(0x04BF927A), UINT32_C(0x12AC5496), UINT32_C(0xE749323E),
          UINT32_C(0x9BB322DB), UINT32_C(0xF6D99AD6), UINT32_C(0xC10C666D),
          UINT32_C(0x4C883E0A), UINT32_C(0x0FDF8FB3)},
         {UINT32_C(0x665272E8), UINT32_C(0x10667F92), UINT32_C(0x5BF8702F),
          UINT32_C(0xA30D4CE1), UINT32_C(0xA2D6033D), UINT32_C(0x56314B47),
          UINT32_C(0xDAC1A10E), UINT32_C(0x09EC90D9)}},
        {{UINT32_C(0xC9EB81D1), UINT32_C(0x364F06DD), UINT32_C(0x4DC5CB76),
          UINT32_C(0xFD181A56), UINT32_C(0xE264567C), UINT32_C(0x91CF010C),
          UINT32_C(0xA05C02FC), UINT32_C(0x71D9A95B)},
         {UINT32_C(0x53967407), UINT32_C(0xAB5AFBA6), UINT32_C(0x9B0AA089),
          UINT32_C(0x3FC77913), UINT32_C(0xAF29EF02), UINT32_C(0xDF1D4912),
          UINT32_C(0x5796A0A5), UINT32_C(0x01C3D61C)}},
        {{UINT32_C(0xB376E8DE), UINT32_C(0x11503A1C), UINT32_C(0xB8B98321),
          UINT32_C(0x5CB17D6D), UINT32_C(0xBD8FE9C2), UINT32_C(0x96C9D585),
          UINT32_C(0xD117171D), UINT32_C(0x048C8DA7)},
         {UINT32_C(0xB582282A), UINT32_C(0xDF7FABB8), UINT32_C(0x24FD6BB7),
          UINT32_C(0x75C2A937), UINT32_C(0x00633701), UINT32_C(0xDF0DBD32),
          UINT32_C(0x039B3E72), UINT32_C(0x04FB7AEC)}},
        {{UINT32_C(0x0E20C09A), UINT32_C(0xE60CCE96), UINT32_C(0x116E1C38),
          UINT32_C(0xAD295B31), UINT32_C(0xC04477D0), UINT32_C(0xCA6B625D),
          UINT32_C(0xFFA32E36), UINT32_C(0x032FE03B)},
         {UINT32_C(0xE2AAABC6), UINT32_C(0x46334FEE), UINT32_C(0xDA1C6871),
          UINT32_C(0x9808B03C), UINT32_C(0xF934A482), UINT32_C(0x76D0E3AA),
          UINT32_C(0xF9CB8F97), UINT32_C(0x2B0BF54A)}},
        {{UINT32_C(0x2CA29D02), UINT32_C(0xB5D52717), UINT32_C(0xDBEACF03),
          UINT32_C(0xF9DAEAFB), UINT32_C(0x113A3811), UINT32_C(0x3786E64B),
          UINT32_C(0x5C30569D), UINT32_C(0x6A01A1A5)},
         {UINT32_C(0xBA1C28B6), UINT32_C(0x0A91E160), UINT32_C(0x929D3F05),
          UINT32_C(0x5BFA32BA), UINT32_C(0x40C51084), UINT32_C(0x1108F875),
          UINT32_C(0x42FD5AE1), UINT32_C(0x37FD2383)}},
        {{UINT32_C(0x2A79BFB8), UINT32_C(0xABF14EDE), UINT32_C(0xAA34300C),
          UINT32_C(0x08B34155), UINT32_C(0x64077041), UINT32_C(0x85C0DFA0),
          UINT32_C(0xF542D447), UINT32_C(0x3AE5D28D)},
         {UINT32_C(0xB74DC4FB), UINT32_C(0xC303A0FE), UINT32_C(0x556E0B87),
          UINT32_C(0xB75292FA), UINT32_C(0x51BDC64C), UINT32_C(0x785628B0),
          UINT32_C(0x13C579F6), UINT32_C(0x43FE786E)}},
        {{UINT32_C(0x5F08790F), UINT32_C(0xBC5898CB), UINT32_C(0x125644EC),
          UINT32_C(0xA298A59A), UINT32_C(0xB048217A), UINT32_C(0xD2D9627B),
          UINT32_C(0x7B1F23F7), UINT32_C(0x6DCEEF32)},
         {UINT32_C(0xFA7B9C6A), UINT32_C(0x7F02FC44), UINT32_C(0x73597BF7),
          UINT32_C(0x90C64960), UINT32_C(0x2CB0B3A2), UINT32_C(0x5DD7E4F4),
          UINT32_C(0x43E83553), UINT32_C(0x5EC5F92C)}},
        {{UINT32_C(0x59E2C8E9), UINT32_C(0xC06B4D49), UINT32_C(0x1DF8AD8B),
          UINT32_C(0x7DBC8218), UINT32_C(0xDAE8B6D7), UINT32_C(0x35570120),
          UINT32_C(0x0CDE2691), UINT32_C(0x4222A1BA)},
         {UINT32_C(0xC1693046), UINT32_C(0xD2F1EFA6), UINT32_C(0x7D36D9CD),
          UINT32_C(0x2707228D), UINT32_C(0x062D499C), UINT32_C(0xD668EE25),
          UINT32_C(0xCE2621A0), UINT32_C(0x7AC81BDF)}},
        {{UINT32_C(0x16F6A215), UINT32_C(0x3A9F04BB), UINT32_C(0x89E5494E),
          UINT32_C(0x739BB2BC), UINT32_C(0xD1CEB043), UINT32_C(0xCB8DBAE8),
          UINT32_C(0x09A6B465), UINT32_C(0x6B177DF0)},
         {UINT32_C(0x1A529744), UINT32_C(0xB7C4980E), UINT32_C(0x0E9012B5),
          UINT32_C(0x3941B997), UINT32_C(0x04C6D677), UINT32_C(0xDF317B95),
          UINT32_C(0x829F51D6), UINT32_C(0x17898D81)}},
        {{UINT32_C(0xA12282BA), UINT32_C(0x3D48FD66), UINT32_C(0x899E5A1A),
          UINT32_C(0xB775465B), UINT32_C(0x55D95C35), UINT32_C(0xDE0CCB99),
          UINT32_C(0x950AB9DF), UINT32_C(0x4CB3CCDD)},
         {UINT32_C(0x175C4CAE), UINT32_C(0x0B4ABA02), UINT32_C(0xCF86187C),
          UINT32_C(0x2DA7C698), UINT32_C(0x9A9BF6CA), UINT32_C(0x3A4453DF),
          UINT32_C(0x8BB9F543), UINT32_C(0x53C86F9C)}},
        {{UINT32_C(0x5B7DB133), UINT32_C(0x806B815E), UINT32_C(0x118FA7C1),
          UINT32_C(0x2451D6AC), UINT32_C(0xFB0BEFC3), UINT32_C(0x32C148B6),
          UINT32_C(0xE433031E), UINT32_C(0x2E6ECEF6)},
         {UINT32_C(0x54B2EE29), UINT32_C(0x2B78F317), UINT32_C(0x5A73BF01),
          UINT32_C(0xBC321BF9), UINT32_C(0xF8F7F981), UINT32_C(0xDF6F7840),
          UINT32_C(0x22280C40), UINT32_C(0x751A917A)}},
        {{UINT32_C(0x4F9161C8), UINT32_C(0x73EFA631), UINT32_C(0x21145C52),
          UINT32_C(0xB61C5E68), UINT32_C(0x6A04DC52), UINT32_C(0x60947773),
          UINT32_C(0x2C2073B2), UINT32_C(0x758E38FF)},
         {UINT32_C(0x03A54541), UINT32_C(0xDC6FEA73), UINT32_C(0xB6E65787),
          UINT32_C(0x5E77682C), UINT32_C(0x37370FD0), UINT32_C(0xAFEF6C1C),
          UINT32_C(0xD5AC255A), UINT32_C(0x33DEEF00)}},
        {{UINT32_C(0x061D35CC), UINT32_C(0x1AD81101), UINT32_C(0x8A77D246),
          UINT32_C(0xD55EED7D), UINT32_C(0x926E64C3), UINT32_C(0x8D59DC22),
          UINT32_C(0xAFC6FFA6), UINT32_C(0x76C9D6CE)},
         {UINT32_C(0x3F4FCC0F), UINT32_C(0x945A89B5), UINT32_C(0x9087F46A),
          UINT32_C(0x65EB52CF), UINT32_C(0xAE9F09DE), UINT32_C(0xC3380377),
          UINT32_C(0x43DFD5FB), UINT32_C(0x59067EDD)}},
        {{UINT32_C(0xCF841445), UINT32_C(0xCBB7BC66), UINT32_C(0xA3BE7C94),
          UINT32_C(0x9ED681D3), UINT32_C(0x396C6DD5), UINT32_C(0xF5CF59BE),
          UINT32_C(0xFA763634), UINT32_C(0x2598A5DC)},
         {UINT32_C(0x85CF4FDE), UINT32_C(0xAD2B445A), UINT32_C(0xA0D92F4C),
          UINT32_C(0xC8CE3F42), UINT32_C(0xF01CD0F5), UINT32_C(0x78356D5B),
          UINT32_C(0x5D50C9D7), UINT32_C(0x26E44A45)}},
        {{UINT32_C(0x4EDF35A5), UINT32_C(0x22EB53E3), UINT32_C(0xAF1A8A60),
          UINT32_C(0xA0C6CDEF), UINT32_C(0xD07C1EBD), UINT32_C(0x1D31BA2C),
          UINT32_C(0xD2C2ADE1), UINT32_C(0x513511A0)},
         {UINT32_C(0xC4449889), UINT32_C(0xBD3772D4), UINT32_C(0xD3F49C61),
          UINT32_C(0xAF5EF819), UINT32_C(0x40047745), UINT32_C(0xAAF21599),
          UINT32_C(0xA54B8080), UINT32_C(0x2128938C)}},
        {{UINT32_C(0x73ADBEC8), UINT32_C(0x9761A94A), UINT32_C(0x1FB2F257),
          UINT32_C(0x4710BBF0), UINT32_C(0xB3920007), UINT32_C(0xFE52603E),
          UINT32_C(0x7DE06F13), UINT32_C(0x66393750)},
         {UINT32_C(0x965AC706), UINT32_C(0x35F4E633), UINT32_C(0x33F953E5),
          UINT32_C(0xF49DC418), UINT32_C(0x31CFE467), UINT32_C(0x1562AD51),
          UINT32_C(0x8ADB1F7A), UINT32_C(0x035FB54D)}},
    },
    {
        {{UINT32_C(0xFD73062E), UINT32_C(0xF632081F), UINT32_C(0xCB740B59),
          UINT32_C(0xB2740C19), UINT32_C(0x8751E315), UINT32_C(0x2DFD957F),
          UINT32_C(0xC21039C2), UINT32_C(0x5722E015)},
         {UINT32_C(0xA4E56D39), UINT32_C(0x44781BFC), UINT32_C(0xDA2FBE63),
          UINT32_C(0x894BD2F7), UINT32_C(0x5DE22DE0), UINT32_C(0x9E81007B),
          UINT32_C(0xC68788FC), UINT32_C(0x0CED0859)}},
        {{UINT32_C(0x8DDA6292), UINT32_C(0x97DD8CF1), UINT32_C(0x27FCF7F1),
          UINT32_C(0x3E9191F7), UINT32_C(0xDAA6AD44), UINT32_C(0x07885E32),
          UINT32_C(0xBE9F7E62), UINT32_C(0x624CE66E)},
         {UINT32_C(0x1893A3D9), UINT32_C(0x0483DA42), UINT32_C(0x8F2A105F),
          UINT32_C(0x1041B7EA), UINT32_C(0x429A24B9), UINT32_C(0x5B706F99),
          UINT32_C(0x167C12E1), UINT32_C(0x30BFBCEE)}},
        {{UINT32_C(0xC38251D8), UINT32_C(0xEB2C7218), UINT32_C(0x022B6411),
          UINT32_C(0x5FE5D8F6), UINT32_C(0x93DCCB63), UINT32_C(0xF62200C1),
          UINT32_C(0xCFF221E6), UINT32_C(0x2CF0F8F1)},
         {UINT32_C(0x9217EE42), UINT32_C(0xDCF1BCD6), UINT32_C(0x9DB2580B),
          UINT32_C(0x1904879C), UINT32_C(0xF6510164), UINT32_C(0x2DDB7E5D),
          UINT32_C(0x8A0EAC6B), UINT32_C(0x7BB29985)}},
        {{UINT32_C(0x0FCF8397), UINT32_C(0x98313C0E), UINT32_C(0x42C8EEF1),
          UINT32_C(0xB594D0B7), UINT32_C(0x97E842F7), UINT32_C(0xBD31FC34),
          UINT32_C(0x8F3ADB9B), UINT32_C(0x49476B9D)},
         {UINT32_C(0x50B45445), UINT32_C(0xD1B5FD37), UINT32_C(0xD583A89F),
          UINT32_C(0x526C51CA), UINT32_C(0x6782C060), UINT32_C(0x5D461F09),
          UINT32_C(0x27274A60), UINT32_C(0x414023EC)}},
        {{UINT32_C(0xEAE4285A), UINT32_C(0x7C809B26), UINT32_C(0x0A066043),
          UINT32_C(0x939814BF), UINT32_C(0x6C640E3D), UINT32_C(0x9CBAC0BB),
          UINT32_C(0x30EB1B86), UINT32_C(0x647E22E1)},
         {UINT32_C(0x3C7DFA0D), UINT32_C(0x21E2A42D), UINT32_C(0xE2CD0CCE),
          UINT32_C(0xFF8CC304), UINT32_C(0x3496964C), UINT32_C(0x3DC8C920),
          UINT32_C(0x2B4DF7C2), UINT32_C(0x5D91FE78)}},
        {{UINT32_C(0x96D84346), UINT32_C(0xD5BBBD6E), UINT32_C(0xF91FFA8C),
          UINT32_C(0x8363527B), UINT32_C(0x7F408588), UINT32_C(0x931D0FDA),
          UINT32_C(0xB0B19D0F), UINT32_C(0x2C51F17B)},
         {UINT32_C(0xFF61C86D), UINT32_C(0x7A693804), UINT32_C(0xB3FFD529),
          UINT32_C(0xBAB4AC45), UINT32_C(0x4C171C84), UINT32_C(0xEDEA275F),
          UINT32_C(0xD59B94D9), UINT32_C(0x0520925C)}},
        {{UINT32_C(0xE8718BB4), UINT32_C(0xB6A620AA), UINT32_C(0x88D37A61),
          UINT32_C(0x67851F0F), UINT32_C(0x9984A787), UINT32_C(0xCBEE8DBC),
          UINT32_C(0xAE834635), UINT32_C(0x7190B766)},
         {UINT32_C(0xC9AC1A8E), UINT32_C(0x3A1D7DB4), UINT32_C(0x7B97BCB7),
          UINT32_C(0x6EEBD5AD), UINT32_C(0x9D0AB769), UINT32_C(0x60978625),
          UINT32_C(0x7C7F02DD), UINT32_C(0x5AD56C0C)}},
        {{UINT32_C(0x2DB3B6F2), UINT32_C(0x2C0003DE), UINT32_C(0xEFCF1DD8),
          UINT32_C(0x3BE1CE3F), UINT32_C(0x379E6B8A), UINT32_C(0xE2F79872),
          UINT32_C(0x0B898094), UINT32_C(0x3F9640D8)},
         {UINT32_C(0x15B29D41), UINT32_C(0x11EBD937), UINT32_C(0x3EF17D8C),
          UINT32_C(0xD6A076B9), UINT32_C(0xB38ED3BA), UINT32_C(0x0A2C0016),
          UINT32_C(0xCCB161CC), UINT32_C(0x64329A02)}},
        {{UINT32_C(0xB1ED1DEA), UINT32_C(0xD135032D), UINT32_C(0x42F734A0),
          UINT32_C(0x43F76848), UINT32_C(0x3C18D8C5), UINT32_C(0x1F6C12BD),
          UINT32_C(0xC0A304E8), UINT32_C(0x7D7757B7)},
         {UINT32_C(0xDE3B6B9F), UINT32_C(0x3F0C2867), UINT32_C(0xB7201E4F),
          UINT32_C(0x72F98EBB), UINT32_C(0x940E748D), UINT32_C(0xCC408000),
          UINT32_C(0xAD74B322), UINT32_C(0x34FE6D8F)}},
        {{UINT32_C(0xE6D884FE), UINT32_C(0xA12A9359), UINT32_C(0xDE063103),
          UINT32_C(0xB080A081), UINT32_C(0x97ABB854), UINT32_C(0x672DE27D),
          UINT32_C(0xEE6F3485), UINT32_C(0x712B0883)},
         {UINT32_C(0x2044A2A2), UINT32_C(0xF430BF2D), UINT32_C(0x7D12027A),
          UINT32_C(0x66561020), UINT32_C(0x2C539C3B), UINT32_C(0x5ED63AD2),
          UINT32_C(0xFE5EE1D1), UINT32_C(0x7982AAD0)}},
        {{UINT32_C(0x3BE94D26), UINT32_C(0x873DC8F6), UINT32_C(0x4B41BD76),
          UINT32_C(0x90923639), UINT32_C(0x0CBE4B5C), UINT32_C(0xE439A496),
          UINT32_C(0x11782BF1), UINT32_C(0x424F8D24)},
         {UINT32_C(0x49686ED9), UINT32_C(0x6612BD99), UINT32_C(0xFB04E27E),
          UINT32_C(0x78157AA9), UINT32_C(0x805F809C), UINT32_C(0x844E1616),
          UINT32_C(0x62CB8BCD), UINT32_C(0x717AEB32)}},
        {{UINT32_C(0x5248CF6A), UINT32_C(0xE98C1A0E), UINT32_C(0xB0E4ADF8),
          UINT32_C(0xC84294A8), UINT32_C(0xA7769275), UINT32_C(0xD35748A4),
          UINT32_C(0x03363C82), UINT32_C(0x2C3867E1)},
         {UINT32_C(0x8F43885A), UINT32_C(0x2EC7AF43), UINT32_C(0x3AE516C7),
          UINT32_C(0x7979D1A2), UINT32_C(0x8B81056C), UINT32_C(0x059939EC),
          UINT32_C(0x7E358480), UINT32_C(0x434AA4DD)}},
        {{UINT32_C(0x4A5228EA), UINT32_C(0x12EA1C87), UINT32_C(0x4D293B9F),
          UINT32_C(0x47B48198), UINT32_C(0xE9696688), UINT32_C(0x319CE379),
          UINT32_C(0x7CE6FD05), UINT32_C(0x7C9FF595)},
         {UINT32_C(0x3093E3E4), UINT32_C(0x15E954DF), UINT32_C(0x304015AF),
          UINT32_C(0xBC98307C), UINT32_C(0x975C69C5), UINT32_C(0x66522DF8),
          UINT32_C(0x963CE892), UINT32_C(0x4C9EBFB3)}},
        {{UINT32_C(0x628FB125), UINT32_C(0x1CEEF18A), UINT32_C(0x4BF30BB6),
          UINT32_C(0xFB69A234), UINT32_C(0x70C9C864), UINT32_C(0x510EB339),
          UINT32_C(0x8A89151D), UINT32_C(0x1EE9D1ED)},
         {UINT32_C(0x4EE1A486), UINT32_C(0x34094028), UINT32_C(0x2FC79CEE),
          UINT32_C(0x66440167), UINT32_C(0xC7DA3A75), UINT32_C(0xB597625A),
          UINT32_C(0x65205AF9), UINT32_C(0x6E5B920E)}},
        {{UINT32_C(0xD87C914C), UINT32_C(0x749D0CA4), UINT32_C(0x0D60C59E),
          UINT32_C(0x55ECBEBB), UINT32_C(0xA65B4652), UINT32_C(0x916A1127),
          UINT32_C(0x4E4767A3), UINT32_C(0x503964D4)},
         {UINT32_C(0x1B1F94D5), UINT32_C(0x8899A4C2), UINT32_C(0x33E0D94D),
          UINT32_C(0xEFFCAF52), UINT32_C(0xA3DAD87D), UINT32_C(0x61B89B3F),
          UINT32_C(0x5088D6BE), UINT32_C(0x3CB455F5)}},
        {{UINT32_C(0x70678C14), UINT32_C(0x5088A52B), UINT32_C(0x41B00FC3),
          UINT32_C(0x212823D9), UINT32_C(0x19865BDB), UINT32_C(0x38D5CEB6),
          UINT32_C(0x12E63491), UINT32_C(0x2E9C7FD7)},
         {UINT32_C(0x59E73913), UINT32_C(0x6656F916), UINT32_C(0xE9035A63),
          UINT32_C(0x57AE9A47), UINT32_C(0xF02B8DAE), UINT32_C(0x970DCF2B),
          UINT32_C(0x950FF8A9), UINT32_C(0x3366F8A6)}},
    },
    {
        {{UINT32_C(0xAC4A8F83), UINT32_C(0x93DABD6F), UINT32_C(0x1CFF0AAD),
          UINT32_C(0x27233488), UINT32_C(0xF500EDFB), UINT32_C(0xBCAC3181),
          UINT32_C(0xB5297515), UINT32_C(0x27C6DB15)},
         {UINT32_C(0x2F08A89F), UINT32_C(0x9CD142D9), UINT32_C(0x2EAD0A80),
          UINT32_C(0x3C005423), UINT32_C(0x44A7623A), UINT32_C(0x82845F95),
          UINT32_C(0x72BC4862), UINT32_C(0x51047070)}},
        {{UINT32_C(0xDC1B9159), UINT32_C(0x4303797A), UINT32_C(0x5D9C9AC1),
          UINT32_C(0x7842434B), UINT32_C(0x6009FE2E), UINT32_C(0x8A36ED2D),
          UINT32_C(0x5106429C), UINT32_C(0x11FE35C9)},
         {UINT32_C(0x23554A92), UINT32_C(0xDF20A393), UINT32_C(0x932E37C2),
          UINT32_C(0x59364A48), UINT32_C(0x7754A5DF), UINT32_C(0x6D7DE6AE),
          UINT32_C(0x462725AC), UINT32_C(0x00CCC6A3)}},
        {{UINT32_C(0xBAE83077), UINT32_C(0xB1F86CA5), UINT32_C(0x5110782C),
          UINT32_C(0x82FE28A5), UINT32_C(0xD942182C), UINT32_C(0x8031BBF3),
          UINT32_C(0x410D9F83), UINT32_C(0x4F1F3815)},
         {UINT32_C(0x835ABA65), UINT32_C(0xE57F9907), UINT32_C(0x5AA10903),
          UINT32_C(0x0A8220C2), UINT32_C(0x8812602E), UINT32_C(0x2E984717),
          UINT32_C(0x2A7D2C6C), UINT32_C(0x0AEC467D)}},
        {{UINT32_C(0xC4DBED03), UINT32_C(0xC779F708), UINT32_C(0x8582BD4E),
          UINT32_C(0x10A30CD8), UINT32_C(0x243FEAEE), UINT32_C(0xFA5646C5),
          UINT32_C(0xCA459EF7), UINT32_C(0x1CFAF38E)},
         {UINT32_C(0x95BC8077), UINT32_C(0xCCDD0146), UINT32_C(0x65858C49),
          UINT32_C(0x4ECDE919), UINT32_C(0x77FEE1B6), UINT32_C(0x562764C6),
          UINT32_C(0x43524407), UINT32_C(0x3CF5A3AB)}},
        {{UINT32_C(0x0F6EF445), UINT32_C(0x0CCEAADD), UINT32_C(0xC297AFAF),
          UINT32_C(0x690C12C1), UINT32_C(0xC15B3D7B), UINT32_C(0xD67AA6EA),
          UINT32_C(0x9FF8884E), UINT32_C(0x445D233C)},
         {UINT32_C(0x6CAD3234), UINT32_C(0xC38FFD09), UINT32_C(0xC7002F6F),
          UINT32_C(0xA690FFD1), UINT32_C(0x11ACB469), UINT32_C(0xD445E851),
          UINT32_C(0x97166E52), UINT32_C(0x64EE1380)}},
        {{UINT32_C(0xCEFBFB0A), UINT32_C(0x1EB031CC), UINT32_C(0xAA40D6A9),
          UINT32_C(0x60F3DEF4), UINT32_C(0xF96FCAFE), UINT32_C(0x240F7CA5),
          UINT32_C(0xE4450A06), UINT32_C(0x53AF2F10)},
         {UINT32_C(0xA84058EF), UINT32_C(0xE8AF980F), UINT32_C(0x34AFFC6E),
          UINT32_C(0x3E300017), UINT32_C(0xC86B458C), UINT32_C(0x62D1D094),
          UINT32_C(0x75732C7E), UINT32_C(0x5338383D)}},
        {{UINT32_C(0x04D82638), UINT32_C(0x6BD46AEB), UINT32_C(0x62E645A0),
          UINT32_C(0x86940A31), UINT32_C(0xA5736B40), UINT32_C(0xD025B4B1),
          UINT32_C(0x924E8E5E), UINT32_C(0x1056D9D0)},
         {UINT32_C(0x1DB58101), UINT32_C(0x3D0495CC), UINT32_C(0x2D677581),
          UINT32_C(0xC300C6E7), UINT32_C(0x610AECEC), UINT32_C(0xFE38B898),
          UINT32_C(0xD66F64ED), UINT32_C(0x1C8B94E2)}},
        {{UINT32_C(0x06D0C7EC), UINT32_C(0x5C9C3A37), UINT32_C(0xB8A74918),
          UINT32_C(0x6B4B5437), UINT32_C(0x9052A235), UINT32_C(0x85689C98),
          UINT32_C(0x87B53AA6), UINT32_C(0x4F7C2C8D)},
         {UINT32_C(0xD8F1D334), UINT32_C(0x9FCD866F), UINT32_C(0x6898223C),
          UINT32_C(0xDBAAA227), UINT32_C(0x95C7B35A), UINT32_C(0x933DE9DA),
          UINT32_C(0x3EA949FD), UINT32_C(0x329AE20F)}},
        {{UINT32_C(0x948A2ECD), UINT32_C(0xB83547AF), UINT32_C(0xBE34890C),
          UINT32_C(0xEBF7C1E7), UINT32_C(0xF8211C33), UINT32_C(0x5F0F44F3),
          UINT32_C(0xC6927638), UINT32_C(0x14A10BDB)},
         {UINT32_C(0x5B579BF5), UINT32_C(0x7FD88567), UINT32_C(0x5B7417F0),
          UINT32_C(0xD7C71281), UINT32_C(0x2083502E), UINT32_C(0x7C04F111),
          UINT32_C(0xE9AD6283), UINT32_C(0x42029128)}},
        {{UINT32_C(0x2C5C0928), UINT32_C(0x32FBFFAE), UINT32_C(0x1469F1D3),
          UINT32_C(0x4E31D312), UINT32_C(0xD79F51A2), UINT32_C(0x17307E28),
          UINT32_C(0x79A51EBD), UINT32_C(0x546C91AF)},
         {UINT32_C(0x668086A6), UINT32_C(0x041D464D), UINT32_C(0x0DB695DB),
          UINT32_C(0x4986BDE5), UINT32_C(0xEF317AA0), UINT32_C(0xCBA5F6EE),
          UINT32_C(0x730221D3), UINT32_C(0x5879259F)}},
        {{UINT32_C(0x253BB4BA), UINT32_C(0xBD9C5CA5), UINT32_C(0x0E2A75BB),
          UINT32_C(0xBBFC6079), UINT32_C(0x67AB9033), UINT32_C(0xB5F11AE3),
          UINT32_C(0xAC2BFAFE), UINT32_C(0x6411CB1E)},
         {UINT32_C(0xBF5390B0), UINT32_C(0x750734FE), UINT32_C(0x879A3D3D),
          UINT32_C(0xA044BED4), UINT32_C(0xA0C47093), UINT32_C(0xE1E9F0E4),
          UINT32_C(0xB64DA48C), UINT32_C(0x3BCAD93E)}},
        {{UINT32_C(0xB37E16C2), UINT32_C(0xAFC6BCB6), UINT32_C(0x2331B0CD),
          UINT32_C(0xB54F56C0), UINT32_C(0x5BBFBEE7), UINT32_C(0x725E81B4),
          UINT32_C(0xE8B9D922), UINT32_C(0x2AE0C039)},
         {UINT32_C(0xDB958319), UINT32_C(0x85301041), UINT32_C(0x0681C4A4),
          UINT32_C(0xDFAE34DD), UINT32_C(0xCBF7BB2B), UINT32_C(0x906C9219),
          UINT32_C(0x10A1710A), UINT32_C(0x1463E9EF)}},
        {{UINT32_C(0x21E6FC9D), UINT32_C(0x41E6C388), UINT32_C(0x24A39EC8),
          UINT32_C(0x0B629A1E), UINT32_C(0x1AEF7A46), UINT32_C(0xC62F60BE),
          UINT32_C(0xC5A16B6E), UINT32_C(0x59A50B54)},
         {UINT32_C(0x285B891E), UINT32_C(0x41CA367A), UINT32_C(0xE2F8AF59),
          UINT32_C(0x70A6CE6B), UINT32_C(0xCBCEEF98), UINT32_C(0x74058747),
          UINT32_C(0x601C375F), UINT32_C(0x4B912170)}},
        {{UINT32_C(0x734EE866), UINT32_C(0x7D975CE2), UINT32_C(0xA09F5F14),
          UINT32_C(0x8D3572C6), UINT32_C(0x2232EE5E), UINT32_C(0x1DB4CC88),
          UINT32_C(0x7C04C250), UINT32_C(0x6C979049)},
         {UINT32_C(0xAE1EBC20), UINT32_C(0xB5EC7706), UINT32_C(0xE21AAA32),
          UINT32_C(0x7BDBD34D), UINT32_C(0xC5D1C733), UINT32_C(0xAD4125FD),
          UINT32_C(0x731E6B09), UINT32_C(0x28B0302D)}},
        {{UINT32_C(0x1521415E), UINT32_C(0xD68EEC49), UINT32_C(0x092763C0),
          UINT32_C(0x31963424), UINT32_C(0x0BFB513B), UINT32_C(0xCA90F48D),
          UINT32_C(0x573A056A), UINT32_C(0x4814DDFF)},
         {UINT32_C(0x400E804D), UINT32_C(0x7E67599C), UINT32_C(0x51FD0596),
          UINT32_C(0x35452750), UINT32_C(0xDB331B66), UINT32_C(0x45EDD7FB),
          UINT32_C(0xBDEDE107), UINT32_C(0x172DA8B3)}},
        {{UINT32_C(0xB5BEB1C8), UINT32_C(0xD46F284C), UINT32_C(0x7B125701),
          UINT32_C(0x5DE5D3F1), UINT32_C(0x248053D1), UINT32_C(0xC3BA591E),
          UINT32_C(0x9C8F487C), UINT32_C(0x4E67F1F2)},
         {UINT32_C(0x8C252EC5), UINT32_C(0x380D93E4), UINT32_C(0x22BC5CF6),
          UINT32_C(0x913F96F1), UINT32_C(0xD7BAA634), UINT32_C(0xC1F06BBD),
          UINT32_C(0xA30BF1B9), UINT32_C(0x7B625179)}},
    },
    {
        {{UINT32_C(0xABD424AC), UINT32_C(0x125D398D), UINT32_C(0x9CC70479),
          UINT32_C(0xFE65DF03), UINT32_C(0xFB5EC82C), UINT32_C(0x89A31794),
          UINT32_C(0xA31C5DCA), UINT32_C(0x63EFFB55)},
         {UINT32_C(0x045B576A), UINT32_C(0x948F7571), UINT32_C(0x022B5FC8),
          UINT32_C(0xEC9F6FAB), UINT32_C(0xBD9F0DD2), UINT32_C(0x174DC936),
          UINT32_C(0xF4C4EE8B), UINT32_C(0x5EEA65E6)}},
        {{UINT32_C(0x8B800D67), UINT32_C(0xE97070AE), UINT32_C(0xB59B433E),
          UINT32_C(0xB9CB66FA), UINT32_C(0xC6141364), UINT32_C(0xC4496574),
          UINT32_C(0x6A9677EA), UINT32_C(0x530AA9B5)},
         {UINT32_C(0x75200533), UINT32_C(0x4A4E2EE3), UINT32_C(0x0F20A9BE),
          UINT32_C(0x4C38A509), UINT32_C(0xEA683510), UINT32_C(0x0A6FFBA4),
          UINT32_C(0x65732EA9), UINT32_C(0x7340EFEE)}},
        {{UINT32_C(0xE41C2B43), UINT32_C(0x3A5612E4), UINT32_C(0xFCB5C0A8),
          UINT32_C(0x31F51B80), UINT32_C(0xBD1F03E6), UINT32_C(0x4C5BBA64),
          UINT32_C(0x3694ADCA), UINT32_C(0x25387243)},
         {UINT32_C(0x1F7E4D5C), UINT32_C(0xF114EFAF), UINT32_C(0x4EA3A59D),
          UINT32_C(0xBEA5223A), UINT32_C(0x67EB414D), UINT32_C(0x82CEF46F),
          UINT32_C(0x9B6CAC3D), UINT32_C(0x09D351C1)}},
        {{UINT32_C(0x810F5054), UINT32_C(0xC69F25CE), UINT32_C(0x548A2CDF),
          UINT32_C(0xE33E5E97), UINT32_C(0x36946D3C), UINT32_C(0x20B3F442),
          UINT32_C(0x65DF2D3B), UINT32_C(0x572C0F5C)},
         {UINT32_C(0xCC953CC8), UINT32_C(0xFC5B2DF3), UINT32_C(0xD1CCADC6),
          UINT32_C(0x934D54C0), UINT32_C(0xA6E7B4DB), UINT32_C(0x828A906E),
          UINT32_C(0x5AD3076F), UINT32_C(0x610D36C1)}},
        {{UINT32_C(0x74F56E27), UINT32_C(0x960B0A01), UINT32_C(0xCF3FEA75),
          UINT32_C(0x9942C6AC), UINT32_C(0x82C51490), UINT32_C(0x2E4D786D),
          UINT32_C(0x9A4749C9), UINT32_C(0x23A51636)},
         {UINT32_C(0x2F7560FC), UINT32_C(0xD86AB36A), UINT32_C(0xDDB852A9),
          UINT32_C(0xDA66B49D), UINT32_C(0x544C1023), UINT32_C(0x84E1587D),
          UINT32_C(0x6AA3C1DA), UINT32_C(0x7AB8BC69)}},
        {{UINT32_C(0xA5F30701), UINT32_C(0xFD0397AF), UINT32_C(0xDFC8B187),
          UINT32_C(0x96FFB15D), UINT32_C(0x1475E520), UINT32_C(0xF2C86453),
          UINT32_C(0xEF37300E), UINT32_C(0x71521986)},
         {UINT32_C(0x68006D45), UINT32_C(0xD81F75A8), UINT32_C(0xCBC06D4D),
          UINT32_C(0xDF7814EA), UINT32_C(0x2E8E9150), UINT32_C(0x5BCF959B),
          UINT32_C(0x56668C18), UINT32_C(0x146D37D7)}},
        {{UINT32_C(0x88E8DC77), UINT32_C(0x1ABD7312), UINT32_C(0xC1C3A4DB),
          UINT32_C(0x0B34B877), UINT32_C(0xF844BACE), UINT32_C(0x85739093),
          UINT32_C(0x04A7CF80), UINT32_C(0x5DEDCF8F)},
         {UINT32_C(0xD87CDBDC), UINT32_C(0xD8BB237E), UINT32_C(0xCCBA784F),
          UINT32_C(0x89852174), UINT32_C(0xB2FAECC3), UINT32_C(0x6843BAB8),
          UINT32_C(0xAA4BBA32), UINT32_C(0x15268302)}},
        {{UINT32_C(0xB23D3770), UINT32_C(0x3B58225A), UINT32_C(0x10CC9DE6),
          UINT32_C(0x9357EB59), UINT32_C(0x42ECF80E), UINT32_C(0x8665F92A),
          UINT32_C(0xC875C031), UINT32_C(0x4819CC9D)},
         {UINT32_C(0xC34B979B), UINT32_C(0x09CBE5D8), UINT32_C(0x7E1D0E63),
          UINT32_C(0x161E8AC0), UINT32_C(0x282E36E8), UINT32_C(0x874DF24F),
          UINT32_C(0x0712A0CD), UINT32_C(0x6528E6FA)}},
        {{UINT32_C(0x107633E4), UINT32_C(0xE37AD786), UINT32_C(0xCF1FE646),
          UINT32_C(0x122D7123), UINT32_C(0xCFA93AC0), UINT32_C(0x1E6E682B),
          UINT32_C(0x276200DB), UINT32_C(0x0A25F4EE)},
         {UINT32_C(0xE25FBB01), UINT32_C(0x44E290ED), UINT32_C(0xC3C1B418),
          UINT32_C(0x3E392DF5), UINT32_C(0x83EBE689), UINT32_C(0xE5E15745),
          UINT32_C(0x4B999926), UINT32_C(0x016139D2)}},
        {{UINT32_C(0x65D7DA58), UINT32_C(0x048915B0), UINT32_C(0xA78F3D9E),
          UINT32_C(0x6EF7C4EF), UINT32_C(0xAD614974), UINT32_C(0x78CCCE55),
          UINT32_C(0x54B95643), UINT32_C(0x43DB7DA0)},
         {UINT32_C(0xE53F1A67), UINT32_C(0xFC423B70), UINT32_C(0x4EFE2427),
          UINT32_C(0x8F8BED81), UINT32_C(0x95B045EB), UINT32_C(0xF5D6AD5F),
          UINT32_C(0xD7407716), UINT32_C(0x23582D5D)}},
        {{UINT32_C(0x9F674472), UINT32_C(0x9E5D24FB), UINT32_C(0x68626041),
          UINT32_C(0x1AE18636), UINT32_C(0x7ABC4380), UINT32_C(0x8977E68F),
          UINT32_C(0x05AF2D04), UINT32_C(0x7D9FF8E8)},
         {UINT32_C(0x4197C4E1), UINT32_C(0x9D31195F), UINT32_C(0x4400F35E),
          UINT32_C(0x9F3F6E11), UINT32_C(0x7BBEF801), UINT32_C(0x1A87D586),
          UINT32_C(0x952BB025), UINT32_C(0x42AE0380)}},
        {{UINT32_C(0x6B96482B), UINT32_C(0xC6A3ED75), UINT32_C(0xA9C6DD2F),
          UINT32_C(0x58B38724), UINT32_C(0x9297FB47), UINT32_C(0x464C8CE8),
          UINT32_C(0xFB6D6C55), UINT32_C(0x0245797E)},
         {UINT32_C(0xC0B58C8F), UINT32_C(0xBE141C80), UINT32_C(0x77766C48),
          UINT32_C(0xC4C405CB), UINT32_C(0xD10C0F31), UINT32_C(0xD57EE428),
          UINT32_C(0x50E8FE7B), UINT32_C(0x03D4862B)}},
        {{UINT32_C(0x1DC3722C), UINT32_C(0x21976F8A), UINT32_C(0x5F476F0D),
          UINT32_C(0x02EC30D5), UINT32_C(0xCA434B06), UINT32_C(0xD711E01D),
          UINT32_C(0x99FF2488), UINT32_C(0x551AC910)},
         {UINT32_C(0xA56CA3C7), UINT32_C(0x24AEC72D), UINT32_C(0x891896CE),
          UINT32_C(0x2DD1219A), UINT32_C(0x67882925), UINT32_C(0xD84BAD19),
          UINT32_C(0x9D4778EF), UINT32_C(0x27E65D7F)}},
        {{UINT32_C(0x4685687F), UINT32_C(0x09F19C8F), UINT32_C(0xBBB58BD3),
          UINT32_C(0xB7C7B9E3), UINT32_C(0x8FA34DD5), UINT32_C(0x349D03A7),
          UINT32_C(0x8D59E889), UINT32_C(0x41F9D003)},
         {UINT32_C(0x2B3ED6FA), UINT32_C(0xCF3367D4), UINT32_C(0x378DA1ED),
          UINT32_C(0xCF3C6715), UINT32_C(0x4E935E9A), UINT32_C(0x86DC3903),
          UINT32_C(0xF08CB23A), UINT32_C(0x50692CFF)}},
        {{UINT32_C(0xC2D65C87), UINT32_C(0x18CA772A), UINT32_C(0x4F1D0CB6),
          UINT32_C(0xC9092B38), UINT32_C(0xBBD2015A), UINT32_C(0x91E71CF1),
          UINT32_C(0x4F3DEF26), UINT32_C(0x4A09DAAC)},
         {UINT32_C(0x735C9281), UINT32_C(0x7CCA7B4A), UINT32_C(0x1BF0AAEE),
          UINT32_C(0x2028F144), UINT32_C(0xACB5B748), UINT32_C(0xCF72A082),
          UINT32_C(0x43299B85), UINT32_C(0x58957D5D)}},
        {{UINT32_C(0x901F1789), UINT32_C(0x64BB164E), UINT32_C(0x5AEF97BF),
          UINT32_C(0xC68766E6), UINT32_C(0x942B6DCE), UINT32_C(0x30ECA3E2),
          UINT32_C(0xF9E798F3), UINT32_C(0x632676FA)},
         {UINT32_C(0xF13896EE), UINT32_C(0xB52533D3), UINT32_C(0x2D8A29C1),
          UINT32_C(0xAD912831), UINT32_C(0xBC14E7FF), UINT32_C(0x12F1B9A4),
          UINT32_C(0x8828D196), UINT32_C(0x4E1D23FD)}},
    },
    {
        {{UINT32_C(0xEF494793), UINT32_C(0xC4F89E00), UINT32_C(0xC93D2F55),
          UINT32_C(0xA6044BC3), UINT32_C(0x8797F8AF), UINT32_C(0x68E60B58),
          UINT32_C(0x841E4B5E), UINT32_C(0x4D5969FA)},
         {UINT32_C(0xD759BB2D), UINT32_C(0xB1EE70FB), UINT32_C(0x66D8AD01),
          UINT32_C(0x9AC30433), UINT32_C(0x84E9F677), UINT32_C(0xD93F23DB),
          UINT32_C(0xC53029A4), UINT32_C(0x2AD9D16F)}},
        {{UINT32_C(0xDD882D23), UINT32_C(0xD01FC16B), UINT32_C(0xFA5B4128),
          UINT32_C(0x3BF921F1), UINT32_C(0x235BC9CE), UINT32_C(0x3D3FE145),
          UINT32_C(0x62E686E1), UINT32_C(0x59556716)},
         {UINT32_C(0x79F99D69), UINT32_C(0xE329A7C2), UINT32_C(0xA4F5F5F5),
          UINT32_C(0xA67EF5EC), UINT32_C(0xD5A34FF0), UINT32_C(0xF96A41EE),
          UINT32_C(0x74674B5F), UINT32_C(0x09D0CF06)}},
        {{UINT32_C(0x6135B7E2), UINT32_C(0x8CCDF71C), UINT32_C(0xAFB6AD6B),
          UINT32_C(0x91F1E33E), UINT32_C(0xDB0CFEDF), UINT32_C(0xC452F439),
          UINT32_C(0xC05B06D4), UINT32_C(0x15724711)},
         {UINT32_C(0xA3BC1277), UINT32_C(0x5FEE0E0E), UINT32_C(0x8D8BA081),
          UINT32_C(0xD6847FAD), UINT32_C(0x0D4C8DDD), UINT32_C(0x8B02666C),
          UINT32_C(0xC35559DB), UINT32_C(0x149E5009)}},
        {{UINT32_C(0x5461D9CA), UINT32_C(0xB4D0D2C9), UINT32_C(0xCE0A3973),
          UINT32_C(0xFE7993B6), UINT32_C(0xD6032E95), UINT32_C(0x42B2A500),
          UINT32_C(0x217131C6), UINT32_C(0x4DEEE35A)},
         {UINT32_C(0xFFE7C2EB), UINT32_C(0x94E65C8C), UINT32_C(0xB19D4B4A),
          UINT32_C(0x0DAD7785), UINT32_C(0x925613F9), UINT32_C(0xEEBA6794),
          UINT32_C(0xE30494CB), UINT32_C(0x6AF45BBE)}},
        {{UINT32_C(0x32F43F67), UINT32_C(0x41352A61), UINT32_C(0x48F886D3),
          UINT32_C(0x0D218DE9), UINT32_C(0x9B33B0F6), UINT32_C(0xCDFC0C55),
          UINT32_C(0x6C5B90CD), UINT32_C(0x21FC6353)},
         {UINT32_C(0x7898AFF2), UINT32_C(0x5D8CA5AD), UINT32_C(0x24287C30),
          UINT32_C(0xA743F80E), UINT32_C(0x9084A3A2), UINT32_C(0x4D037131),
          UINT32_C(0xB5EFC978), UINT32_C(0x52041EED)}},
        {{UINT32_C(0xCC1BCFCB), UINT32_C(0x80B588EE), UINT32_C(0xE5CE0035),
          UINT32_C(0xAD871A11), UINT32_C(0xF966D746), UINT32_C(0xF47224D0),
          UINT32_C(0xB387FCC2), UINT32_C(0x5215A9D2)},
         {UINT32_C(0x695C02AF), UINT32_C(0xC54EB2E7), UINT32_C(0xDFC8493D),
          UINT32_C(0x36FD06BC), UINT32_C(0x98CE7C76), UINT32_C(0x1CE8A9AA),
          UINT32_C(0x644D398B), UINT32_C(0x058DFCBF)}},
        {{UINT32_C(0x5BB81464), UINT32_C(0xCD7E67DC), UINT32_C(0x047A7789),
          UINT32_C(0xE7A19301), UINT32_C(0x573E837B), UINT32_C(0xCCC31EE5),
          UINT32_C(0xAF7703D5), UINT32_C(0x25EE99AF)},
         {UINT32_C(0xDDB3E807), UINT32_C(0x34FDD6DA), UINT32_C(0x109092DD),
          UINT32_C(0x273D8288), UINT32_C(0xB7357633), UINT32_C(0xF8F2464F),
          UINT32_C(0xCCAA31D5), UINT32_C(0x26B2CBAD)}},
        {{UINT32_C(0xF707F9F7), UINT32_C(0xBA9CFEDE), UINT32_C(0xAC4975FB),
          UINT32_C(0xA9A6896C), UINT32_C(0xBB1C35E4), UINT32_C(0x62135D9D),
          UINT32_C(0xCBA133D2), UINT32_C(0x13AE840F)},
         {UINT32_C(0x4C2BA3A9), UINT32_C(0x6ABF3913), UINT32_C(0x6D8A62C1),
          UINT32_C(0xE4D8508A), UINT32_C(0x66D96607), UINT32_C(0xF2565354),
          UINT32_C(0xB6CABAE8), UINT32_C(0x5C368CCE)}},
        {{UINT32_C(0x8B3999BB), UINT32_C(0x0C3B52E8), UINT32_C(0xEF691871),
          UINT32_C(0xB752E28F), UINT32_C(0xF17D0D2D), UINT32_C(0xA0460ABC),
          UINT32_C(0xB7741F2C), UINT32_C(0x7DDCE3C1)},
         {UINT32_C(0x3673000F), UINT32_C(0x076A6BAB), UINT32_C(0x425E8A9D),
          UINT32_C(0xCDB1CD2B), UINT32_C(0x2606EAB5), UINT32_C(0x357FCFFF),
          UINT32_C(0x035DE7B4), UINT32_C(0x308644F8)}},
        {{UINT32_C(0x6D6FF45E), UINT32_C(0xBA64A127), UINT32_C(0x6B0C3CEF),
          UINT32_C(0x1F52B6AE), UINT32_C(0xCBF496CB), UINT32_C(0x91295179),
          UINT32_C(0xA1B12BE4), UINT32_C(0x2B986FAD)},
         {UINT32_C(0x44DBAF57), UINT32_C(0x243D2366), UINT32_C(0x346E88C2),
          UINT32_C(0x48E22BBA), UINT32_C(0x8BBAFA0D), UINT32_C(0xCDFB7957),
          UINT32_C(0x0D70670E), UINT32_C(0x094ED36E)}},
        {{UINT32_C(0xA0D60407), UINT32_C(0x2BAD1539), UINT32_C(0x6E744111),
          UINT32_C(0xC1A9286E), UINT32_C(0x81A6DCAA), UINT32_C(0x6D08C0DB),
          UINT32_C(0x80AFB34F), UINT32_C(0x108F35EC)},
         {UINT32_C(0x1E3E34AE), UINT32_C(0xBE79A6E3), UINT32_C(0x16D524E5),
          UINT32_C(0x206EAA28), UINT32_C(0x344ABA64), UINT32_C(0x563B6E1C),
          UINT32_C(0x3207CA68), UINT32_C(0x6C362A61)}},
        {{UINT32_C(0xEF9A9A0F), UINT32_C(0x04D8145B), UINT32_C(0xA15B6247),
          UINT32_C(0x8B57559B), UINT32_C(0x303AFBF3), UINT32_C(0x72D53570),
          UINT32_C(0xD6DB5736), UINT32_C(0x01C36B41)},
         {UINT32_C(0x1173B5FA), UINT32_C(0x94D583C9), UINT32_C(0x013C8AAA),
          UINT32_C(0x71F8E12D), UINT32_C(0xF29CB838), UINT32_C(0xA4B5A532),
          UINT32_C(0x7CE4EBA4), UINT32_C(0x4B179700)}},
        {{UINT32_C(0x0CE86FC3), UINT32_C(0x69CFA7B0), UINT32_C(0xD60E076C),
          UINT32_C(0x3705D7C0), UINT32_C(0xB1091E10), UINT32_C(0xB1A1464A),
          UINT32_C(0x7FE80950), UINT32_C(0x097945A9)},
         {UINT32_C(0x9AA381E3), UINT32_C(0xD9C71A95), UINT32_C(0xA410FF56),
          UINT32_C(0x2A929073), UINT32_C(0xF0FEB121), UINT32_C(0x79EF8353),
          UINT32_C(0x5F3107E5), UINT32_C(0x1437C4B0)}},
        {{UINT32_C(0x621DB2E5), UINT32_C(0xC5128C8B), UINT32_C(0x51A9499A),
          UINT32_C(0x4E9C9B2E), UINT32_C(0xD8CD7594), UINT32_C(0x11535880),
          UINT32_C(0xB0697C07), UINT32_C(0x35A26F59)},
         {UINT32_C(0xC43B624E), UINT32_C(0xAB3F4B75), UINT32_C(0xB8E03E6B),
          UINT32_C(0x69F82105), UINT32_C(0xFB04E036), UINT32_C(0xFB268288),
          UINT32_C(0xA0BDB41C), UINT32_C(0x6A5E6BD3)}},
        {{UINT32_C(0xC8082916), UINT32_C(0x8C716A1A), UINT32_C(0x4592472C),
          UINT32_C(0xB1D1B152), UINT32_C(0x3AB6938A), UINT32_C(0x63657A6D),
          UINT32_C(0xF03214AE), UINT32_C(0x44882EB6)},
         {UINT32_C(0xC615AF7D), UINT32_C(0x19575B8A), UINT32_C(0x35EE3D98),
          UINT32_C(0x14D740C1), UINT32_C(0x57768D2D), UINT32_C(0xBC478E89),
          UINT32_C(0x13FC5E4C), UINT32_C(0x30CC8FA2)}},
        {{UINT32_C(0x4EBE1E7C), UINT32_C(0x705607C5), UINT32_C(0x284EDA2B),
          UINT32_C(0x631E5B88), UINT32_C(0x07F54DDB), UINT32_C(0x07E9E39C),
          UINT32_C(0x8DCF6BC5), UINT32_C(0x4E554D88)},
         {UINT32_C(0x0CBAB0FE), UINT32_C(0x12E9FB20), UINT32_C(0xBA5E007F),
          UINT32_C(0x6F3BC7CE), UINT32_C(0xBC871DF6), UINT32_C(0xA770BA1D),
          UINT32_C(0xFE01142C), UINT32_C(0x541AA4C6)}},
    },
    {
        {{UINT32_C(0xF2412EC7), UINT32_C(0xBFE26700), UINT32_C(0xCFE96AF4),
          UINT32_C(0x0E975796), UINT32_C(0xDD6B04F7), UINT32_C(0x7D30BF7C),
          UINT32_C(0xF1D8FCE4), UINT32_C(0x5421925D)},
         {UINT32_C(0xEC709107), UINT32_C(0x1CF5E9F5), UINT32_C(0xB4580AA9),
          UINT32_C(0x124FCFC2), UINT32_C(0x67A835B3), UINT32_C(0x02F7012B),
          UINT32_C(0x47C0760F), UINT32_C(0x753FE01B)}},
        {{UINT32_C(0xB1D2A896), UINT32_C(0x82FD5D47), UINT32_C(0x54E75DDB),
          UINT32_C(0x7EABC175), UINT32_C(0x1AB080BC), UINT32_C(0x724FC3A8),
          UINT32_C(0xA75C31DD), UINT32_C(0x363D6016)},
         {UINT32_C(0x863F308F), UINT32_C(0x5D465FF2), UINT32_C(0xE515ADCB),
          UINT32_C(0x9EC70664), UINT32_C(0xB3BC206A), UINT32_C(0x4BD7A1A2),
          UINT32_C(0x4A167D34), UINT32_C(0x2022576C)}},
        {{UINT32_C(0x5CD6AC65), UINT32_C(0xF5AC3451), UINT32_C(0x5839F554),
          UINT32_C(0x7629731E), UINT32_C(0x93545A60), UINT32_C(0xA3260AE3),
          UINT32_C(0xA7AD1979), UINT32_C(0x49D190E8)},
         {UINT32_C(0xF0B35045), UINT32_C(0x5AA8492F), UINT32_C(0x2584E651),
          UINT32_C(0x4A5FAB7B), UINT32_C(0x395E2AAE), UINT32_C(0x5A05420E),
          UINT32_C(0x547B4038), UINT32_C(0x30613C78)}},
        {{UINT32_C(0xF9DAE7E6), UINT32_C(0x47E1C59D), UINT32_C(0x247A5A9D),
          UINT32_C(0x8D68839B), UINT32_C(0xC1A80D5E), UINT32_C(0x663B5977),
          UINT32_C(0x40D8CF32), UINT32_C(0x5E51F872)},
         {UINT32_C(0xECE49494), UINT32_C(0x88ADBF9E), UINT32_C(0x1792BAE8),
          UINT32_C(0x40B4AC5C), UINT32_C(0x9A1B3314), UINT32_C(0x278200D1),
          UINT32_C(0xD9F83584), UINT32_C(0x7D15320E)}},
        {{UINT32_C(0xEAF2BFF8), UINT32_C(0xFE6DAA74), UINT32_C(0xC156AA6B),
          UINT32_C(0x6E4EE4C0), UINT32_C(0xD0F4E7D5), UINT32_C(0xD9310FF8),
          UINT32_C(0x7BB0C42D), UINT32_C(0x552EEF9E)},
         {UINT32_C(0xFDC69E1A), UINT32_C(0x323FF6F1), UINT32_C(0x41D79365),
          UINT32_C(0x00FA66B7), UINT32_C(0xA96B22B4), UINT32_C(0x0006B16E),
          UINT32_C(0xD20F07BE), UINT32_C(0x71BBC653)}},
        {{UINT32_C(0xA440FA1C), UINT32_C(0x89A7B7EE), UINT32_C(0x757CD658),
          UINT32_C(0x52BB5278), UINT32_C(0xB0CDDEA4), UINT32_C(0xC5906F4B),
          UINT32_C(0x5DE2D8DA), UINT32_C(0x66AAAFEE)},
         {UINT32_C(0x53B6E226), UINT32_C(0x4D5E016A), UINT32_C(0x1993A1D7),
          UINT32_C(0xA2F73DC6), UINT32_C(0xA09DD554), UINT32_C(0x7CDD4C1D),
          UINT32_C(0xAB416627), UINT32_C(0x6F723079)}},
        {{UINT32_C(0xC4E5C4AF), UINT32_C(0xE641639E), UINT32_C(0x371CC648),
          UINT32_C(0x8BC6100D), UINT32_C(0x9B216E8A), UINT32_C(0x7BD161B1),
          UINT32_C(0xF810DB32), UINT32_C(0x58098AEB)},
         {UINT32_C(0x5AD92372), UINT32_C(0xEE52BB46), UINT32_C(0xEEF938CA),
          UINT32_C(0x4B2C48E1), UINT32_C(0xAB43A5D0), UINT32_C(0xE8FDE4D6),
          UINT32_C(0xA5284C83), UINT32_C(0x459274CD)}},
        {{UINT32_C(0xD015095D), UINT32_C(0xA98925B0), UINT32_C(0x4611A1A5),
          UINT32_C(0xC8969F5F), UINT32_C(0x2CE4663B), UINT32_C(0xBDDCD62F),
          UINT32_C(0xA076C8BE), UINT32_C(0x1C9D9007)},
         {UINT32_C(0x749F7BE5), UINT32_C(0xE8DE8890), UINT32_C(0xFF208E75),
          UINT32_C(0xC9E455E7), UINT32_C(0x8F5FAC9A), UINT32_C(0xDCEE17A9),
          UINT32_C(0x68A3A666), UINT32_C(0x776B72D3)}},
        {{UINT32_C(0xFEE0E89A), UINT32_C(0x28C7D648), UINT32_C(0x463AF60D),
          UINT32_C(0x621B370F), UINT32_C(0x5ADC8ACD), UINT32_C(0x9DC1548E),
          UINT32_C(0xA0B49504), UINT32_C(0x48032ACF)},
         {UINT32_C(0x85E992D5), UINT32_C(0x146C6EAC), UINT32_C(0x5CB491E0),
          UINT32_C(0x5A2CB577), UINT32_C(0x454C120A), UINT32_C(0x669DD6D4),
          UINT32_C(0x98203C39), UINT32_C(0x3431AB33)}},
        {{UINT32_C(0x9DE017BF), UINT32_C(0xE8761503), UINT32_C(0xB60AE61F),
          UINT32_C(0xAB117D2F), UINT32_C(0x827937FF), UINT32_C(0x0846463F),
          UINT32_C(0x6BD89C65), UINT32_C(0x45E6BD40)},
         {UINT32_C(0xA613BDB8), UINT32_C(0x3160AD67), UINT32_C(0xB8714A49),
          UINT32_C(0xBD5266F3), UINT32_C(0x51A233E4), UINT32_C(0xF7D29C47),
          UINT32_C(0x4DE6A90C), UINT32_C(0x6887B48D)}},
        {{UINT32_C(0xDFDE1EF8), UINT32_C(0x087290A5), UINT32_C(0xA166950A),
          UINT32_C(0xC70CCB52), UINT32_C(0x4A170AAE), UINT32_C(0xAA7F095B),
          UINT32_C(0x5517CA0B), UINT32_C(0x15301F4E)},
         {UINT32_C(0x302F1F84), UINT32_C(0x3C86B787), UINT32_C(0x44676E39),
          UINT32_C(0x95D41535), UINT32_C(0x9DF5F751), UINT32_C(0xBFEC4AE3),
          UINT32_C(0x304923D3), UINT32_C(0x4A0D3986)}},
        {{UINT32_C(0x79B1390C), UINT32_C(0x70FAABA9), UINT32_C(0x62BA8B9E),
          UINT32_C(0xA9067EEE), UINT32_C(0x1E17DF6F), UINT32_C(0x98789503),
          UINT32_C(0x78D5B295), UINT32_C(0x5997E8AE)},
         {UINT32_C(0xAE0C6768), UINT32_C(0x31E13AD7), UINT32_C(0xEF17A7B1),
          UINT32_C(0x23262F05), UINT32_C(0x49B7B101), UINT32_C(0x15803227),
          UINT32_C(0x36B5BA70), UINT32_C(0x1234A9C5)}},
        {{UINT32_C(0x395793AC), UINT32_C(0xED65C961), UINT32_C(0xCCDE1C47),
          UINT32_C(0x01157CD8), UINT32_C(0x1D5614DF), UINT32_C(0x0D0240B0),
          UINT32_C(0x568E83A5), UINT32_C(0x0F0DA1EF)},
         {UINT32_C(0xC0B783C1), UINT32_C(0x57C90846), UINT32_C(0x81E2F613),
          UINT32_C(0x4501048C), UINT32_C(0xA2709DC1), UINT32_C(0x03D8A69B),
          UINT32_C(0xA97CCE0E), UINT32_C(0x06F365C4)}},
        {{UINT32_C(0x551580CD), UINT32_C(0xEAF23159), UINT32_C(0x053DD5EE),
          UINT32_C(0x0F1E586A), UINT32_C(0x3CBCC3D5), UINT32_C(0xEB7A78DD),
          UINT32_C(0xB014B850), UINT32_C(0x39BBC65A)},
         {UINT32_C(0x79B61AC7), UINT32_C(0x13DA4E85), UINT32_C(0x0DA59E37),
          UINT32_C(0x33E78DCF), UINT32_C(0x2A643C4C), UINT32_C(0x4E65AF25),
          UINT32_C(0x08869D03), UINT32_C(0x0DC38C97)}},
        {{UINT32_C(0xA3A38837), UINT32_C(0x2B648345), UINT32_C(0x905E261D),
          UINT32_C(0x2FA6D8F7), UINT32_C(0x66A14946), UINT32_C(0xA23BD786),
          UINT32_C(0x5E01CC9A), UINT32_C(0x781633FD)},
         {UINT32_C(0xE2C71AD1), UINT32_C(0xB1352709), UINT32_C(0x83A6D365),
          UINT32_C(0x9D745052), UINT32_C(0x66567032), UINT32_C(0xD88B5CAE),
          UINT32_C(0x53D875CA), UINT32_C(0x27FC40DF)}},
        {{UINT32_C(0x47F7554F), UINT32_C(0xB254E54C), UINT32_C(0xD708614D),
          UINT32_C(0x33AD0ED6), UINT32_C(0x76CE908D), UINT32_C(0x830566A3),
          UINT32_C(0xAA1ADD5C), UINT32_C(0x73DF94BD)},
         {UINT32_C(0x2DBDD8A3), UINT32_C(0x23EC411F), UINT32_C(0x3A979FDC),
          UINT32_C(0x9BA47338), UINT32_C(0xC667E9F7), UINT32_C(0x56A2C27F),
          UINT32_C(0x427E6BFB), UINT32_C(0x295647C7)}},
    },
    {
        {{UINT32_C(0xF8E48C13), UINT32_C(0x9B5F4652), UINT32_C(0x9EEF4BA3),
          UINT32_C(0xE979034F), UINT32_C(0x7CF5AF6E), UINT32_C(0xF95FD776),
          UINT32_C(0x506CEB46), UINT32_C(0x4236C47E)},
         {UINT32_C(0xE08D2312), UINT32_C(0x0C02A249), UINT32_C(0xC056499A),
          UINT32_C(0xAA5A38CC), UINT32_C(0x7C188B64), UINT32_C(0xCB26A8E2),
          UINT32_C(0x0AE373D5), UINT32_C(0x38FB961D)}},
        {{UINT32_C(0x7B23470D), UINT32_C(0xEB179C9E), UINT32_C(0x1EBC44E7),
          UINT32_C(0xAE70102F), UINT32_C(0x92E0EED0), UINT32_C(0x8184C1D4),
          UINT32_C(0x5C21BF08), UINT32_C(0x32988281)},
         {UINT32_C(0x8180D11E), UINT32_C(0x46958967), UINT32_C(0x7FD7278D),
          UINT32_C(0xEBD5518C), UINT32_C(0xAD2B74F7), UINT32_C(0xFCEB7F68),
          UINT32_C(0xF9C7B6DA), UINT32_C(0x082D2011)}},
        {{UINT32_C(0xBBE0299D), UINT32_C(0x65D5AED1), UINT32_C(0xCF565A0A),
          UINT32_C(0x0077F756), UINT32_C(0x344BB90D), UINT32_C(0xD44FCD6B),
          UINT32_C(0x536F3F25), UINT32_C(0x6C2A19C0)},
         {UINT32_C(0xBB2A4D91), UINT32_C(0x32EE7439), UINT32_C(0xED9351E1),
          UINT32_C(0xA97E677A), UINT32_C(0x413A16E0), UINT32_C(0x6752EDCF),
          UINT32_C(0x1CE4FBE6), UINT32_C(0x5DE1B0C7)}},
        {{UINT32_C(0xD6009B36), UINT32_C(0x6C10DA15), UINT32_C(0xE5D8CFBE),
          UINT32_C(0xAAD05F4F), UINT32_C(0x31D58B76), UINT32_C(0xD8BCE0B4),
          UINT32_C(0x27B2811B), UINT32_C(0x08DE344E)},
         {UINT32_C(0x80B51E48), UINT32_C(0xD9A78AAE), UINT32_C(0x3E41C63A),
          UINT32_C(0x1E1D0A81), UINT32_C(0x8076B3C7), UINT32_C(0x844376DE),
          UINT32_C(0x5FDF9D53), UINT32_C(0x73F0D4A3)}},
        {{UINT32_C(0x558C7719), UINT32_C(0xF1532922), UINT32_C(0xA8221197),
          UINT32_C(0x0F10188A), UINT32_C(0x5DDC1716), UINT32_C(0x51A97E5F),
          UINT32_C(0x444789E7), UINT32_C(0x0F583A9B)},
         {UINT32_C(0x97D63B87), UINT32_C(0xAA8FC58D), UINT32_C(0x1CFDA59C),
          UINT32_C(0xA5AF048B), UINT32_C(0x2DDB34EB), UINT32_C(0x2A4A0C5F),
          UINT32_C(0x701E2E07), UINT32_C(0x66C0F0C7)}},
        {{UINT32_C(0x36BE2ABF), UINT32_C(0xC0BC88B8), UINT32_C(0x5C721B85),
          UINT32_C(0x265CCE74), UINT32_C(0xD54299BA), UINT32_C(0x483EBB01),
          UINT32_C(0x348ED89E), UINT32_C(0x18F11CBE)},
         {UINT32_C(0xE42129D4), UINT32_C(0x5E9AE7B9), UINT32_C(0x81DE5B77),
          UINT32_C(0x6B3E9E8D), UINT32_C(0x7A14A74A), UINT32_C(0xB3ADBAC9),
          UINT32_C(0x0003B266), UINT32_C(0x1B6CEBB2)}},
        {{UINT32_C(0x15EB200E), UINT32_C(0xD4D4DD10), UINT32_C(0xFB87C57B),
          UINT32_C(0xEEAEA4C6), UINT32_C(0x72FF6321), UINT32_C(0x48F0B957),
          UINT32_C(0xB782B01D), UINT32_C(0x187C4B75)},
         {UINT32_C(0xE9B4D622), UINT32_C(0x3DC1AACD), UINT32_C(0x3F4ED519),
          UINT32_C(0x0358418E), UINT32_C(0x773D019C), UINT32_C(0x981A24F8),
          UINT32_C(0x3DB0B4F4), UINT32_C(0x6643CA91)}},
        {{UINT32_C(0xD47670E3), UINT32_C(0xE3254F4B), UINT32_C(0x30B1DDE9),
          UINT32_C(0x98226125), UINT32_C(0xDA8AF160), UINT32_C(0x61EB6C86),
          UINT32_C(0x18363269), UINT32_C(0x725C7716)},
         {UINT32_C(0x02F62462), UINT32_C(0xB051DC9F), UINT32_C(0x00AC5531),
          UINT32_C(0xFF8C9EDF), UINT32_C(0x962A92A3), UINT32_C(0x3909C79B),
          UINT32_C(0x27790237), UINT32_C(0x25C90D93)}},
        {{UINT32_C(0x88ADC475), UINT32_C(0x0A5DF2CC), UINT32_C(0xE5D27D0A),
          UINT32_C(0x48D26967), UINT32_C(0x359FF194), UINT32_C(0x21D5F616),
          UINT32_C(0x89977CE2), UINT32_C(0x38ACD141)},
         {UINT32_C(0xFDAA8ACB), UINT32_C(0x39B9BD92), UINT32_C(0x035B62D0),
          UINT32_C(0xDB157DF2), UINT32_C(0xB7D252D9), UINT32_C(0x4E33386E),
          UINT32_C(0xCF196258), UINT32_C(0x6BD2E33F)}},
        {{UINT32_C(0xCE8F10C5), UINT32_C(0xE0806297), UINT32_C(0x8A14B746),
          UINT32_C(0x446AFD6D), UINT32_C(0xBF566190), UINT32_C(0xD7931F29),
          UINT32_C(0x86FDB72A), UINT32_C(0x4D9CFBFA)},
         {UINT32_C(0x95009F63), UINT32_C(0x77528851), UINT32_C(0x34C0FF45),
          UINT32_C(0x5FE50134), UINT32_C(0x6E134B81), UINT32_C(0xC38CABBB),
          UINT32_C(0xE36DB037), UINT32_C(0x2E60B277)}},
        {{UINT32_C(0x57184CA5), UINT32_C(0xA614CF67), UINT32_C(0x25BE01E3),
          UINT32_C(0x6CBD8D63), UINT32_C(0xA0030BE3), UINT32_C(0xE313EE8D),
          UINT32_C(0x2B1E7C60), UINT32_C(0x69AF0399)},
         {UINT32_C(0x50423F30), UINT32_C(0x519ABFBB), UINT32_C(0x486B9519),
          UINT32_C(0x200111FF), UINT32_C(0x3351F692), UINT32_C(0x6FF93CCB),
          UINT32_C(0x3ED9BE71), UINT32_C(0x32EB3E54)}},
        {{UINT32_C(0x54052EBD), UINT32_C(0x0851ACB9), UINT32_C(0x6D2336D7),
          UINT32_C(0x3A389B7B), UINT32_C(0x17C6ACD9), UINT32_C(0x50A87925),
          UINT32_C(0xB807D9B1), UINT32_C(0x031FE845)},
         {UINT32_C(0xE22F7492), UINT32_C(0xA348BB01), UINT32_C(0x05F39661),
          UINT32_C(0x9547ED36), UINT32_C(0x68EC4AC2), UINT32_C(0x97DF6756),
          UINT32_C(0x85B7F81B), UINT32_C(0x5836FEFE)}},
        {{UINT32_C(0x5F0B2ACB), UINT32_C(0x4E4869A6), UINT32_C(0xDEC46001),
          UINT32_C(0xC4798F3F), UINT32_C(0x00903474), UINT32_C(0x281A4ED6),
          UINT32_C(0xEFB9AABD), UINT32_C(0x04F22E9D)},
         {UINT32_C(0xFAA721A4), UINT32_C(0x2AC92264), UINT32_C(0x276F8041),
          UINT32_C(0xBCE2FF0B), UINT32_C(0xE4943926), UINT32_C(0x5F605607),
          UINT32_C(0x55506DF7), UINT32_C(0x388C5FAB)}},
        {{UINT32_C(0xAB5687E2), UINT32_C(0xFF104F6D), UINT32_C(0x3B2D0245),
          UINT32_C(0x1B6DAFE9), UINT32_C(0x81B2EC4B), UINT32_C(0x6405C026),
          UINT32_C(0xF489EBBC), UINT32_C(0x2B7676DA)},
         {UINT32_C(0x6DA1F57A), UINT32_C(0xBAA158F0), UINT32_C(0x27A8457F),
          UINT32_C(0x9CB044AD), UINT32_C(0xA3BBD6C9), UINT32_C(0xC23737A5),
          UINT32_C(0x1D2267E1), UINT32_C(0x71FB5B47)}},
        {{UINT32_C(0xD14F56E4), UINT32_C(0x779BD825), UINT32_C(0x08396F23),
          UINT32_C(0xD7E672A0), UINT32_C(0xD40BA6EE), UINT32_C(0x23FE3FC0),
          UINT32_C(0x3B56A3AB), UINT32_C(0x41E749E7)},
         {UINT32_C(0x72042F67), UINT32_C(0xD19471CE), UINT32_C(0x4989D4D7),
          UINT32_C(0x8A686DA7), UINT32_C(0x4FA09BC9), UINT32_C(0x52A709C6),
          UINT32_C(0xB3B6AA64), UINT32_C(0x1DC21162)}},
        {{UINT32_C(0xF9B3BD1D), UINT32_C(0x62C9838B), UINT32_C(0x0CE6384C),
          UINT32_C(0x1EE59E5A), UINT32_C(0xECE8CC7F), UINT32_C(0xA9F5ABF6),
          UINT32_C(0x80BDDA83), UINT32_C(0x1961D80F)},
         {UINT32_C(0xCA406FB1), UINT32_C(0x7A40880C), UINT32_C(0xDFBCE2E4),
          UINT32_C(0x5035D307), UINT32_C(0x3D637299), UINT32_C(0x590259E0),
          UINT32_C(0xD6C34E05), UINT32_C(0x1607AC9F)}},
    },
    {
        {{UINT32_C(0x9D818B72), UINT32_C(0x4ABC2710), UINT32_C(0x092607B7),
          UINT32_C(0x2496CEA6), UINT32_C(0x055C4EC8), UINT32_C(0xFB1087E1),
          UINT32_C(0x258ADC7D), UINT32_C(0x50A30C6A)},
         {UINT32_C(0x0FF502E3), UINT32_C(0xAF4EB6B3), UINT32_C(0x190607AB),
          UINT32_C(0x5D5D76AD), UINT32_C(0x34482C13), UINT32_C(0xC9C9B711),
          UINT32_C(0x42213696), UINT32_C(0x574A9718)}},
        {{UINT32_C(0x7018FC70), UINT32_C(0x7C90FAFD), UINT32_C(0x2B83291C),
          UINT32_C(0x36A04559), UINT32_C(0x40D1B175), UINT32_C(0x6120B51E),
          UINT32_C(0x3DCF9606), UINT32_C(0x45F10B20)},
         {UINT32_C(0xF20C5636), UINT32_C(0x3C6A9EFF), UINT32_C(0xFFBBC648),
          UINT32_C(0xB2768BA3), UINT32_C(0xB523B36C), UINT32_C(0x1C9DF90A),
          UINT32_C(0xD6FF34ED), UINT32_C(0x4148BF06)}},
        {{UINT32_C(0x3B5F9492), UINT32_C(0x3D29821A), UINT32_C(0x90B24561),
          UINT32_C(0xAE12C782), UINT32_C(0x8A3BDC5F), UINT32_C(0xEF6FB277),
          UINT32_C(0xAC3BD74E), UINT32_C(0x6034BF3B)},
         {UINT32_C(0x4ACB6F85), UINT32_C(0x131D57CD), UINT32_C(0x3BE79B31),
          UINT32_C(0xDED1C433), UINT32_C(0x78A896B8), UINT32_C(0xB0913489),
          UINT32_C(0xB287862C), UINT32_C(0x1247C0B7)}},
        {{UINT32_C(0x7C494054), UINT32_C(0xEB642893), UINT32_C(0x22142D26),
          UINT32_C(0x79227930), UINT32_C(0x943E8398), UINT32_C(0x8F1C8371),
          UINT32_C(0x60886DB7), UINT32_C(0x583C7AEF)},
         {UINT32_C(0x3A12EE0E), UINT32_C(0xAFE46022), UINT32_C(0xB6CB8685),
          UINT32_C(0xE9C9253A), UINT32_C(0x6316A4C6), UINT32_C(0x5334F9DD),
          UINT32_C(0xE6F1DEE9), UINT32_C(0x4E2F13D8)}},
        {{UINT32_C(0xB37D8BA5), UINT32_C(0x7499A5B4), UINT32_C(0x1C9BCDE2),
          UINT32_C(0xA12AA637), UINT32_C(0xBFD6AE86), UINT32_C(0xCC99471D),
          UINT32_C(0x92048D63), UINT32_C(0x09966378)},
         {UINT32_C(0x552E71A3), UINT32_C(0x42CBFA9D), UINT32_C(0x675C1716),
          UINT32_C(0x84A8B153), UINT32_C(0x4CF00A7D), UINT32_C(0xB9C07C0E),
          UINT32_C(0x0DA504DB), UINT32_C(0x32E2322B)}},
        {{UINT32_C(0xE671EE59), UINT32_C(0x569F581F), UINT32_C(0x422E86C7),
          UINT32_C(0x293522D7), UINT32_C(0x15DCEF10), UINT32_C(0x5E4CEA7E),
          UINT32_C(0x483C0FE3), UINT32_C(0x67C8A9FC)},
         {UINT32_C(0x47B79284), UINT32_C(0x4DE5AC09), UINT32_C(0x025016BA),
          UINT32_C(0x22AB8FBD), UINT32_C(0x2A099B37), UINT32_C(0x51318C23),
          UINT32_C(0x49E06623), UINT32_C(0x542EA0FA)}},
        {{UINT32_C(0x28909F31), UINT32_C(0xDD240F64), UINT32_C(0x101B7F01),
          UINT32_C(0x46B66F9E), UINT32_C(0x20481C3F), UINT32_C(0x788C29CA),
          UINT32_C(0xCA5D5182), UINT32_C(0x3218A509)},
         {UINT32_C(0x63E9A2B9), UINT32_C(0x64BCC7AD), UINT32_C(0xADDF5C0B),
          UINT32_C(0x3D213CA2), UINT32_C(0x9960D650), UINT32_C(0x6D93ED4C),
          UINT32_C(0x284EE5F3), UINT32_C(0x3F13DB22)}},
        {{UINT32_C(0x6697E0D1), UINT32_C(0x5B678C3A), UINT32_C(0x16D9D878),
          UINT32_C(0x25A171F4), UINT32_C(0xFAEC362B), UINT32_C(0xC20A6D80),
          UINT32_C(0xC512EA4B), UINT32_C(0x1BB3F14C)},
         {UINT32_C(0x2AE35FA5), UINT32_C(0xECE5313B), UINT32_C(0xBBD76B87),
          UINT32_C(0xE390A01F), UINT32_C(0x882DA3FC), UINT32_C(0xC78EA4C5),
          UINT32_C(0x42086A77), UINT32_C(0x771BCDAE)}},
        {{UINT32_C(0x565802E9), UINT32_C(0x8E9E3C8B), UINT32_C(0x53FA1BE7),
          UINT32_C(0xC37A7B35), UINT32_C(0x4408FB77), UINT32_C(0x9D2F1A26),
          UINT32_C(0xFF308B7B), UINT32_C(0x0B3ECE36)},
         {UINT32_C(0x1F30FC37), UINT32_C(0x8FB35B36), UINT32_C(0x83E1A3C9),
          UINT32_C(0x463B44E2), UINT32_C(0x3402233A), UINT32_C(0x7218F09F),
          UINT32_C(0xFC9A6990), UINT32_C(0x1519638A)}},
        {{UINT32_C(0x8EAAC478), UINT32_C(0x51FB3E5D), UINT32_C(0x760ED4EC),
          UINT32_C(0x620E4826), UINT32_C(0x1D865577), UINT32_C(0x46FC5B1F),
          UINT32_C(0x5244A538), UINT32_C(0x15EF2AD9)},
         {UINT32_C(0x4BF382BD), UINT32_C(0x8D7E477C), UINT32_C(0x02A5C9EE),
          UINT32_C(0xCBF170C9), UINT32_C(0x4AFB0EC1), UINT32_C(0xB91A870C),
          UINT32_C(0x69C31425), UINT32_C(0x052FFC51)}},
        {{UINT32_C(0x2018D066), UINT32_C(0x1FD43746), UINT32_C(0x4C67FC35),
          UINT32_C(0xBC501517), UINT32_C(0xBC990EB6), UINT32_C(0xE65BC2FB),
          UINT32_C(0x73F87F92), UINT32_C(0x538CA6F9)},
         {UINT32_C(0x8352B03F), UINT32_C(0x42FBDAE0), UINT32_C(0x99A4C9B9),
          UINT32_C(0xF265B1E0), UINT32_C(0x185CA070), UINT32_C(0x6E3EAB2F),
          UINT32_C(0x37D0A2C1), UINT32_C(0x6E6F4F7D)}},
        {{UINT32_C(0xC2D5D73E), UINT32_C(0x9B20D8EE), UINT32_C(0x75844C15),
          UINT32_C(0x190521AE), UINT32_C(0x26AD08FE), UINT32_C(0x67663AC4),
          UINT32_C(0xF984EC06), UINT32_C(0x67AEEFEF)},
         {UINT32_C(0xCBDD87EF), UINT32_C(0x61C71142), UINT32_C(0x63396E3B),
          UINT32_C(0x0FA4995B), UINT32_C(0x85C193B0), UINT32_C(0x3196E551),
          UINT32_C(0xDACB3A3D), UINT32_C(0x36C0A2A8)}},
        {{UINT32_C(0x178A1115), UINT32_C(0xEAB89FDC), UINT32_C(0xD7C31303),
          UINT32_C(0xC7B764D8), UINT32_C(0x90203755), UINT32_C(0xA5B2D6FB),
          UINT32_C(0xD5F8AEEE), UINT32_C(0x3C360BF9)},
         {UINT32_C(0x02F1CC3C), UINT32_C(0x8DFDCD05), UINT32_C(0x64E5269E),
          UINT32_C(0x7F8A64D2), UINT32_C(0xEA13FFD7), UINT32_C(0xA36196EC),
          UINT32_C(0x77E3839F), UINT32_C(0x35E22415)}},
        {{UINT32_C(0xE22E0C52), UINT32_C(0x29E7AB0B), UINT32_C(0x8B27DEDA),
          UINT32_C(0x68BF32C7), UINT32_C(0xDC7971AE), UINT32_C(0x52A762A2),
          UINT32_C(0x18B0CDCC), UINT32_C(0x4CA43487)},
         {UINT32_C(0x3FCEAF73), UINT32_C(0xED429DA1), UINT32_C(0x06718D19),
          UINT32_C(0x49396E6F), UINT32_C(0x5BB3301C), UINT32_C(0xDECB9337),
          UINT32_C(0x0FF489B1), UINT32_C(0x4B7723C1)}},
        {{UINT32_C(0xABEE6B9B), UINT32_C(0xAE321F09), UINT32_C(0x37318F60),
          UINT32_C(0xF251BF4D), UINT32_C(0xB63DC269), UINT32_C(0xB0A8A251),
          UINT32_C(0x71817963), UINT32_C(0x514A25FC)},
         {UINT32_C(0x55C9B2E9), UINT32_C(0x518F5747), UINT32_C(0x1C9B4845),
          UINT32_C(0x3E56CC3E), UINT32_C(0x283AE1FA), UINT32_C(0xBDFD637A),
          UINT32_C(0xC3DE778E), UINT32_C(0x419BA4B4)}},
        {{UINT32_C(0xBCD2EB74), UINT32_C(0xC7F18E93), UINT32_C(0xFC61FB42),
          UINT32_C(0x171264C8), UINT32_C(0x85119033), UINT32_C(0x27282E76),
          UINT32_C(0xD7DB91C7), UINT32_C(0x225006A4)},
         {UINT32_C(0x1ECF5024), UINT32_C(0x628E0F3C), UINT32_C(0x00859CDE),
          UINT32_C(0xDC5111E0), UINT32_C(0x1F220711), UINT32_C(0x4AB1764F),
          UINT32_C(0x70DDED3C), UINT32_C(0x7C6916F1)}},
    },
    {
        {{UINT32_C(0x5F0CA58A), UINT32_C(0xF9FFE8FC), UINT32_C(0x22879EBB),
          UINT32_C(0x09E34F30), UINT32_C(0xED7B0520), UINT32_C(0x648D6339),
          UINT32_C(0x1AF5ECDC), UINT32_C(0x0D6719D0)},
         {UINT32_C(0x0B8590E4), UINT32_C(0x2878714D), UINT32_C(0x90EC312B),
          UINT32_C(0x827D04ED), UINT32_C(0x3B5767C3), UINT32_C(0xD415C8B4),
          UINT32_C(0xC09FD18D), UINT32_C(0x4170F0AD)}},
        {{UINT32_C(0x3C601031), UINT32_C(0x9B649CFC), UINT32_C(0x636DDAE7),
          UINT32_C(0x0478603A), UINT32_C(0x914E100A), UINT32_C(0xDC972DFA),
          UINT32_C(0x091621AE), UINT32_C(0x519C55DF)},
         {UINT32_C(0xD4A9963D), UINT32_C(0x863046CB), UINT32_C(0x5ACF7C0C),
          UINT32_C(0xDF16763C), UINT32_C(0xFF5468A4), UINT32_C(0x4999A93E),
          UINT32_C(0x424074A5), UINT32_C(0x35543EFF)}},
        {{UINT32_C(0xDD33307C), UINT32_C(0x27B1DBFA), UINT32_C(0x927CA6F3),
          UINT32_C(0xA0D04784), UINT32_C(0xA37CF855), UINT32_C(0xBD3EBC5E),
          UINT32_C(0x49F5AA2C), UINT32_C(0x59D02EF5)},
         {UINT32_C(0xBDD57BF3), UINT32_C(0xCDABE86F), UINT32_C(0x37819D86),
          UINT32_C(0x7B3ADD2F), UINT32_C(0x0413B7B0), UINT32_C(0x7B90BA15),
          UINT32_C(0x6B99685B), UINT32_C(0x47071782)}},
        {{UINT32_C(0xEF0CE97F), UINT32_C(0xB7C3218E), UINT32_C(0x0898C79C),
          UINT32_C(0xDAE3B56C), UINT32_C(0x0908877D), UINT32_C(0x6349D83D),
          UINT32_C(0xC81E8C4E), UINT32_C(0x0970C6C0)},
         {UINT32_C(0xA47F426C), UINT32_C(0x0E45C4A7), UINT32_C(0x3FBB194E),
          UINT32_C(0xAB000A59), UINT32_C(0x3A6DD13E), UINT32_C(0x570FBBA5),
          UINT32_C(0xC8F44A57), UINT32_C(0x66045580)}},
        {{UINT32_C(0x12A72F7F), UINT32_C(0x5ABEB749), UINT32_C(0x7AE56F4D),
          UINT32_C(0x15072A92), UINT32_C(0x222AB2C4), UINT32_C(0x1C77AE00),
          UINT32_C(0x9AFE63DE), UINT32_C(0x591EAEC6)},
         {UINT32_C(0xDFD24304), UINT32_C(0xB51D41AF), UINT32_C(0xDFBCC096),
          UINT32_C(0xDE28DF26), UINT32_C(0x38A20DA7), UINT32_C(0x02F046C8),
          UINT32_C(0x1AE0A45B), UINT32_C(0x5EC3DBDC)}},
        {{UINT32_C(0x63DD86C2), UINT32_C(0x7C19BD75), UINT32_C(0x8D78A57B),
          UINT32_C(0xDB119311), UINT32_C(0x23C5C4E7), UINT32_C(0xF48BB4FA),
          UINT32_C(0x97DB0A05), UINT32_C(0x65514C1C)},
         {UINT32_C(0x43CAC49C), UINT32_C(0x1BC1F2F0), UINT32_C(0x2851B4BE),
          UINT32_C(0x975FEB51), UINT32_C(0xDD60D530), UINT32_C(0x0E0A4633),
          UINT32_C(0x09B1D2C6), UINT32_C(0x32BBBF14)}},
        {{UINT32_C(0xA670EAC0), UINT32_C(0x79124749), UINT32_C(0x31DD893C),
          UINT32_C(0x504D89D5), UINT32_C(0xE0654D63), UINT32_C(0xDDCED74C),
          UINT32_C(0xE2208707), UINT32_C(0x58956BE5)},
         {UINT32_C(0x437E7077), UINT32_C(0xBE6A3ECD), UINT32_C(0x574095C8),
          UINT32_C(0xB8AB332D), UINT32_C(0x3869DA42), UINT32_C(0x4E79AC1C),
          UINT32_C(0x68859F51), UINT32_C(0x79D4C3FB)}},
        {{UINT32_C(0x7936A831), UINT32_C(0x1E5FC1B9), UINT32_C(0xD74F1F41),
          UINT32_C(0x1EA42ED2), UINT32_C(0xC4EA3228), UINT32_C(0x33D22EC1),
          UINT32_C(0x729BEBFE), UINT32_C(0x5705333F)},
         {UINT32_C(0x64596076), UINT32_C(0xDBD1A67B), UINT32_C(0xFA65BA98),
          UINT32_C(0x6BFF269D), UINT32_C(0x6C47E715), UINT32_C(0x8451A9C2),
          UINT32_C(0x22898DB3), UINT32_C(0x243D679D)}},
        {{UINT32_C(0xB8323FD0), UINT32_C(0xE935D705), UINT32_C(0x6937E5CB),
          UINT32_C(0xE2DA8845), UINT32_C(0x4A5EAE1E), UINT32_C(0x1C9DFFF8),
          UINT32_C(0x45DF7A79), UINT32_C(0x796F0B95)},
         {UINT32_C(0x640DBA32), UINT32_C(0xC24D573F), UINT32_C(0x02E4B792),
          UINT32_C(0x2B775217), UINT32_C(0x94D12C40), UINT32_C(0xD437EB63),
          UINT32_C(0x4AD371F0), UINT32_C(0x6182AF6D)}},
        {{UINT32_C(0x41FC7551), UINT32_C(0x133EDA52), UINT32_C(0xE91714AF),
          UINT32_C(0xA0088A2B), UINT32_C(0x5E0A73C0), UINT32_C(0xB41B9AC2),
          UINT32_C(0x1D3B3953), UINT32_C(0x4808BB5A)},
         {UINT32_C(0x2B9AE648), UINT32_C(0xD875AA14), UINT32_C(0x2408244C),
          UINT32_C(0x4F38C946), UINT32_C(0xFF051A87), UINT32_C(0x04B6B941),
          UINT32_C(0x6DF48ECD), UINT32_C(0x1D5B0B9E)}},
        {{UINT32_C(0x169E757F), UINT32_C(0x27FD368A), UINT32_C(0x7B94D9DB),
          UINT32_C(0x2ACB3560), UINT32_C(0x4D4C9B5F), UINT32_C(0x81903F4B),
          UINT32_C(0x169B81DE), UINT32_C(0x641F806C)},
         {UINT32_C(0x9E957475), UINT32_C(0x574E9444), UINT32_C(0xC6C8EE52),
          UINT32_C(0xE08814AE), UINT32_C(0x6C84FDDF), UINT32_C(0xD1AE71EC),
          UINT32_C(0xFAA040D9), UINT32_C(0x44A56014)}},
        {{UINT32_C(0x75A48F60), UINT32_C(0x06DA6908), UINT32_C(0xBB2CD408),
          UINT32_C(0x7BA6C9CB), UINT32_C(0x3A1BCBFF), UINT32_C(0x57D2D0FF),
          UINT32_C(0x8928CE36), UINT32_C(0x186F1A8B)},
         {UINT32_C(0x7A40F877), UINT32_C(0x0FFD205B), UINT32_C(0x01AF68F7),
          UINT32_C(0x2915BC8E), UINT32_C(0xC36A5FB1), UINT32_C(0x816AC4DF),
          UINT32_C(0x2C9E1F7D), UINT32_C(0x609B0A87)}},
        {{UINT32_C(0xB97536FB), UINT32_C(0x4032AC5E), UINT32_C(0xA7C5EDB6),
          UINT32_C(0x53E6FE68), UINT32_C(0x5F0DCBA1), UINT32_C(0x2F414930),
          UINT32_C(0x2837E314), UINT32_C(0x20975256)},
         {UINT32_C(0x3C3C1D27), UINT32_C(0xDF5DC496), UINT32_C(0x71797C36),
          UINT32_C(0x0DFDAAF3), UINT32_C(0xDA504E04), UINT32_C(0x5F3E9229),
          UINT32_C(0x8C234246), UINT32_C(0x354EA88D)}},
        {{UINT32_C(0x0922D317), UINT32_C(0xAF6741C3), UINT32_C(0x9DF0A572),
          UINT32_C(0x7429853B), UINT32_C(0x1DC207A8), UINT32_C(0x0EA1AE04),
          UINT32_C(0x450075F5), UINT32_C(0x2C1DAA1C)},
         {UINT32_C(0x6ED729B4), UINT32_C(0x27C71F16), UINT32_C(0x53AB8EC0),
          UINT32_C(0x785718A6), UINT32_C(0xA8465487), UINT32_C(0x1EEC7BBF),
          UINT32_C(0x4C578BA9), UINT32_C(0x78DA9B04)}},
        {{UINT32_C(0xB3B707FA), UINT32_C(0xFF9ED65E), UINT32_C(0xF5D28D33),
          UINT32_C(0xF8C8301F), UINT32_C(0xA65F5C0F), UINT32_C(0xB15D498F),
          UINT32_C(0xB0EF2B89), UINT32_C(0x6DEF256D)},
         {UINT32_C(0x52184EF6), UINT32_C(0x0D40A6B2), UINT32_C(0x2BF06F5A),
          UINT32_C(0xC702EBE5), UINT32_C(0x4BA041AA), UINT32_C(0x13E50E18),
          UINT32_C(0x7EC4C784), UINT32_C(0x53552D88)}},
        {{UINT32_C(0xF28ABB3A), UINT32_C(0x2CD09B19), UINT32_C(0x724EDB9B),
          UINT32_C(0x4F5C040F), UINT32_C(0xE0DCBD16), UINT32_C(0xD6820590),
          UINT32_C(0x1B7155A3), UINT32_C(0x45D84DE9)},
         {UINT32_C(0xA251B1BA), UINT32_C(0x995BDD01), UINT32_C(0x37CAA4DC),
          UINT32_C(0x607F9517), UINT32_C(0xA15D9674), UINT32_C(0x747FEA1C),
          UINT32_C(0x73E97C97), UINT32_C(0x646C1876)}},
    },
    {
        {{UINT32_C(0x6FAC1486), UINT32_C(0x1951682B), UINT32_C(0x4A4D14C5),
          UINT32_C(0x8B578E1E), UINT32_C(0xB7384D42), UINT32_C(0x083FA101),
          UINT32_C(0xED1C8A87), UINT32_C(0x13380CE9)},
         {UINT32_C(0x732A493B), UINT32_C(0xC7052ED8), UINT32_C(0xB32E3D69),
          UINT32_C(0xD5FEF40F), UINT32_C(0x88833566), UINT32_C(0xA64ACE87),
          UINT32_C(0x4177DC00), UINT32_C(0x6E36CFDB)}},
        {{UINT32_C(0xE742C3B4), UINT32_C(0xAA14E281), UINT32_C(0xEE5AF40A),
          UINT32_C(0xB75E7B2A), UINT32_C(0x1616EFA2), UINT32_C(0x3FC5FF0B),
          UINT32_C(0xAD763298), UINT32_C(0x090259B0)},
         {UINT32_C(0x38753438), UINT32_C(0x4105B57E), UINT32_C(0xCF2D8926),
          UINT32_C(0x70ED1A00), UINT32_C(0x322F40BB), UINT32_C(0x78921395),
          UINT32_C(0x67A3FF56), UINT32_C(0x3AEE8199)}},
        {{UINT32_C(0x11EA75FC), UINT32_C(0x88073D00), UINT32_C(0x06A4B4EB),
          UINT32_C(0xD23D2796), UINT32_C(0xD85D3A6B), UINT32_C(0x1FD22F9E),
          UINT32_C(0xAFB43B70), UINT32_C(0x6B5EA051)},
         {UINT32_C(0xD99BE576), UINT32_C(0x96C9C176), UINT32_C(0x4C47261E),
          UINT32_C(0x85AC2B6C), UINT32_C(0x99A9C378), UINT32_C(0x27263959),
          UINT32_C(0x8B5CABDA), UINT32_C(0x6D36E9FE)}},
        {{UINT32_C(0xA58F614C), UINT32_C(0xC9FC7661), UINT32_C(0x2E45AE73),
          UINT32_C(0x82AA317D), UINT32_C(0xC8CB9CC7), UINT32_C(0xDCB1925F),
          UINT32_C(0x27813205), UINT32_C(0x1341C1AA)},
         {UINT32_C(0x6CD478AB), UINT32_C(0xDD06745B), UINT32_C(0x1E28F6A3),
          UINT32_C(0x0C2534B2), UINT32_C(0x9D27FE63), UINT32_C(0xE2183345),
          UINT32_C(0x06466147), UINT32_C(0x7F1E2A33)}},
        {{UINT32_C(0x5AEE2471), UINT32_C(0x378D727E), UINT32_C(0xD47739B6),
          UINT32_C(0xB718FC17), UINT32_C(0x4145E8EF), UINT32_C(0xDA27CB9B),
          UINT32_C(0x0EF2AB20), UINT32_C(0x3F8AB1A3)},
         {UINT32_C(0xE16C0141), UINT32_C(0xA89ADD37), UINT32_C(0x59DF1C95),
          UINT32_C(0x2127823B), UINT32_C(0xB7455CC2), UINT32_C(0x53F90B73),
          UINT32_C(0x1183FBE5), UINT32_C(0x7F960586)}},
        {{UINT32_C(0xE77235C3), UINT32_C(0x56D0475A), UINT32_C(0xB18ED61A),
          UINT32_C(0xED2907C5), UINT32_C(0x7D73F6F8), UINT32_C(0x2D02C4CB),
          UINT32_C(0xC42E7AED), UINT32_C(0x35EF69B4)},
         {UINT32_C(0x31B7324A), UINT32_C(0x53A6120A), UINT32_C(0x59F1A395),
          UINT32_C(0x982DD221), UINT32_C(0x835CFD94), UINT32_C(0x03ECA86F),
          UINT32_C(0x73CA1BD5), UINT32_C(0x4CBA837D)}},
        {{UINT32_C(0x41B17E6D), UINT32_C(0x64F66D39), UINT32_C(0xCB14F3B3),
          UINT32_C(0x3C869BF5), UINT32_C(0x28350EFA), UINT32_C(0x1EBA045A),
          UINT32_C(0xC7CDEC47), UINT32_C(0x7ACFB882)},
         {UINT32_C(0x8FB3097B), UINT32_C(0x7ACFD28D), UINT32_C(0x62986426),
          UINT32_C(0xDA397C31), UINT32_C(0x2A1A7A94), UINT32_C(0xD49F8421),
          UINT32_C(0xFAB65156), UINT32_C(0x7B372E2D)}},
        {{UINT32_C(0x01D9DB0F), UINT32_C(0x3ADBDD07), UINT32_C(0x94FF0CFB),
          UINT32_C(0x617521E6), UINT32_C(0x3F5BD583), UINT32_C(0x5BA5905C),
          UINT32_C(0x78670CD1), UINT32_C(0x6F896033)},
         {UINT32_C(0xFB98EA11), UINT32_C(0x0A59C447), UINT32_C(0x653EDC59),
          UINT32_C(0x59B918CC), UINT32_C(0x9F72C01E), UINT32_C(0x00BF4D2A),
          UINT32_C(0x47DEE00F), UINT32_C(0x748455D1)}},
        {{UINT32_C(0x386E7491), UINT32_C(0xE371A7A8), UINT32_C(0x621A3484),
          UINT32_C(0xF71711CC), UINT32_C(0xE0015C3B), UINT32_C(0x1568256E),
          UINT32_C(0x7D3FFDE9), UINT32_C(0x5ACEF7A6)},
         {UINT32_C(0xB08E4219), UINT32_C(0x02ED70E5), UINT32_C(0x832AC3AA),
          UINT32_C(0x7ECE1726), UINT32_C(0x951D1CA2), UINT32_C(0xC3C0D32B),
          UINT32_C(0x38DECC59), UINT32_C(0x4C991664)}},
        {{UINT32_C(0x96EB21A4), UINT32_C(0xB99DF8BA), UINT32_C(0x2BBF8E6D),
          UINT32_C(0xB88D25F4), UINT32_C(0x686DAA3C), UINT32_C(0x16B3E0B1),
          UINT32_C(0x70D47C57), UINT32_C(0x11314561)},
         {UINT32_C(0x3338342D), UINT32_C(0x8DCDC3D1), UINT32_C(0x88E028A7),
          UINT32_C(0xE6D39B01), UINT32_C(0x72855B5E), UINT32_C(0xB781F1ED),
          UINT32_C(0xCC192572), UINT32_C(0x0E0D82F6)}},
        {{UINT32_C(0xCF1E20AA), UINT32_C(0xC86A8E5D), UINT32_C(0xF9AB96D5),
          UINT32_C(0x1A87AEF3), UINT32_C(0xF3D19051), UINT32_C(0xA8941635),
          UINT32_C(0x654FFF15), UINT32_C(0x67B1D0A2)},
         {UINT32_C(0x92862ACD), UINT32_C(0x266FD5ED), UINT32_C(0xD11DEEAC),
          UINT32_C(0xB72587BE), UINT32_C(0xD09320AA), UINT32_C(0x5CF0D2E2),
          UINT32_C(0x515E0277), UINT32_C(0x68456EBA)}},
        {{UINT32_C(0x771F64CA), UINT32_C(0x86A5461C), UINT32_C(0x48FF8D7A),
          UINT32_C(0xB7A220B7), UINT32_C(0xD7A568D1), UINT32_C(0x9A0DD72A),
          UINT32_C(0xF644D858), UINT32_C(0x18F5E1DC)},
         {UINT32_C(0x3E00364F), UINT32_C(0xB7AE1BC2), UINT32_C(0xCEE8D9F7),
          UINT32_C(0xD7EA31F3), UINT32_C(0xDCDB883D), UINT32_C(0xD18DA30F),
          UINT32_C(0xCBA00F48), UINT32_C(0x179CFCA5)}},
        {{UINT32_C(0x39E7860C), UINT32_C(0x496F2C01), UINT32_C(0x27F15EAF),
          UINT32_C(0xACDF8B40), UINT32_C(0x687AC815), UINT32_C(0x8871966C),
          UINT32_C(0x8DB8FDB5), UINT32_C(0x6228F1B5)},
         {UINT32_C(0xF30ECF2B), UINT32_C(0x8644656A), UINT32_C(0xAE1DEAFF),
          UINT32_C(0x15576CC2), UINT32_C(0x697AB3FC), UINT32_C(0x93D86D56),
          UINT32_C(0x811E3FF2), UINT32_C(0x3E4A428E)}},
        {{UINT32_C(0x91B9F5DF), UINT32_C(0xFB85DE3D), UINT32_C(0xB20A9C71),
          UINT32_C(0xCDB595D4), UINT32_C(0xB44D671E), UINT32_C(0x55CB08F3),
          UINT32_C(0xFCD7D5ED), UINT32_C(0x780FC2E5)},
         {UINT32_C(0x7F939366), UINT32_C(0x815AB41F), UINT32_C(0xECD52B20),
          UINT32_C(0xA7597A02), UINT32_C(0x4648E3C5), UINT32_C(0x9BE078F0),
          UINT32_C(0x17BD3DC2), UINT32_C(0x7A3E2179)}},
        {{UINT32_C(0x9D9E5E53), UINT32_C(0x22758C41), UINT32_C(0x9EF09FAE),
          UINT32_C(0x44D675F4), UINT32_C(0x27159F97), UINT32_C(0x1AB7986D),
          UINT32_C(0xB6B9465B), UINT32_C(0x72B3F02B)},
         {UINT32_C(0xFE56F578), UINT32_C(0xA372FAC7), UINT32_C(0xDA534F4A),
          UINT32_C(0x33FA6479), UINT32_C(0xDF63BF2D), UINT32_C(0xB0003307),
          UINT32_C(0xB80D0F64), UINT32_C(0x34D40B4D)}},
        {{UINT32_C(0x3D2B9FC2), UINT32_C(0x8A8929DC), UINT32_C(0x55EE75E5),
          UINT32_C(0x7D12E86C), UINT32_C(0x92E1A870), UINT32_C(0xB3FE1AD3),
          UINT32_C(0x729CFE4C), UINT32_C(0x27148C94)},
         {UINT32_C(0x18BA868B), UINT32_C(0x6A8C3B52), UINT32_C(0x7F038A9C),
          UINT32_C(0xDD2006E4), UINT32_C(0xB7124908), UINT32_C(0x4606FA9E),
          UINT32_C(0xF4940CB1), UINT32_C(0x434A8C07)}},
    },
    {
        {{UINT32_C(0xF98B91EA), UINT32_C(0x15F36EBE), UINT32_C(0xC1ED17B1),
          UINT32_C(0x94D802DE), UINT32_C(0x085D77F8), UINT32_C(0x3C45FA08),
          UINT32_C(0x02FF571A), UINT32_C(0x0A30B3C3)},
         {UINT32_C(0x264C93D0), UINT32_C(0x70F5852D), UINT32_C(0x191AEE57),
          UINT32_C(0x5E51BCAB), UINT32_C(0xFAD8E96E), UINT32_C(0xD5C14AE9),
          UINT32_C(0xD4BC414B), UINT32_C(0x73B00534)}},
        {{UINT32_C(0x12AFF5E7), UINT32_C(0x21CF876B), UINT32_C(0xF75799A6),
          UINT32_C(0x3E9F664C), UINT32_C(0x9A0E73CD), UINT32_C(0xC23B7D19),
          UINT32_C(0x427EEA36), UINT32_C(0x77AAB691)},
         {UINT32_C(0x604EE854), UINT32_C(0x2E74F972), UINT32_C(0xF867C81A),
          UINT32_C(0x8712C7A0), UINT32_C(0x953A4C56), UINT32_C(0x6085980F),
          UINT32_C(0x0F7707E1), UINT32_C(0x2DB99707)}},
        {{UINT32_C(0x78BDB7A7), UINT32_C(0x5ECC087F), UINT32_C(0x04C693F2),
          UINT32_C(0x43CC156C), UINT32_C(0x039BD7F1), UINT32_C(0x965067CF),
          UINT32_C(0x6E3FAE2F), UINT32_C(0x72140E56)},
         {UINT32_C(0xE019DED1), UINT32_C(0x26452E4D), UINT32_C(0x2EDEF154),
          UINT32_C(0x6F4C2349), UINT32_C(0x054DFC0F), UINT32_C(0xA7066D7F),
          UINT32_C(0x3381AB44), UINT32_C(0x544E6F6D)}},
        {{UINT32_C(0x9214C791), UINT32_C(0x9B6E9469), UINT32_C(0x86938BDC),
          UINT32_C(0xD74F9C55), UINT32_C(0xFC2928FD), UINT32_C(0x0F1527F6),
          UINT32_C(0x63C3A053), UINT32_C(0x5B0FBF0F)},
         {UINT32_C(0xFC41FF10), UINT32_C(0xAC1F442C), UINT32_C(0x787B4932),
          UINT32_C(0x34EF88EF), UINT32_C(0x316732AC), UINT32_C(0xF8120F08),
          UINT32_C(0xA655DC4A), UINT32_C(0x7BCCF12C)}},
        {{UINT32_C(0xA6C7760E), UINT32_C(0x750DF97F), UINT32_C(0x609BF215),
          UINT32_C(0xF1A0A827), UINT32_C(0x67FD04B4), UINT32_C(0x7348C1B4),
          UINT32_C(0x615C8145), UINT32_C(0x6A581016)},
         {UINT32_C(0x9A11AAFC), UINT32_C(0x9DC01225), UINT32_C(0x3F2B0C8B),
          UINT32_C(0x24F65B05), UINT32_C(0xDCB1B2A4), UINT32_C(0xA27CB8BF),
          UINT32_C(0xE48C1A71), UINT32_C(0x3C44B811)}},
        {{UINT32_C(0xF780B295), UINT32_C(0xBC059AF2), UINT32_C(0x0B6B247D),
          UINT32_C(0xDF58928C), UINT32_C(0x01903F3D), UINT32_C(0x224D4C3C),
          UINT32_C(0x818EE0AC), UINT32_C(0x7152E120)},
         {UINT32_C(0x54BFF1BE), UINT32_C(0x6C8F4745), UINT32_C(0x431ADEF7),
          UINT32_C(0x98A6C7EC), UINT32_C(0x91B2CFB6), UINT32_C(0xDCB6BB75),
          UINT32_C(0x7E83A5BB), UINT32_C(0x145F6D39)}},
        {{UINT32_C(0x81D23BC1), UINT32_C(0x827C000C), UINT32_C(0x403956FC),
          UINT32_C(0x5CDC1135), UINT32_C(0x3C751158), UINT32_C(0xD967A5B1),
          UINT32_C(0x96201D7D), UINT32_C(0x52AF85BC)},
         {UINT32_C(0x644558F7), UINT32_C(0x522BC492), UINT32_C(0xED7A060D),
          UINT32_C(0xF74A35AF), UINT32_C(0x4DC4619E), UINT32_C(0x10E5F9FD),
          UINT32_C(0x324F60BB), UINT32_C(0x06071F1F)}},
        {{UINT32_C(0x65921C34), UINT32_C(0xC5FFD5EF), UINT32_C(0x302BAA5D),
          UINT32_C(0x46CE1A69), UINT32_C(0x4E22FF1D), UINT32_C(0x89CC84EC),
          UINT32_C(0x68131754), UINT32_C(0x16A481AE)},
         {UINT32_C(0xB89039F5), UINT32_C(0x2A06A156), UINT32_C(0xB3A95AB9),
          UINT32_C(0x40B6401B), UINT32_C(0x313820C3), UINT32_C(0xFFCC53EB),
          UINT32_C(0xEA959F76), UINT32_C(0x256B00E7)}},
        {{UINT32_C(0x54FBDD74), UINT32_C(0xCCE87FC9), UINT32_C(0xB23C6E1D),
          UINT32_C(0xEC258542), UINT32_C(0x9E5E1928), UINT32_C(0x5BE392B4),
          UINT32_C(0x47A8A759), UINT32_C(0x65AF3110)},
         {UINT32_C(0x47DFFD31), UINT32_C(0x943F7A25), UINT32_C(0x51E896FA),
          UINT32_C(0xDCCDA186), UINT32_C(0x933E747F), UINT32_C(0x71A93B1E),
          UINT32_C(0xDFB043AD), UINT32_C(0x44F5C468)}},
        {{UINT32_C(0x786FCCBA), UINT32_C(0xF6AEC52C), UINT32_C(0x6D51FA78),
          UINT32_C(0x23D49DCF), UINT32_C(0x9B40D8E6), UINT32_C(0x0F81463B),
          UINT32_C(0x708D3DA2), UINT32_C(0x18B9D932)},
         {UINT32_C(0xF986DC6D), UINT32_C(0x796F94ED), UINT32_C(0xFC2622C3),
          UINT32_C(0x33B2CCC1), UINT32_C(0x9CCEC606), UINT32_C(0x16790DFB),
          UINT32_C(0xCFD31481), UINT32_C(0x6F5D1452)}},
        {{UINT32_C(0x6C3A15D6), UINT32_C(0x91F15DDC), UINT32_C(0x4D360E75),
          UINT32_C(0x45D12F40), UINT32_C(0x1DAFFC9C), UINT32_C(0xF2E28EE8),
          UINT32_C(0x6CDF5566), UINT32_C(0x5CC6A056)},
         {UINT32_C(0x1779B9BF), UINT32_C(0x855166D2), UINT32_C(0xCF94D9FE),
          UINT32_C(0x92BA5EF4), UINT32_C(0x985BC1DD), UINT32_C(0x1266FB2A),
          UINT32_C(0xCA3018AD), UINT32_C(0x4572CE8F)}},
        {{UINT32_C(0xBE4BB604), UINT32_C(0x8729A12D), UINT32_C(0x4E99E9AB),
          UINT32_C(0x6A29C849), UINT32_C(0x7A89894D), UINT32_C(0x54AE5011),
          UINT32_C(0xCDB0EEBD), UINT32_C(0x5E66A255)},
         {UINT32_C(0xCBEE153B), UINT32_C(0x006736EA), UINT32_C(0x225E7B86),
          UINT32_C(0x8A36CC2D), UINT32_C(0xEC0598EC), UINT32_C(0xF731E430),
          UINT32_C(0x7FD9A11F), UINT32_C(0x49338E4D)}},
        {{UINT32_C(0xDA6DABAA), UINT32_C(0xE038CE03), UINT32_C(0x7C1BCE0C),
          UINT32_C(0x13A08DCE), UINT32_C(0xDA89EFBF), UINT32_C(0x12D00DD0),
          UINT32_C(0x6FCF0510), UINT32_C(0x70A13FB9)},
         {UINT32_C(0x5CDB03E2), UINT32_C(0x16ED1C92), UINT32_C(0x08E9EE4B),
          UINT32_C(0xDF1AB61D), UINT32_C(0x03AF3E3D), UINT32_C(0x48983DA8),
          UINT32_C(0x429DB770), UINT32_C(0x63CCA113)}},
        {{UINT32_C(0xCFB805E5), UINT32_C(0x6D9AC1EB), UINT32_C(0x50FA37B8),
          UINT32_C(0x47C3FE69), UINT32_C(0x2C33D457), UINT32_C(0xD308EC73),
          UINT32_C(0xD4CCA340), UINT32_C(0x3CB08E00)},
         {UINT32_C(0xBE862794), UINT32_C(0xC078DAD0), UINT32_C(0xF4E10A57),
          UINT32_C(0x2D147F83), UINT32_C(0x3DE1B3D5), UINT32_C(0xE91820FF),
          UINT32_C(0x6F30491B), UINT32_C(0x3D85DD72)}},
        {{UINT32_C(0xF5CBDD3A), UINT32_C(0xD486A022), UINT32_C(0xCAC0B99E),
          UINT32_C(0x2663134A), UINT32_C(0x5F3ABFCA), UINT32_C(0x42DE13F5),
          UINT32_C(0xB365B973), UINT32_C(0x4967A225)},
         {UINT32_C(0x10F1F997), UINT32_C(0x99C98A25), UINT32_C(0x7714FAB2),
          UINT32_C(0x23F057C9), UINT32_C(0x1BA2338D), UINT32_C(0xCE07CA6E),
          UINT32_C(0x069F65D7), UINT32_C(0x3BA69161)}},
        {{UINT32_C(0xC026FB0E), UINT32_C(0xCCD8C86F), UINT32_C(0x50407A8C),
          UINT32_C(0xF49F1FEA), UINT32_C(0x7F19A1DB), UINT32_C(0x72FEA37B),
          UINT32_C(0x3F457DB7), UINT32_C(0x22A03E25)},
         {UINT32_C(0x71F736D2), UINT32_C(0x2D6C62B2), UINT32_C(0xA5ACB4E5),
          UINT32_C(0xCC99F8E7), UINT32_C(0x0DE5F380), UINT32_C(0x8F7DBF2E),
          UINT32_C(0x352B4933), UINT32_C(0x24494786)}},
    },
    {
        {{UINT32_C(0xAE2A5E8F), UINT32_C(0xF020E7A9), UINT32_C(0xD14C5F02),
          UINT32_C(0x5ADC788B), UINT32_C(0x65C84DB4), UINT32_C(0xC5E5AFE4),
          UINT32_C(0x35C2633C), UINT32_C(0x392FACC4)},
         {UINT32_C(0x42DEE269), UINT32_C(0x47D50070), UINT32_C(0x6EB7849C),
          UINT32_C(0x76706ED7), UINT32_C(0x316548CB), UINT32_C(0x6BF56D56),
          UINT32_C(0xD37FF4DF), UINT32_C(0x4A466066)}},
        {{UINT32_C(0xC30283AD), UINT32_C(0xC8EBBFB5), UINT32_C(0x3544E645),
          UINT32_C(0x31E9CF96), UINT32_C(0x88886B50), UINT32_C(0x90EA9A49),
          UINT32_C(0x021D3D5D), UINT32_C(0x5E4B8C88)},
         {UINT32_C(0x0DFEB658), UINT32_C(0xA4DB9225), UINT32_C(0x1910FDAE),
          UINT32_C(0x8AA95DB6), UINT32_C(0xDE400EB9), UINT32_C(0x82E9A997),
          UINT32_C(0x96769A04), UINT32_C(0x238967E9)}},
        {{UINT32_C(0x89E2DF0A), UINT32_C(0x1ABB076A), UINT32_C(0x07065929),
          UINT32_C(0xDA8B09B0), UINT32_C(0x63BD349B), UINT32_C(0x332BE8A5),
          UINT32_C(0xA2D35385), UINT32_C(0x0EB973CE)},
         {UINT32_C(0x9C7D375E), UINT32_C(0x67F7AE63), UINT32_C(0xE7AE90B1),
          UINT32_C(0xA235818D), UINT32_C(0x817493B0), UINT32_C(0x2B59C26E),
          UINT32_C(0x33C4ACD6), UINT32_C(0x39DC1050)}},
        {{UINT32_C(0x7B7DB3F5), UINT32_C(0x11801ACE), UINT32_C(0x8CC97CA5),
          UINT32_C(0x79C214C3), UINT32_C(0xBF2674BF), UINT32_C(0xB4BFE1AB),
          UINT32_C(0x43252011), UINT32_C(0x598EA7DC)},
         {UINT32_C(0xB08F8EF5), UINT32_C(0x217FF6D3), UINT32_C(0x8B9226B7),
          UINT32_C(0x9797BBC9), UINT32_C(0x7B0EDB09), UINT32_C(0xAB8E98C9),
          UINT32_C(0x083A401F), UINT32_C(0x240EC22D)}},
        {{UINT32_C(0x459ABC3D), UINT32_C(0x55A75BCF), UINT32_C(0x64ECC2DC),
          UINT32_C(0xB2F98598), UINT32_C(0x9EE84779), UINT32_C(0x271C47C3),
          UINT32_C(0xBF9BDBF2), UINT32_C(0x0166E5D4)},
         {UINT32_C(0x4215B666), UINT32_C(0xD205380F), UINT32_C(0x64E9FE64),
          UINT32_C(0xF7041396), UINT32_C(0x2BB0DA40), UINT32_C(0x4C737E94),
          UINT32_C(0xC8119691), UINT32_C(0x2E763521)}},
        {{UINT32_C(0xFD2F8593), UINT32_C(0x79550B60), UINT32_C(0x0C17A56F),
          UINT32_C(0x47E00AFD), UINT32_C(0xB44157CF), UINT32_C(0x0D900A9D),
          UINT32_C(0xA81BED76), UINT32_C(0x016CF746)},
         {UINT32_C(0xAC47A84B), UINT32_C(0xC21E861B), UINT32_C(0x1724BD47),
          UINT32_C(0x0E14387A), UINT32_C(0x2077F7BC), UINT32_C(0xC209303E),
          UINT32_C(0xBAD12F0B), UINT32_C(0x33B5EB59)}},
        {{UINT32_C(0x9850FC1F), UINT32_C(0x7152354F), UINT32_C(0x83637934),
          UINT32_C(0x1239576F), UINT32_C(0x82AF46BA), UINT32_C(0xB00C4E4E),
          UINT32_C(0xEC3FEEFF), UINT32_C(0x563D5062)},
         {UINT32_C(0x33D67B7F), UINT32_C(0xEF25E373), UINT32_C(0x50D9845E),
          UINT32_C(0x3A80A50E), UINT32_C(0xA5787EF5), UINT32_C(0x1DCED1E9),
          UINT32_C(0xA0F87C3C), UINT32_C(0x15723E9A)}},
        {{UINT32_C(0x2B4A156D), UINT32_C(0x21743511), UINT32_C(0xCD12BD2B),
          UINT32_C(0xB75C041C), UINT32_C(0x79F393A6), UINT32_C(0x6947368C),
          UINT32_C(0x76420E56), UINT32_C(0x32CDE49E)},
         {UINT32_C(0x43D612FF), UINT32_C(0x67FBA315), UINT32_C(0xE3B87BC2),
          UINT32_C(0x697F7FAE), UINT32_C(0x7391129A), UINT32_C(0x980DAFBC),
          UINT32_C(0x6F707469), UINT32_C(0x438B2858)}},
        {{UINT32_C(0x5E9D085F), UINT32_C(0xDA8AD16D), UINT32_C(0x768FA87C),
          UINT32_C(0xE636F1AF), UINT32_C(0xB85FF1F1), UINT32_C(0x08520756),
          UINT32_C(0x6ABB31BE), UINT32_C(0x1B818481)},
         {UINT32_C(0x2E686F1A), UINT32_C(0x25B3DCB9), UINT32_C(0x2B0CB829),
          UINT32_C(0xE1282134), UINT32_C(0x3B9B759C), UINT32_C(0x626232BC),
          UINT32_C(0x38C4338E), UINT32_C(0x797316BB)}},
        {{UINT32_C(0x4A62DCBD), UINT32_C(0xF8365B64), UINT32_C(0x6BF0EFED),
          UINT32_C(0xC2CF51BA), UINT32_C(0xABF74764), UINT32_C(0x37E379EF),
          UINT32_C(0xA350D603), UINT32_C(0x5DC32071)},
         {UINT32_C(0x5B732100), UINT32_C(0x5465CC80), UINT32_C(0xB3BB5366),
          UINT32_C(0x3231B4E3), UINT32_C(0xD0D067CE), UINT32_C(0x23F5385E),
          UINT32_C(0x67D33451), UINT32_C(0x76CD7621)}},
        {{UINT32_C(0x55D857DD), UINT32_C(0xC6C93A05), UINT32_C(0x8F308F7F),
          UINT32_C(0xB4B6F176), UINT32_C(0xC0F13577), UINT32_C(0x2371CD88),
          UINT32_C(0x70807D9D), UINT32_C(0x1E507D6C)},
         {UINT32_C(0xC73E8E2F), UINT32_C(0x7A77CCE1), UINT32_C(0xFCCBDEEB),
          UINT32_C(0x1DD96274), UINT32_C(0x03F378B8), UINT32_C(0xA4DBEA5D),
          UINT32_C(0x2A1C347F), UINT32_C(0x44B4DF55)}},
        {{UINT32_C(0x8D067A47), UINT32_C(0x9853D282), UINT32_C(0x86813E74),
          UINT32_C(0xBF0ADAF4), UINT32_C(0x39409037), UINT32_C(0xFDE1F24D),
          UINT32_C(0x973B045D), UINT32_C(0x0E629604)},
         {UINT32_C(0x3BB92FAB), UINT32_C(0x9880A74B), UINT32_C(0xC6C4D6C6),
          UINT32_C(0xBC4E3405), UINT32_C(0x5184A2D6), UINT32_C(0x98C24318),
          UINT32_C(0xC210C183), UINT32_C(0x07D65412)}},
        {{UINT32_C(0x441A5FBC), UINT32_C(0x3938E528), UINT32_C(0xCCC66B22),
          UINT32_C(0x2CCD837D), UINT32_C(0x5E606282), UINT32_C(0x075FADE7),
          UINT32_C(0x4BB0E76A), UINT32_C(0x32181165)},
         {UINT32_C(0xFC929890), UINT32_C(0xE7240305), UINT32_C(0xE03AAA52),
          UINT32_C(0x1FA427C8), UINT32_C(0x0BC7B9F8), UINT32_C(0xF23C879B),
          UINT32_C(0xD6BBC908), UINT32_C(0x699A1235)}},
        {{UINT32_C(0x14124B8A), UINT32_C(0x20C29781), UINT32_C(0x48000278),
          UINT32_C(0x0C6464B3), UINT32_C(0xD644E10C), UINT32_C(0xF1939127),
          UINT32_C(0x4EC07EE3), UINT32_C(0x47A479E6)},
         {UINT32_C(0x77023389), UINT32_C(0xB6315768), UINT32_C(0x8BFDD90F),
          UINT32_C(0xC0FD319D), UINT32_C(0x6CB022D4), UINT32_C(0x0EBEC200),
          UINT32_C(0x302F58EF), UINT32_C(0x6810DF3D)}},
        {{UINT32_C(0xACB1C3F2), UINT32_C(0xCF97FA07), UINT32_C(0xA2C3F2F1),
          UINT32_C(0xACC60D84), UINT32_C(0x5DEB73D4), UINT32_C(0x4EF3CAAC),
          UINT32_C(0xD5472C1D), UINT32_C(0x654D0D90)},
         {UINT32_C(0xE4729062), UINT32_C(0x5A39A718), UINT32_C(0x8324E0F2),
          UINT32_C(0x84B286B0), UINT32_C(0xD21E8457), UINT32_C(0xA07A01CB),
          UINT32_C(0xB094714E), UINT32_C(0x0EC091C7)}},
        {{UINT32_C(0x895736BD), UINT32_C(0x7AB81940), UINT32_C(0xE4679DF5),
          UINT32_C(0x9AE791B7), UINT32_C(0xF064109B), UINT32_C(0x36163D81),
          UINT32_C(0x0E956B07), UINT32_C(0x3DDEE4A4)},
         {UINT32_C(0xFEAAE47C), UINT32_C(0xE146E7EE), UINT32_C(0x6A8EEC03),
          UINT32_C(0x81C0C2A7), UINT32_C(0xA8C315CB), UINT32_C(0x10BB8DD9),
          UINT32_C(0xD21B9AB0), UINT32_C(0x2CB423D8)}},
    },
    {
        {{UINT32_C(0x166A5B9A), UINT32_C(0x5B11D3C7), UINT32_C(0x8768861D),
          UINT32_C(0x973627BB), UINT32_C(0x5A3E442A), UINT32_C(0x82A5E2CD),
          UINT32_C(0xDDE63678), UINT32_C(0x13F6C741)},
         {UINT32_C(0xD892738E), UINT32_C(0x8DAA3C74), UINT32_C(0xA932376F),
          UINT32_C(0x0A07D651), UINT32_C(0x6892504B), UINT32_C(0xE12612C5),
          UINT32_C(0xCA3FF301), UINT32_C(0x619D2B1D)}},
        {{UINT32_C(0x1B07CEB7), UINT32_C(0x2B6D686F), UINT32_C(0x298D0996),
          UINT32_C(0x90C0260C), UINT32_C(0x102BC73C), UINT32_C(0x8CAAB926),
          UINT32_C(0xAEB3911C), UINT32_C(0x445A6487)},
         {UINT32_C(0x57F17290), UINT32_C(0x7EE1E547), UINT32_C(0x417711BF),
          UINT32_C(0xC055478B), UINT32_C(0x5CFA42C2), UINT32_C(0x29EF9FEC),
          UINT32_C(0x2B8EA0D6), UINT32_C(0x5A022DE4)}},
        {{UINT32_C(0xAEEB2675), UINT32_C(0x81A5EC18), UINT32_C(0xAD1BBA8A),
          UINT32_C(0xA867C5AA), UINT32_C(0x8DB47EBC), UINT32_C(0xAECB3688),
          UINT32_C(0x26D1038F), UINT32_C(0x77CE00BC)},
         {UINT32_C(0x3E68504B), UINT32_C(0xADC635EF), UINT32_C(0xDAE8AF4F),
          UINT32_C(0x0EFC21DE), UINT32_C(0xAC70C4C9), UINT32_C(0xDE57FD43),
          UINT32_C(0xE78FFC0D), UINT32_C(0x123360BE)}},
        {{UINT32_C(0xD82B61DB), UINT32_C(0xD608DB32), UINT32_C(0x8E45C853),
          UINT32_C(0x05AF2A90), UINT32_C(0x9D3B0032), UINT32_C(0xF1B8213E),
          UINT32_C(0xCAD15361), UINT32_C(0x2312F8AB)},
         {UINT32_C(0xC29EE818), UINT32_C(0xDC8D8E32), UINT32_C(0xDE5CD587),
          UINT32_C(0x07D7A475), UINT32_C(0x0C6C38B8), UINT32_C(0x76610913),
          UINT32_C(0xD7984BD9), UINT32_C(0x0131B6C6)}},
        {{UINT32_C(0xCF69C844), UINT32_C(0xC05CD4D0), UINT32_C(0x81A9B005),
          UINT32_C(0x747C092D), UINT32_C(0xD9E39F54), UINT32_C(0x0D793551),
          UINT32_C(0x7FFEF17C), UINT32_C(0x3BBB00DA)},
         {UINT32_C(0x655AD7C1), UINT32_C(0x6CAB83D9), UINT32_C(0x66A8F590),
          UINT32_C(0x601BECD0), UINT32_C(0xAE51811B), UINT32_C(0xFADB086D),
          UINT32_C(0xD69F734B), UINT32_C(0x7768A5D8)}},
        {{UINT32_C(0xF0E2385E), UINT32_C(0x3BB9B347), UINT32_C(0xF7D39F23),
          UINT32_C(0x376C8C48), UINT32_C(0xD82EC840), UINT32_C(0xE656C1A4),
          UINT32_C(0xFC2AC59A), UINT32_C(0x328B25C9)},
         {UINT32_C(0xA046BEE6), UINT32_C(0xD02B2F39), UINT32_C(0x80066D6C),
          UINT32_C(0xDBAB19A5), UINT32_C(0xE938B7F7), UINT32_C(0x6A2E8F67),
          UINT32_C(0xAA7F2661), UINT32_C(0x645A57A1)}},
        {{UINT32_C(0x9A006FAE), UINT32_C(0x6227904D), UINT32_C(0xB598CB72),
          UINT32_C(0xA975FC4C), UINT32_C(0xA1120B82), UINT32_C(0x945BFC2F),
          UINT32_C(0x2AC15CE5), UINT32_C(0x437A8AB4)},
         {UINT32_C(0x0F53317C), UINT32_C(0xA512A107), UINT32_C(0xFF9BD7D6),
          UINT32_C(0x7B552554), UINT32_C(0x54155AF9), UINT32_C(0xF81213E7),
          UINT32_C(0xFDCE0842), UINT32_C(0x0923F42C)}},
        {{UINT32_C(0x5216BB55), UINT32_C(0x13523916), UINT32_C(0x599CA117),
          UINT32_C(0xF27E4C7A), UINT32_C(0x7DD95BE1), UINT32_C(0x464D040A),
          UINT32_C(0x3C417D05), UINT32_C(0x40897486)},
         {UINT32_C(0x7C88E5D7), UINT32_C(0x0A3D16BF), UINT32_C(0xC13B286F),
          UINT32_C(0x0B94C661), UINT32_C(0xE2214821), UINT32_C(0xF73C7126),
          UINT32_C(0xF2F6DAFA), UINT32_C(0x4B3D5BF0)}},
        {{UINT32_C(0xF1A4332A), UINT32_C(0xCFABD8A2), UINT32_C(0xBAAC9A51),
          UINT32_C(0x56DB1546), UINT32_C(0x04416247), UINT32_C(0x8CC5204B),
          UINT32_C(0xF0583310), UINT32_C(0x75EC13BF)},
         {UINT32_C(0xD35B55D0), UINT32_C(0x0D68896E), UINT32_C(0x67FC14D9),
          UINT32_C(0xE89274E2), UINT32_C(0xFC322878), UINT32_C(0x18D425C0),
          UINT32_C(0x916C714A), UINT32_C(0x69477DD7)}},
        {{UINT32_C(0x9BDDF0F9), UINT32_C(0x427CBB6C), UINT32_C(0xDB9F52CB),
          UINT32_C(0xCF6941E2), UINT32_C(0x35E60DFA), UINT32_C(0xEF144DF6),
          UINT32_C(0xB61DF45C), UINT32_C(0x27B5246E)},
         {UINT32_C(0xB8D3D1D9), UINT32_C(0x0E124518), UINT32_C(0x8B313B95),
          UINT32_C(0xBB3BA134), UINT32_C(0x0FA2B7A9), UINT32_C(0x050DCBDF),
          UINT32_C(0x1D0A99B5), UINT32_C(0x50DBCF6D)}},
        {{UINT32_C(0x3924A1E5), UINT32_C(0x8A8B22CB), UINT32_C(0x118F9D55),
          UINT32_C(0x86CB4C5A), UINT32_C(0x5B339C53), UINT32_C(0xE5330ACC),
          UINT32_C(0x66A35A67), UINT32_C(0x6D5FDDF9)},
         {UINT32_C(0x6F6438A5), UINT32_C(0xC9500719), UINT32_C(0x07E5394E),
          UINT32_C(0x9723F2BA), UINT32_C(0x866B45A8), UINT32_C(0xA9CE2117),
          UINT32_C(0x045CA2CA), UINT32_C(0x1B737D8D)}},
        {{UINT32_C(0x6EE00E30), UINT32_C(0x6093F5A5), UINT32_C(0x5DE0A6FC),
          UINT32_C(0x5CAB98D4), UINT32_C(0x65DE754F), UINT32_C(0xADFB652C),
          UINT32_C(0x862EFD1D), UINT32_C(0x679900D1)},
         {UINT32_C(0xAFC5D235), UINT32_C(0x6E5C230F), UINT32_C(0x12CF6DD3),
          UINT32_C(0x3A1E5579), UINT32_C(0x03FB4FA0), UINT32_C(0x241C20FB),
          UINT32_C(0x20F6C013), UINT32_C(0x562FFAE3)}},
        {{UINT32_C(0x397F25EC), UINT32_C(0x6EFC732F), UINT32_C(0xBC1F03B8),
          UINT32_C(0x304D1F7D), UINT32_C(0x8890DADE), UINT32_C(0xA2FA6001),
          UINT32_C(0x51A25539), UINT32_C(0x4F91F97C)},
         {UINT32_C(0x48F4EF02), UINT32_C(0xE75F9C50), UINT32_C(0x218AEE9D),
          UINT32_C(0xCC53F460), UINT32_C(0x10D76649), UINT32_C(0xE7B40489),
          UINT32_C(0x42ECDBA4), UINT32_C(0x148F90A2)}},
        {{UINT32_C(0x1F683AD6), UINT32_C(0xBF45023A), UINT32_C(0x95E868D1),
          UINT32_C(0x2EA5F70C), UINT32_C(0xA97F2DE3), UINT32_C(0x47A19F33),
          UINT32_C(0x8A76ED9F), UINT32_C(0x3C8CCA9E)},
         {UINT32_C(0xE1A268D0), UINT32_C(0x01562C6E), UINT32_C(0xBA4EF01E),
          UINT32_C(0x9EB6EBAC), UINT32_C(0x342410FB), UINT32_C(0x835E64D4),
          UINT32_C(0xFFF4594D), UINT32_C(0x06F96B87)}},
        {{UINT32_C(0xD233612B), UINT32_C(0xE49A383A), UINT32_C(0xC9C14F64),
          UINT32_C(0x3CA5421F), UINT32_C(0xBB53DF81), UINT32_C(0x25192E1B),
          UINT32_C(0xA94C046C), UINT32_C(0x3C1451FE)},
         {UINT32_C(0x0423FAA8), UINT32_C(0x72B270F8), UINT32_C(0x3763888A),
          UINT32_C(0xFF63513D), UINT32_C(0xC1745190), UINT32_C(0xB22F2F20),
          UINT32_C(0x35DEA32C), UINT32_C(0x2E005A7A)}},
        {{UINT32_C(0x6305B2EB), UINT32_C(0x6B5A4E7A), UINT32_C(0x9CCD05D2),
          UINT32_C(0xF017BCA1), UINT32_C(0xD19AD8CB), UINT32_C(0xB37027C9),
          UINT32_C(0x0CBB36A6), UINT32_C(0x2CFCB470)},
         {UINT32_C(0x663F3485), UINT32_C(0x17F4FE51), UINT32_C(0x0DC3467B),
          UINT32_C(0x7DC20A17), UINT32_C(0x4AF63CBD), UINT32_C(0x6B56BA3F),
          UINT32_C(0x0D5D64AF), UINT32_C(0x4E7CF289)}},
    },
    {
        {{UINT32_C(0x7F59D2E9), UINT32_C(0xE2C5CD1F), UINT32_C(0x9D7FBE1E),
          UINT32_C(0x6B9ACEB7), UINT32_C(0xA20225B0), UINT32_C(0x84F0441D),
          UINT32_C(0x8B369FBC), UINT32_C(0x15875CDA)},
         {UINT32_C(0x0659E294), UINT32_C(0xED133277), UINT32_C(0x7AE02043),
          UINT32_C(0x7FAA913E), UINT32_C(0x9DCEDE14), UINT32_C(0xCA0E58DA),
          UINT32_C(0xCDE68547), UINT32_C(0x5F6A70FD)}},
        {{UINT32_C(0xE7282711), UINT32_C(0x524B790D), UINT32_C(0xBCA05694),
          UINT32_C(0x4B4F6246), UINT32_C(0x949AF774), UINT32_C(0x85169ECB),
          UINT32_C(0xCC743068), UINT32_C(0x5B168842)},
         {UINT32_C(0x31FB3BA3), UINT32_C(0xB8D0E9F2), UINT32_C(0x62D471C7),
          UINT32_C(0x56DD4BC3), UINT32_C(0xE2A34F75), UINT32_C(0xB14D689C),
          UINT32_C(0x02E8D2D2), UINT32_C(0x7F4E1717)}},
        {{UINT32_C(0xB17090B9), UINT32_C(0x8EE3491A), UINT32_C(0x6B7EDAF4),
          UINT32_C(0x67C07116), UINT32_C(0x4D0E6CCE), UINT32_C(0x6876E4CE),
          UINT32_C(0xBC5A86BE), UINT32_C(0x6D2FBB64)},
         {UINT32_C(0x070FA8C3), UINT32_C(0x0431C67A), UINT32_C(0x0F5D65F4),
          UINT32_C(0x91EFF9BE), UINT32_C(0xE07088DF), UINT32_C(0x332985E2),
          UINT32_C(0x676EADA8), UINT32_C(0x006D2583)}},
        {{UINT32_C(0x0AA747D6), UINT32_C(0xA1FBCC37), UINT32_C(0xB0DFDF3C),
          UINT32_C(0xADEA4A90), UINT32_C(0x401ED81B), UINT32_C(0x650162C7),
          UINT32_C(0xA8B15E22), UINT32_C(0x0FBC4841)},
         {UINT32_C(0xBF98CDAC), UINT32_C(0x1044B4E8), UINT32_C(0xECD1C668),
          UINT32_C(0x37071115), UINT32_C(0x233C220C), UINT32_C(0x29B93C17),
          UINT32_C(0xE69BC0C0), UINT32_C(0x4BEBC3CC)}},
        {{UINT32_C(0x46BF7E51), UINT32_C(0xD1A16E37), UINT32_C(0xF7A7370C),
          UINT32_C(0x889C7782), UINT32_C(0x3CCB474D), UINT32_C(0xC73F396E),
          UINT32_C(0xB9D67A2E), UINT32_C(0x1C508F18)},
         {UINT32_C(0x6B03B7E7), UINT32_C(0x3F17E967), UINT32_C(0xF857BB26),
          UINT32_C(0x3928F1D8), UINT32_C(0xC0EA8620), UINT32_C(0x3086FB2E),
          UINT32_C(0x1BE7C3E4), UINT32_C(0x15DC32C2)}},
        {{UINT32_C(0x11F4D949), UINT32_C(0xF48D4C32), UINT32_C(0xB0357C05),
          UINT32_C(0xE14A4AE3), UINT32_C(0x151D91AE), UINT32_C(0x77A1121F),
          UINT32_C(0xE8C6869D), UINT32_C(0x33F85C2F)},
         {UINT32_C(0x364B77B0), UINT32_C(0x8EA3BB4C), UINT32_C(0x9BD43E50),
          UINT32_C(0x1F155B91), UINT32_C(0x54748E7D), UINT32_C(0xA6C28730),
          UINT32_C(0xE7DDC539), UINT32_C(0x5AA34DDA)}},
        {{UINT32_C(0xA6CF8A82), UINT32_C(0xF0F80DDA), UINT32_C(0x091663B5),
          UINT32_C(0x87DE6D6C), UINT32_C(0x02FE5519), UINT32_C(0x94798734),
          UINT32_C(0x96722130), UINT32_C(0x109D411F)},
         {UINT32_C(0xE661041F), UINT32_C(0xBC47CA73), UINT32_C(0x65741541),
          UINT32_C(0x071D6059), UINT32_C(0x07E08735), UINT32_C(0x7CD4DF66),
          UINT32_C(0xE68FC807), UINT32_C(0x175E1F77)}},
        {{UINT32_C(0xDA58865B), UINT32_C(0xB88BDAB8), UINT32_C(0x20ED2B89),
          UINT32_C(0x14AD9112), UINT32_C(0x039BF0A3), UINT32_C(0x2B21AEDF),
          UINT32_C(0x9D4B77E9), UINT32_C(0x78971777)},
         {UINT32_C(0xD6612EF3), UINT32_C(0x133DA2AC), UINT32_C(0x12AD1785),
          UINT32_C(0x6260FCF5), UINT32_C(0x9DF08843), UINT32_C(0xDBA784DA),
          UINT32_C(0x4449FBD1), UINT32_C(0x1A30C4CF)}},
        {{UINT32_C(0x4EF7ACA2), UINT32_C(0xB6FECE87), UINT32_C(0x13F7C58C),
          UINT32_C(0x9CE7B61A), UINT32_C(0xF8719A60), UINT32_C(0x6B0223C9),
          UINT32_C(0xA3B3B088), UINT32_C(0x21199AA5)},
         {UINT32_C(0x6938BB02), UINT32_C(0x4A717196), UINT32_C(0xE7ABC263),
          UINT32_C(0x2E9A17C9), UINT32_C(0x4BAB12B7), UINT32_C(0x83F79623),
          UINT32_C(0x49D7CFBD), UINT32_C(0x15C0C4AF)}},
        {{UINT32_C(0x56D2957F), UINT32_C(0x99B34139), UINT32_C(0x07218BB6),
          UINT32_C(0xA51B8DFD), UINT32_C(0xFC91D7C9), UINT32_C(0x47CA4323),
          UINT32_C(0x3DCFD5F0), UINT32_C(0x44B01E75)},
         {UINT32_C(0x8CE894F3), UINT32_C(0x29F9D18E), UINT32_C(0x95227C6F),
          UINT32_C(0x22BCC540), UINT32_C(0x3FC75409), UINT32_C(0x815CD936),
          UINT32_C(0xD8989472), UINT32_C(0x0D58B325)}},
        {{UINT32_C(0xB6C80208), UINT32_C(0x8B4C6980), UINT32_C(0x8FB77CCD),
          UINT32_C(0xA5D97497), UINT32_C(0x9477132F), UINT32_C(0x1B896571),
          UINT32_C(0x3AE45F53), UINT32_C(0x348ABC21)},
         {UINT32_C(0x14BCDB96), UINT32_C(0xE438C1C3), UINT32_C(0x8007C1BF),
          UINT32_C(0x63150CF9), UINT32_C(0x8508B903), UINT32_C(0xDB861A33),
          UINT32_C(0x7B04ECD6), UINT32_C(0x421DFB01)}},
        {{UINT32_C(0x19430E7B), UINT32_C(0xF2FCE58B), UINT32_C(0xD0F8ECB7),
          UINT32_C(0x851A5F03), UINT32_C(0x0A5A1833), UINT32_C(0xE756C167),
          UINT32_C(0x227F866C), UINT32_C(0x25A51405)},
         {UINT32_C(0x3C6EE5F3), UINT32_C(0x40F34CB0), UINT32_C(0xF244B5CF),
          UINT32_C(0xF4010401), UINT32_C(0x01349BCF), UINT32_C(0x0E21BDED),
          UINT32_C(0x04547F42), UINT32_C(0x1B129D82)}},
        {{UINT32_C(0x0927D153), UINT32_C(0x802EC480), UINT32_C(0x72541520),
          UINT32_C(0x0F75E4FE), UINT32_C(0x026C4613), UINT32_C(0xA4A1557A),
          UINT32_C(0x7D92BC18), UINT32_C(0x25E8DAFB)},
         {UINT32_C(0x12F15F05), UINT32_C(0x1D87A143), UINT32_C(0x7B6B4240),
          UINT32_C(0x79390E3C), UINT32_C(0x492E6273), UINT32_C(0xFC199D76),
          UINT32_C(0x7EB090C0), UINT32_C(0x0053F1C4)}},
        {{UINT32_C(0xACEE6DFC), UINT32_C(0xE790F1CA), UINT32_C(0xDFEA04FF),
          UINT32_C(0xC8FB4626), UINT32_C(0x627D88D7), UINT32_C(0xBF03627F),
          UINT32_C(0x3D81A75A), UINT32_C(0x1B369884)},
         {UINT32_C(0x917FA19D), UINT32_C(0x83405DDA), UINT32_C(0x8C7DDCD2),
          UINT32_C(0xFFB23FF9), UINT32_C(0x40F10B48), UINT32_C(0x644F54C7),
          UINT32_C(0x17FF713A), UINT32_C(0x4636FADF)}},
        {{UINT32_C(0x27F417E4), UINT32_C(0xDA62ECC2), UINT32_C(0xFD8662BE),
          UINT32_C(0xC0DBE48F), UINT32_C(0x1011E73C), UINT32_C(0x729EE4AA),
          UINT32_C(0x3E11C84B), UINT32_C(0x4BAE5D3C)},
         {UINT32_C(0x6CEF6CDA), UINT32_C(0x854DFFF8), UINT32_C(0xCB7131EA),
          UINT32_C(0x7939228C), UINT32_C(0xD3EBC607), UINT32_C(0x58B3744A),
          UINT32_C(0x2049E239), UINT32_C(0x6EB9248F)}},
        {{UINT32_C(0xED0D4E57), UINT32_C(0x0265CAE9), UINT32_C(0x8AA65AEF),
          UINT32_C(0x92166D02), UINT32_C(0x198345D6), UINT32_C(0x2E337CDA),
          UINT32_C(0xABE1AD7B), UINT32_C(0x6775330C)},
         {UINT32_C(0xBF6FBC7D), UINT32_C(0xA9A828A8), UINT32_C(0xCBFEA393),
          UINT32_C(0x33A56F8D), UINT32_C(0xD811EC51), UINT32_C(0x2DB72F77),
          UINT32_C(0x8327C78E), UINT32_C(0x3DDFCD26)}},
    },
    {
        {{UINT32_C(0xB46AA2C4), UINT32_C(0x7CF8A521), UINT32_C(0xACF0D567),
          UINT32_C(0xE3B20937), UINT32_C(0xA440648E), UINT32_C(0xD47D8D1B),
          UINT32_C(0x1E9791A1), UINT32_C(0x674E7920)},
         {UINT32_C(0x18366462), UINT32_C(0x27B714EB), UINT32_C(0x8476F588),
          UINT32_C(0x1526E558), UINT32_C(0x6C240D70), UINT32_C(0x72C8D374),
          UINT32_C(0x805C1265), UINT32_C(0x066BBAFB)}},
        {{UINT32_C(0x457034E1), UINT32_C(0x15F1CFF5), UINT32_C(0xDD819FA7),
          UINT32_C(0xCF7C6550), UINT32_C(0x77AC7AD6), UINT32_C(0x57C2CD53),
          UINT32_C(0xAFED669D), UINT32_C(0x7DB2A8BE)},
         {UINT32_C(0xD4697340), UINT32_C(0x2DAFD95F), UINT32_C(0x15A6B6E7),
          UINT32_C(0x382FF892), UINT32_C(0xBF4A6B1B), UINT32_C(0x036FC753),
          UINT32_C(0xE4012711), UINT32_C(0x3E7AC46D)}},
        {{UINT32_C(0x5752A34D), UINT32_C(0xBA5ECDED), UINT32_C(0x6BAA08DD),
          UINT32_C(0xB08749D4), UINT32_C(0x4A4A47A8), UINT32_C(0x8A2B9897),
          UINT32_C(0xE42DCE02), UINT32_C(0x7230966F)},
         {UINT32_C(0x58654FF5), UINT32_C(0xA6FF614A), UINT32_C(0xAB3C2A7E),
          UINT32_C(0x7F3531D1), UINT32_C(0x0D0ED417), UINT32_C(0x0282A2F0),
          UINT32_C(0xEA9755A3), UINT32_C(0x2DC7B872)}},
        {{UINT32_C(0x2392536A), UINT32_C(0x7678D765), UINT32_C(0x574C657D),
          UINT32_C(0x0C2025F1), UINT32_C(0x795413DC), UINT32_C(0x01701C80),
          UINT32_C(0x5396279E), UINT32_C(0x63F0D496)},
         {UINT32_C(0xFA32EA64), UINT32_C(0xB0F9968A), UINT32_C(0x5BB393DE),
          UINT32_C(0x81265D15), UINT32_C(0x0BCD8C10), UINT32_C(0xC05ECC6D),
          UINT32_C(0x2824457E), UINT32_C(0x4F3769F9)}},
        {{UINT32_C(0xF13DB92E), UINT32_C(0x9AA58686), UINT32_C(0xED2E1B18),
          UINT32_C(0x1155CDF4), UINT32_C(0x09823F5A), UINT32_C(0xA06E9194),
          UINT32_C(0x4257AB0E), UINT32_C(0x7F1BBE73)},
         {UINT32_C(0xABA6FCD1), UINT32_C(0x2DFB6472), UINT32_C(0xD73D850E),
          UINT32_C(0x04BE6BCA), UINT32_C(0x297D312B), UINT32_C(0x72AAEC34),
          UINT32_C(0x7509D9F5), UINT32_C(0x31F4C02C)}},
        {{UINT32_C(0x7CA72AD5), UINT32_C(0xAA9BA000), UINT32_C(0x7FBCB4D6),
          UINT32_C(0x21EE2945), UINT32_C(0x1CF8580A), UINT32_C(0x0E210AAB),
          UINT32_C(0x0FA8DE10), UINT32_C(0x600479FE)},
         {UINT32_C(0x54322F70), UINT32_C(0x246FD265), UINT32_C(0x60DF1893),
          UINT32_C(0xC60BE9BB), UINT32_C(0x05137E38), UINT32_C(0x04D4F99D),
          UINT32_C(0x6164C176), UINT32_C(0x6ACB9E01)}},
        {{UINT32_C(0xC1DB7B6C), UINT32_C(0x126F2C7E), UINT32_C(0xCF4DD3C0),
          UINT32_C(0x4C3B30B5), UINT32_C(0xF782A489), UINT32_C(0x827D57A2),
          UINT32_C(0xE52621F0), UINT32_C(0x41B897DE)},
         {UINT32_C(0xDDA0A3CD), UINT32_C(0xED31C55A), UINT32_C(0xA11AD179),
          UINT32_C(0x21C91BB2), UINT32_C(0x43FD6E23), UINT32_C(0x60E606B8),
          UINT32_C(0x51ED7FA6), UINT32_C(0x31B8138D)}},
        {{UINT32_C(0xE72E4BC5), UINT32_C(0x1387B313), UINT32_C(0x82EBFC72),
          UINT32_C(0xDCCCB09C), UINT32_C(0xAA4432D6), UINT32_C(0xF0B01202),
          UINT32_C(0x7C52B69D), UINT32_C(0x632599C4)},
         {UINT32_C(0xBCE9A04C), UINT32_C(0x3922D0C0), UINT32_C(0xB53F4268),
          UINT32_C(0xC2397D88), UINT32_C(0x00669858), UINT32_C(0x50AE5ED9),
          UINT32_C(0x16C7696B), UINT32_C(0x1B2BD4C2)}},
        {{UINT32_C(0x2BF7DF06), UINT32_C(0x6FAE1B08), UINT32_C(0x5210DB3B),
          UINT32_C(0x870B3FE8), UINT32_C(0x9BDC0B91), UINT32_C(0x680BE422),
          UINT32_C(0xBCC970AD), UINT32_C(0x56BA83C6)},
         {UINT32_C(0x859D6C78), UINT32_C(0x1AE91BAC), UINT32_C(0x2895A1A6),
          UINT32_C(0xC5BDD5FB), UINT32_C(0x550610F5), UINT32_C(0xA169E73C),
          UINT32_C(0x0CC7D3EA), UINT32_C(0x01B46767)}},
        {{UINT32_C(0x0EC5ECE2), UINT32_C(0x1E147A51), UINT32_C(0xD0E2C46C),
          UINT32_C(0x9B612A1F), UINT32_C(0x5E293783), UINT32_C(0x664FDD55),
          UINT32_C(0x67DC4DBC), UINT32_C(0x52070E15)},
         {UINT32_C(0x4A4903FB), UINT32_C(0x449B53E5), UINT32_C(0xA8D30103),
          UINT32_C(0x79B53583), UINT32_C(0xAF7CC314), UINT32_C(0x616C97F3),
          UINT32_C(0x2849862C), UINT32_C(0x6BEB304C)}},
        {{UINT32_C(0x019F0313), UINT32_C(0xB9C636D6), UINT32_C(0xD3E0188D),
          UINT32_C(0x0B08E7CB), UINT32_C(0xD704DE15), UINT32_C(0xEAEB1715),
          UINT32_C(0x837E7543), UINT32_C(0x4990282C)},
         {UINT32_C(0xFBD3A061), UINT32_C(0xCBB0BD49), UINT32_C(0x1DA124AE),
          UINT32_C(0x3454A8AC), UINT32_C(0x37D64EAB), UINT32_C(0x0D524A02),
          UINT32_C(0x0B3E4ADE), UINT32_C(0x76680749)}},
        {{UINT32_C(0x95B04835), UINT32_C(0xC293E011), UINT32_C(0x23D0C885),
          UINT32_C(0x76D304BA), UINT32_C(0xD6552D80), UINT32_C(0x36A63627),
          UINT32_C(0xC504CCAB), UINT32_C(0x3B4FA680)},
         {UINT32_C(0xE1FC08DF), UINT32_C(0xF25B3A04), UINT32_C(0x62D080F8),
          UINT32_C(0x786380E5), UINT32_C(0xDAC0D110), UINT32_C(0x0A731427),
          UINT32_C(0xD628429A), UINT32_C(0x1D65288F)}},
        {{UINT32_C(0xDC94453E), UINT32_C(0x3CE5E929), UINT32_C(0xB6073324),
          UINT32_C(0xEC7CF988), UINT32_C(0xDCB35234), UINT32_C(0x023361E7),
          UINT32_C(0xF5E89B7C), UINT32_C(0x3AF20624)},
         {UINT32_C(0xA5B2B103), UINT32_C(0x860F188E), UINT32_C(0xCB6D112F),
          UINT32_C(0x5EAC84CE), UINT32_C(0x914C9FFD), UINT32_C(0x63B200C3),
          UINT32_C(0x55A1FDCB), UINT32_C(0x327870A0)}},
        {{UINT32_C(0x155280ED), UINT32_C(0x4F94633C), UINT32_C(0x3654B8AA),
          UINT32_C(0xF98321D5), UINT32_C(0x489AE89A), UINT32_C(0x9C057A23),
          UINT32_C(0xD59CA3B5), UINT32_C(0x1124A1FB)},
         {UINT32_C(0x1F64AFD7), UINT32_C(0x2F4CE052), UINT32_C(0x7C789152),
          UINT32_C(0x841EE441), UINT32_C(0x59A98374), UINT32_C(0x93531ED4),
          UINT32_C(0x36BB8F07), UINT32_C(0x69A4F48C)}},
        {{UINT32_C(0x5FD512A7), UINT32_C(0xD8FFD243), UINT32_C(0x9BEA1738),
          UINT32_C(0xF48C96F1), UINT32_C(0x0FFB4553), UINT32_C(0xF70E1F6A),
          UINT32_C(0x5FF91D21), UINT32_C(0x29DB63B1)},
         {UINT32_C(0x77BF7279), UINT32_C(0xC1355C23), UINT32_C(0xA2FC904D),
          UINT32_C(0xD3946EE9), UINT32_C(0xE7B7A9F4), UINT32_C(0x07223881),
          UINT32_C(0x56E08ED6), UINT32_C(0x212D8967)}},
        {{UINT32_C(0x45503451), UINT32_C(0x32B8C22A), UINT32_C(0xE6AB7B3D),
          UINT32_C(0x9E4FDAF1), UINT32_C(0x04A31294), UINT32_C(0x7A300E3D),
          UINT32_C(0x05FE2AEB), UINT32_C(0x0F529DFD)},
         {UINT32_C(0x9951B6FB), UINT32_C(0x7EFFEA9E), UINT32_C(0x336B9A2B),
          UINT32_C(0x18C60266), UINT32_C(0x6C8D0EEC), UINT32_C(0xB78A5EE1),
          UINT32_C(0x46ED0B23), UINT32_C(0x68C17FE4)}},
    },
    {
        {{UINT32_C(0x96B3222E), UINT32_C(0xF707FAD5), UINT32_C(0x0223F804),
          UINT32_C(0xD6AF6161), UINT32_C(0x4F43A0E9), UINT32_C(0x13FFDC74),
          UINT32_C(0x3347F487), UINT32_C(0x6A3B70E9)},
         {UINT32_C(0x6A4AF4F5), UINT32_C(0xBDDF02A4), UINT32_C(0xE4C69950),
          UINT32_C(0x61B451E1), UINT32_C(0xF9E3BB99), UINT32_C(0xFF854590),
          UINT32_C(0x7CD54C54), UINT32_C(0x46EB1F69)}},
        {{UINT32_C(0x8E6848D3), UINT32_C(0x70E643B6), UINT32_C(0x848C2587),
          UINT32_C(0xC58B8519), UINT32_C(0xEDF4A38E), UINT32_C(0x2F195C54),
          UINT32_C(0x3D2A52E8), UINT32_C(0x206E6A32)},
         {UINT32_C(0x417595BF), UINT32_C(0x234845B5), UINT32_C(0xFF5AE3CB),
          UINT32_C(0x90354373), UINT32_C(0x89C0E555), UINT32_C(0x13BE31CE),
          UINT32_C(0xCC67E26F), UINT32_C(0x2D18AA43)}},
        {{UINT32_C(0xF041BD17), UINT32_C(0xC74EE8C4), UINT32_C(0xC2B3CC64),
          UINT32_C(0x655CF527), UINT32_C(0x160FF053), UINT32_C(0x6735CF0A),
          UINT32_C(0x04218A0D), UINT32_C(0x35DAB9EB)},
         {UINT32_C(0xCBC34E46), UINT32_C(0x32BB2E9A), UINT32_C(0x7D190342),
          UINT32_C(0xF780CEAF), UINT32_C(0x9F0DA1A4), UINT32_C(0x161C0C1A),
          UINT32_C(0xE7642FD6), UINT32_C(0x7B198C9E)}},
        {{UINT32_C(0x122FD0B4), UINT32_C(0x936C763E), UINT32_C(0xA7E0C435),
          UINT32_C(0xA3819ED9), UINT32_C(0xCAAE6D7B), UINT32_C(0x86228B04),
          UINT32_C(0x7A3C65B4), UINT32_C(0x2E116018)},
         {UINT32_C(0xD4EB0345), UINT32_C(0xF55BB1F3), UINT32_C(0x0630B569),
          UINT32_C(0x858A0BF4), UINT32_C(0xCB78A626), UINT32_C(0x8CC22657),
          UINT32_C(0xB45E3005), UINT32_C(0x7CD93BDE)}},
        {{UINT32_C(0x98E517AB), UINT32_C(0xCAA1F459), UINT32_C(0xB34A6F5C),
          UINT32_C(0x36E60281), UINT32_C(0x0B46F47F), UINT32_C(0x877A49F3),
          UINT32_C(0x9E7BE761), UINT32_C(0x0179824B)},
         {UINT32_C(0xD455D9C0), UINT32_C(0x6830A2B2), UINT32_C(0x7BA31962),
          UINT32_C(0xB734BA0A), UINT32_C(0x065C3B51), UINT32_C(0x344665A4),
          UINT32_C(0x562E7F1D), UINT32_C(0x0B1D2210)}},
        {{UINT32_C(0x0B2E22E8), UINT32_C(0x289BAFCA), UINT32_C(0x83390107),
          UINT32_C(0x038929A0), UINT32_C(0x0683E782), UINT32_C(0x968A014D),
          UINT32_C(0x53D34463), UINT32_C(0x5A1AD5C8)},
         {UINT32_C(0x9527B2CA), UINT32_C(0xA2613334), UINT32_C(0x310B745F),
          UINT32_C(0xE8471271), UINT32_C(0x31387F59), UINT32_C(0x49C81A26),
          UINT32_C(0x0343C691), UINT32_C(0x1B955AF7)}},
        {{UINT32_C(0xA4A9FCA4), UINT32_C(0x069328AD), UINT32_C(0x624FCB94),
          UINT32_C(0x14EF09A7), UINT32_C(0xE3E0CECD), UINT32_C(0x21C76F0D),
          UINT32_C(0x6C1BCE0F), UINT32_C(0x5F470B86)},
         {UINT32_C(0xB15BC8B4), UINT32_C(0x79319A3F), UINT32_C(0xDB06AFA1),
          UINT32_C(0xB1407CB1), UINT32_C(0x911116E0), UINT32_C(0xD69E9E09),
          UINT32_C(0x0756579E), UINT32_C(0x6E77524E)}},
        {{UINT32_C(0xE2D851D5), UINT32_C(0xD3EC5EBC), UINT32_C(0x03B63143),
          UINT32_C(0xC888BC23), UINT32_C(0xDB0C357F), UINT32_C(0x5F3DE41E),
          UINT32_C(0xC3D47D37), UINT32_C(0x646FFBD3)},
         {UINT32_C(0x0692639B), UINT32_C(0xE53F8BEB), UINT32_C(0xD4FBC3D4),
          UINT32_C(0x7E194E37), UINT32_C(0x452B2A2E), UINT32_C(0xE1988A22),
          UINT32_C(0xB013F9E1), UINT32_C(0x5D359A15)}},
        {{UINT32_C(0xB2A6627D), UINT32_C(0xA48160A7), UINT32_C(0x3CE8789E),
          UINT32_C(0x5EFDC848), UINT32_C(0xB1CD14EE), UINT32_C(0x264CBFF1),
          UINT32_C(0x44D84222), UINT32_C(0x288823D4)},
         {UINT32_C(0x3A6DB1F8), UINT32_C(0x2F091B23), UINT32_C(0xCEA89B44),
          UINT32_C(0xBFD737B5), UINT32_C(0x17F5E969), UINT32_C(0x682AB86C),
          UINT32_C(0xABB0FA87), UINT32_C(0x7653005C)}},
        {{UINT32_C(0xD4B8A43A), UINT32_C(0x619C2629), UINT32_C(0xB6DAF943),
          UINT32_C(0xBFDAF433), UINT32_C(0x6D640DB8), UINT32_C(0xDC7AA1EE),
          UINT32_C(0x3B08D55C), UINT32_C(0x35ADEEA8)},
         {UINT32_C(0xD7AF5382), UINT32_C(0x30935454), UINT32_C(0x3D68A24A),
          UINT32_C(0x1F9C51A1), UINT32_C(0x78BDBEA9), UINT32_C(0xDBD13CFC),
          UINT32_C(0x31210A3F), UINT32_C(0x003B6D99)}},
        {{UINT32_C(0x9C2B515D), UINT32_C(0xD4547A32), UINT32_C(0xFECDAAA9),
          UINT32_C(0x4AF29AA8), UINT32_C(0xE401D5AD), UINT32_C(0x85C80ECD),
          UINT32_C(0x8AA315A1), UINT32_C(0x2830332D)},
         {UINT32_C(0x71DCE198), UINT32_C(0x56758823), UINT32_C(0x6ACBDEE3),
          UINT32_C(0x55AC9D10), UINT32_C(0x575CF4BB), UINT32_C(0xF6D468CF),
          UINT32_C(0x576B5C4A), UINT32_C(0x46E4FA98)}},
        {{UINT32_C(0x20D859EF), UINT32_C(0xAD20F820), UINT32_C(0x2A5462B0),
          UINT32_C(0x38091588), UINT32_C(0x2135DA7D), UINT32_C(0x35F45C9F),
          UINT32_C(0xF7F20DBD), UINT32_C(0x6B426F91)},
         {UINT32_C(0xF96E77D2), UINT32_C(0x4A0D8CBE), UINT32_C(0xCC51D3F4),
          UINT32_C(0x8FC36F5B), UINT32_C(0xBE16A0A8), UINT32_C(0x7A1870DD),
          UINT32_C(0x114DB780), UINT32_C(0x29C3E2B3)}},
        {{UINT32_C(0x21779E6E), UINT32_C(0xFF692A4C), UINT32_C(0xA6026EC1),
          UINT32_C(0x698231AB), UINT32_C(0xEF03E21B), UINT32_C(0xDAB0D835),
          UINT32_C(0xC846D56F), UINT32_C(0x770BFFAC)},
         {UINT32_C(0x3B8B0747), UINT32_C(0xCD28722D), UINT32_C(0x32AE95E5),
          UINT32_C(0x3DEFE040), UINT32_C(0x0F9857D6), UINT32_C(0x6F5D816A),
          UINT32_C(0xFC630F5E), UINT32_C(0x2E483FED)}},
        {{UINT32_C(0x967C7140), UINT32_C(0xDBF82EC4), UINT32_C(0x0D20A2A5),
          UINT32_C(0x6265CAD1), UINT32_C(0x5862DEFE), UINT32_C(0x1509652B),
          UINT32_C(0x94A284E5), UINT32_C(0x699DD939)},
         {UINT32_C(0x0B2CC732), UINT32_C(0xC0116646), UINT32_C(0x94C3EF86),
          UINT32_C(0x583FE012), UINT32_C(0xCD353430), UINT32_C(0xCD5DAEA8),
          UINT32_C(0xC7ADA62B), UINT32_C(0x2B39A746)}},
        {{UINT32_C(0xE4257BBC), UINT32_C(0xF449B989), UINT32_C(0xA90DCCE6),
          UINT32_C(0x95BA21BA), UINT32_C(0x93CA4ACD), UINT32_C(0xDD53AD5C),
          UINT32_C(0x0BB4213B), UINT32_C(0x7FCF2738)},
         {UINT32_C(0xC2E7E54E), UINT32_C(0x0E57C1C0), UINT32_C(0xA1A0E975),
          UINT32_C(0xD1769DAE), UINT32_C(0xC3B6E13B), UINT32_C(0x68F62C4E),
          UINT32_C(0x781242D8), UINT32_C(0x75152F9A)}},
        {{UINT32_C(0x24B8B820), UINT32_C(0x4D582768), UINT32_C(0x5BBD9F84),
          UINT32_C(0x36E37AC4), UINT32_C(0xDA076F12), UINT32_C(0x1F34414A),
          UINT32_C(0x3E0333C6), UINT32_C(0x08A77C28)},
         {UINT32_C(0xD9193382), UINT32_C(0xBB1F017D), UINT32_C(0x83A5612D),
          UINT32_C(0x56E9AA24), UINT32_C(0xD0B4554F), UINT32_C(0x6959B02B),
          UINT32_C(0xE4559B52), UINT32_C(0x2479BC56)}},
    },
    {
        {{UINT32_C(0x0F570A8E), UINT32_C(0x96D631C6), UINT32_C(0xD714B807),
          UINT32_C(0xE3F566A3), UINT32_C(0xEF7E1550), UINT32_C(0x564DD512),
          UINT32_C(0x79FA2F58), UINT32_C(0x1C5CF24A)},
         {UINT32_C(0x897958DB), UINT32_C(0x973BA599), UINT32_C(0x11A9CBB1),
          UINT32_C(0x93951D17), UINT32_C(0xA37A969A), UINT32_C(0x86BA17F6),
          UINT32_C(0xA069B195), UINT32_C(0x4807CAC7)}},
        {{UINT32_C(0x6665B35E), UINT32_C(0xB64AC0D4), UINT32_C(0x7EF72C68),
          UINT32_C(0xBA9CD394), UINT32_C(0x9C4CBC44), UINT32_C(0x838807B2),
          UINT32_C(0x82770197), UINT32_C(0x2675D268)},
         {UINT32_C(0x17087FA9), UINT32_C(0xBFC2F137), UINT32_C(0xE7B79B31),
          UINT32_C(0x811E644B), UINT32_C(0xC963A061), UINT32_C(0x597CE23F),
          UINT32_C(0x2EA0DEB0), UINT32_C(0x40BC32E4)}},
        {{UINT32_C(0x27C85959), UINT32_C(0xC0AEFB50), UINT32_C(0x058E0FDD),
          UINT32_C(0x76D1087E), UINT32_C(0x7E51A6F8), UINT32_C(0x6ADA5AAF),
          UINT32_C(0x054A058D), UINT32_C(0x424B16E0)},
         {UINT32_C(0x63AF9766), UINT32_C(0x9A2C20A9), UINT32_C(0x3CF18DAB),
          UINT32_C(0x4C1CB532), UINT32_C(0x6C5D6A00), UINT32_C(0x599CD929),
          UINT32_C(0x8AA311BF), UINT32_C(0x57C39BAE)}},
        {{UINT32_C(0xCD987F02), UINT32_C(0x3FDF5B46), UINT32_C(0x353175C4),
          UINT32_C(0x57755078), UINT32_C(0xCD578394), UINT32_C(0x80223EC0),
          UINT32_C(0xAEB7D278), UINT32_C(0x04BBA6AC)},
         {UINT32_C(0x8688BFB2), UINT32_C(0xD27FD2BE), UINT32_C(0xC27A62E5),
          UINT32_C(0xB2F80278), UINT32_C(0x339429D8), UINT32_C(0x8BA6FB07),
          UINT32_C(0x3AB70AA0), UINT32_C(0x57737FF6)}},
        {{UINT32_C(0x8EAEB3C9), UINT32_C(0x0140E47F), UINT32_C(0x735AC8EA),
          UINT32_C(0xB91C9798), UINT32_C(0x83D4EFAA), UINT32_C(0x325E0312),
          UINT32_C(0xD9C5888E), UINT32_C(0x1E7DA3BE)},
         {UINT32_C(0xF7F1EB13), UINT32_C(0xA210CDA6), UINT32_C(0x936EA9E9),
          UINT32_C(0xEDC1F6B3), UINT32_C(0x1B097F65), UINT32_C(0x46E831C4),
          UINT32_C(0x1939A0AE), UINT32_C(0x00857601)}},
        {{UINT32_C(0x1F68BB40), UINT32_C(0x7C26F711), UINT32_C(0x39DDBE6D),
          UINT32_C(0xEA69C845), UINT32_C(0xE5316F22), UINT32_C(0x590BF426),
          UINT32_C(0xCC2DF9C9), UINT32_C(0x40CDC921)},
         {UINT32_C(0xF3F991C6), UINT32_C(0x28A32DDE), UINT32_C(0x5356CA78),
          UINT32_C(0xD75B59E6), UINT32_C(0xD1F5F318), UINT32_C(0xB5DD3861),
          UINT32_C(0xE7929834), UINT32_C(0x09EB1A2D)}},
        {{UINT32_C(0xDBC0370D), UINT32_C(0x701F9A2D), UINT32_C(0x2870B59D),
          UINT32_C(0x559D0FAF), UINT32_C(0x55367B5D), UINT32_C(0xE89E5DF0),
          UINT32_C(0x74005A58), UINT32_C(0x22BBD4FC)},
         {UINT32_C(0x99CDC76B), UINT32_C(0x7ACED1E4), UINT32_C(0xE3C219D3),
          UINT32_C(0xD41C827C), UINT32_C(0x8221D91F), UINT32_C(0x5AF3F2AE),
          UINT32_C(0xE5B6BC98), UINT32_C(0x6D62C990)}},
        {{UINT32_C(0x7FFC9D0F), UINT32_C(0x23B2A0BF), UINT32_C(0x974CA299),
          UINT32_C(0xED98F71D), UINT32_C(0x151D559B), UINT32_C(0x10F8C07A),
          UINT32_C(0x8E949C62), UINT32_C(0x40E46FC3)},
         {UINT32_C(0xBBE55338), UINT32_C(0x0CF53E34), UINT32_C(0x115520D4),
          UINT32_C(0xF2D6CF26), UINT32_C(0x590B4E23), UINT32_C(0x915FF09A),
          UINT32_C(0xBEDC75F2), UINT32_C(0x072E4233)}},
        {{UINT32_C(0x997E9BFA), UINT32_C(0xB67A6B60), UINT32_C(0x973BC3E7),
          UINT32_C(0xE7686AC9), UINT32_C(0x0B228320), UINT32_C(0x9525B449),
          UINT32_C(0x7ADE8F19), UINT32_C(0x6C727583)},
         {UINT32_C(0x062FF3D5), UINT32_C(0x3D064298), UINT32_C(0x07E22768),
          UINT32_C(0x5483826C), UINT32_C(0x1F7A64A4), UINT32_C(0xF4ADE921),
          UINT32_C(0xBD92EB25), UINT32_C(0x70BDDCF7)}},
        {{UINT32_C(0x5D8A9E36), UINT32_C(0xA8DB3611), UINT32_C(0xFA81065A),
          UINT32_C(0xAA6A5F33), UINT32_C(0x366DDA90), UINT32_C(0x8EC120A3),
          UINT32_C(0xD8A15CF7), UINT32_C(0x2AA0AB25)},
         {UINT32_C(0xA0DFFB9C), UINT32_C(0x5E11E169), UINT32_C(0x118408A7),
          UINT32_C(0x8C7572E9), UINT32_C(0x35833ADF), UINT32_C(0x4EEFD13E),
          UINT32_C(0xFC2C1811), UINT32_C(0x2C6732E8)}},
        {{UINT32_C(0xB1537DF6), UINT32_C(0x15D063F9), UINT32_C(0x0414FCFD),
          UINT32_C(0x864176B3), UINT32_C(0x8FF9E32E), UINT32_C(0x9C0A194C),
          UINT32_C(0xDDE1540B), UINT32_C(0x4DB14C6F)},
         {UINT32_C(0x31F6493F), UINT32_C(0xFAA4AED4), UINT32_C(0xD3C41A46),
          UINT32_C(0x2C479F1D), UINT32_C(0x8E5E85A2), UINT32_C(0xC3119667),
          UINT32_C(0x84E9A76C), UINT32_C(0x7E567C80)}},
        {{UINT32_C(0x689A6B95), UINT32_C(0xB9E2C92A), UINT32_C(0x3B635B01),
          UINT32_C(0xCCEAC383), UINT32_C(0x34AAB952), UINT32_C(0x04FEA465),
          UINT32_C(0x63B5CF63), UINT32_C(0x772E5027)},
         {UINT32_C(0x25830581), UINT32_C(0xCB94F5D2), UINT32_C(0xC77FB7DE),
          UINT32_C(0x791004AF), UINT32_C(0x5140E4AE), UINT32_C(0x53273C33),
          UINT32_C(0xA524419F), UINT32_C(0x0C2D329E)}},
        {{UINT32_C(0xB307B0E4), UINT32_C(0xB7CEDA36), UINT32_C(0x0F8F9667),
          UINT32_C(0x12DF7FD0), UINT32_C(0xBF62BD94), UINT32_C(0x74274002),
          UINT32_C(0xC436C319), UINT32_C(0x6765C73D)},
         {UINT32_C(0xF6EEC946), UINT32_C(0x79B64CE5), UINT32_C(0xDAB258B6),
          UINT32_C(0x3B1B4B43), UINT32_C(0xEE1F8B84), UINT32_C(0x377819A3),
          UINT32_C(0x76D0EB1F), UINT32_C(0x1F45F1D6)}},
        {{UINT32_C(0x58C953AD), UINT32_C(0xCC5BF9B3), UINT32_C(0x7BAD1D2C),
          UINT32_C(0x8303250F), UINT32_C(0xF164972B), UINT32_C(0xBCA7BC36),
          UINT32_C(0xB1DFDA64), UINT32_C(0x2CACF8A9)},
         {UINT32_C(0xD4E2A06F), UINT32_C(0xB03A59B9), UINT32_C(0x1B7FB8FD),
          UINT32_C(0xFED68E68), UINT32_C(0x7E747AE6), UINT32_C(0x08F75A52),
          UINT32_C(0x37A4420B), UINT32_C(0x3299EA6B)}},
        {{UINT32_C(0x932E5BA6), UINT32_C(0x49A00BE6), UINT32_C(0x56114C4B),
          UINT32_C(0x49212505), UINT32_C(0x376183C7), UINT32_C(0x786B7D31),
          UINT32_C(0xDD8A5EAF), UINT32_C(0x01F9E229)},
         {UINT32_C(0x53094AD4), UINT32_C(0xE9B8E990), UINT32_C(0xBFAEDFA8),
          UINT32_C(0x2EDA305C), UINT32_C(0x7F9E3BC8), UINT32_C(0x34443726),
          UINT32_C(0x6B55B3C3), UINT32_C(0x1729519C)}},
        {{UINT32_C(0x50A597D6), UINT32_C(0xEA5A68C0), UINT32_C(0xF1E86D1B),
          UINT32_C(0xA65147D4), UINT32_C(0x8B47CDEB), UINT32_C(0x554FA36B),
          UINT32_C(0x9F24FFED), UINT32_C(0x7F38364B)},
         {UINT32_C(0x1D2A8E2B), UINT32_C(0x657C7E05), UINT32_C(0xE3F64D62),
          UINT32_C(0x8270F1A7), UINT32_C(0x953AF5A2), UINT32_C(0xFD258B59),
          UINT32_C(0x43510AA3), UINT32_C(0x6DE01141)}},
    },
    {
        {{UINT32_C(0x0D7A5CBE), UINT32_C(0x48390428), UINT32_C(0xDE441E5E),
          UINT32_C(0xD37E8C1F), UINT32_C(0x0DE31C8C), UINT32_C(0x908C88B8),
          UINT32_C(0x0ACD87CE), UINT32_C(0x7C0E24BB)},
         {UINT32_C(0x25ECCCE8), UINT32_C(0x4A781177), UINT32_C(0xCBDA746F),
          UINT32_C(0xC06C2F7A), UINT32_C(0xAB565DD4), UINT32_C(0xDB9E9A08),
          UINT32_C(0xBE776F5B), UINT32_C(0x1E9B44C0)}},
        {{UINT32_C(0x85B54ABC), UINT32_C(0x7CFD4E50), UINT32_C(0xE7A44F8B),
          UINT32_C(0x41A4A4DC), UINT32_C(0xA4422576), UINT32_C(0x751C5052),
          UINT32_C(0xD56B6CB1), UINT32_C(0x534FE0B2)},
         {UINT32_C(0xD5D767D0), UINT32_C(0x22DAA5CD), UINT32_C(0x0AF8E22C),
          UINT32_C(0x9C1999AB), UINT32_C(0x99259068), UINT32_C(0xC70C0932),
          UINT32_C(0xFD0839F0), UINT32_C(0x459D212E)}},
        {{UINT32_C(0xFD32D79B), UINT32_C(0xA207E7DE), UINT32_C(0x410B479F),
          UINT32_C(0xA7B54991), UINT32_C(0xD68E5CDC), UINT32_C(0x806912B6),
          UINT32_C(0x92AB8B64), UINT32_C(0x1CB7B68C)},
         {UINT32_C(0xDF98339F), UINT32_C(0x3DB85378), UINT32_C(0x83EA7A18),
          UINT32_C(0xA24101DC), UINT32_C(0xE25522C5), UINT32_C(0x8892367C),
          UINT32_C(0x7753A2C3), UINT32_C(0x491A8BB3)}},
        {{UINT32_C(0x8C7875A7), UINT32_C(0x571C547E), UINT32_C(0xE9747C13),
          UINT32_C(0x7E5F23E4), UINT32_C(0x1058548D), UINT32_C(0x00F3BBB2),
          UINT32_C(0xE2397102), UINT32_C(0x7081F172)},
         {UINT32_C(0x6B573034), UINT32_C(0xB4351B8A), UINT32_C(0xC1A094F0),
          UINT32_C(0xB35A4F44), UINT32_C(0xAE951E96), UINT32_C(0xE2C1DAED),
          UINT32_C(0xB9DAA081), UINT32_C(0x5CF2A742)}},
        {{UINT32_C(0x9828ED9F), UINT32_C(0xB4F0D3F0), UINT32_C(0xA9251386),
          UINT32_C(0x6DB312FB), UINT32_C(0x537203F2), UINT32_C(0xC9A4583F),
          UINT32_C(0x9CE76D40), UINT32_C(0x5E099639)},
         {UINT32_C(0xC9F8CEA8), UINT32_C(0x3381B894), UINT32_C(0x626E07E8),
          UINT32_C(0x8242DAF8), UINT32_C(0x6077DFD9), UINT32_C(0x64A0B68C),
          UINT32_C(0x563CF051), UINT32_C(0x3CC462C0)}},
        {{UINT32_C(0x87AF4A45), UINT32_C(0x8937364C), UINT32_C(0x2DE0FD60),
          UINT32_C(0x8C4ACBFA), UINT32_C(0x472A5D8A), UINT32_C(0xF10AED11),
          UINT32_C(0x5380C2E6), UINT32_C(0x3F5674B5)},
         {UINT32_C(0x2BF8A452), UINT32_C(0x8F4FD0F5), UINT32_C(0xC7390418),
          UINT32_C(0xB436E388), UINT32_C(0xE6EE9406), UINT32_C(0xAFAB7B7C),
          UINT32_C(0x951739BA), UINT32_C(0x4F623177)}},
        {{UINT32_C(0xA9B50F2A), UINT32_C(0x90B0ED35), UINT32_C(0xAC6CF217),
          UINT32_C(0x46DC3F91), UINT32_C(0x2C7B119C), UINT32_C(0x2F142031),
          UINT32_C(0x07D79225), UINT32_C(0x55A93CBC)},
         {UINT32_C(0xB304A642), UINT32_C(0x45E0DD7D), UINT32_C(0xD572D446),
          UINT32_C(0xB743DFCD), UINT32_C(0xAC74B368), UINT32_C(0x867B02EB),
          UINT32_C(0x169B94B0), UINT32_C(0x67B2B86C)}},
        {{UINT32_C(0x483CFEDB), UINT32_C(0x18396DA7), UINT32_C(0x8A3A07C2),
          UINT32_C(0x6C6E0370), UINT32_C(0xAB554998), UINT32_C(0xF32A1AFE),
          UINT32_C(0x87D1C136), UINT32_C(0x408C9119)},
         {UINT32_C(0x4BBE0B78), UINT32_C(0x755F6325), UINT32_C(0xD1178550),
          UINT32_C(0xDC4A7319), UINT32_C(0xB3B9E459), UINT32_C(0x44B49813),
          UINT32_C(0x4C3D3620), UINT32_C(0x0294B9A9)}},
        {{UINT32_C(0x067FA6FF), UINT32_C(0x6480F6FE), UINT32_C(0xF307A52E),
          UINT32_C(0x67891400), UINT32_C(0x7F865DA8), UINT32_C(0x9F846EF8),
          UINT32_C(0xAE02F671), UINT32_C(0x318DAC55)},
         {UINT32_C(0xE288A317), UINT32_C(0x91119652), UINT32_C(0x038C61B8),
          UINT32_C(0x4D7CF2B8), UINT32_C(0x5154C1A8), UINT32_C(0x098F80DD),
          UINT32_C(0xD239A2D4), UINT32_C(0x10C04F87)}},
        {{UINT32_C(0x5CA6F183), UINT32_C(0x13460926), UINT32_C(0xD52001ED),
          UINT32_C(0x5E97AD18), UINT32_C(0xE14843DF), UINT32_C(0x7DCD2477),
          UINT32_C(0x98A30426), UINT32_C(0x27DAB276)},
         {UINT32_C(0xE120D80C), UINT32_C(0x7939CAE3), UINT32_C(0x51E5B81A),
          UINT32_C(0xC9F46466), UINT32_C(0xE2E49D52), UINT32_C(0xED620322),
          UINT32_C(0xFA172BBB), UINT32_C(0x3C0F5A2E)}},
        {{UINT32_C(0x5DB1196B), UINT32_C(0xBFFE8742), UINT32_C(0x49B7214E),
          UINT32_C(0xCD45F8ED), UINT32_C(0xC35F5C33), UINT32_C(0x923ABA47),
          UINT32_C(0x83F3EE48), UINT32_C(0x16ED1F10)},
         {UINT32_C(0x99274930), UINT32_C(0x042E6DF0), UINT32_C(0xC5F8EA16),
          UINT32_C(0xE8AE1DCF), UINT32_C(0xF02EA2B2), UINT32_C(0x004462CB),
          UINT32_C(0xD284B04E), UINT32_C(0x427F9381)}},
        {{UINT32_C(0x75EFACC5), UINT32_C(0x4CD481F8), UINT32_C(0x21C83368),
          UINT32_C(0xD98C3FD4), UINT32_C(0x3894CE88), UINT32_C(0x4335E7C8),
          UINT32_C(0x955A298C), UINT32_C(0x18321F87)},
         {UINT32_C(0xD1716E18), UINT32_C(0x073DD00A), UINT32_C(0xFE0BFE61),
          UINT32_C(0x66D82A5F), UINT32_C(0x2310C532), UINT32_C(0x7D869E20),
          UINT32_C(0x19BF4704), UINT32_C(0x29A376FB)}},
        {{UINT32_C(0xC149B5B0), UINT32_C(0xA1B12B35), UINT32_C(0x1E828959),
          UINT32_C(0x3411B231), UINT32_C(0x560D99FB), UINT32_C(0x56417519),
          UINT32_C(0xEBB52124), UINT32_C(0x4E0EB143)},
         {UINT32_C(0x6AEF3801), UINT32_C(0x7B594B5E), UINT32_C(0x9ECB536E),
          UINT32_C(0x00AEE12E), UINT32_C(0x56E23145), UINT32_C(0x6BF0FB29),
          UINT32_C(0x61AE8E98), UINT32_C(0x2B2D83B9)}},
        {{UINT32_C(0x6AC27F2D), UINT32_C(0x9CB3E2E8), UINT32_C(0x5A6280AA),
          UINT32_C(0x82BACA96), UINT32_C(0x2C6B7C8F), UINT32_C(0xCBC6C01B),
          UINT32_C(0xD0C01ABD), UINT32_C(0x390511BC)},
         {UINT32_C(0x49551C0D), UINT32_C(0xB322D972), UINT32_C(0x7B6489C8),
          UINT32_C(0x7905E82E), UINT32_C(0x40EEC20D), UINT32_C(0x4DD0CE8B),
          UINT32_C(0x2409298A), UINT32_C(0x5C0B3EE7)}},
        {{UINT32_C(0xB635FB99), UINT32_C(0x4418D685), UINT32_C(0x3ACE8B39),
          UINT32_C(0x652EA608), UINT32_C(0x46FC4047), UINT32_C(0xE586FBDC),
          UINT32_C(0xD8CC13D8), UINT32_C(0x3C832D34)},
         {UINT32_C(0xF7AA54A1), UINT32_C(0x14CC9F23), UINT32_C(0x07153B9F),
          UINT32_C(0x80D094E6), UINT32_C(0x6A2EED8E), UINT32_C(0x0776E540),
          UINT32_C(0x77249085), UINT32_C(0x03CC3BFC)}},
        {{UINT32_C(0x1308C1A8), UINT32_C(0x5F8F281F), UINT32_C(0xD1AFC4B7),
          UINT32_C(0x31C8E737), UINT32_C(0x41AE8EF2), UINT32_C(0x67785298),
          UINT32_C(0xFD028A4B), UINT32_C(0x17716086)},
         {UINT32_C(0xF922E100), UINT32_C(0x1A2083E0), UINT32_C(0xD53FE691),
          UINT32_C(0xD67EC9D1), UINT32_C(0xECCA8DEB), UINT32_C(0x2DF8B6ED),
          UINT32_C(0xBCCC999E), UINT32_C(0x3B595EE4)}},
    },
    {
        {{UINT32_C(0x5A4B8C04), UINT32_C(0x11F03F89), UINT32_C(0x7DAE8E6B),
          UINT32_C(0x254C3648), UINT32_C(0x637CDB83), UINT32_C(0xAB6EAAF1),
          UINT32_C(0xFDDED8F6), UINT32_C(0x41F52243)},
         {UINT32_C(0xBBDF3270), UINT32_C(0x487078E1), UINT32_C(0x339CEA28),
          UINT32_C(0x98853B49), UINT32_C(0xAB3EDE57), UINT32_C(0x8AF0522B),
          UINT32_C(0x85EB4CC0), UINT32_C(0x734D711F)}},
        {{UINT32_C(0xF86BA644), UINT32_C(0xFD1F46AD), UINT32_C(0xA3299855),
          UINT32_C(0xA5332B97), UINT32_C(0xD9493634), UINT32_C(0x61BE90DB),
          UINT32_C(0xC2705911), UINT32_C(0x308F09B1)},
         {UINT32_C(0x0B7918A5), UINT32_C(0xD59F1B1A), UINT32_C(0xCF6399E6),
          UINT32_C(0x9CF333D0), UINT32_C(0xFBB26B6B), UINT32_C(0xD09C63CD),
          UINT32_C(0xA6536647), UINT32_C(0x76C27913)}},
        {{UINT32_C(0xAAAB555C), UINT32_C(0x3DF1811F), UINT32_C(0x886C828B),
          UINT32_C(0x60853351), UINT32_C(0xF1E87F41), UINT32_C(0xF6CA7707),
          UINT32_C(0x7D7082E6), UINT32_C(0x5B4F6EDF)},
         {UINT32_C(0x3F672DE7), UINT32_C(0xADE518E0), UINT32_C(0x022541B2),
          UINT32_C(0x00ED0B84), UINT32_C(0x618E8969), UINT32_C(0x04FE5DD6),
          UINT32_C(0xDB9CCA4D), UINT32_C(0x2F5F5C65)}},
        {{UINT32_C(0x96BDAE2C), UINT32_C(0x00B69B45), UINT32_C(0x770604C4),
          UINT32_C(0x06DB22CF), UINT32_C(0x856585C3), UINT32_C(0xC2EB7F8F),
          UINT32_C(0x0413C614), UINT32_C(0x6E322539)},
         {UINT32_C(0x70A46872), UINT32_C(0x22C09EA8), UINT32_C(0x1FF23734),
          UINT32_C(0x143E73BC), UINT32_C(0x575C20B4), UINT32_C(0xCAC5E2DD),
          UINT32_C(0x3FEBE787), UINT32_C(0x225E5390)}},
        {{UINT32_C(0xBE9C512D), UINT32_C(0x594FEA4E), UINT32_C(0x92CB73AE),
          UINT32_C(0x58507092), UINT32_C(0xB0CE2096), UINT32_C(0xFD8EFC7D),
          UINT32_C(0xE031D6AB), UINT32_C(0x3B58C199)},
         {UINT32_C(0x479F23E4), UINT32_C(0x55DA1CBD), UINT32_C(0xA6DB6137),
          UINT32_C(0x060C6BB5), UINT32_C(0x6864488E), UINT32_C(0xD8319CF8),
          UINT32_C(0x21B02EDA), UINT32_C(0x6C15A31B)}},
        {{UINT32_C(0x8CA7084D), UINT32_C(0x13C48372), UINT32_C(0xA171ECE5),
          UINT32_C(0xF7554E59), UINT32_C(0x23A97699), UINT32_C(0x7425C5D8),
          UINT32_C(0x71E1120E), UINT32_C(0x6F2C68DA)},
         {UINT32_C(0x24324B64), UINT32_C(0x9591B9B6), UINT32_C(0xC02AC704),
          UINT32_C(0x2DA33472), UINT32_C(0x81EE1295), UINT32_C(0xC5DE7FC9),
          UINT32_C(0x5D6E93C6), UINT32_C(0x6A646A44)}},
        {{UINT32_C(0xA39D6554), UINT32_C(0x48684061), UINT32_C(0xC3DF57B6),
          UINT32_C(0xB70ABF61), UINT32_C(0x58B9EEE3), UINT32_C(0x9824AFD6),
          UINT32_C(0x3A14A733), UINT32_C(0x46EBE9D1)},
         {UINT32_C(0xD74F8E94), UINT32_C(0x8E70F95D), UINT32_C(0x6AFCA4E2),
          UINT32_C(0xA9D922A2), UINT32_C(0x6988CC16), UINT32_C(0x519A9753),
          UINT32_C(0xD545AF8A), UINT32_C(0x711DEF16)}},
        {{UINT32_C(0x811A2BF7), UINT32_C(0x362A5D95), UINT32_C(0x566B90CE),
          UINT32_C(0x42A84A33), UINT32_C(0x7C41EC87), UINT32_C(0x25CBC760),
          UINT32_C(0xD4B7DBEE), UINT32_C(0x6B77E39C)},
         {UINT32_C(0x833015A4), UINT32_C(0xA98B8201), UINT32_C(0xC31B26F4),
          UINT32_C(0xE412E217), UINT32_C(0xE0090782), UINT32_C(0x518BE8F0),
          UINT32_C(0x3DB51D4E), UINT32_C(0x08D9F4B6)}},
        {{UINT32_C(0x297D421E), UINT32_C(0x2C80CE87), UINT32_C(0xADBA1498),
          UINT32_C(0x2FD137F8), UINT32_C(0x2899AA14), UINT32_C(0xA2ED3D47),
          UINT32_C(0xFE4F365A), UINT32_C(0x2AC924A5)},
         {UINT32_C(0x666DC0A0), UINT32_C(0xAC0389B7), UINT32_C(0x8ABF3D9E),
          UINT32_C(0x3CC99739), UINT32_C(0xDFBFF83A), UINT32_C(0x33060DB6),
          UINT32_C(0x0339C3B8), UINT32_C(0x54EEE215)}},
        {{UINT32_C(0x820F7E4D), UINT32_C(0x06C3A4F5), UINT32_C(0x08C3D311),
          UINT32_C(0x86F083E2), UINT32_C(0xFE4B0476), UINT32_C(0x47E29984),
          UINT32_C(0xCA7DF6CF), UINT32_C(0x218F52E2)},
         {UINT32_C(0xBF2C2084), UINT32_C(0x59317E26), UINT32_C(0x289A10CF),
          UINT32_C(0xEA9C865B), UINT32_C(0x2074FEA3), UINT32_C(0x7AA1E50B),
          UINT32_C(0x4B3EFC31), UINT32_C(0x708A1D8C)}},
        {{UINT32_C(0x864817D7), UINT32_C(0x34C5C63E), UINT32_C(0xD89E995B),
          UINT32_C(0x0F614043), UINT32_C(0x975E2A03), UINT32_C(0x60CE8BCE),
          UINT32_C(0x78493E0C), UINT32_C(0x70916E29)},
         {UINT32_C(0x216782C6), UINT32_C(0xBD0748F9), UINT32_C(0xED32FB72),
          UINT32_C(0x0051C65A), UINT32_C(0x4DD64705), UINT32_C(0x9DC5F558),
          UINT32_C(0xEEC14B50), UINT32_C(0x674F1A63)}},
        {{UINT32_C(0xDB633FD1), UINT32_C(0x73D6E68E), UINT32_C(0xF52F9537),
          UINT32_C(0x7B5F8303), UINT32_C(0x88A74CFB), UINT32_C(0x980FDDDC),
          UINT32_C(0x47FC32D1), UINT32_C(0x6419C18F)},
         {UINT32_C(0x870B5D59), UINT32_C(0x93727B4C), UINT32_C(0xCF28021D),
          UINT32_C(0x4BCE05DE), UINT32_C(0xAB4F0CE5), UINT32_C(0x3C059B47),
          UINT32_C(0xB85FFDBB), UINT32_C(0x77CA7F67)}},
        {{UINT32_C(0xC525088E), UINT32_C(0xDBEADDCE), UINT32_C(0x390D2221),
          UINT32_C(0x561E12BE), UINT32_C(0xD9BA7AF0), UINT32_C(0xCD224FC1),
          UINT32_C(0x394DC073), UINT32_C(0x03744552)},
         {UINT32_C(0x21BB6B6E), UINT32_C(0xCFC67B49), UINT32_C(0x1B5F8E6A),
          UINT32_C(0xD234FD8D), UINT32_C(0x40B7F8B0), UINT32_C(0x6DDBC18B),
          UINT32_C(0xDAACCC74), UINT32_C(0x79F40857)}},
        {{UINT32_C(0x9DD71B9C), UINT32_C(0x30E5F990), UINT32_C(0x291124EF),
          UINT32_C(0x00FCBFA5), UINT32_C(0x49B8C570), UINT32_C(0xBE595A25),
          UINT32_C(0xBC094446), UINT32_C(0x5B4B8141)},
         {UINT32_C(0x469191B6), UINT32_C(0xB22B4F04), UINT32_C(0xD73C4D38),
          UINT32_C(0x10845AC8), UINT32_C(0xED0C8224), UINT32_C(0x39C9F0FB),
          UINT32_C(0xF5813BEE), UINT32_C(0x7E009DFB)}},
        {{UINT32_C(0xA61D09C0), UINT32_C(0xA47C2989), UINT32_C(0x59E55A9C),
          UINT32_C(0x3706F456), UINT32_C(0xEA0259B9), UINT32_C(0x2373976F),
          UINT32_C(0x077D20CC), UINT32_C(0x13FC0E09)},
         {UINT32_C(0xE78D29CF), UINT32_C(0xBB24DD05), UINT32_C(0x822CFA02),
          UINT32_C(0xD8757A67), UINT32_C(0x3C55A4C6), UINT32_C(0x36CA7486),
          UINT32_C(0x3EEABBE1), UINT32_C(0x4234E689)}},
        {{UINT32_C(0xB46BDB51), UINT32_C(0xA2F54D14), UINT32_C(0x675BB770),
          UINT32_C(0x8A530B78), UINT32_C(0xDE9F1F8B), UINT32_C(0x617D7E8E),
          UINT32_C(0x2DCC4712), UINT32_C(0x799B3E44)},
         {UINT32_C(0xB486FE8C), UINT32_C(0x658A31D8), UINT32_C(0x163D4AF0),
          UINT32_C(0x45BAFC29), UINT32_C(0xA5289C8D), UINT32_C(0x3A2C7F66),
          UINT32_C(0xB91FF3DB), UINT32_C(0x4ECC3C7D)}},
    },
    {
        {{UINT32_C(0xDF4DFD43), UINT32_C(0x738CF1C7), UINT32_C(0xE987084C),
          UINT32_C(0x72943A2D), UINT32_C(0x2491FF24), UINT32_C(0xEA21C05F),
          UINT32_C(0xDA050094), UINT32_C(0x3D3F4ED7)},
         {UINT32_C(0x61C4054D), UINT32_C(0xF90644E4), UINT32_C(0x3A50E82A),
          UINT32_C(0x25379214), UINT32_C(0xC7DEF970), UINT32_C(0x47EDB006),
          UINT32_C(0x0F53F307), UINT32_C(0x0F8F031C)}},
        {{UINT32_C(0x724976D5), UINT32_C(0x50FEB6D8), UINT32_C(0xF40C7720),
          UINT32_C(0x57AA499F), UINT32_C(0x0DAAF428), UINT32_C(0x6B80AC54),
          UINT32_C(0x1F6FC276), UINT32_C(0x7AC6845E)},
         {UINT32_C(0x17A4B9C5), UINT32_C(0x8EC7FAB1), UINT32_C(0xED0C8F97),
          UINT32_C(0x8336DD62), UINT32_C(0xB7B7104E), UINT32_C(0x6014A510),
          UINT32_C(0xA2911C30), UINT32_C(0x4991A03B)}},
        {{UINT32_C(0xCBCC9BA3), UINT32_C(0x6D353975), UINT32_C(0xC4564492),
          UINT32_C(0x23E97E28), UINT32_C(0xF8AEED3E), UINT32_C(0xDF432FDA),
          UINT32_C(0x6F6B472C), UINT32_C(0x11DB40DD)},
         {UINT32_C(0x95AA0174), UINT32_C(0x5B87005B), UINT32_C(0x89D9F1A8),
          UINT32_C(0x1DB41080), UINT32_C(0x689DF208), UINT32_C(0x5A6BC444),
          UINT32_C(0xBF38FF8D), UINT32_C(0x16153F87)}},
        {{UINT32_C(0xFFD3C814), UINT32_C(0xD217003F), UINT32_C(0xFD50AF95),
          UINT32_C(0x1ADE64C3), UINT32_C(0x9FFB8BEB), UINT32_C(0x1936332C),
          UINT32_C(0xD70CD8D8), UINT32_C(0x6EE322DC)},
         {UINT32_C(0xF2A60976), UINT32_C(0xE40A0419), UINT32_C(0xEF93B05B),
          UINT32_C(0xA62F6FA1), UINT32_C(0x596575FF), UINT32_C(0x5978206C),
          UINT32_C(0xB68BFE5C), UINT32_C(0x5CDCA200)}},
        {{UINT32_C(0xB7949E33), UINT32_C(0x3FB16AED), UINT32_C(0x40304A1B),
          UINT32_C(0x34538928), UINT32_C(0x3BCA4239), UINT32_C(0x7FA35A34),
          UINT32_C(0xEE76919E), UINT32_C(0x22FD1AEF)},
         {UINT32_C(0x0F6A5D50), UINT32_C(0x1F8FE6A4), UINT32_C(0x26BBA46B),
          UINT32_C(0x27CC704F), UINT32_C(0x3420CC52), UINT32_C(0x230FD0CA),
          UINT32_C(0xB3A83D85), UINT32_C(0x3E9E4DA4)}},
        {{UINT32_C(0x7F5CC75E), UINT32_C(0x1D82390E), UINT32_C(0x49D0A605),
          UINT32_C(0x70256245), UINT32_C(0x4FF4BC44), UINT32_C(0x5B877813),
          UINT32_C(0xB5EC02E4), UINT32_C(0x28E6A057)},
         {UINT32_C(0x2E89FB84), UINT32_C(0xBC7A10DA), UINT32_C(0x20E1EA00),
          UINT32_C(0x3AF182E5), UINT32_C(0x9C507274), UINT32_C(0x4B590FFA),
          UINT32_C(0xAA7FD65B), UINT32_C(0x26BA94D6)}},
        {{UINT32_C(0x238CC195), UINT32_C(0xC02CC77C), UINT32_C(0xA97EE3E4),
          UINT32_C(0x3F175C97), UINT32_C(0xDFA1F9DC), UINT32_C(0x8A28FA23),
          UINT32_C(0x1F968D15), UINT32_C(0x35CAC0FF)},
         {UINT32_C(0x37C7C773), UINT32_C(0x0FC41B33), UINT32_C(0xBC999443),
          UINT32_C(0x71E06B10), UINT32_C(0x2C87B0A4), UINT32_C(0x073A1ABA),
          UINT32_C(0x9E5E8B70), UINT32_C(0x29F29B12)}},
        {{UINT32_C(0xE491FE70), UINT32_C(0xAA25F348), UINT32_C(0xC1713992),
          UINT32_C(0x9371F94B), UINT32_C(0x4FA08818), UINT32_C(0x674B478C),
          UINT32_C(0xB1407431), UINT32_C(0x6F3C31FE)},
         {UINT32_C(0xD93DD5E1), UINT32_C(0xBB7D37FB), UINT32_C(0x7E04EE7A),
          UINT32_C(0xE34A40B8), UINT32_C(0xF3C33528), UINT32_C(0xCF82360D),
          UINT32_C(0x01477712), UINT32_C(0x0A3B8FF5)}},
        {{UINT32_C(0x6B718511), UINT32_C(0xA4591471), UINT32_C(0xD2FD6B9B),
          UINT32_C(0x7B0CE8DE), UINT32_C(0x6845DBEF), UINT32_C(0xC42544FA),
          UINT32_C(0x63AF476A), UINT32_C(0x456A6985)},
         {UINT32_C(0x9CDE4E74), UINT32_C(0x5DD611F6), UINT32_C(0x2B346AEB),
          UINT32_C(0x86095683), UINT32_C(0x6E75B3D7), UINT32_C(0xD15C5DA0),
          UINT32_C(0xC72D5D2C), UINT32_C(0x220FFD73)}},
        {{UINT32_C(0xD2ED888F), UINT32_C(0x478DA345), UINT32_C(0xE04CBCC7),
          UINT32_C(0xA69D4FB9), UINT32_C(0xB3F1179D), UINT32_C(0xA427150A),
          UINT32_C(0xD5CEA78A), UINT32_C(0x1DD3B8C2)},
         {UINT32_C(0xB8628A22), UINT32_C(0x9462EFF0), UINT32_C(0xB2CB44A5),
          UINT32_C(0xB2FFFF4A), UINT32_C(0x24039BA8), UINT32_C(0x8234A3FF),
          UINT32_C(0x916DE889), UINT32_C(0x01BE7202)}},
        {{UINT32_C(0x6DFCEF0B), UINT32_C(0x51066985), UINT32_C(0xDF20CDEE),
          UINT32_C(0x25729D98), UINT32_C(0x9693E5EF), UINT32_C(0x872FD39D),
          UINT32_C(0x2D859635), UINT32_C(0x72D03AE1)},
         {UINT32_C(0xDACAEB82), UINT32_C(0x3F28F84E), UINT32_C(0xCB5284D7),
          UINT32_C(0x9EB40FD6), UINT32_C(0xC5F54041), UINT32_C(0x66C2DCA6),
          UINT32_C(0x1C1F2461), UINT32_C(0x4BDBA382)}},
        {{UINT32_C(0x0E0ED176), UINT32_C(0xE5342197), UINT32_C(0xA225A47F),
          UINT32_C(0xF588547A), UINT32_C(0x1FEB2259), UINT32_C(0xC83B54ED),
          UINT32_C(0x92F3733D), UINT32_C(0x1B037913)},
         {UINT32_C(0x2271ECFA), UINT32_C(0x935C9782), UINT32_C(0x53CFE07C),
          UINT32_C(0x5F7E94A6), UINT32_C(0x1B40CA19), UINT32_C(0xBFF5B0E6),
          UINT32_C(0x459445E1), UINT32_C(0x36C7851D)}},
        {{UINT32_C(0x588C9748), UINT32_C(0xB6547971), UINT32_C(0x11970562),
          UINT32_C(0xCFD8E81B), UINT32_C(0x702FE4FA), UINT32_C(0x41333C80),
          UINT32_C(0x962A993B), UINT32_C(0x2F153C8C)},
         {UINT32_C(0x8BDA48AC), UINT32_C(0x028BBD6A), UINT32_C(0xFE1DB02A),
          UINT32_C(0x7B076F88), UINT32_C(0x078FB3FC), UINT32_C(0xC9560400),
          UINT32_C(0x035907EA), UINT32_C(0x5DCC0946)}},
        {{UINT32_C(0xA6233F1C), UINT32_C(0x93D7CF33), UINT32_C(0xDF2A187C),
          UINT32_C(0x03184BC4), UINT32_C(0xE83DAC32), UINT32_C(0x291149BC),
          UINT32_C(0xFAEDF216), UINT32_C(0x575F4279)},
         {UINT32_C(0x086FC141), UINT32_C(0x101427B4), UINT32_C(0xD288562E),
          UINT32_C(0xC924F2AE), UINT32_C(0xEEF5799A), UINT32_C(0xDB610463),
          UINT32_C(0x6A09661D), UINT32_C(0x20F18767)}},
        {{UINT32_C(0xF59D0C20), UINT32_C(0xE39BB775), UINT32_C(0x723A4EF2),
          UINT32_C(0x18DA90E2), UINT32_C(0xF56B381B), UINT32_C(0x8E747A7B),
          UINT32_C(0xF98F26DC), UINT32_C(0x7EF67224)},
         {UINT32_C(0xE1F94B99), UINT32_C(0xB1373AF5), UINT32_C(0x0C3B6AA8),
          UINT32_C(0x1076FBA6), UINT32_C(0xA3A7811C), UINT32_C(0x7FCD0017),
          UINT32_C(0x46554E7E), UINT32_C(0x6D1A6973)}},
        {{UINT32_C(0xB9CED2C2), UINT32_C(0xE5734077), UINT32_C(0x1F770914),
          UINT32_C(0xC94D17F8), UINT32_C(0x1CD248EB), UINT32_C(0x58B47BCB),
          UINT32_C(0x24804B6F), UINT32_C(0x2E06538C)},
         {UINT32_C(0x32E7CA19), UINT32_C(0x275D933F), UINT32_C(0x1FC9241E),
          UINT32_C(0x1B982B49), UINT32_C(0x3986B6AC), UINT32_C(0x8B8A6ED5),
          UINT32_C(0x35B4EA6A), UINT32_C(0x17568221)}},
    },
    {
        {{UINT32_C(0xE796327F), UINT32_C(0x090AD05A), UINT32_C(0xAD21DD4B),
          UINT32_C(0xA78DAE5E), UINT32_C(0x9C2F8CBE), UINT32_C(0x8EEC9EDB),
          UINT32_C(0x653E0F2D), UINT32_C(0x33E375E0)},
         {UINT32_C(0x8D67AC72), UINT32_C(0xDA19EFF2), UINT32_C(0x2737AB8C),
          UINT32_C(0xBFC7E62B), UINT32_C(0x4CF53C12), UINT32_C(0xBBF8BD1D),
          UINT32_C(0x45C6D555), UINT32_C(0x5ABFE23F)}},
        {{UINT32_C(0x0DE39342), UINT32_C(0x32460B33), UINT32_C(0xB8977067),
          UINT32_C(0x3567454A), UINT32_C(0xF954592C), UINT32_C(0x10A1E47D),
          UINT32_C(0x4DD019C4), UINT32_C(0x4DE8C6EF)},
         {UINT32_C(0x1BDAAAFA), UINT32_C(0x1F1D296B), UINT32_C(0x3A75AD99),
          UINT32_C(0x4E6B8E8F), UINT32_C(0xA27FE061), UINT32_C(0x259015E1),
          UINT32_C(0x9F320632), UINT32_C(0x6B6A4820)}},
        {{UINT32_C(0xA0B5E605), UINT32_C(0x8AA089AF), UINT32_C(0x1B4058FD),
          UINT32_C(0x1D6C1EEE), UINT32_C(0xB4E89BEF), UINT32_C(0x1D920534),
          UINT32_C(0x16163340), UINT32_C(0x722A3A35)},
         {UINT32_C(0xF33B49B2), UINT32_C(0xA3B9178C), UINT32_C(0x65558E90),
          UINT32_C(0xFF8FE9BB), UINT32_C(0x9794EFAE), UINT32_C(0x94766BC0),
          UINT32_C(0xFDFAEB42), UINT32_C(0x79A1EFA2)}},
        {{UINT32_C(0xBCB6D558), UINT32_C(0x2FE44B97), UINT32_C(0xDB8B0A79),
          UINT32_C(0xB4F4F402), UINT32_C(0x247C32E5), UINT32_C(0xF53D8AB1),
          UINT32_C(0x4DA4C009), UINT32_C(0x3B883CE5)},
         {UINT32_C(0x2EC9F1C6), UINT32_C(0xB46168BD), UINT32_C(0x6B8FE01A),
          UINT32_C(0xD40BDE7B), UINT32_C(0xCDFE509F), UINT32_C(0x60A5C168),
          UINT32_C(0x23BE249E), UINT32_C(0x3314D878)}},
        {{UINT32_C(0x4D9F5769), UINT32_C(0x02511A85), UINT32_C(0xB49D6A8E),
          UINT32_C(0x8398F9BD), UINT32_C(0x5D2D7135), UINT32_C(0xE8D773F3),
          UINT32_C(0x9DECC331), UINT32_C(0x09B3B8AB)},
         {UINT32_C(0x584C11D9), UINT32_C(0x8D2B269B), UINT32_C(0x6B6B86A9),
          UINT32_C(0xF7661944), UINT32_C(0xC7659AF7), UINT32_C(0x719A3620),
          UINT32_C(0x37C27DBE), UINT32_C(0x3CFC8DF0)}},
        {{UINT32_C(0x1145B14B), UINT32_C(0x5EE0BE06), UINT32_C(0x23193ED6),
          UINT32_C(0xAC6950E4), UINT32_C(0xDF244C7F), UINT32_C(0x7291C44C),
          UINT32_C(0x43D744EA), UINT32_C(0x4650C162)},
         {UINT32_C(0x34A084D8), UINT32_C(0x60B92D3F), UINT32_C(0x376E5414),
          UINT32_C(0xBBD44A0E), UINT32_C(0x0980F36C), UINT32_C(0x5C0E488A),
          UINT32_C(0xD7991A09), UINT32_C(0x4E53FCCA)}},
        {{UINT32_C(0x367B55C2), UINT32_C(0x7A2ADBCF), UINT32_C(0x1FED467E),
          UINT32_C(0x96A88B75), UINT32_C(0xFB263845), UINT32_C(0x8E75E37E),
          UINT32_C(0xEB508DD0), UINT32_C(0x4C2E47B8)},
         {UINT32_C(0xB19FCD14), UINT32_C(0x20BF51DE), UINT32_C(0x14CB67D0),
          UINT32_C(0xD9071749), UINT32_C(0x29EBDA7C), UINT32_C(0xEC90714B),
          UINT32_C(0x634C0F2E), UINT32_C(0x4ACADAA6)}},
        {{UINT32_C(0xEC715EC9), UINT32_C(0xA516B9B8), UINT32_C(0x42B8A87B),
          UINT32_C(0xC7DCA263), UINT32_C(0xDA27B456), UINT32_C(0x2CE450C9),
          UINT32_C(0x00A8819F), UINT32_C(0x3C974812)},
         {UINT32_C(0xECDED574), UINT32_C(0xF4822C23), UINT32_C(0x19FA48D4),
          UINT32_C(0xFA737FAD), UINT32_C(0x45D718E0), UINT32_C(0xE34B2F2A),
          UINT32_C(0xBEA7B540), UINT32_C(0x1D6F19FE)}},
        {{UINT32_C(0x98E24789), UINT32_C(0xADC8FCE7), UINT32_C(0x45869609),
          UINT32_C(0xFE2F890C), UINT32_C(0x78A35C19), UINT32_C(0x6466E03C),
          UINT32_C(0xC1F34AA9), UINT32_C(0x24C70FED)},
         {UINT32_C(0x57747DD1), UINT32_C(0x89530F75), UINT32_C(0x2B8CDE2D),
          UINT32_C(0x343DE05B), UINT32_C(0x35CC8D5A), UINT32_C(0xC33134E3),
          UINT32_C(0xAC9B4F2B), UINT32_C(0x3CCEFC38)}},
        {{UINT32_C(0xEF923364), UINT32_C(0x84C904B8), UINT32_C(0xBDDD31D8),
          UINT32_C(0x46E1FECF), UINT32_C(0xFAE79B6B), UINT32_C(0xA8126DD6),
          UINT32_C(0xFBF05C9A), UINT32_C(0x4A53C034)},
         {UINT32_C(0xBE8F255F), UINT32_C(0x44CA3ACB), UINT32_C(0xEC319885),
          UINT32_C(0x6F0FD374), UINT32_C(0xF1836DC2), UINT32_C(0xADBCB4AA),
          UINT32_C(0x65187EE9), UINT32_C(0x6CC3A596)}},
        {{UINT32_C(0xB397B5E7), UINT32_C(0x941E7821), UINT32_C(0xFEE2A9D5),
          UINT32_C(0xD3457371), UINT32_C(0x66382F60), UINT32_C(0x9F69BE44),
          UINT32_C(0xA1F49E9B), UINT32_C(0x6DCEAD04)},
         {UINT32_C(0x3BF21647), UINT32_C(0xDC6BC23B), UINT32_C(0xB5271BE9),
          UINT32_C(0x1500FD7F), UINT32_C(0xF23FDF3D), UINT32_C(0x9B0994DD),
          UINT32_C(0x45065CF7), UINT32_C(0x38A2ECEB)}},
        {{UINT32_C(0x0DCA8BF4), UINT32_C(0x2667CEFE), UINT32_C(0xE46EB469),
          UINT32_C(0x8227ACB3), UINT32_C(0xA75C5B8B), UINT32_C(0x4C20677D),
          UINT32_C(0xB36ACDFE), UINT32_C(0x224FC5B4)},
         {UINT32_C(0x7A6A01D3), UINT32_C(0xA0007E14), UINT32_C(0xF8A64EED),
          UINT32_C(0x15C79558), UINT32_C(0x93DEDC09), UINT32_C(0xFB58A76A),
          UINT32_C(0x26F10A98), UINT32_C(0x2057DDDC)}},
        {{UINT32_C(0xBDB27AE4), UINT32_C(0x1FF658AE), UINT32_C(0xDDD96647),
          UINT32_C(0x7F30DF57), UINT32_C(0xC7294313), UINT32_C(0x63490B8D),
          UINT32_C(0x5435869E), UINT32_C(0x0EAEC573)},
         {UINT32_C(0xDF115B78), UINT32_C(0x85F05C49), UINT32_C(0x62992F5D),
          UINT32_C(0x95739C0C), UINT32_C(0x2B573963), UINT32_C(0x72F14319),
          UINT32_C(0x86328FF4), UINT32_C(0x05600E64)}},
        {{UINT32_C(0xEAB0F425), UINT32_C(0x9BE7331F), UINT32_C(0x74447C20),
          UINT32_C(0x2E4CF5AA), UINT32_C(0x66243D2A), UINT32_C(0x9B26F512),
          UINT32_C(0x84AB5627), UINT32_C(0x77C96722)},
         {UINT32_C(0x601673B4), UINT32_C(0xEC545427), UINT32_C(0x2F127AF7),
          UINT32_C(0xEF6A34FB), UINT32_C(0xE2DFD269), UINT32_C(0x519559C1),
          UINT32_C(0x8258E37A), UINT32_C(0x34D7D754)}},
        {{UINT32_C(0x5E8B5281), UINT32_C(0xC113747B), UINT32_C(0xE04D779B),
          UINT32_C(0x0C085456), UINT32_C(0x1CCBCFC6), UINT32_C(0x3E326052),
          UINT32_C(0x2A37D19F), UINT32_C(0x5C954CC1)},
         {UINT32_C(0x9124435B), UINT32_C(0xB1A4A5B3), UINT32_C(0x18ED98E7),
          UINT32_C(0x5E8B8D41), UINT32_C(0x144A3793), UINT32_C(0xC973D969),
          UINT32_C(0x88DD8B49), UINT32_C(0x0CB98CC8)}},
        {{UINT32_C(0xB48D04DF), UINT32_C(0x0E0233B2), UINT32_C(0x7BEAA4A5),
          UINT32_C(0x1B3916E0), UINT32_C(0xB672BE8C), UINT32_C(0xA24A4BE4),
          UINT32_C(0x845AB94D), UINT32_C(0x7A61506D)},
         {UINT32_C(0xE7F4CA3B), UINT32_C(0x160DFA0F), UINT32_C(0xD84C1148),
          UINT32_C(0xA9562C89), UINT32_C(0x92A276EB), UINT32_C(0x52979B95),
          UINT32_C(0x924E86E9), UINT32_C(0x17869B53)}},
    },
    {
        {{UINT32_C(0x1A86D0D8), UINT32_C(0x5D39F478), UINT32_C(0xFB8BC8A9),
          UINT32_C(0xDE5932DA), UINT32_C(0x2F5B4B70), UINT32_C(0xD706C6D7),
          UINT32_C(0x8A36AFC2), UINT32_C(0x53F450FC)},
         {UINT32_C(0x1E550B3B), UINT32_C(0xE1DC3540), UINT32_C(0x8B7EB6D2),
          UINT32_C(0x475507DC), UINT32_C(0xDFA2E5F7), UINT32_C(0xF803F78A),
          UINT32_C(0xC48097FF), UINT32_C(0x40B5F263)}},
        {{UINT32_C(0x226CDB1F), UINT32_C(0x336FB00E), UINT32_C(0x88215C40),
          UINT32_C(0xDDC1BB02), UINT32_C(0x73C07FD0), UINT32_C(0x6C4DD40E),
          UINT32_C(0x8F7D15E7), UINT32_C(0x4D0D2E49)},
         {UINT32_C(0xD2061402), UINT32_C(0xAF96E9B3), UINT32_C(0x1372FCF8),
          UINT32_C(0x15A3084A), UINT32_C(0x307B02D6), UINT32_C(0x91B571E6),
          UINT32_C(0x53AE7705), UINT32_C(0x2239592F)}},
        {{UINT32_C(0xC20B6645), UINT32_C(0x7D8615A1), UINT32_C(0xC7C4465B),
          UINT32_C(0xF4875767), UINT32_C(0x861702AB), UINT32_C(0xF6D3E718),
          UINT32_C(0x131F726A), UINT32_C(0x7F014A53)},
         {UINT32_C(0xDAAB77CA), UINT32_C(0x30809F8F), UINT32_C(0x28F944D3),
          UINT32_C(0x7CE8DC61), UINT32_C(0x9AEEF6A1), UINT32_C(0xF915111D),
          UINT32_C(0x206902FD), UINT32_C(0x246D7CC8)}},
        {{UINT32_C(0xEF806225), UINT32_C(0x7677488B), UINT32_C(0xF4C75EAE),
          UINT32_C(0x994C8104), UINT32_C(0x4E0C8988), UINT32_C(0x17586D4E),
          UINT32_C(0x90E33A2A), UINT32_C(0x70E52580)},
         {UINT32_C(0x022D2FED), UINT32_C(0xB993F26A), UINT32_C(0x689FBFBD),
          UINT32_C(0x955C130D), UINT32_C(0xA3612E8E), UINT32_C(0x0D3D1C63),
          UINT32_C(0xB91A8DE6), UINT32_C(0x423D73E1)}},
        {{UINT32_C(0x3027164F), UINT32_C(0x7274BE08), UINT32_C(0x42FDB769),
          UINT32_C(0xDE907B49), UINT32_C(0xB697060D), UINT32_C(0x61D74449),
          UINT32_C(0x26602CC9), UINT32_C(0x18A5FDC2)},
         {UINT32_C(0x049CAF4A), UINT32_C(0xB08DC02B), UINT32_C(0x78DBA1F1),
          UINT32_C(0xC84AF485), UINT32_C(0x7178E4DF), UINT32_C(0x0A5B3519),
          UINT32_C(0x5B26D0FE), UINT32_C(0x6EC7A7A5)}},
        {{UINT32_C(0x88554F05), UINT32_C(0xDEF1782F), UINT32_C(0xD8D6DF47),
          UINT32_C(0xB73E7333), UINT32_C(0x90E9C67A), UINT32_C(0x1DDF9022),
          UINT32_C(0xD56181AC), UINT32_C(0x5D217B51)},
         {UINT32_C(0xE27F90EE), UINT32_C(0x7A338C7B), UINT32_C(0x0D84A177),
          UINT32_C(0xB97CCD2A), UINT32_C(0x7C5E3FA9), UINT32_C(0x3E101601),
          UINT32_C(0x30FF0918), UINT32_C(0x2706E77C)}},
        {{UINT32_C(0x72A7CB9F), UINT32_C(0x1BD1274F), UINT32_C(0x0622DB90),
          UINT32_C(0x8B60357A), UINT32_C(0x2151BB23), UINT32_C(0x0140E14A),
          UINT32_C(0xE9A30C4C), UINT32_C(0x358D7DDA)},
         {UINT32_C(0x89BFB2C6), UINT32_C(0x3B153060), UINT32_C(0xB6757C69),
          UINT32_C(0x47462C79), UINT32_C(0xB43EF986), UINT32_C(0x2B22239D),
          UINT32_C(0x0B774DE3), UINT32_C(0x6793671F)}},
        {{UINT32_C(0xF6F8EDC6), UINT32_C(0x99EDB02E), UINT32_C(0xC4257DD9),
          UINT32_C(0x24432760), UINT32_C(0x0336EED2), UINT32_C(0x4FDD7301),
          UINT32_C(0xF6C6506B), UINT32_C(0x44879709)},
         {UINT32_C(0x13F18D89), UINT32_C(0x107C7DE2), UINT32_C(0xA5701FBD),
          UINT32_C(0x71C71DFB), UINT32_C(0xC7DE3E0B), UINT32_C(0x97017E24),
          UINT32_C(0xFC9EDDC2), UINT32_C(0x0F8D7E09)}},
        {{UINT32_C(0x3897E01D), UINT32_C(0x7A0BB3B1), UINT32_C(0xC5892BDE),
          UINT32_C(0x7FD4F504), UINT32_C(0xAB752928), UINT32_C(0x2EA9AA77),
          UINT32_C(0x9078B466), UINT32_C(0x19A82F55)},
         {UINT32_C(0x55A0F0D9), UINT32_C(0xEF2842C5), UINT32_C(0x15B6F2B4),
          UINT32_C(0x5501EEE9), UINT32_C(0x942AA4B4), UINT32_C(0x9665EA6F),
          UINT32_C(0x0E707C32), UINT32_C(0x015F41F4)}},
        {{UINT32_C(0x9C6B6FD6), UINT32_C(0x1B4D6A91), UINT32_C(0x68217AFC),
          UINT32_C(0xCFD2CEE9), UINT32_C(0xBBC9284D), UINT32_C(0xC5076256),
          UINT32_C(0xAC36547B), UINT32_C(0x4C7F4EEF)},
         {UINT32_C(0x65EE1907), UINT32_C(0xAB1AAD2C), UINT32_C(0xBAC25425),
          UINT32_C(0xBCFE8C77), UINT32_C(0xC9048A35), UINT32_C(0x38BA0F85),
          UINT32_C(0x60A035F6), UINT32_C(0x300E6AC4)}},
        {{UINT32_C(0x34707CC6), UINT32_C(0xA8EDBC5E), UINT32_C(0x56ADFC16),
          UINT32_C(0x3DA6BC51), UINT32_C(0xCA8B6F3F), UINT32_C(0x5C7CB5E1),
          UINT32_C(0x2D612DFA), UINT32_C(0x76E4A028)},
         {UINT32_C(0x64F49D39), UINT32_C(0x75AB66FD), UINT32_C(0xC387A739),
          UINT32_C(0x5AF9879D), UINT32_C(0x3E9EDBCF), UINT32_C(0x83964808),
          UINT32_C(0x7F4C4FFE), UINT32_C(0x555D8BBD)}},
        {{UINT32_C(0x3C5590B0), UINT32_C(0xAAE8A2FE), UINT32_C(0x8AB34213),
          UINT32_C(0x461C6CCC), UINT32_C(0x9E719B77), UINT32_C(0xB2F3E822),
          UINT32_C(0x663188BB), UINT32_C(0x25B8FCA8)},
         {UINT32_C(0x72548131), UINT32_C(0xAA7A047B), UINT32_C(0x189FA6F0),
          UINT32_C(0x0878FFEE), UINT32_C(0xCE3E17C3), UINT32_C(0x9E7FB402),
          UINT32_C(0x44418277), UINT32_C(0x6F260D93)}},
        {{UINT32_C(0xB703B647), UINT32_C(0x0EF1C290), UINT32_C(0x651673E4),
          UINT32_C(0x995009FA), UINT32_C(0xBE46362D), UINT32_C(0x661F76D7),
          UINT32_C(0x23E56E7A), UINT32_C(0x74B00FD1)},
         {UINT32_C(0xA1A50E4B), UINT32_C(0x9557D0AB), UINT32_C(0x587688CE),
          UINT32_C(0xC5A1CF95), UINT32_C(0x7AE08ECA), UINT32_C(0x2A14D1B2),
          UINT32_C(0x3C23D507), UINT32_C(0x2DA8816C)}},
        {{UINT32_C(0xB9934883), UINT32_C(0x51CB405F), UINT32_C(0x01A6864B),
          UINT32_C(0xC99A67D4), UINT32_C(0x6CDFFFC3), UINT32_C(0xCCF62233),
          UINT32_C(0x98FE0B79), UINT32_C(0x2938F9F9)},
         {UINT32_C(0x39A5AA28), UINT32_C(0x77666911), UINT32_C(0x2427BFC0),
          UINT32_C(0xDF56CBB5), UINT32_C(0x189EB66D), UINT32_C(0xA39BE968),
          UINT32_C(0xA64FD2AB), UINT32_C(0x71E6E105)}},
        {{UINT32_C(0x60F9D20B), UINT32_C(0xA0C6F795), UINT32_C(0x765670CC),
          UINT32_C(0xE06DC8BB), UINT32_C(0xA67275E0), UINT32_C(0x9FA1DD58),
          UINT32_C(0xE2D23BBB), UINT32_C(0x0F7F670D)},
         {UINT32_C(0x33FB15EA), UINT32_C(0xF8F07CF3), UINT32_C(0x723A0271),
          UINT32_C(0x1D09B592), UINT32_C(0x4E6FCAAB), UINT32_C(0xF1402923),
          UINT32_C(0xAE301940), UINT32_C(0x05BE1273)}},
        {{UINT32_C(0x114AFD1E), UINT32_C(0x2D83906C), UINT32_C(0xC88E5761),
          UINT32_C(0x091474FD), UINT32_C(0xEF9E4F9B), UINT32_C(0xAFF18EEB),
          UINT32_C(0xF4E646ED), UINT32_C(0x136ECAE5)},
         {UINT32_C(0xEB01808F), UINT32_C(0xEF4526D0), UINT32_C(0x940C0AEC),
          UINT32_C(0x3923EBBA), UINT32_C(0xA437F460), UINT32_C(0xAB34160C),
          UINT32_C(0x421AD57C), UINT32_C(0x7A46966E)}},
    }};

/*-
 * Q := 2P, both projective, Q and P same pointers OK
 * Autogenerated: op3/dbl_proj_any.op3
 * https://eprint.iacr.org/2015/1060 Alg 3
 */
static void point_double(pt_prj_t *Q, const pt_prj_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4;
    /* constants */
    const limb_t *b3 = const_b3;
    const limb_t *a = const_a;
    /* set pointers for legacy curve arith */
    const limb_t *X = P->X;
    const limb_t *Y = P->Y;
    const limb_t *Z = P->Z;
    limb_t *X3 = Q->X;
    limb_t *Y3 = Q->Y;
    limb_t *Z3 = Q->Z;

    /* the curve arith formula */
    fiat_id_GostR3410_2001_TestParamSet_square(t0, X);
    fiat_id_GostR3410_2001_TestParamSet_square(t1, Y);
    fiat_id_GostR3410_2001_TestParamSet_square(t2, Z);
    fiat_id_GostR3410_2001_TestParamSet_mul(t3, X, Y);
    fiat_id_GostR3410_2001_TestParamSet_add(t3, t3, t3);
    fiat_id_GostR3410_2001_TestParamSet_mul(t4, Y, Z);
    fiat_id_GostR3410_2001_TestParamSet_mul(Z3, X, Z);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, Z3, Z3);
    fiat_id_GostR3410_2001_TestParamSet_mul(X3, a, Z3);
    fiat_id_GostR3410_2001_TestParamSet_mul(Y3, b3, t2);
    fiat_id_GostR3410_2001_TestParamSet_add(Y3, X3, Y3);
    fiat_id_GostR3410_2001_TestParamSet_sub(X3, t1, Y3);
    fiat_id_GostR3410_2001_TestParamSet_add(Y3, t1, Y3);
    fiat_id_GostR3410_2001_TestParamSet_mul(Y3, X3, Y3);
    fiat_id_GostR3410_2001_TestParamSet_mul(X3, t3, X3);
    fiat_id_GostR3410_2001_TestParamSet_mul(Z3, b3, Z3);
    fiat_id_GostR3410_2001_TestParamSet_mul(t2, a, t2);
    fiat_id_GostR3410_2001_TestParamSet_sub(t3, t0, t2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t3, a, t3);
    fiat_id_GostR3410_2001_TestParamSet_add(t3, t3, Z3);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, t0, t0);
    fiat_id_GostR3410_2001_TestParamSet_add(t0, Z3, t0);
    fiat_id_GostR3410_2001_TestParamSet_add(t0, t0, t2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, t0, t3);
    fiat_id_GostR3410_2001_TestParamSet_add(Y3, Y3, t0);
    fiat_id_GostR3410_2001_TestParamSet_add(t2, t4, t4);
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, t2, t3);
    fiat_id_GostR3410_2001_TestParamSet_sub(X3, X3, t0);
    fiat_id_GostR3410_2001_TestParamSet_mul(Z3, t2, t1);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, Z3, Z3);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, Z3, Z3);
}

/*-
 * R := Q + P where R and Q are projective, P affine.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_mixed_any.op3
 * https://eprint.iacr.org/2015/1060 Alg 2
 */
static void point_add_mixed(pt_prj_t *R, const pt_prj_t *Q, const pt_aff_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4, t5;
    /* constants */
    const limb_t *b3 = const_b3;
    const limb_t *a = const_a;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    fe_t X3;
    fe_t Y3;
    fe_t Z3;
    limb_t nz;

    /* check P for affine inf */
    fiat_id_GostR3410_2001_TestParamSet_nonzero(&nz, P->Y);

    /* the curve arith formula */
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, X1, X2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t1, Y1, Y2);
    fiat_id_GostR3410_2001_TestParamSet_add(t3, X2, Y2);
    fiat_id_GostR3410_2001_TestParamSet_add(t4, X1, Y1);
    fiat_id_GostR3410_2001_TestParamSet_mul(t3, t3, t4);
    fiat_id_GostR3410_2001_TestParamSet_add(t4, t0, t1);
    fiat_id_GostR3410_2001_TestParamSet_sub(t3, t3, t4);
    fiat_id_GostR3410_2001_TestParamSet_mul(t4, X2, Z1);
    fiat_id_GostR3410_2001_TestParamSet_add(t4, t4, X1);
    fiat_id_GostR3410_2001_TestParamSet_mul(t5, Y2, Z1);
    fiat_id_GostR3410_2001_TestParamSet_add(t5, t5, Y1);
    fiat_id_GostR3410_2001_TestParamSet_mul(Z3, a, t4);
    fiat_id_GostR3410_2001_TestParamSet_mul(X3, b3, Z1);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, X3, Z3);
    fiat_id_GostR3410_2001_TestParamSet_sub(X3, t1, Z3);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, t1, Z3);
    fiat_id_GostR3410_2001_TestParamSet_mul(Y3, X3, Z3);
    fiat_id_GostR3410_2001_TestParamSet_add(t1, t0, t0);
    fiat_id_GostR3410_2001_TestParamSet_add(t1, t1, t0);
    fiat_id_GostR3410_2001_TestParamSet_mul(t2, a, Z1);
    fiat_id_GostR3410_2001_TestParamSet_mul(t4, b3, t4);
    fiat_id_GostR3410_2001_TestParamSet_add(t1, t1, t2);
    fiat_id_GostR3410_2001_TestParamSet_sub(t2, t0, t2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t2, a, t2);
    fiat_id_GostR3410_2001_TestParamSet_add(t4, t4, t2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, t1, t4);
    fiat_id_GostR3410_2001_TestParamSet_add(Y3, Y3, t0);
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, t5, t4);
    fiat_id_GostR3410_2001_TestParamSet_mul(X3, t3, X3);
    fiat_id_GostR3410_2001_TestParamSet_sub(X3, X3, t0);
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, t3, t1);
    fiat_id_GostR3410_2001_TestParamSet_mul(Z3, t5, Z3);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, Z3, t0);

    /* if P is inf, throw all that away and take Q */
    fiat_id_GostR3410_2001_TestParamSet_selectznz(R->X, nz, Q->X, X3);
    fiat_id_GostR3410_2001_TestParamSet_selectznz(R->Y, nz, Q->Y, Y3);
    fiat_id_GostR3410_2001_TestParamSet_selectznz(R->Z, nz, Q->Z, Z3);
}

/*-
 * R := Q + P all projective.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_proj_any.op3
 * https://eprint.iacr.org/2015/1060 Alg 1
 */
static void point_add_proj(pt_prj_t *R, const pt_prj_t *Q, const pt_prj_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4, t5;
    /* constants */
    const limb_t *b3 = const_b3;
    const limb_t *a = const_a;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    const limb_t *Z2 = P->Z;
    limb_t *X3 = R->X;
    limb_t *Y3 = R->Y;
    limb_t *Z3 = R->Z;

    /* the curve arith formula */
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, X1, X2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t1, Y1, Y2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t2, Z1, Z2);
    fiat_id_GostR3410_2001_TestParamSet_add(t3, X1, Y1);
    fiat_id_GostR3410_2001_TestParamSet_add(t4, X2, Y2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t3, t3, t4);
    fiat_id_GostR3410_2001_TestParamSet_add(t4, t0, t1);
    fiat_id_GostR3410_2001_TestParamSet_sub(t3, t3, t4);
    fiat_id_GostR3410_2001_TestParamSet_add(t4, X1, Z1);
    fiat_id_GostR3410_2001_TestParamSet_add(t5, X2, Z2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t4, t4, t5);
    fiat_id_GostR3410_2001_TestParamSet_add(t5, t0, t2);
    fiat_id_GostR3410_2001_TestParamSet_sub(t4, t4, t5);
    fiat_id_GostR3410_2001_TestParamSet_add(t5, Y1, Z1);
    fiat_id_GostR3410_2001_TestParamSet_add(X3, Y2, Z2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t5, t5, X3);
    fiat_id_GostR3410_2001_TestParamSet_add(X3, t1, t2);
    fiat_id_GostR3410_2001_TestParamSet_sub(t5, t5, X3);
    fiat_id_GostR3410_2001_TestParamSet_mul(Z3, a, t4);
    fiat_id_GostR3410_2001_TestParamSet_mul(X3, b3, t2);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, X3, Z3);
    fiat_id_GostR3410_2001_TestParamSet_sub(X3, t1, Z3);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, t1, Z3);
    fiat_id_GostR3410_2001_TestParamSet_mul(Y3, X3, Z3);
    fiat_id_GostR3410_2001_TestParamSet_add(t1, t0, t0);
    fiat_id_GostR3410_2001_TestParamSet_add(t1, t1, t0);
    fiat_id_GostR3410_2001_TestParamSet_mul(t2, a, t2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t4, b3, t4);
    fiat_id_GostR3410_2001_TestParamSet_add(t1, t1, t2);
    fiat_id_GostR3410_2001_TestParamSet_sub(t2, t0, t2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t2, a, t2);
    fiat_id_GostR3410_2001_TestParamSet_add(t4, t4, t2);
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, t1, t4);
    fiat_id_GostR3410_2001_TestParamSet_add(Y3, Y3, t0);
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, t5, t4);
    fiat_id_GostR3410_2001_TestParamSet_mul(X3, t3, X3);
    fiat_id_GostR3410_2001_TestParamSet_sub(X3, X3, t0);
    fiat_id_GostR3410_2001_TestParamSet_mul(t0, t3, t1);
    fiat_id_GostR3410_2001_TestParamSet_mul(Z3, t5, Z3);
    fiat_id_GostR3410_2001_TestParamSet_add(Z3, Z3, t0);
}

/* constants */
#define RADIX 5
#define DRADIX (1 << RADIX)
#define DRADIX_WNAF ((DRADIX) << 1)

/*-
 * precomp for wnaf scalar multiplication:
 * precomp[0] = 1P
 * precomp[1] = 3P
 * precomp[2] = 5P
 * precomp[3] = 7P
 * precomp[4] = 9P
 * ...
 */
static void precomp_wnaf(pt_prj_t precomp[DRADIX / 2], const pt_aff_t *P) {
    int i;

    fe_copy(precomp[0].X, P->X);
    fe_copy(precomp[0].Y, P->Y);
    fe_copy(precomp[0].Z, const_one);
    point_double(&precomp[DRADIX / 2 - 1], &precomp[0]);

    for (i = 1; i < DRADIX / 2; i++)
        point_add_proj(&precomp[i], &precomp[DRADIX / 2 - 1], &precomp[i - 1]);
}

/* fetch a scalar bit */
static int scalar_get_bit(const unsigned char in[32], int idx) {
    int widx, rshift;

    widx = idx >> 3;
    rshift = idx & 0x7;

    if (idx < 0 || widx >= 32) return 0;

    return (in[widx] >> rshift) & 0x1;
}

/*-
 * Compute "regular" wnaf representation of a scalar.
 * See "Exponent Recoding and Regular Exponentiation Algorithms",
 * Tunstall et al., AfricaCrypt 2009, Alg 6.
 * It forces an odd scalar and outputs digits in
 * {\pm 1, \pm 3, \pm 5, \pm 7, \pm 9, ...}
 * i.e. signed odd digits with _no zeroes_ -- that makes it "regular".
 */
static void scalar_rwnaf(int8_t out[52], const unsigned char in[32]) {
    int i;
    int8_t window, d;

    window = (in[0] & (DRADIX_WNAF - 1)) | 1;
    for (i = 0; i < 51; i++) {
        d = (window & (DRADIX_WNAF - 1)) - DRADIX;
        out[i] = d;
        window = (window - d) >> RADIX;
        window += scalar_get_bit(in, (i + 1) * RADIX + 1) << 1;
        window += scalar_get_bit(in, (i + 1) * RADIX + 2) << 2;
        window += scalar_get_bit(in, (i + 1) * RADIX + 3) << 3;
        window += scalar_get_bit(in, (i + 1) * RADIX + 4) << 4;
        window += scalar_get_bit(in, (i + 1) * RADIX + 5) << 5;
    }
    out[i] = window;
}

/*-
 * Compute "textbook" wnaf representation of a scalar.
 * NB: not constant time
 */
static void scalar_wnaf(int8_t out[257], const unsigned char in[32]) {
    int i;
    int8_t window, d;

    window = in[0] & (DRADIX_WNAF - 1);
    for (i = 0; i < 257; i++) {
        d = 0;
        if ((window & 1) && ((d = window & (DRADIX_WNAF - 1)) & DRADIX))
            d -= DRADIX_WNAF;
        out[i] = d;
        window = (window - d) >> 1;
        window += scalar_get_bit(in, i + 1 + RADIX) << RADIX;
    }
}

/*-
 * Simultaneous scalar multiplication: interleaved "textbook" wnaf.
 * NB: not constant time
 */
static void var_smul_wnaf_two(pt_aff_t *out, const unsigned char a[32],
                              const unsigned char b[32], const pt_aff_t *P) {
    int i, d, is_neg, is_inf = 1, flipped = 0;
    int8_t anaf[257] = {0};
    int8_t bnaf[257] = {0};
    pt_prj_t Q = {0};
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_wnaf(anaf, a);
    scalar_wnaf(bnaf, b);

    for (i = 256; i >= 0; i--) {
        if (!is_inf) point_double(&Q, &Q);
        if ((d = bnaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_id_GostR3410_2001_TestParamSet_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &precomp[d].X);
                fe_copy(Q.Y, &precomp[d].Y);
                fe_copy(Q.Z, &precomp[d].Z);
                is_inf = 0;
            } else
                point_add_proj(&Q, &Q, &precomp[d]);
        }
        if ((d = anaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_id_GostR3410_2001_TestParamSet_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &lut_cmb[0][d].X);
                fe_copy(Q.Y, &lut_cmb[0][d].Y);
                fe_copy(Q.Z, const_one);
                is_inf = 0;
            } else
                point_add_mixed(&Q, &Q, &lut_cmb[0][d]);
        }
    }

    if (is_inf) {
        /* initialize accumulator to inf: all-zero scalars */
        fe_set_zero(Q.X);
        fe_copy(Q.Y, const_one);
        fe_set_zero(Q.Z);
    }

    if (flipped) {
        /* correct sign */
        fiat_id_GostR3410_2001_TestParamSet_opp(Q.Y, Q.Y);
    }

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_GostR3410_2001_TestParamSet_inv(Q.Z, Q.Z);
    fiat_id_GostR3410_2001_TestParamSet_mul(out->X, Q.X, Q.Z);
    fiat_id_GostR3410_2001_TestParamSet_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Variable point scalar multiplication with "regular" wnaf.
 */
static void var_smul_rwnaf(pt_aff_t *out, const unsigned char scalar[32],
                           const pt_aff_t *P) {
    int i, j, d, diff, is_neg;
    int8_t rnaf[52] = {0};
    pt_prj_t Q = {0}, lut = {0};
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_rwnaf(rnaf, scalar);

#if defined(_MSC_VER)
    /* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    /* initialize accumulator to high digit */
    d = (rnaf[51] - 1) >> 1;
    for (j = 0; j < DRADIX / 2; j++) {
        diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
        fiat_id_GostR3410_2001_TestParamSet_selectznz(Q.X, diff, Q.X,
                                                      precomp[j].X);
        fiat_id_GostR3410_2001_TestParamSet_selectznz(Q.Y, diff, Q.Y,
                                                      precomp[j].Y);
        fiat_id_GostR3410_2001_TestParamSet_selectznz(Q.Z, diff, Q.Z,
                                                      precomp[j].Z);
    }

    for (i = 50; i >= 0; i--) {
        for (j = 0; j < RADIX; j++) point_double(&Q, &Q);
        d = rnaf[i];
        /* is_neg = (d < 0) ? 1 : 0 */
        is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
        /* d = abs(d) */
        d = (d ^ -is_neg) + is_neg;
        d = (d - 1) >> 1;
        for (j = 0; j < DRADIX / 2; j++) {
            diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
            fiat_id_GostR3410_2001_TestParamSet_selectznz(lut.X, diff, lut.X,
                                                          precomp[j].X);
            fiat_id_GostR3410_2001_TestParamSet_selectznz(lut.Y, diff, lut.Y,
                                                          precomp[j].Y);
            fiat_id_GostR3410_2001_TestParamSet_selectznz(lut.Z, diff, lut.Z,
                                                          precomp[j].Z);
        }
        /* negate lut point if digit is negative */
        fiat_id_GostR3410_2001_TestParamSet_opp(out->Y, lut.Y);
        fiat_id_GostR3410_2001_TestParamSet_selectznz(lut.Y, is_neg, lut.Y,
                                                      out->Y);
        point_add_proj(&Q, &Q, &lut);
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, precomp[0].X);
    fiat_id_GostR3410_2001_TestParamSet_opp(lut.Y, precomp[0].Y);
    fe_copy(lut.Z, precomp[0].Z);
    point_add_proj(&lut, &lut, &Q);
    fiat_id_GostR3410_2001_TestParamSet_selectznz(Q.X, scalar[0] & 1, lut.X,
                                                  Q.X);
    fiat_id_GostR3410_2001_TestParamSet_selectznz(Q.Y, scalar[0] & 1, lut.Y,
                                                  Q.Y);
    fiat_id_GostR3410_2001_TestParamSet_selectznz(Q.Z, scalar[0] & 1, lut.Z,
                                                  Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_GostR3410_2001_TestParamSet_inv(Q.Z, Q.Z);
    fiat_id_GostR3410_2001_TestParamSet_mul(out->X, Q.X, Q.Z);
    fiat_id_GostR3410_2001_TestParamSet_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Fixed scalar multiplication: comb with interleaving.
 */
static void fixed_smul_cmb(pt_aff_t *out, const unsigned char scalar[32]) {
    int i, j, k, d, diff, is_neg = 0;
    int8_t rnaf[52] = {0};
    pt_prj_t Q = {0}, R = {0};
    pt_aff_t lut = {0};

    scalar_rwnaf(rnaf, scalar);

    /* initalize accumulator to inf */
    fe_set_zero(Q.X);
    fe_copy(Q.Y, const_one);
    fe_set_zero(Q.Z);

#if defined(_MSC_VER)
    /* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    for (i = 1; i >= 0; i--) {
        for (j = 0; i != 1 && j < RADIX; j++) point_double(&Q, &Q);
        for (j = 0; j < 27; j++) {
            if (j * 2 + i > 51) continue;
            d = rnaf[j * 2 + i];
            /* is_neg = (d < 0) ? 1 : 0 */
            is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
            /* d = abs(d) */
            d = (d ^ -is_neg) + is_neg;
            d = (d - 1) >> 1;
            for (k = 0; k < DRADIX / 2; k++) {
                diff = (1 - (-(d ^ k) >> (8 * sizeof(int) - 1))) & 1;
                fiat_id_GostR3410_2001_TestParamSet_selectznz(
                    lut.X, diff, lut.X, lut_cmb[j][k].X);
                fiat_id_GostR3410_2001_TestParamSet_selectznz(
                    lut.Y, diff, lut.Y, lut_cmb[j][k].Y);
            }
            /* negate lut point if digit is negative */
            fiat_id_GostR3410_2001_TestParamSet_opp(out->Y, lut.Y);
            fiat_id_GostR3410_2001_TestParamSet_selectznz(lut.Y, is_neg, lut.Y,
                                                          out->Y);
            point_add_mixed(&Q, &Q, &lut);
        }
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, lut_cmb[0][0].X);
    fiat_id_GostR3410_2001_TestParamSet_opp(lut.Y, lut_cmb[0][0].Y);
    point_add_mixed(&R, &Q, &lut);
    fiat_id_GostR3410_2001_TestParamSet_selectznz(Q.X, scalar[0] & 1, R.X, Q.X);
    fiat_id_GostR3410_2001_TestParamSet_selectznz(Q.Y, scalar[0] & 1, R.Y, Q.Y);
    fiat_id_GostR3410_2001_TestParamSet_selectznz(Q.Z, scalar[0] & 1, R.Z, Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_GostR3410_2001_TestParamSet_inv(Q.Z, Q.Z);
    fiat_id_GostR3410_2001_TestParamSet_mul(out->X, Q.X, Q.Z);
    fiat_id_GostR3410_2001_TestParamSet_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Wrapper: simultaneous scalar mutiplication.
 * outx, outy := a * G + b * P
 * where P = (inx, iny).
 * Everything is LE byte ordering.
 */
static void point_mul_two(unsigned char outx[32], unsigned char outy[32],
                          const unsigned char a[32], const unsigned char b[32],
                          const unsigned char inx[32],
                          const unsigned char iny[32]) {
    pt_aff_t P;

    fiat_id_GostR3410_2001_TestParamSet_from_bytes(P.X, inx);
    fiat_id_GostR3410_2001_TestParamSet_from_bytes(P.Y, iny);
    fiat_id_GostR3410_2001_TestParamSet_to_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_TestParamSet_to_montgomery(P.Y, P.Y);
    /* simultaneous scalar multiplication */
    var_smul_wnaf_two(&P, a, b, &P);

    fiat_id_GostR3410_2001_TestParamSet_from_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_TestParamSet_from_montgomery(P.Y, P.Y);
    fiat_id_GostR3410_2001_TestParamSet_to_bytes(outx, P.X);
    fiat_id_GostR3410_2001_TestParamSet_to_bytes(outy, P.Y);
}

/*-
 * Wrapper: fixed scalar mutiplication.
 * outx, outy := scalar * G
 * Everything is LE byte ordering.
 */
static void point_mul_g(unsigned char outx[32], unsigned char outy[32],
                        const unsigned char scalar[32]) {
    pt_aff_t P;

    /* fixed scmul function */
    fixed_smul_cmb(&P, scalar);
    fiat_id_GostR3410_2001_TestParamSet_from_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_TestParamSet_from_montgomery(P.Y, P.Y);
    fiat_id_GostR3410_2001_TestParamSet_to_bytes(outx, P.X);
    fiat_id_GostR3410_2001_TestParamSet_to_bytes(outy, P.Y);
}

/*-
 * Wrapper: variable point scalar mutiplication.
 * outx, outy := scalar * P
 * where P = (inx, iny).
 * Everything is LE byte ordering.
 */
static void point_mul(unsigned char outx[32], unsigned char outy[32],
                      const unsigned char scalar[32],
                      const unsigned char inx[32],
                      const unsigned char iny[32]) {
    pt_aff_t P;

    fiat_id_GostR3410_2001_TestParamSet_from_bytes(P.X, inx);
    fiat_id_GostR3410_2001_TestParamSet_from_bytes(P.Y, iny);
    fiat_id_GostR3410_2001_TestParamSet_to_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_TestParamSet_to_montgomery(P.Y, P.Y);
    /* var scmul function */
    var_smul_rwnaf(&P, scalar, &P);
    fiat_id_GostR3410_2001_TestParamSet_from_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_TestParamSet_from_montgomery(P.Y, P.Y);
    fiat_id_GostR3410_2001_TestParamSet_to_bytes(outx, P.X);
    fiat_id_GostR3410_2001_TestParamSet_to_bytes(outy, P.Y);
}


#include <openssl/ec.h>

/* the zero field element */
static const unsigned char const_zb[32] = {0};

/*-
 * An OpenSSL wrapper for simultaneous scalar multiplication.
 * r := n * G + m * q
 */
    int
    point_mul_two_id_GostR3410_2001_TestParamSet(const EC_GROUP *group,
                                                 EC_POINT *r, const BIGNUM *n,
                                                 const EC_POINT *q,
                                                 const BIGNUM *m, BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[32];
    unsigned char b_y[32];
    unsigned char b_n[32];
    unsigned char b_m[32];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL
        /* pull out coords as bytes */
        || !EC_POINT_get_affine_coordinates(group, q, x, y, ctx) ||
        BN_bn2lebinpad(x, b_x, 32) != 32 || BN_bn2lebinpad(y, b_y, 32) != 32 ||
        BN_bn2lebinpad(n, b_n, 32) != 32 || BN_bn2lebinpad(m, b_m, 32) != 32)
        goto err;
    /* do the simultaneous scalar multiplication */
    point_mul_two(b_x, b_y, b_n, b_m, b_x, b_y);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 32) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 32) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 32, x) == NULL ||
            BN_lebin2bn(b_y, 32, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}

/*-
 * An OpenSSL wrapper for variable point scalar multiplication.
 * r := m * q
 */
    int
    point_mul_id_GostR3410_2001_TestParamSet(const EC_GROUP *group, EC_POINT *r,
                                             const EC_POINT *q, const BIGNUM *m,
                                             BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[32];
    unsigned char b_y[32];
    unsigned char b_m[32];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL
        /* pull out coords as bytes */
        || !EC_POINT_get_affine_coordinates(group, q, x, y, ctx) ||
        BN_bn2lebinpad(x, b_x, 32) != 32 || BN_bn2lebinpad(y, b_y, 32) != 32 ||
        BN_bn2lebinpad(m, b_m, 32) != 32)
        goto err;
    /* do the variable scalar multiplication */
    point_mul(b_x, b_y, b_m, b_x, b_y);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 32) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 32) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 32, x) == NULL ||
            BN_lebin2bn(b_y, 32, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}

/*-
 * An OpenSSL wrapper for fixed scalar multiplication.
 * r := n * G
 */
    int
    point_mul_g_id_GostR3410_2001_TestParamSet(const EC_GROUP *group,
                                               EC_POINT *r, const BIGNUM *n,
                                               BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[32];
    unsigned char b_y[32];
    unsigned char b_n[32];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL || BN_bn2lebinpad(n, b_n, 32) != 32)
        goto err;
    /* do the fixed scalar multiplication */
    point_mul_g(b_x, b_y, b_n);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 32) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 32) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 32, x) == NULL ||
            BN_lebin2bn(b_y, 32, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}



#endif /* __SIZEOF_INT128__ */
