package Debian::Debhelper::Buildsystem::fortran;
=head1 NAME

dh-fortran -- debhelper build system class for Fortran support

=head1 DESCRIPTION

This is a buildsystem class modelled on dh-golang.
It provides a build system for debhelper which can be used
by adding B<dh-sequence-fortran> to the package build dependencies,
and passing the following options to B<dh>:

 %:
        dh $@ --builddirectory=_build --buildsystem=fortran

Starting with debhelper 13.4 (a versioned build dependency is currently
required), the build system is automatically detected, and the following
is enough:


 %:
 	dh $@ --builddirectory=_build

Starting with debhelper compatibility level 14, the build directory defaults
to F<_build>, and the following is enough:

 %:
 	dh $@

=head1 FPM SUPPORT

If a file "fpm.toml" is present in the top-level directory, then dh_fortran
invokes the fpm build tool.

=over

=item B<configure>

=head1 SEE ALSO

L<dh(1)>, L<dh_golang(1p)>, L<dh-make-golang(1)>

=cut

use strict;
use warnings;
use parent qw(Debian::Debhelper::Buildsystem);
use Debian::Debhelper::Dh_Lib;
use Dpkg::BuildFlags;
use Dpkg::Control::Info;
use File::Copy qw(cp); # in core since 5.002
use File::Path qw(make_path); # in core since 5.001
use File::Find; # in core since 5
use File::Spec; # in core since 5.00405

sub DESCRIPTION {
    "Fortran"
}

#sub DEFAULT_BUILD_DIRECTORY {
#  TODO:
# Enable a default builddir only if not specified
#    my $this = shift;
#    return $this->SUPER::DEFAULT_BUILD_DIRECTORY() if compat(13);
#    return '_build';
#}

#sub IS_GENERATOR_BUILD_SYSTEM {
#        return 0;
#}

my @fpmfiles = qw(
  fpm.toml
);

sub check_auto_buildable {
    my $this = shift;

    foreach my $file (@fpmfiles) {
        return 1 if -e $this->get_sourcepath($file);
    }
    return 0
}


sub new {
    my $class = shift;
    my $this = $class->SUPER::new(@_);
    $this->prefer_out_of_source_building();
    #_set_dh_fortranpkg();
    $this->set_fortran_env();
    return $this;
}

sub set_fortran_env {
    my $this = shift;
    # print "set_fortran_env";
    # doit('dh_fortran','env');
    # TODO Defaults
    $ENV{FC_DEFAULT} = 'gfortran-15';
    # $ENV{FC_OPTIONAL} = 'gfortran-14 flang-new-21';
}



sub configure {
	my $this=shift;
	foreach my $command ($this->dhf_commands('configure', @_)) {
		doit(@$command);
	}
}

sub build {
	my $this=shift;
	foreach my $command ($this->dhf_commands('build', @_)) {
		doit(@$command);
	}
}

sub install {
	my $this=shift;
	foreach my $command ($this->dhf_commands('install', @_)) {
		doit(@$command);
	}
}

sub test {
	my $this=shift;
	foreach my $command ($this->dhf_commands('test', @_)) {
		doit(@$command);
	}
}

sub clean {
	my $this=shift;

	foreach my $command ($this->dhf_commands('clean', @_)) {
		doit(@$command);
	}
	# doit('find', '.', '-name', '*.pyc', '-exec', 'rm', '{}', ';');
}

sub dhf_commands {
    	my $this=shift;
	my $step=shift;
	my @options = @_;
	my @result;

	doit('dh_fortran',$step);
	my $dir = $this->get_sourcedir();
	if (not grep {$_ eq '--dir'} @options and $dir ne '.') {
		# if --dir is not passed, PYBUILD_DIR can be used
		push @options, '--dir', $dir;
	}

	if (not grep {$_ eq '--verbose'} @options and $dh{QUIET}) {
		push @options, '--quiet';
	}

	# Pass dh's destdir, if it's not the default value
	if ($step eq 'install') {
		my $destdir = shift(@options);
		if ($destdir ne "debian/tmp") {
			push @options, "--dest-dir=$destdir";
		}
	}
	return @result;
	
}

sub dhf_build_dependencies {
	my $this=shift;

	# TODO
	
	my @result;
	#my $c = Dpkg::Control->new(type => CTRL_INFO_SRC);
	#if ($c->load('debian/control')) {
	#	for my $field (grep /^Build-Depends/, keys %{$c}) {
	#		my $builddeps = $c->{$field};
	#		while ($builddeps =~ /(?:^|[\s,])((pypy|python|tox)[0-9\.]*(-[^\s,\(]+)?)(?:[\s,\(]|$)/g) {
	#			my $dep = $1;
	#			$dep =~ s/:(any|native)$//;
	#			if ($dep) {push @result, $dep};
	#		}
	#	}
	#}

##	return @result;
}

1
# vim:ts=4:sw=4:expandtab
